/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.utils.animation;

import com.creativemd.creativecore.common.gui.controls.gui.timeline.IAnimationHandler;
import com.creativemd.littletiles.common.entity.EntityAnimation;
import com.creativemd.littletiles.common.gui.controls.IAnimationControl;
import com.creativemd.littletiles.common.structure.relative.StructureAbsolute;
import com.creativemd.littletiles.common.utils.animation.AnimationState;
import com.creativemd.littletiles.common.utils.animation.AnimationTimeline;
import javax.vecmath.Vector3d;

public class AnimationGuiHandler
implements IAnimationHandler {
    private IAnimationControl parent;
    private int lastTick = -1;
    private StructureAbsolute center = null;
    private boolean loop = true;
    private boolean playing = false;
    private int tick = 0;
    private AnimationTimeline timeline;
    private AnimationState state = new AnimationState();

    public AnimationGuiHandler(IAnimationControl parent) {
        this.parent = parent;
    }

    public void setCenter(StructureAbsolute center) {
        this.center = center;
    }

    public void loop(boolean loop) {
        this.loop = loop;
    }

    public void play() {
        this.playing = true;
    }

    public void pause() {
        this.playing = false;
    }

    public void stop() {
        this.playing = false;
        this.set(0);
    }

    public void set(int tick) {
        this.tick = tick;
    }

    public int get() {
        return this.tick;
    }

    public void tick(EntityAnimation animation) {
        if (this.timeline == null) {
            return;
        }
        if (this.playing) {
            if (this.tick > this.timeline.duration) {
                if (this.loop) {
                    this.tick = 0;
                }
            } else {
                ++this.tick;
            }
        }
        if (this.center != null) {
            animation.setCenter(this.center);
            this.center = null;
        }
        this.updateTick(animation);
    }

    public void updateTick(EntityAnimation animation) {
        animation.prevWorldOffsetX = animation.worldOffsetX;
        animation.prevWorldOffsetY = animation.worldOffsetY;
        animation.prevWorldOffsetZ = animation.worldOffsetZ;
        animation.prevWorldRotX = animation.worldRotX;
        animation.prevWorldRotY = animation.worldRotY;
        animation.prevWorldRotZ = animation.worldRotZ;
        if (this.tick == this.lastTick) {
            return;
        }
        this.lastTick = this.tick;
        if (this.timeline != null) {
            this.timeline.tick(Math.min(this.tick, this.timeline.duration), this.state);
        } else {
            this.state.clear();
        }
        Vector3d offset = this.state.getOffset();
        Vector3d rotation = this.state.getRotation();
        animation.moveAndRotateAnimation(offset.x - animation.worldOffsetX, offset.y - animation.worldOffsetY, offset.z - animation.worldOffsetZ, rotation.x - animation.worldRotX, rotation.y - animation.worldRotY, rotation.z - animation.worldRotZ);
    }

    public void setTimeline(AnimationTimeline timeline) {
        this.timeline = timeline;
        this.state.clear();
    }
}

