/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.tiles.preview;

import com.creativemd.littletiles.common.tiles.preview.LittlePreviews;
import com.creativemd.littletiles.common.tiles.preview.LittleTilePreview;
import com.creativemd.littletiles.common.utils.grid.LittleGridContext;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;

public class LittleVolumes {
    public LittleGridContext context;
    private HashMap<LittleVolume, Double> volumes = new HashMap();

    public LittleVolumes(LittleGridContext context) {
        this.context = context;
    }

    public void convertTo(LittleGridContext context) {
        double ratio = (double)context.size / (double)this.context.size;
        for (Map.Entry<LittleVolume, Double> entry : this.volumes.entrySet()) {
            entry.setValue(entry.getValue() * ratio);
        }
    }

    public void ensureContext(LittleGridContext context) {
        if (this.context.size < context.size) {
            this.convertTo(context);
        }
    }

    public void addPreviews(LittlePreviews previews) {
        this.ensureContext(previews.context);
        for (LittleTilePreview preview : previews) {
            this.addPreviewDirectly(this.context, preview);
        }
    }

    public void addPreview(LittleGridContext context, LittleTilePreview preview) {
        this.ensureContext(context);
        this.addPreviewDirectly(context, preview);
    }

    private void addPreviewDirectly(LittleGridContext context, LittleTilePreview preview) {
        LittleVolume type;
        Double exist;
        double volume = preview.getVolume();
        if (context.size < this.context.size) {
            volume *= (double)(this.context.size / context.size);
        }
        exist = (exist = this.volumes.get(type = new LittleVolume(preview.getPreviewBlock(), preview.getPreviewBlockMeta()))) == null ? Double.valueOf(volume) : Double.valueOf(exist + volume);
        this.volumes.put(type, exist);
    }

    public int hashCode() {
        return this.volumes.size();
    }

    public boolean equals(Object obj) {
        if (obj instanceof LittleVolumes) {
            LittleGridContext beforeThis = this.context;
            this.ensureContext(((LittleVolumes)obj).context);
            LittleGridContext beforeTheirs = ((LittleVolumes)obj).context;
            ((LittleVolumes)obj).ensureContext(this.context);
            boolean result = ((LittleVolumes)obj).volumes.equals(this.volumes);
            if (beforeThis != this.context) {
                this.convertTo(beforeThis);
            }
            if (beforeTheirs != ((LittleVolumes)obj).context) {
                ((LittleVolumes)obj).convertTo(beforeTheirs);
            }
            return result;
        }
        return false;
    }

    public static class LittleVolume {
        public final Block block;
        public final int meta;

        public LittleVolume(Block block, int meta) {
            this.block = block;
            this.meta = meta;
        }

        public int hashCode() {
            return this.block.hashCode() + this.meta;
        }

        public boolean equals(Object object) {
            if (object instanceof LittleVolume) {
                return ((LittleVolume)object).block == this.block && ((LittleVolume)object).meta == this.meta;
            }
            return false;
        }
    }
}

