/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.tiles.preview;

import com.creativemd.creativecore.client.rendering.RenderCubeObject;
import com.creativemd.creativecore.common.utils.math.Rotation;
import com.creativemd.creativecore.common.utils.mc.ColorUtils;
import com.creativemd.littletiles.client.tiles.LittleRenderingCube;
import com.creativemd.littletiles.common.tiles.preview.LittleTilePreview;
import com.creativemd.littletiles.common.tiles.vec.LittleTileVec;
import com.creativemd.littletiles.common.utils.grid.LittleGridContext;
import com.creativemd.littletiles.common.utils.ingredients.BlockIngredient;
import com.creativemd.littletiles.common.utils.ingredients.IngredientUtils;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class LittleTilePreviewHandler {
    public static DefaultPreviewHandler defaultHandler = new DefaultPreviewHandler();

    public abstract boolean canBeConvertedToBlockEntry(LittleTilePreview var1);

    public abstract String getPreviewBlockName(LittleTilePreview var1);

    public abstract Block getPreviewBlock(LittleTilePreview var1);

    public abstract int getPreviewBlockMeta(LittleTilePreview var1);

    public abstract boolean hasColor(LittleTilePreview var1);

    public abstract int getColor(LittleTilePreview var1);

    public abstract void setColor(LittleTilePreview var1, int var2);

    @SideOnly(value=Side.CLIENT)
    public abstract RenderCubeObject getCubeBlock(LittleGridContext var1, LittleTilePreview var2);

    public abstract BlockIngredient getBlockIngredient(LittleGridContext var1, LittleTilePreview var2);

    public abstract ItemStack getBlockStack(LittleTilePreview var1);

    public abstract void flipPreview(EnumFacing.Axis var1, LittleTilePreview var2, LittleTileVec var3);

    public abstract void rotatePreview(Rotation var1, LittleTilePreview var2, LittleTileVec var3);

    public abstract boolean canBeNBTGrouped();

    public abstract boolean canBeCombined(LittleTilePreview var1, LittleTilePreview var2);

    public static class DefaultPreviewHandler
    extends LittleTilePreviewHandler {
        @Override
        public boolean canBeConvertedToBlockEntry(LittleTilePreview preview) {
            return true;
        }

        @Override
        public String getPreviewBlockName(LittleTilePreview preview) {
            return preview.getTileData().func_74779_i("block");
        }

        @Override
        public Block getPreviewBlock(LittleTilePreview preview) {
            if (preview.getTileData().func_74764_b("block")) {
                return Block.func_149684_b((String)preview.getTileData().func_74779_i("block"));
            }
            return Blocks.field_150350_a;
        }

        @Override
        public int getPreviewBlockMeta(LittleTilePreview preview) {
            return preview.getTileData().func_74762_e("meta");
        }

        @Override
        public boolean hasColor(LittleTilePreview preview) {
            return preview.getTileData().func_74764_b("color");
        }

        @Override
        public int getColor(LittleTilePreview preview) {
            if (preview.getTileData().func_74764_b("color")) {
                return preview.getTileData().func_74762_e("color");
            }
            return -1;
        }

        @Override
        public void setColor(LittleTilePreview preview, int color) {
            if (ColorUtils.isWhite((int)color) && !ColorUtils.isTransparent((int)color)) {
                if (preview.getTileData().func_74779_i("tID").equals("BlockTileColored")) {
                    preview.getTileData().func_74778_a("tID", "BlockTileBlock");
                }
                preview.getTileData().func_82580_o("color");
            } else {
                if (preview.getTileData().func_74779_i("tID").equals("BlockTileBlock")) {
                    preview.getTileData().func_74778_a("tID", "BlockTileColored");
                }
                preview.getTileData().func_74768_a("color", color);
            }
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public RenderCubeObject getCubeBlock(LittleGridContext context, LittleTilePreview preview) {
            LittleRenderingCube cube = preview.box.getRenderingCube(context, this.getPreviewBlock(preview), this.getPreviewBlockMeta(preview));
            if (preview.getTileData().func_74764_b("color")) {
                cube.color = preview.getTileData().func_74762_e("color");
            }
            return cube;
        }

        @Override
        public BlockIngredient getBlockIngredient(LittleGridContext context, LittleTilePreview preview) {
            return IngredientUtils.getBlockIngredient(this.getPreviewBlock(preview), this.getPreviewBlockMeta(preview), preview.getPercentVolume(context));
        }

        @Override
        public void flipPreview(EnumFacing.Axis axis, LittleTilePreview preview, LittleTileVec doubledCenter) {
        }

        @Override
        public void rotatePreview(Rotation direction, LittleTilePreview preview, LittleTileVec doubledCenter) {
        }

        @Override
        public boolean canBeNBTGrouped() {
            return true;
        }

        @Override
        public ItemStack getBlockStack(LittleTilePreview preview) {
            return new ItemStack(this.getPreviewBlock(preview), 1, this.getPreviewBlockMeta(preview));
        }

        @Override
        public boolean canBeCombined(LittleTilePreview preview, LittleTilePreview other) {
            return preview.getTileData().equals((Object)other.getTileData());
        }
    }
}

