/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.structure.type;

import com.creativemd.creativecore.common.gui.CoreControl;
import com.creativemd.creativecore.common.gui.container.GuiParent;
import com.creativemd.creativecore.common.gui.controls.gui.GuiCheckBox;
import com.creativemd.creativecore.common.gui.controls.gui.GuiLabel;
import com.creativemd.creativecore.common.gui.controls.gui.GuiSteppedSlider;
import com.creativemd.creativecore.common.gui.event.gui.GuiControlChangedEvent;
import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import com.creativemd.creativecore.common.packet.PacketHandler;
import com.creativemd.creativecore.common.utils.type.HashMapList;
import com.creativemd.creativecore.common.utils.type.PairList;
import com.creativemd.creativecore.common.world.CreativeWorld;
import com.creativemd.creativecore.common.world.SubWorld;
import com.creativemd.littletiles.common.action.block.LittleActionActivated;
import com.creativemd.littletiles.common.action.block.LittleActionPlaceStack;
import com.creativemd.littletiles.common.entity.DoorController;
import com.creativemd.littletiles.common.entity.EntityAnimation;
import com.creativemd.littletiles.common.packet.LittleDoorPacket;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.attribute.LittleStructureAttribute;
import com.creativemd.littletiles.common.structure.registry.LittleStructureGuiParser;
import com.creativemd.littletiles.common.structure.registry.LittleStructureRegistry;
import com.creativemd.littletiles.common.structure.registry.LittleStructureType;
import com.creativemd.littletiles.common.structure.relative.StructureAbsolute;
import com.creativemd.littletiles.common.structure.type.LittleAdvancedDoor;
import com.creativemd.littletiles.common.structure.type.LittleAxisDoor;
import com.creativemd.littletiles.common.structure.type.LittleSlidingDoor;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.tiles.LittleTile;
import com.creativemd.littletiles.common.tiles.place.PlacePreviewTile;
import com.creativemd.littletiles.common.tiles.place.PlacePreviews;
import com.creativemd.littletiles.common.tiles.preview.LittleAbsolutePreviewsStructure;
import com.creativemd.littletiles.common.tiles.preview.LittlePreviews;
import com.creativemd.littletiles.common.tiles.vec.LittleTileVec;
import com.creativemd.littletiles.common.utils.animation.AnimationGuiHandler;
import com.creativemd.littletiles.common.utils.animation.AnimationKey;
import com.creativemd.littletiles.common.utils.animation.AnimationTimeline;
import com.creativemd.littletiles.common.utils.animation.ValueTimeline;
import com.creativemd.littletiles.common.utils.grid.LittleGridContext;
import com.creativemd.littletiles.common.utils.placing.PlacementMode;
import com.n247s.api.eventapi.eventsystem.CustomEventSubscribe;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class LittleDoorBase
extends LittleStructure {
    public int duration = 50;
    public boolean stayAnimated = false;

    public LittleDoorBase(LittleStructureType type) {
        super(type);
    }

    @Override
    protected void loadFromNBTExtra(NBTTagCompound nbt) {
        this.duration = nbt.func_74764_b("duration") ? nbt.func_74762_e("duration") : 50;
        this.stayAnimated = nbt.func_74767_n("stayAnimated");
    }

    @Override
    protected void writeToNBTExtra(NBTTagCompound nbt) {
        nbt.func_74768_a("duration", this.duration);
        if (this.stayAnimated) {
            nbt.func_74757_a("stayAnimated", this.stayAnimated);
        }
    }

    public boolean place(World world, EntityPlayer player, LittleAbsolutePreviewsStructure previews, DoorController controller, UUID uuid, StructureAbsolute absolute) {
        ArrayList<PlacePreviewTile> placePreviews = new ArrayList<PlacePreviewTile>();
        previews.getPlacePreviews(placePreviews, null, true, LittleTileVec.ZERO);
        HashMap<BlockPos, PlacePreviews> splitted = LittleActionPlaceStack.getSplittedTiles(previews.context, placePreviews, previews.pos);
        if (LittleActionPlaceStack.canPlaceTiles(player, world, splitted, PlacementMode.all.getCoordsToCheck(splitted, previews.pos), PlacementMode.all)) {
            ArrayList blocks = new ArrayList();
            SubWorld fakeWorld = SubWorld.createFakeWorld((World)world);
            LittleActionPlaceStack.placeTilesWithoutPlayer((World)fakeWorld, previews.context, splitted, previews.getStructure(), PlacementMode.all, previews.pos, null, null, null, null);
            controller.activator = player;
            if (world.field_72995_K) {
                controller.markWaitingForApprove();
                for (TileEntityLittleTiles te : this.tiles.keySet()) {
                    if (te.waitingAnimation == null) continue;
                    te.clearWaitingAnimations();
                }
            }
            LittleStructure newDoor = previews.getStructure();
            EntityAnimation animation = new EntityAnimation(world, (CreativeWorld)fakeWorld, controller, previews.pos, uuid, absolute);
            if (this.parent != null) {
                LittleStructure parentStructure = this.parent.getStructure(world);
                parentStructure.updateChildConnection(this.parent.getChildID(), newDoor);
                newDoor.updateParentConnection(this.parent.getChildID(), parentStructure);
            }
            world.func_72838_d((Entity)animation);
            return true;
        }
        return false;
    }

    public boolean activate(World world, @Nullable EntityPlayer player, BlockPos pos, @Nullable LittleTile tile) {
        if (!this.hasLoaded() || !this.loadChildren()) {
            player.func_146105_b((ITextComponent)new TextComponentTranslation("Cannot interact with door! Not all tiles are loaded!", new Object[0]), true);
            return false;
        }
        if (this.isChildMoving()) {
            player.func_146105_b((ITextComponent)new TextComponentTranslation("A child is still in motion!", new Object[0]), true);
            return false;
        }
        UUID uuid = UUID.randomUUID();
        if (world.field_72995_K) {
            PacketHandler.sendPacketToServer((CreativeCorePacket)new LittleDoorPacket(tile != null ? tile : this.getMainTile(), uuid));
        }
        this.openDoor(world, player, uuid);
        return true;
    }

    public void openDoor(World world, @Nullable EntityPlayer player, UUID uuid) {
        HashMapList<TileEntityLittleTiles, LittleTile> tempTiles = this.getAllTiles((HashMapList<TileEntityLittleTiles, LittleTile>)new HashMapList());
        HashMap<TileEntityLittleTiles, LittleGridContext> tempContext = new HashMap<TileEntityLittleTiles, LittleGridContext>();
        StructureAbsolute absolute = this.getAbsoluteAxis();
        for (TileEntityLittleTiles te : tempTiles.keySet()) {
            tempContext.put(te, te.getContext());
        }
        for (Map.Entry entry : tempTiles.entrySet()) {
            ((TileEntityLittleTiles)entry.getKey()).preventUpdate = true;
            ((TileEntityLittleTiles)entry.getKey()).removeTiles((Collection)entry.getValue());
            ((TileEntityLittleTiles)entry.getKey()).preventUpdate = false;
        }
        if (this.tryToPlacePreviews(world, player, uuid, absolute)) {
            for (Map.Entry entry : tempTiles.entrySet()) {
                ((TileEntityLittleTiles)entry.getKey()).updateTiles();
            }
            return;
        }
        for (Map.Entry entry : tempTiles.entrySet()) {
            ((TileEntityLittleTiles)entry.getKey()).convertTo((LittleGridContext)tempContext.get(entry.getKey()));
            ((TileEntityLittleTiles)entry.getKey()).addTiles((Collection)entry.getValue());
        }
    }

    public abstract boolean tryToPlacePreviews(World var1, EntityPlayer var2, UUID var3, StructureAbsolute var4);

    @Override
    public boolean onBlockActivated(World world, LittleTile tile, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ, LittleActionActivated action) {
        if (world.field_72995_K) {
            this.activate(world, player, pos, tile);
            action.preventInteraction = true;
        }
        return true;
    }

    public abstract StructureAbsolute getAbsoluteAxis();

    public static void initDoors() {
        LittleStructureRegistry.registerStructureType("door", "door", LittleAxisDoor.class, LittleStructureAttribute.NONE, LittleAxisDoor.LittleAxisDoorParser.class);
        LittleStructureRegistry.registerStructureType("slidingDoor", "door", LittleSlidingDoor.class, LittleStructureAttribute.NONE, LittleSlidingDoor.LittleSlidingDoorParser.class);
        LittleStructureRegistry.registerStructureType("advancedDoor", "door", LittleAdvancedDoor.class, LittleStructureAttribute.NONE, LittleAdvancedDoor.LittleAdvancedDoorParser.class);
    }

    public static abstract class LittleDoorBaseParser
    extends LittleStructureGuiParser {
        public LittleDoorBaseParser(GuiParent parent, AnimationGuiHandler handler) {
            super(parent, handler);
        }

        @SideOnly(value=Side.CLIENT)
        @CustomEventSubscribe
        public void onChanged(GuiControlChangedEvent event) {
            if (event.source.is(new String[]{"duration_s"})) {
                this.updateTimeline();
            }
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void createControls(LittlePreviews previews, LittleStructure structure) {
            this.parent.controls.add(new GuiCheckBox("stayAnimated", CoreControl.translate((String)"gui.door.stayAnimated"), 0, 120, structure instanceof LittleDoorBase ? ((LittleDoorBase)structure).stayAnimated : false).setCustomTooltip(new String[]{CoreControl.translate((String)"gui.door.stayAnimatedTooltip")}));
            this.parent.controls.add(new GuiLabel(CoreControl.translate((String)"gui.door.duration") + ":", 90, 122));
            this.parent.controls.add(new GuiSteppedSlider("duration_s", 140, 122, 50, 6, structure instanceof LittleDoorBase ? ((LittleDoorBase)structure).duration : 50, 1, 500));
            this.updateTimeline();
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public LittleDoorBase parseStructure(LittlePreviews previews) {
            GuiSteppedSlider slider = (GuiSteppedSlider)this.parent.get("duration_s");
            GuiCheckBox checkBox = (GuiCheckBox)this.parent.get("stayAnimated");
            return this.parseStructure((int)slider.value, checkBox.value);
        }

        @SideOnly(value=Side.CLIENT)
        public abstract LittleDoorBase parseStructure(int var1, boolean var2);

        @SideOnly(value=Side.CLIENT)
        public abstract void populateTimeline(AnimationTimeline var1);

        public void updateTimeline() {
            GuiSteppedSlider slider = (GuiSteppedSlider)this.parent.get("duration_s");
            AnimationTimeline timeline = new AnimationTimeline((int)slider.value, (PairList<AnimationKey, ValueTimeline>)new PairList());
            this.populateTimeline(timeline);
            this.handler.setTimeline(timeline);
        }
    }
}

