/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.structure;

import com.creativemd.creativecore.common.utils.math.Rotation;
import com.creativemd.creativecore.common.utils.mc.WorldUtils;
import com.creativemd.creativecore.common.utils.type.HashMapList;
import com.creativemd.creativecore.common.world.SubWorld;
import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.common.action.block.LittleActionActivated;
import com.creativemd.littletiles.common.structure.attribute.LittleStructureAttribute;
import com.creativemd.littletiles.common.structure.connection.IStructureChildConnector;
import com.creativemd.littletiles.common.structure.connection.StructureLink;
import com.creativemd.littletiles.common.structure.connection.StructureLinkFromSubWorld;
import com.creativemd.littletiles.common.structure.connection.StructureLinkTile;
import com.creativemd.littletiles.common.structure.connection.StructureLinkToSubWorld;
import com.creativemd.littletiles.common.structure.connection.StructureMainTile;
import com.creativemd.littletiles.common.structure.registry.LittleStructureRegistry;
import com.creativemd.littletiles.common.structure.registry.LittleStructureType;
import com.creativemd.littletiles.common.structure.relative.StructureRelative;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.tiles.LittleTile;
import com.creativemd.littletiles.common.tiles.place.PlacePreviewTile;
import com.creativemd.littletiles.common.tiles.preview.LittleAbsolutePreviewsStructure;
import com.creativemd.littletiles.common.tiles.preview.LittlePreviews;
import com.creativemd.littletiles.common.tiles.preview.LittlePreviewsStructure;
import com.creativemd.littletiles.common.tiles.preview.LittleTilePreview;
import com.creativemd.littletiles.common.tiles.vec.LittleTileIdentifierRelative;
import com.creativemd.littletiles.common.tiles.vec.LittleTileIdentifierStructureRelative;
import com.creativemd.littletiles.common.tiles.vec.LittleTilePos;
import com.creativemd.littletiles.common.tiles.vec.LittleTileVec;
import com.creativemd.littletiles.common.tiles.vec.LittleTileVecContext;
import com.creativemd.littletiles.common.tiles.vec.RelativeBlockPos;
import com.creativemd.littletiles.common.utils.grid.LittleGridContext;
import com.creativemd.littletiles.common.utils.ingredients.Ingredients;
import com.creativemd.littletiles.common.utils.vec.SurroundingBox;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public abstract class LittleStructure {
    public final LittleStructureAttribute attribute;
    public final LittleStructureType type;
    public String name;
    public IStructureChildConnector parent;
    public LinkedHashMap<Integer, IStructureChildConnector> children;
    public List<LittleStructure> tempChildren;
    public LittleTilePos lastMainTileVec = null;
    private LittleTile mainTile;
    protected HashMapList<TileEntityLittleTiles, LittleTile> tiles = null;
    public HashMap<BlockPos, Integer> tilesToLoad = null;

    public static LittleStructure createAndLoadStructure(NBTTagCompound nbt, @Nullable LittleTile mainTile) {
        if (nbt == null) {
            return null;
        }
        String id = nbt.func_74779_i("id");
        LittleStructureType type = LittleStructureRegistry.getStructureType(id);
        if (type != null) {
            LittleStructure structure = type.createStructure();
            structure.mainTile = mainTile;
            structure.loadFromNBT(nbt);
            return structure;
        }
        System.out.println("Could not find structureID=" + id);
        return null;
    }

    public LittleStructure(LittleStructureType type) {
        this.attribute = type.attribute;
        this.type = type;
    }

    public void placedStructure(@Nullable ItemStack stack) {
        NBTTagCompound nbt;
        if (this.name == null && stack != null && (nbt = stack.func_179543_a("display")) != null && nbt.func_150297_b("Name", 8)) {
            this.name = nbt.func_74779_i("Name");
        }
        this.combineTiles();
        if (this.tempChildren != null) {
            this.children = new LinkedHashMap();
            for (int i = 0; i < this.tempChildren.size(); ++i) {
                LittleStructure child = this.tempChildren.get(i);
                child.updateParentConnection(i, this);
                this.updateChildConnection(i, child);
                child.placedStructure(null);
            }
            this.tempChildren = null;
        }
    }

    public void updateStructure() {
        this.mainTile.te.updateBlock();
    }

    public void setMainTile(LittleTile tile) {
        this.mainTile = tile;
        if (this.parent != null) {
            LittleStructure parentStructure = this.parent.getStructure(this.getWorld());
            parentStructure.updateChildConnection(this.parent.getChildID(), this);
            this.updateParentConnection(this.parent.getChildID(), parentStructure);
        }
        for (IStructureChildConnector child : this.children.values()) {
            LittleStructure childStructure = child.getStructure(this.getWorld());
            childStructure.updateParentConnection(child.getChildID(), this);
            this.updateChildConnection(child.getChildID(), childStructure);
        }
        this.mainTile.connection = new StructureMainTile(this.mainTile, this);
        this.updateStructure();
        if (this.tiles == null) {
            this.tiles = new HashMapList();
            this.tiles.add((Object)this.mainTile.te, (Object)this.mainTile);
        } else if (!this.containsTile(tile)) {
            this.addTile(tile);
        }
        for (Map.Entry entry : this.tiles.entrySet()) {
            ((TileEntityLittleTiles)entry.getKey()).func_145831_w().func_175646_b(((TileEntityLittleTiles)entry.getKey()).func_174877_v(), (TileEntity)entry.getKey());
            for (LittleTile stTile : (ArrayList)entry.getValue()) {
                if (stTile == this.mainTile) continue;
                stTile.connection = this.getStructureLink(stTile);
                stTile.connection.setLoadedStructure(this, this.attribute);
            }
        }
        LittleTilePos absolute = tile.getAbsolutePos();
        if (this.lastMainTileVec != null) {
            LittleTileVecContext vec = this.lastMainTileVec.getRelative(absolute);
            if (!this.lastMainTileVec.equals(absolute)) {
                for (LittleStructureType.StructureTypeRelative relative : this.type.relatives) {
                    StructureRelative relativeST = relative.getRelative(this);
                    if (relativeST == null) continue;
                    relativeST.onMove(this, vec.context, vec.vec);
                }
            }
        }
        this.lastMainTileVec = absolute;
    }

    public LittleTileIdentifierStructureRelative getMainTileCoord(BlockPos pos) {
        return new LittleTileIdentifierStructureRelative(pos, this.mainTile.te.func_174877_v(), this.mainTile.getContext(), this.mainTile.getIdentifier(), this.attribute);
    }

    public StructureLinkTile getStructureLink(LittleTile tile) {
        return new StructureLinkTile((TileEntity)tile.te, this.mainTile.te.func_174877_v(), this.mainTile.getContext(), this.mainTile.getIdentifier(), this.attribute, tile);
    }

    public boolean hasMainTile() {
        return this.mainTile != null;
    }

    public boolean isPlaced() {
        return this.hasMainTile();
    }

    public void combineTiles() {
        if (!this.hasLoaded()) {
            return;
        }
        Object pos = null;
        Iterator iterator = this.tiles.keySet().iterator();
        while (iterator.hasNext()) {
            ((TileEntityLittleTiles)iterator.next()).combineTiles(this);
        }
    }

    public boolean selectMainTile() {
        LittleTile first;
        if (this.hasLoaded() && (first = (LittleTile)this.tiles.getFirst()) != null) {
            this.setMainTile(first);
            return true;
        }
        return false;
    }

    public LittleTile getMainTile() {
        return this.mainTile;
    }

    public void setTiles(HashMapList<TileEntityLittleTiles, LittleTile> tiles) {
        this.tiles = tiles;
    }

    public boolean LoadList() {
        if (this.tiles == null) {
            return this.loadTiles();
        }
        return true;
    }

    public boolean containsTile(LittleTile tile) {
        return this.tiles.contains((Object)tile.te, (Object)tile);
    }

    public HashMapList<TileEntityLittleTiles, LittleTile> copyOfTiles() {
        if (this.tiles == null && !this.loadTiles()) {
            return new HashMapList();
        }
        return new HashMapList(this.tiles);
    }

    public Set<Map.Entry<TileEntityLittleTiles, ArrayList<LittleTile>>> getEntrySet() {
        return this.tiles.entrySet();
    }

    public Iterator<LittleTile> getTiles() {
        if (this.tiles == null && !this.loadTiles()) {
            return new Iterator<LittleTile>(){

                @Override
                public boolean hasNext() {
                    return false;
                }

                @Override
                public LittleTile next() {
                    return null;
                }
            };
        }
        return this.tiles.iterator();
    }

    public Set<Map.Entry<TileEntityLittleTiles, ArrayList<LittleTile>>> entrySet() {
        if (this.tiles == null && !this.loadTiles()) {
            return Collections.EMPTY_SET;
        }
        return this.tiles.entrySet();
    }

    public HashMapList<TileEntityLittleTiles, LittleTile> getAllTiles(HashMapList<TileEntityLittleTiles, LittleTile> tiles) {
        if (!this.hasLoaded() || !this.loadChildren()) {
            return tiles;
        }
        for (Map.Entry entry : this.tiles.entrySet()) {
            tiles.add(entry.getKey(), (List)entry.getValue());
        }
        for (IStructureChildConnector child : this.children.values()) {
            child.getStructure(this.getWorld()).getAllTiles(tiles);
        }
        return tiles;
    }

    public void removeTile(LittleTile tile) {
        if (this.tiles != null) {
            this.tiles.removeValue((Object)tile.te, (Object)tile);
        }
    }

    public void addTile(LittleTile tile) {
        this.tiles.add((Object)tile.te, (Object)tile);
    }

    public boolean hasLoaded() {
        this.loadTiles();
        return this.mainTile != null && this.tiles != null && (this.tilesToLoad == null || this.tilesToLoad.size() == 0) && !this.isRelationToParentBroken() && !this.isRelationToChildrenBroken();
    }

    public boolean isRelationToParentBroken() {
        return this.parent != null && !this.parent.isConnected(this.getWorld());
    }

    public boolean isRelationToChildrenBroken() {
        for (IStructureChildConnector child : this.children.values()) {
            if (child.isConnected(this.getWorld())) continue;
            return true;
        }
        return false;
    }

    public void updateChildConnection(int i, LittleStructure child) {
        IStructureChildConnector<LittleStructure> connector;
        World world = this.getWorld();
        World childWorld = child.getWorld();
        if (childWorld == world) {
            connector = new StructureLink((TileEntity)this.mainTile.te, child.getMainTile().te.func_174877_v(), child.getMainTile().getContext(), child.getMainTile().getIdentifier(), child.attribute, this, i, false);
        } else if (childWorld instanceof SubWorld && ((SubWorld)childWorld).parent != null) {
            connector = new StructureLinkToSubWorld(child.getMainTile(), child.attribute, this, i, ((SubWorld)childWorld).parent.func_110124_au().toString());
        } else {
            throw new RuntimeException("Invalid connection between to structures!");
        }
        connector.setLoadedStructure(child, child.attribute);
        this.children.put(i, connector);
    }

    public void updateParentConnection(int i, LittleStructure parent) {
        IStructureChildConnector<LittleStructure> connector;
        World world = this.getWorld();
        World parentWorld = parent.getWorld();
        if (parentWorld == world) {
            connector = new StructureLink((TileEntity)this.mainTile.te, parent.getMainTile().te.func_174877_v(), parent.getMainTile().getContext(), parent.getMainTile().getIdentifier(), parent.attribute, this, i, true);
        } else if (world instanceof SubWorld && ((SubWorld)world).parent != null) {
            connector = new StructureLinkFromSubWorld(parent.getMainTile(), parent.attribute, this, i);
        } else {
            throw new RuntimeException("Invalid connection between to structures!");
        }
        connector.setLoadedStructure(parent, parent.attribute);
        this.parent = connector;
    }

    public boolean loadTiles() {
        if (this.mainTile != null) {
            if (this.tiles == null) {
                this.tiles = new HashMapList();
                this.addTile(this.mainTile);
            }
            if (this.tilesToLoad == null) {
                return true;
            }
            Iterator<Map.Entry<BlockPos, Integer>> iterator = this.tilesToLoad.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<BlockPos, Integer> entry = iterator.next();
                if (!this.checkForTiles(this.mainTile.te.func_145831_w(), entry.getKey(), entry.getValue())) continue;
                iterator.remove();
            }
            if (!this.tiles.contains((Object)this.mainTile)) {
                this.addTile(this.mainTile);
            }
            if (this.tilesToLoad.size() == 0) {
                this.tilesToLoad = null;
            }
            return true;
        }
        return false;
    }

    public boolean loadParent() {
        if (this.parent != null) {
            return this.parent.isConnected(this.getWorld());
        }
        return true;
    }

    public boolean loadChildren() {
        if (this.children == null) {
            this.children = new LinkedHashMap();
        }
        if (this.children.isEmpty()) {
            return true;
        }
        for (IStructureChildConnector child : this.children.values()) {
            if (child.isConnected(this.mainTile.te.func_145831_w()) && child.getStructureWithoutLoading().hasLoaded() && child.getStructureWithoutLoading().loadChildren()) continue;
            return false;
        }
        return true;
    }

    public boolean isChildMoving() {
        for (IStructureChildConnector child : this.children.values()) {
            if (child.isLinkToAnotherWorld()) {
                return true;
            }
            if (!child.getStructure(this.getWorld()).isChildMoving()) continue;
            return true;
        }
        return false;
    }

    public void loadStructure(LittleTile mainTile) {
        this.mainTile = mainTile;
        this.mainTile.connection = new StructureMainTile(mainTile, this);
        if (this.tiles != null && !this.containsTile(mainTile)) {
            this.addTile(mainTile);
        }
    }

    public void loadFromNBT(NBTTagCompound nbt) {
        Object pos;
        int i;
        if (this.tiles != null) {
            this.tiles = null;
        }
        this.tilesToLoad = new HashMap();
        if (nbt.func_74764_b("count")) {
            int count = nbt.func_74762_e("count");
            for (i = 0; i < count; ++i) {
                LittleTileIdentifierRelative coord = null;
                if (nbt.func_74764_b("i" + i + "coX")) {
                    pos = new LittleTile.LittleTilePosition("i" + i, nbt);
                    coord = new LittleTileIdentifierRelative((TileEntity)this.mainTile.te, ((LittleTile.LittleTilePosition)pos).coord, LittleGridContext.get(), new int[]{((LittleTile.LittleTilePosition)pos).position.x, ((LittleTile.LittleTilePosition)pos).position.y, ((LittleTile.LittleTilePosition)pos).position.z});
                } else {
                    coord = LittleTileIdentifierRelative.loadIdentifierOld("i" + i, nbt);
                }
                pos = coord.getAbsolutePosition((TileEntity)this.mainTile.te);
                Integer insideBlock = this.tilesToLoad.get(pos);
                insideBlock = insideBlock == null ? new Integer(1) : Integer.valueOf(insideBlock + 1);
                this.tilesToLoad.put((BlockPos)pos, insideBlock);
            }
        } else if (nbt.func_74764_b("tiles")) {
            NBTTagList list = nbt.func_150295_c("tiles", 11);
            for (i = 0; i < list.func_74745_c(); ++i) {
                int[] array = list.func_150306_c(i);
                if (array.length == 4) {
                    pos = new RelativeBlockPos(array);
                    this.tilesToLoad.put(((RelativeBlockPos)pos).getAbsolutePos((TileEntity)this.mainTile.te), array[3]);
                    continue;
                }
                System.out.println("Found invalid array! " + nbt);
            }
        }
        this.name = nbt.func_74764_b("name") ? nbt.func_74779_i("name") : null;
        this.parent = nbt.func_74764_b("parent") ? StructureLink.loadFromNBT(this, nbt.func_74775_l("parent"), true) : null;
        if (nbt.func_74764_b("children")) {
            this.children = new LinkedHashMap();
            NBTTagList list = nbt.func_150295_c("children", 10);
            for (i = 0; i < list.func_74745_c(); ++i) {
                IStructureChildConnector child = StructureLink.loadFromNBT(this, list.func_150305_b(i), false);
                this.children.put(child.getChildID(), child);
            }
        } else {
            this.children = new LinkedHashMap();
        }
        for (LittleStructureType.StructureTypeRelative relative : this.type.relatives) {
            if (nbt.func_74764_b(relative.saveKey)) {
                relative.createAndSetRelative(this, nbt);
                continue;
            }
            this.failedLoadingRelative(nbt, relative);
        }
        this.loadFromNBTExtra(nbt);
    }

    protected void failedLoadingRelative(NBTTagCompound nbt, LittleStructureType.StructureTypeRelative relative) {
        relative.setRelative(this, null);
    }

    protected abstract void loadFromNBTExtra(NBTTagCompound var1);

    public NBTTagCompound writeToNBTPreview(NBTTagCompound nbt, BlockPos newCenter) {
        nbt.func_74778_a("id", this.type.id);
        if (this.name != null) {
            nbt.func_74778_a("name", this.name);
        } else {
            nbt.func_82580_o("name");
        }
        LittleTileVecContext vec = this.getMainTile().getAbsolutePos().getRelative(new LittleTilePos(newCenter, this.getMainTile().getContext()));
        LittleTileVec inverted = vec.vec.copy();
        inverted.invert();
        for (LittleStructureType.StructureTypeRelative relative : this.type.relatives) {
            StructureRelative relativeST = relative.getRelative(this);
            if (relativeST == null) continue;
            relativeST.onMove(this, vec.context, vec.vec);
            relativeST.writeToNBT(relative.saveKey, nbt);
            relativeST.onMove(this, vec.context, inverted);
        }
        this.writeToNBTExtra(nbt);
        return nbt;
    }

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74778_a("id", this.type.id);
        if (this.name != null) {
            nbt.func_74778_a("name", this.name);
        } else {
            nbt.func_82580_o("name");
        }
        if (this.parent != null) {
            nbt.func_74782_a("parent", (NBTBase)this.parent.writeToNBT(new NBTTagCompound()));
        }
        if (this.children != null && !this.children.isEmpty()) {
            NBTTagList list = new NBTTagList();
            for (IStructureChildConnector child : this.children.values()) {
                list.func_74742_a((NBTBase)child.writeToNBT(new NBTTagCompound()));
            }
            nbt.func_74782_a("children", (NBTBase)list);
        }
        HashMap<BlockPos, Integer> positions = new HashMap<BlockPos, Integer>();
        if (this.tiles != null) {
            for (Map.Entry entry : this.tiles.entrySet()) {
                if (((ArrayList)entry.getValue()).size() <= 0) continue;
                positions.put(((TileEntityLittleTiles)entry.getKey()).func_174877_v(), ((ArrayList)entry.getValue()).size());
            }
        }
        if (this.tilesToLoad != null) {
            positions.putAll(this.tilesToLoad);
        }
        if (positions.size() > 0) {
            NBTTagList list = new NBTTagList();
            for (Map.Entry entry : positions.entrySet()) {
                RelativeBlockPos pos = new RelativeBlockPos((TileEntity)this.mainTile.te, (BlockPos)entry.getKey());
                list.func_74742_a((NBTBase)new NBTTagIntArray(new int[]{pos.getRelativePos().func_177958_n(), pos.getRelativePos().func_177956_o(), pos.getRelativePos().func_177952_p(), (Integer)entry.getValue()}));
            }
            nbt.func_74782_a("tiles", (NBTBase)list);
        }
        for (LittleStructureType.StructureTypeRelative relative : this.type.relatives) {
            StructureRelative relativeST = relative.getRelative(this);
            if (relativeST == null) continue;
            relativeST.writeToNBT(relative.saveKey, nbt);
        }
        this.writeToNBTExtra(nbt);
    }

    protected abstract void writeToNBTExtra(NBTTagCompound var1);

    public boolean doesLinkToMainTile(LittleTile tile) {
        try {
            return tile == this.getMainTile() || tile.connection.isLink() && tile.connection.getStructurePosition().equals((Object)this.mainTile.te.func_174877_v()) && tile.connection.is(this.mainTile);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean checkForTiles(World world, BlockPos pos, Integer expectedCount) {
        TileEntity tileEntity;
        Chunk chunk = world.func_175726_f(pos);
        if (WorldUtils.checkIfChunkExists((Chunk)chunk) && (tileEntity = world.func_175625_s(pos)) instanceof TileEntityLittleTiles) {
            if (!((TileEntityLittleTiles)tileEntity).hasLoaded()) {
                return false;
            }
            int found = 0;
            if (this.tiles.keySet().contains(tileEntity)) {
                this.tiles.removeKey((Object)((TileEntityLittleTiles)tileEntity));
            }
            for (LittleTile tile : ((TileEntityLittleTiles)tileEntity).getTiles()) {
                if (!tile.isChildOfStructure() || tile.connection.getStructureWithoutLoading() != this && !this.doesLinkToMainTile(tile)) continue;
                this.tiles.add((Object)((TileEntityLittleTiles)tileEntity), (Object)tile);
                if (tile.connection.isLink()) {
                    tile.connection.setLoadedStructure(this, this.attribute);
                }
                ++found;
            }
            if (found == expectedCount) {
                return true;
            }
        }
        return false;
    }

    public int countTiles() {
        int count = 0;
        if (this.tilesToLoad != null) {
            for (Integer tiles : this.tilesToLoad.values()) {
                count += tiles.intValue();
            }
        }
        if (this.tiles != null) {
            for (Map.Entry entry : this.tiles.entrySet()) {
                if (this.tilesToLoad != null && this.tilesToLoad.containsKey(((TileEntityLittleTiles)entry.getKey()).func_174877_v())) continue;
                count += ((ArrayList)entry.getValue()).size();
            }
        }
        return count;
    }

    public World getWorld() {
        return this.mainTile.te.func_145831_w();
    }

    public void onLittleTileDestroy() {
        if (this.parent != null) {
            if (this.parent.isConnected(this.getWorld())) {
                this.parent.getStructure(this.getWorld()).onLittleTileDestroy();
            }
            return;
        }
        if (this.hasLoaded() && this.loadChildren()) {
            for (Map.Entry entry : this.tiles.entrySet()) {
                ((TileEntityLittleTiles)entry.getKey()).removeTiles((Collection)entry.getValue());
            }
            for (IStructureChildConnector child : this.children.values()) {
                child.destroyStructure();
            }
        }
    }

    public void addIngredients(Ingredients ingredients) {
    }

    public LittleGridContext getMinContext() {
        LittleGridContext context = LittleGridContext.getMin();
        for (IStructureChildConnector child : this.children.values()) {
            context = LittleGridContext.max(context, child.getStructure(this.getWorld()).getMinContext());
        }
        for (LittleStructureType.StructureTypeRelative relative : this.type.relatives) {
            StructureRelative relativeST = relative.getRelative(this);
            if (relativeST == null) continue;
            relativeST.convertToSmallest();
            context = LittleGridContext.max(context, relativeST.getContext());
        }
        return context;
    }

    public LittlePreviewsStructure getPreviews(BlockPos pos) {
        NBTTagCompound structureNBT = new NBTTagCompound();
        this.writeToNBTPreview(structureNBT, pos);
        LittlePreviewsStructure previews = new LittlePreviewsStructure(structureNBT, this.getMinContext());
        Iterator<LittleTile> iterator = this.getTiles();
        while (iterator.hasNext()) {
            LittleTile tile = iterator.next();
            LittleTilePreview preview = previews.addTile(tile);
            preview.box.add(new LittleTileVec(previews.context, (Vec3i)tile.te.func_174877_v().func_177973_b((Vec3i)pos)));
        }
        for (IStructureChildConnector child : this.children.values()) {
            previews.addChild(child.getStructure(this.getWorld()).getPreviews(pos));
        }
        previews.convertToSmallest();
        previews.ensureContext(this.getMinContext());
        return previews;
    }

    public LittleAbsolutePreviewsStructure getAbsolutePreviews(BlockPos pos) {
        NBTTagCompound structureNBT = new NBTTagCompound();
        this.writeToNBTPreview(structureNBT, pos);
        LittleAbsolutePreviewsStructure previews = new LittleAbsolutePreviewsStructure(structureNBT, pos, this.getMinContext());
        Iterator<LittleTile> iterator = this.getTiles();
        while (iterator.hasNext()) {
            previews.addTile(iterator.next());
        }
        for (IStructureChildConnector child : this.children.values()) {
            previews.addChild(child.getStructure(this.getWorld()).getPreviews(pos));
        }
        previews.convertToSmallest();
        previews.ensureContext(this.getMinContext());
        return previews;
    }

    public BlockPos.MutableBlockPos getMinPos(BlockPos.MutableBlockPos pos) {
        for (TileEntityLittleTiles te : this.tiles.keySet()) {
            pos.func_181079_c(Math.min(pos.func_177958_n(), te.func_174877_v().func_177958_n()), Math.min(pos.func_177956_o(), te.func_174877_v().func_177956_o()), Math.min(pos.func_177952_p(), te.func_174877_v().func_177952_p()));
        }
        for (IStructureChildConnector child : this.children.values()) {
            child.getStructure(this.getWorld()).getMinPos(pos);
        }
        return pos;
    }

    public List<PlacePreviewTile> getSpecialTiles(LittlePreviews previews) {
        if (this.type.relatives.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<PlacePreviewTile> placePreviews = new ArrayList<PlacePreviewTile>();
        for (LittleStructureType.StructureTypeRelative relative : this.type.relatives) {
            StructureRelative relativeST = relative.getRelative(this);
            if (relativeST == null) continue;
            PlacePreviewTile tile = this.getPlacePreview(relativeST, relative, previews);
            if (relativeST.getContext().size < previews.context.size) {
                tile.convertTo(relativeST.getContext(), previews.context);
            }
            placePreviews.add(tile);
        }
        return placePreviews;
    }

    protected PlacePreviewTile getPlacePreview(StructureRelative relative, LittleStructureType.StructureTypeRelative type, LittlePreviews previews) {
        return relative.getPlacePreview(previews, type);
    }

    public ItemStack getStructureDrop() {
        if (this.parent != null) {
            if (this.parent.isConnected(this.getWorld())) {
                return this.parent.getStructure(this.getWorld()).getStructureDrop();
            }
            return ItemStack.field_190927_a;
        }
        if (this.hasLoaded() && this.loadChildren()) {
            BlockPos.MutableBlockPos pos = this.getMinPos(new BlockPos.MutableBlockPos(this.getMainTile().te.func_174877_v()));
            ItemStack stack = new ItemStack(LittleTiles.multiTiles);
            LittlePreviewsStructure previews = this.getPreviews((BlockPos)pos);
            LittleTilePreview.savePreview(previews, stack);
            if (this.name != null) {
                NBTTagCompound display = new NBTTagCompound();
                display.func_74778_a("Name", this.name);
                stack.func_77978_p().func_74782_a("display", (NBTBase)display);
            }
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    public boolean onBlockActivated(World worldIn, LittleTile tile, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ, LittleActionActivated action) {
        return false;
    }

    public void onMove(World world, @Nullable EntityPlayer player, @Nullable ItemStack stack, LittleGridContext context, LittleTileVec offset) {
        for (LittleStructureType.StructureTypeRelative relative : this.type.relatives) {
            StructureRelative relativeST = relative.getRelative(this);
            if (relativeST == null) continue;
            relativeST.onMove(this, context, offset);
        }
    }

    public void onFlip(World world, @Nullable EntityPlayer player, @Nullable ItemStack stack, LittleGridContext context, EnumFacing.Axis axis, LittleTileVec doubledCenter) {
        for (LittleStructureType.StructureTypeRelative relative : this.type.relatives) {
            StructureRelative relativeST = relative.getRelative(this);
            if (relativeST == null) continue;
            relativeST.onFlip(this, context, axis, doubledCenter);
        }
    }

    public void onRotate(World world, @Nullable EntityPlayer player, @Nullable ItemStack stack, LittleGridContext context, Rotation rotation, LittleTileVec doubledCenter) {
        for (LittleStructureType.StructureTypeRelative relative : this.type.relatives) {
            StructureRelative relativeST = relative.getRelative(this);
            if (relativeST == null) continue;
            relativeST.onRotate(this, context, rotation, doubledCenter);
        }
    }

    public AxisAlignedBB getSurroundingBox() {
        return new SurroundingBox(true).add(this.tiles.entrySet()).getSurroundingBox();
    }

    public Vec3d getHighestCenterVec() {
        return new SurroundingBox(true).add(this.tiles.entrySet()).getHighestCenterVec();
    }

    public LittleTilePos getHighestCenterPoint() {
        return new SurroundingBox(true).add(this.tiles.entrySet()).getHighestCenterPoint();
    }

    public boolean shouldPlaceTile(LittleTile tile) {
        return true;
    }

    public boolean isBed(IBlockAccess world, BlockPos pos, EntityLivingBase player) {
        return false;
    }

    public boolean shouldCheckForCollision() {
        return false;
    }

    public void onEntityCollidedWithBlock(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
    }

    public void onUpdatePacketReceived() {
    }

    public void removeWorldProperties() {
        this.mainTile = null;
        this.tiles = new HashMapList();
        this.tilesToLoad = null;
    }

    public boolean canOnlyBePlacedByItemStack() {
        return false;
    }

    public String getStructureDropIdentifier() {
        return null;
    }
}

