/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.gui.controls;

import com.creativemd.creativecore.common.gui.controls.container.SlotControl;
import com.creativemd.creativecore.common.gui.controls.container.client.GuiSlotControl;
import com.creativemd.littletiles.common.gui.controls.SlotControlBlockIngredient;
import com.creativemd.littletiles.common.items.ItemBlockTiles;
import com.creativemd.littletiles.common.tiles.preview.LittleTilePreview;
import com.creativemd.littletiles.common.tiles.vec.LittleTileSize;
import com.creativemd.littletiles.common.utils.grid.LittleGridContext;
import com.creativemd.littletiles.common.utils.ingredients.BlockIngredient;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;

public class GuiSlotControlBlockIngredient
extends GuiSlotControl {
    public GuiSlotControlBlockIngredient(int x, int y, SlotControl slot, BlockIngredient ingredient) {
        super(x, y, slot);
    }

    public ItemStack getStackToRender() {
        ItemStack stack = super.getStackToRender();
        if (stack.func_77973_b() instanceof ItemBlockTiles) {
            if (stack.func_190916_E() >= LittleGridContext.get().maxTilesPerBlock) {
                LittleTilePreview preview = LittleTilePreview.loadPreviewFromNBT(stack.func_77978_p());
                stack = new ItemStack(preview.getPreviewBlock(), stack.func_190916_E() / LittleGridContext.get().maxTilesPerBlock, preview.getPreviewBlockMeta());
            } else {
                stack = stack.func_77946_l();
                stack.func_190920_e(1);
                new LittleTileSize(LittleGridContext.get().size, LittleGridContext.get().size, LittleGridContext.get().size).writeToNBT("size", stack.func_77978_p());
            }
        }
        return stack;
    }

    public ArrayList<String> getTooltip() {
        ArrayList tooltip = super.getTooltip();
        BlockIngredient ingredient = ((SlotControlBlockIngredient)this.slot).ingredient;
        if (ingredient != null) {
            int blocks = (int)ingredient.value;
            double pixel = (ingredient.value - (double)blocks) * (double)LittleGridContext.get().maxTilesPerBlock;
            String line = "volume: ";
            if (blocks > 0) {
                line = line + blocks + " blocks ";
            }
            if (pixel > 0.0) {
                line = line + Math.round(pixel * 100.0) / 100L + " pixel";
            }
            tooltip.add(line);
        }
        return tooltip;
    }
}

