/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.events;

import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import com.creativemd.creativecore.common.packet.PacketHandler;
import com.creativemd.creativecore.common.utils.math.box.OrientatedBoundingBox;
import com.creativemd.creativecore.common.utils.mc.TickUtils;
import com.creativemd.littletiles.client.render.entity.RenderAnimation;
import com.creativemd.littletiles.common.entity.EntityAnimation;
import com.creativemd.littletiles.common.packet.LittleEntityInteractPacket;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.culling.ICamera;
import net.minecraft.crash.CrashReport;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ClassInheritanceMultiMap;
import net.minecraft.util.ReportedException;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.GetCollisionBoxesEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LittleDoorHandler {
    public static LittleDoorHandler client;
    public static LittleDoorHandler server;
    public final Side side;
    protected List<EntityAnimation> toBeAdded = new ArrayList<EntityAnimation>();
    protected boolean isTicking = false;
    public List<EntityAnimation> openDoors = new ArrayList<EntityAnimation>();
    @SideOnly(value=Side.CLIENT)
    public static RenderAnimation render;
    private static Field wasPushedByDoor;

    public static LittleDoorHandler getHandler(World world) {
        if (world.field_72995_K) {
            return client;
        }
        return server;
    }

    public LittleDoorHandler(Side side) {
        this.side = side;
    }

    public List<EntityAnimation> findDoors(World world, AxisAlignedBB bb) {
        if (this.openDoors.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<EntityAnimation> doors = new ArrayList<EntityAnimation>();
        for (EntityAnimation door : this.openDoors) {
            if (door.field_70170_p != world || !door.func_174813_aQ().func_72326_a(bb)) continue;
            doors.add(door);
        }
        return doors;
    }

    public List<EntityAnimation> findDoors(World world, BlockPos pos) {
        if (this.openDoors.isEmpty()) {
            return Collections.emptyList();
        }
        AxisAlignedBB box = new AxisAlignedBB(pos);
        ArrayList<EntityAnimation> doors = new ArrayList<EntityAnimation>();
        for (EntityAnimation door : this.openDoors) {
            if (door.field_70170_p != world || !door.func_174813_aQ().func_72326_a(box)) continue;
            doors.add(door);
        }
        return doors;
    }

    public EntityAnimation findDoor(UUID uuid) {
        for (EntityAnimation animation : this.openDoors) {
            if (!animation.func_110124_au().equals(uuid)) continue;
            return animation;
        }
        return null;
    }

    public void createDoor(EntityAnimation door) {
        if (this.isTicking) {
            this.toBeAdded.add(door);
        } else {
            this.openDoors.add(door);
        }
    }

    @SubscribeEvent
    public void tick(TickEvent.WorldTickEvent event) {
        if (event.side == this.side && event.phase == TickEvent.Phase.END) {
            World world = event.world;
            this.openDoors.addAll(this.toBeAdded);
            this.toBeAdded.clear();
            this.isTicking = true;
            Iterator<EntityAnimation> iterator = this.openDoors.iterator();
            while (iterator.hasNext()) {
                EntityAnimation door = iterator.next();
                if (door.field_70170_p != world) continue;
                door.onUpdateForReal();
                if (!door.field_70128_L) continue;
                iterator.remove();
            }
            this.isTicking = false;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void renderTick() {
        if (render == null) {
            render = new RenderAnimation(Minecraft.func_71410_x().func_175598_ae());
        }
        float partialTicks = TickUtils.getPartialTickTime();
        Entity renderViewEntity = Minecraft.func_71410_x().func_175606_aa();
        if (renderViewEntity == null || LittleDoorHandler.client.openDoors.isEmpty()) {
            return;
        }
        double camX = renderViewEntity.field_70169_q + (renderViewEntity.field_70165_t - renderViewEntity.field_70169_q) * (double)partialTicks;
        double camY = renderViewEntity.field_70167_r + (renderViewEntity.field_70163_u - renderViewEntity.field_70167_r) * (double)partialTicks;
        double camZ = renderViewEntity.field_70166_s + (renderViewEntity.field_70161_v - renderViewEntity.field_70166_s) * (double)partialTicks;
        Frustum camera = new Frustum();
        camera.func_78547_a(camX, camY, camZ);
        for (EntityAnimation door : LittleDoorHandler.client.openDoors) {
            if (!render.func_177071_a(door, (ICamera)camera, camX, camY, camZ) || door.field_70128_L) continue;
            if (door.field_70173_aa == 0) {
                door.field_70142_S = door.field_70165_t;
                door.field_70137_T = door.field_70163_u;
                door.field_70136_U = door.field_70161_v;
            }
            double d0 = door.field_70142_S + (door.field_70165_t - door.field_70142_S) * (double)partialTicks;
            double d1 = door.field_70137_T + (door.field_70163_u - door.field_70137_T) * (double)partialTicks;
            double d2 = door.field_70136_U + (door.field_70161_v - door.field_70136_U) * (double)partialTicks;
            float f = door.field_70126_B + (door.field_70177_z - door.field_70126_B) * partialTicks;
            int i = door.func_70070_b();
            if (door.func_70027_ad()) {
                i = 0xF000F0;
            }
            int j = i % 65536;
            int k = i / 65536;
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)j, (float)k);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            try {
                render.doRender(door, d0 - camX, d1 - camY, d2 - camZ, f, partialTicks);
            }
            catch (Throwable throwable1) {
                throw new ReportedException(CrashReport.func_85055_a((Throwable)throwable1, (String)"Rendering entity in world"));
            }
        }
    }

    @SubscribeEvent
    public void rightClick(PlayerInteractEvent event) {
        if (event instanceof PlayerInteractEvent.RightClickBlock || event instanceof PlayerInteractEvent.RightClickEmpty || event instanceof PlayerInteractEvent.RightClickItem || event instanceof PlayerInteractEvent.EntityInteractSpecific || event instanceof PlayerInteractEvent.EntityInteract) {
            Entity selectedEntity;
            double d0;
            if (!event.getWorld().field_72995_K) {
                return;
            }
            Minecraft mc = Minecraft.func_71410_x();
            EntityPlayer entity = event.getEntityPlayer();
            Vec3d vec3d = entity.func_174824_e(TickUtils.getPartialTickTime());
            double d1 = d0 = (double)mc.field_71442_b.func_78757_d();
            boolean flag = false;
            if (mc.field_71442_b.func_78749_i()) {
                d0 = d1 = 6.0;
            } else if (d0 > 3.0) {
                flag = true;
            }
            if (mc.field_71476_x != null) {
                d1 = mc.field_71476_x.field_72307_f.func_72438_d(vec3d);
            }
            Vec3d vec3d1 = entity.func_70676_i(1.0f);
            Vec3d vec3d2 = vec3d.func_72441_c(vec3d1.field_72450_a * d0, vec3d1.field_72448_b * d0, vec3d1.field_72449_c * d0);
            EntityAnimation pointedEntity = null;
            Vec3d vec3d3 = null;
            float f = 1.0f;
            List<EntityAnimation> list = this.findDoors(entity.field_70170_p, entity.func_174813_aQ().func_72321_a(vec3d1.field_72450_a * d0, vec3d1.field_72448_b * d0, vec3d1.field_72449_c * d0).func_72314_b(1.0, 1.0, 1.0));
            double d2 = d1;
            for (int j = 0; j < list.size(); ++j) {
                double d3;
                EntityAnimation entity1 = list.get(j);
                AxisAlignedBB axisalignedbb = entity1.func_174813_aQ().func_186662_g((double)entity1.func_70111_Y());
                RayTraceResult raytraceresult = axisalignedbb.func_72327_a(vec3d, vec3d2);
                if (axisalignedbb.func_72318_a(vec3d)) {
                    if (!(d2 >= 0.0)) continue;
                    pointedEntity = entity1;
                    vec3d3 = raytraceresult == null ? vec3d : raytraceresult.field_72307_f;
                    d2 = 0.0;
                    continue;
                }
                if (raytraceresult == null || !((d3 = vec3d.func_72438_d(raytraceresult.field_72307_f)) < d2) && d2 != 0.0) continue;
                if (entity1.func_184208_bv() == entity.func_184208_bv() && !entity1.canRiderInteract()) {
                    if (d2 != 0.0) continue;
                    pointedEntity = entity1;
                    vec3d3 = raytraceresult.field_72307_f;
                    continue;
                }
                pointedEntity = entity1;
                vec3d3 = raytraceresult.field_72307_f;
                d2 = d3;
            }
            if (pointedEntity != null && flag && vec3d.func_72438_d(vec3d3) > 3.0) {
                return;
            }
            Entity entity2 = selectedEntity = mc.field_71476_x != null ? mc.field_71476_x.field_72308_g : null;
            if (event instanceof PlayerInteractEvent.EntityInteractSpecific) {
                selectedEntity = ((PlayerInteractEvent.EntityInteractSpecific)event).getTarget();
            } else if (event instanceof PlayerInteractEvent.EntityInteract) {
                selectedEntity = ((PlayerInteractEvent.EntityInteract)event).getTarget();
            }
            if (pointedEntity == null && selectedEntity instanceof EntityAnimation) {
                pointedEntity = (EntityAnimation)selectedEntity;
            }
            if (pointedEntity != null && (d2 < d1 || mc.field_71476_x == null || selectedEntity == pointedEntity)) {
                if (pointedEntity.onRightClick(entity)) {
                    PacketHandler.sendPacketToServer((CreativeCorePacket)new LittleEntityInteractPacket(pointedEntity.func_110124_au()));
                }
                if (event instanceof PlayerInteractEvent.RightClickBlock) {
                    event.setCanceled(true);
                }
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void tickClient(TickEvent.ClientTickEvent event) {
        if (!(event.side != this.side || event.phase != TickEvent.Phase.END || Minecraft.func_71410_x().func_71356_B() && Minecraft.func_71410_x().func_147113_T())) {
            Iterator<EntityAnimation> iterator = this.openDoors.iterator();
            while (iterator.hasNext()) {
                EntityAnimation door = iterator.next();
                if (door.field_70128_L) {
                    iterator.remove();
                }
                door.onUpdateForReal();
            }
        }
    }

    @SubscribeEvent
    public void chunkUnload(ChunkEvent.Unload event) {
        for (ClassInheritanceMultiMap map : event.getChunk().func_177429_s()) {
            for (Entity entity : map) {
                if (!(entity instanceof EntityAnimation) || !((EntityAnimation)entity).addedDoor) continue;
                ((EntityAnimation)entity).addedDoor = false;
                this.openDoors.remove(entity);
            }
        }
    }

    @SubscribeEvent
    public void worldUnload(WorldEvent.Unload event) {
        Iterator<EntityAnimation> iterator = this.openDoors.iterator();
        while (iterator.hasNext()) {
            EntityAnimation animation = iterator.next();
            if (animation.field_70170_p != event.getWorld()) continue;
            animation.addedDoor = false;
            iterator.remove();
        }
    }

    @SubscribeEvent
    public void worldCollision(GetCollisionBoxesEvent event) {
        if (event.getWorld().field_72995_K != this.side.isClient()) {
            return;
        }
        AxisAlignedBB box = event.getAabb();
        for (EntityAnimation animation : this.findDoors(event.getWorld(), box)) {
            if (animation.noCollision) continue;
            OrientatedBoundingBox newAlignedBox = animation.origin.getOrientatedBox(box);
            for (OrientatedBoundingBox bb : animation.worldCollisionBoxes) {
                if (!bb.func_72326_a((AxisAlignedBB)newAlignedBox)) continue;
                event.getCollisionBoxesList().add(bb);
            }
        }
    }

    public static void setPushedByDoor(EntityPlayerMP player) {
        try {
            wasPushedByDoor.setInt(player, 10);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
    }

    public static boolean checkIfEmpty(List<AxisAlignedBB> boxes, EntityPlayerMP player) {
        try {
            if (wasPushedByDoor.getInt(player) > 0) {
                return true;
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
        return boxes.isEmpty();
    }

    static {
        wasPushedByDoor = ReflectionHelper.findField(EntityPlayerMP.class, (String[])new String[]{"wasPushedByDoor"});
    }
}

