/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.entity;

import com.creativemd.creativecore.common.utils.mc.WorldUtils;
import com.creativemd.creativecore.common.world.CreativeWorld;
import com.creativemd.littletiles.common.action.block.LittleActionPlaceStack;
import com.creativemd.littletiles.common.entity.EntityAnimation;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.connection.StructureLink;
import com.creativemd.littletiles.common.structure.type.LittleDoorBase;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.tiles.place.PlacePreviewTile;
import com.creativemd.littletiles.common.tiles.preview.LittleAbsolutePreviewsStructure;
import com.creativemd.littletiles.common.tiles.vec.LittleTilePos;
import com.creativemd.littletiles.common.tiles.vec.LittleTileVec;
import com.creativemd.littletiles.common.utils.placing.PlacementMode;
import com.creativemd.littletiles.common.utils.transformation.DoorTransformation;
import java.util.ArrayList;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class EntityDoorAnimation
extends EntityAnimation {
    public EntityPlayer activator;
    public long started = System.currentTimeMillis();
    private double progress;
    public int duration;
    public boolean approved = true;
    public DoorTransformation transformation;
    private float lastSendProgress = -1.0f;

    public void setTransformationStartOffset() {
        this.preventPush = true;
        this.transformation.performTransformation(this, 0.0);
        this.prevWorldRotX = this.worldRotX;
        this.prevWorldRotY = this.worldRotY;
        this.prevWorldRotZ = this.worldRotZ;
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        this.preventPush = false;
    }

    public EntityDoorAnimation(World worldIn) {
        super(worldIn);
    }

    public EntityDoorAnimation(World world, CreativeWorld worldFake, ArrayList<TileEntityLittleTiles> blocks, LittleAbsolutePreviewsStructure previews, LittleTilePos axis, DoorTransformation transformation, UUID uuid, EntityPlayer activator, LittleTileVec additionalAxis, int duration) {
        super(world, worldFake, blocks, previews, uuid, axis, additionalAxis);
        this.activator = activator;
        this.transformation = transformation;
        this.duration = duration;
        this.setTransformationStartOffset();
        this.field_70167_r -= 0.1;
        this.updateBoundingBox();
        this.updateOrigin();
        if (world.field_72995_K) {
            this.approved = false;
        }
    }

    public void copyExtra(EntityAnimation animation) {
        EntityDoorAnimation doorAnimation = (EntityDoorAnimation)animation;
        doorAnimation.progress = this.progress;
        doorAnimation.duration = this.duration;
        doorAnimation.approved = this.approved;
        doorAnimation.transformation = this.transformation;
        doorAnimation.lastSendProgress = this.lastSendProgress;
        animation.additionalAxis = this.additionalAxis.copy();
    }

    public void setProgress(double progress) {
        this.progress = progress > (double)this.duration ? (double)this.duration : progress;
    }

    public double getProgress() {
        return this.progress;
    }

    @Override
    protected void func_70088_a() {
    }

    public void func_184206_a(DataParameter<?> key) {
    }

    @Override
    public void onTick() {
        if (this.field_70170_p.field_72995_K && this.isWaitingForRender()) {
            return;
        }
        if (this.transformation != null) {
            this.transformation.performTransformation(this, this.progress / (double)this.duration);
        }
    }

    @Override
    public void onPostTick() {
        if (this.transformation == null) {
            return;
        }
        if (this.field_70170_p.field_72995_K && this.isWaitingForRender()) {
            --this.ticksToWait;
            if (this.ticksToWait % 10 == 0) {
                ArrayList<TileEntityLittleTiles> tileEntities = null;
                for (TileEntityLittleTiles te : this.waitingForRender) {
                    if (te == te.func_145831_w().func_175625_s(te.func_174877_v())) continue;
                    if (tileEntities == null) {
                        tileEntities = new ArrayList<TileEntityLittleTiles>();
                    }
                    tileEntities.add(te);
                }
                if (tileEntities != null) {
                    this.waitingForRender.removeAll(tileEntities);
                }
            }
            if (this.waitingForRender.size() == 0 || this.ticksToWait < 0) {
                this.unloadRenderCache();
                this.field_70128_L = true;
            } else {
                this.field_70128_L = false;
            }
        } else if (this.progress >= (double)this.duration) {
            LittleStructure placedStructureParent = this.getParentStructure();
            this.reloadPreviews(placedStructureParent, this.previews.pos);
            if (this.field_70170_p.field_72995_K) {
                ((LittleDoorBase)this.previews.getStructure()).isWaitingForApprove = true;
            }
            if (!this.field_70170_p.field_72995_K || this.approved) {
                ArrayList<PlacePreviewTile> placePreviews = new ArrayList<PlacePreviewTile>();
                this.previews.getPlacePreviews(placePreviews, null, true, LittleTileVec.ZERO);
                LittleStructure newDoor = this.previews.getStructure();
                if (LittleActionPlaceStack.placeTilesWithoutPlayer(this.field_70170_p, this.previews.context, placePreviews, this.previews.getStructure(), PlacementMode.all, this.previews.pos, null, null, null, EnumFacing.EAST) != null) {
                    if (placedStructureParent.parent != null && placedStructureParent.parent.isConnected(this.field_70170_p)) {
                        LittleStructure parentStructure = placedStructureParent.parent.getStructureWithoutLoading();
                        newDoor.parent = new StructureLink((TileEntity)newDoor.getMainTile().te, parentStructure.getMainTile().te.func_174877_v(), parentStructure.getMainTile().getContext(), parentStructure.getMainTile().getIdentifier(), parentStructure.attribute, newDoor, placedStructureParent.parent.getChildID(), true);
                        parentStructure.children.put(newDoor.parent.getChildID(), new StructureLink((TileEntity)parentStructure.getMainTile().te, newDoor.getMainTile().te.func_174877_v(), newDoor.getMainTile().getContext(), newDoor.getMainTile().getIdentifier(), newDoor.attribute, parentStructure, newDoor.parent.getChildID(), false));
                    }
                    if (this.field_70170_p.field_72995_K) {
                        this.waitingForRender = new CopyOnWriteArrayList();
                        ArrayList<BlockPos> coordsToCheck = new ArrayList<BlockPos>(LittleActionPlaceStack.getSplittedTiles(this.previews.context, placePreviews, this.previews.pos).keySet());
                        for (int i = 0; i < coordsToCheck.size(); ++i) {
                            TileEntity te = this.field_70170_p.func_175625_s(coordsToCheck.get(i));
                            if (!(te instanceof TileEntityLittleTiles)) continue;
                            ((TileEntityLittleTiles)te).waitingAnimation = this;
                            this.waitingForRender.add((TileEntityLittleTiles)te);
                        }
                        this.ticksToWait = 200;
                        this.field_70128_L = false;
                        return;
                    }
                } else if (!this.field_70170_p.field_72995_K) {
                    WorldUtils.dropItem((World)this.field_70170_p, (ItemStack)this.previews.getStructure().getStructureDrop(), (BlockPos)this.baseOffset);
                }
            }
            this.field_70128_L = true;
        } else {
            this.setProgress((double)(System.currentTimeMillis() - this.started) / 50.0);
        }
    }

    @Override
    protected void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.duration = compound.func_74762_e("duration");
        NBTBase tag = compound.func_74781_a("progress");
        if (tag instanceof NBTTagInt) {
            this.setProgress(((NBTTagInt)tag).func_150287_d());
        } else if (tag instanceof NBTTagFloat) {
            this.setProgress(((NBTTagFloat)tag).func_150288_h());
        } else {
            this.setProgress(((NBTTagDouble)tag).func_150286_g());
        }
        this.transformation = DoorTransformation.loadFromNBT(compound.func_74775_l("transform"));
        this.setTransformationStartOffset();
        this.started = System.currentTimeMillis() - (long)(this.progress * 50.0);
    }

    @Override
    protected void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("duration", this.duration);
        compound.func_74780_a("progress", this.progress);
        compound.func_74782_a("transform", (NBTBase)this.transformation.writeToNBT(new NBTTagCompound()));
    }
}

