/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.action;

import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import com.creativemd.creativecore.common.packet.PacketHandler;
import com.creativemd.creativecore.common.utils.mc.ColorUtils;
import com.creativemd.creativecore.common.utils.mc.InventoryUtils;
import com.creativemd.creativecore.common.utils.mc.PlayerUtils;
import com.creativemd.creativecore.common.utils.mc.WorldUtils;
import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.LittleTilesConfig;
import com.creativemd.littletiles.common.action.LittleActionException;
import com.creativemd.littletiles.common.action.block.NotEnoughIngredientsException;
import com.creativemd.littletiles.common.blocks.BlockTile;
import com.creativemd.littletiles.common.config.SpecialServerConfig;
import com.creativemd.littletiles.common.items.ItemPremadeStructure;
import com.creativemd.littletiles.common.items.ItemTileContainer;
import com.creativemd.littletiles.common.mods.chiselsandbits.ChiselsAndBitsManager;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.tiles.LittleTile;
import com.creativemd.littletiles.common.tiles.LittleTileBlock;
import com.creativemd.littletiles.common.tiles.preview.LittleAbsolutePreviews;
import com.creativemd.littletiles.common.tiles.preview.LittleAbsolutePreviewsStructure;
import com.creativemd.littletiles.common.tiles.preview.LittlePreviews;
import com.creativemd.littletiles.common.tiles.preview.LittlePreviewsStructure;
import com.creativemd.littletiles.common.tiles.preview.LittleTilePreview;
import com.creativemd.littletiles.common.tiles.vec.LittleBoxes;
import com.creativemd.littletiles.common.tiles.vec.LittleTileBox;
import com.creativemd.littletiles.common.tiles.vec.LittleTileIdentifierAbsolute;
import com.creativemd.littletiles.common.tiles.vec.LittleTilePos;
import com.creativemd.littletiles.common.tiles.vec.LittleTileVec;
import com.creativemd.littletiles.common.tiles.vec.LittleTileVecContext;
import com.creativemd.littletiles.common.utils.compression.LittleNBTCompressionTools;
import com.creativemd.littletiles.common.utils.grid.LittleGridContext;
import com.creativemd.littletiles.common.utils.ingredients.BlockIngredient;
import com.creativemd.littletiles.common.utils.ingredients.ColorUnit;
import com.creativemd.littletiles.common.utils.ingredients.IngredientUtils;
import com.creativemd.littletiles.common.utils.ingredients.Ingredients;
import com.creativemd.littletiles.common.utils.ingredients.StackIngredient;
import com.creativemd.littletiles.common.utils.placing.PlacementMode;
import com.creativemd.littletiles.common.utils.selection.selector.TileSelector;
import io.netty.buffer.ByteBuf;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBreakable;
import net.minecraft.block.BlockGlass;
import net.minecraft.block.BlockStainedGlass;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketBlockChange;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class LittleAction
extends CreativeCorePacket {
    private static List<LittleAction> lastActions = new ArrayList<LittleAction>();
    private static int index = 0;
    private static Method WorldEditEvent = LittleAction.loadWorldEditEvent();
    private static Object worldEditInstance = null;

    @SideOnly(value=Side.CLIENT)
    public static boolean isUsingSecondMode(EntityPlayer player) {
        if (LittleTilesConfig.building.useALTForEverything) {
            return GuiScreen.func_175283_s();
        }
        if (LittleTilesConfig.building.useAltWhenFlying) {
            return player.field_71075_bZ.field_75100_b ? GuiScreen.func_175283_s() : player.func_70093_af();
        }
        return player.func_70093_af();
    }

    public static void rememberAction(LittleAction action) {
        if (!action.canBeReverted()) {
            return;
        }
        if (index > 0) {
            lastActions = index < lastActions.size() ? lastActions.subList(index, lastActions.size() - 1) : new ArrayList<LittleAction>();
        }
        index = 0;
        if (lastActions.size() == LittleTilesConfig.building.maxSavedActions) {
            lastActions.remove(LittleTilesConfig.building.maxSavedActions - 1);
        }
        lastActions.add(0, action);
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean undo() throws LittleActionException {
        if (lastActions.size() > index) {
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            LittleAction reverted = lastActions.get(index).revert();
            if (reverted == null) {
                throw new LittleActionException("action.revert.notavailable");
            }
            if (reverted.action((EntityPlayer)player)) {
                PacketHandler.sendPacketToServer((CreativeCorePacket)reverted);
                lastActions.set(index, reverted);
                ++index;
                return true;
            }
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean redo() throws LittleActionException {
        if (index > 0 && index <= lastActions.size()) {
            LittleAction reverted;
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            if ((reverted = lastActions.get(--index).revert()) == null) {
                throw new LittleActionException("action.revert.notavailable");
            }
            if (reverted.action((EntityPlayer)player)) {
                PacketHandler.sendPacketToServer((CreativeCorePacket)reverted);
                lastActions.set(index, reverted);
                return true;
            }
        }
        return false;
    }

    public static void registerLittleAction(String id, Class<? extends LittleAction> ... classTypes) {
        for (int i = 0; i < classTypes.length; ++i) {
            CreativeCorePacket.registerPacket(classTypes[i], (String)("ac" + id + i));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public abstract boolean canBeReverted();

    @SideOnly(value=Side.CLIENT)
    public abstract LittleAction revert() throws LittleActionException;

    public boolean sendToServer() {
        return true;
    }

    protected abstract boolean action(EntityPlayer var1) throws LittleActionException;

    @SideOnly(value=Side.CLIENT)
    public boolean execute() {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        try {
            if (this.action((EntityPlayer)player)) {
                LittleAction.rememberAction(this);
                if (this.sendToServer()) {
                    PacketHandler.sendPacketToServer((CreativeCorePacket)this);
                }
                return true;
            }
        }
        catch (LittleActionException e) {
            player.func_146105_b((ITextComponent)new TextComponentString(e.getLocalizedMessage()), true);
            return false;
        }
        return false;
    }

    public void executeClient(EntityPlayer player) {
        try {
            this.action(player);
        }
        catch (LittleActionException e) {
            player.func_146105_b((ITextComponent)new TextComponentString(e.getLocalizedMessage()), true);
        }
    }

    public void executeServer(EntityPlayer player) {
        try {
            this.action(player);
        }
        catch (LittleActionException e) {
            player.func_146105_b((ITextComponent)new TextComponentString(e.getLocalizedMessage()), true);
        }
    }

    public static boolean canConvertBlock(EntityPlayer player, World world, BlockPos pos, IBlockState state) {
        if (player.func_184812_l_()) {
            return true;
        }
        if (SpecialServerConfig.strictMining) {
            return false;
        }
        if (!SpecialServerConfig.editUnbreakable) {
            return state.func_177230_c().func_176195_g(state, world, pos) > 0.0f;
        }
        return true;
    }

    public static TileEntityLittleTiles loadTe(EntityPlayer player, World world, BlockPos pos, boolean shouldConvert) {
        Object tileEntity = world.func_175625_s(pos);
        if (!(tileEntity instanceof TileEntityLittleTiles)) {
            LittleGridContext context;
            List<LittleTile> tiles = ChiselsAndBitsManager.getTiles(tileEntity);
            LittleGridContext littleGridContext = context = tiles != null ? LittleGridContext.get(ChiselsAndBitsManager.convertingFrom) : LittleGridContext.get();
            if (tileEntity == null && tiles == null) {
                IBlockState state = world.func_180495_p(pos);
                if (shouldConvert && LittleAction.isBlockValid(state.func_177230_c()) && LittleAction.canConvertBlock(player, world, pos, state)) {
                    tiles = new ArrayList<LittleTile>();
                    context = LittleGridContext.get(LittleGridContext.minSize);
                    LittleTileBox box = new LittleTileBox(context.minPos, context.minPos, context.minPos, context.maxPos, context.maxPos, context.maxPos);
                    LittleTileBlock tile = new LittleTileBlock(state.func_177230_c(), state.func_177230_c().func_176201_c(state));
                    tile.box = box;
                    tiles.add(tile);
                } else if (state.func_185904_a().func_76222_j()) {
                    if (!world.func_175656_a(pos, BlockTile.getState(false, false))) {
                        return null;
                    }
                    tileEntity = (TileEntityLittleTiles)world.func_175625_s(pos);
                }
            }
            if (tiles != null && tiles.size() > 0) {
                world.func_175656_a(pos, BlockTile.getState(tiles));
                tileEntity = world.func_175625_s(pos);
                ((TileEntityLittleTiles)tileEntity).convertTo(context);
                for (LittleTile tile : tiles) {
                    tile.te = (TileEntityLittleTiles)tileEntity;
                    tile.place();
                }
            }
        }
        if (tileEntity instanceof TileEntityLittleTiles) {
            return (TileEntityLittleTiles)tileEntity;
        }
        return null;
    }

    private static Method loadWorldEditEvent() {
        try {
            Class<?> clazz = Class.forName("com.sk89q.worldedit.forge.ForgeWorldEdit");
            worldEditInstance = clazz.getField("inst").get(null);
            return clazz.getMethod("onPlayerInteract", PlayerInteractEvent.class);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void sendBlockResetToClient(EntityPlayerMP player, BlockPos pos, TileEntityLittleTiles te) {
        player.field_71135_a.func_147359_a((Packet)new SPacketBlockChange(player.field_70170_p, pos));
        if (te != null) {
            player.field_71135_a.func_147359_a((Packet)te.func_189518_D_());
        }
    }

    public static boolean isAllowedToInteract(EntityPlayer player, BlockPos pos, boolean rightClick, EnumFacing facing) {
        if (player == null || player.field_70170_p.field_72995_K) {
            return true;
        }
        if (player.func_175149_v() || !rightClick && (PlayerUtils.isAdventure((EntityPlayer)player) || !player.func_175142_cm())) {
            return false;
        }
        if (WorldEditEvent != null) {
            PlayerInteractEvent.RightClickBlock event = rightClick ? new PlayerInteractEvent.RightClickBlock(player, EnumHand.MAIN_HAND, pos, facing, new Vec3d((Vec3i)pos)) : new PlayerInteractEvent.LeftClickBlock(player, pos, facing, new Vec3d((Vec3i)pos));
            try {
                if (worldEditInstance == null) {
                    LittleAction.loadWorldEditEvent();
                }
                WorldEditEvent.invoke(worldEditInstance, event);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                e.printStackTrace();
            }
            if (event.isCanceled()) {
                return false;
            }
        }
        return !player.func_184102_h().func_175579_a(player.field_70170_p, pos, player);
    }

    public static boolean isAllowedToPlacePreview(EntityPlayer player, LittleTilePreview preview) throws LittleActionException {
        if (preview == null) {
            return true;
        }
        if (preview.hasColor() && ColorUtils.getAlpha((int)preview.getColor()) < SpecialServerConfig.getMinimumTransparency(player)) {
            throw new SpecialServerConfig.NotAllowedToPlaceColorException();
        }
        return true;
    }

    public static boolean isTileStillInPlace(LittleTile tile) {
        return tile.te.getTiles().contains(tile);
    }

    public static LittleTile getTile(World world, LittleTileIdentifierAbsolute coord) throws LittleActionException {
        TileEntity te = world.func_175625_s(coord.pos);
        if (te instanceof TileEntityLittleTiles) {
            LittleTile tile = ((TileEntityLittleTiles)te).getTile(coord.context, coord.identifier);
            if (tile != null) {
                return tile;
            }
            throw new LittleActionException.TileNotFoundException();
        }
        throw new LittleActionException.TileEntityNotFoundException();
    }

    public static void writeAbsoluteCoord(LittleTileIdentifierAbsolute coord, ByteBuf buf) {
        LittleAction.writePos((ByteBuf)buf, (BlockPos)coord.pos);
        buf.writeInt(coord.identifier.length);
        for (int i = 0; i < coord.identifier.length; ++i) {
            buf.writeInt(coord.identifier[i]);
        }
        LittleAction.writeContext(coord.context, buf);
    }

    public static LittleTileIdentifierAbsolute readAbsoluteCoord(ByteBuf buf) {
        BlockPos pos = LittleAction.readPos((ByteBuf)buf);
        int[] identifier = new int[buf.readInt()];
        for (int i = 0; i < identifier.length; ++i) {
            identifier[i] = buf.readInt();
        }
        return new LittleTileIdentifierAbsolute(pos, LittleAction.readContext(buf), identifier);
    }

    public static void writePreviews(LittlePreviews previews, ByteBuf buf) {
        buf.writeBoolean(previews.isAbsolute());
        buf.writeBoolean(previews.hasStructure());
        if (previews.hasStructure()) {
            LittleAction.writeNBT((ByteBuf)buf, (NBTTagCompound)previews.getStructureData());
        }
        if (previews.isAbsolute()) {
            LittleAction.writePos((ByteBuf)buf, (BlockPos)((LittleAbsolutePreviews)previews).pos);
        }
        LittleAction.writeContext(previews.context, buf);
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74782_a("list", (NBTBase)LittleNBTCompressionTools.writePreviews(previews));
        NBTTagList children = new NBTTagList();
        for (LittlePreviews child : previews.getChildren()) {
            children.func_74742_a((NBTBase)LittleTilePreview.saveChildPreviews(child));
        }
        nbt.func_74782_a("children", (NBTBase)children);
        LittleAction.writeNBT((ByteBuf)buf, (NBTTagCompound)nbt);
    }

    public static LittlePreviews readPreviews(ByteBuf buf) {
        LittlePreviews previews;
        NBTTagCompound nbt;
        boolean absolute = buf.readBoolean();
        boolean structure = buf.readBoolean();
        if (absolute) {
            if (structure) {
                nbt = LittleAction.readNBT((ByteBuf)buf);
                previews = LittleNBTCompressionTools.readPreviews(new LittleAbsolutePreviewsStructure(LittleAction.readNBT((ByteBuf)buf), LittleAction.readPos((ByteBuf)buf), LittleAction.readContext(buf)), nbt.func_150295_c("list", 10));
            } else {
                nbt = LittleAction.readNBT((ByteBuf)buf);
                previews = LittleNBTCompressionTools.readPreviews(new LittleAbsolutePreviews(LittleAction.readPos((ByteBuf)buf), LittleAction.readContext(buf)), nbt.func_150295_c("list", 10));
            }
        } else if (structure) {
            nbt = LittleAction.readNBT((ByteBuf)buf);
            previews = LittleNBTCompressionTools.readPreviews(new LittlePreviewsStructure(LittleAction.readNBT((ByteBuf)buf), LittleAction.readContext(buf)), nbt.func_150295_c("list", 10));
        } else {
            nbt = LittleAction.readNBT((ByteBuf)buf);
            previews = LittleNBTCompressionTools.readPreviews(new LittlePreviews(LittleAction.readContext(buf)), nbt.func_150295_c("list", 10));
        }
        NBTTagList list = nbt.func_150295_c("children", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound child = list.func_150305_b(i);
            previews.addChild(LittlePreviews.getChild(previews.context, child));
        }
        return previews;
    }

    public static void writePlacementMode(PlacementMode mode, ByteBuf buf) {
        LittleAction.writeString((ByteBuf)buf, (String)mode.name);
    }

    public static PlacementMode readPlacementMode(ByteBuf buf) {
        return PlacementMode.getModeOrDefault(LittleAction.readString((ByteBuf)buf));
    }

    public static void writeContext(LittleGridContext context, ByteBuf buf) {
        buf.writeInt(context.size);
    }

    public static LittleGridContext readContext(ByteBuf buf) {
        return LittleGridContext.get(buf.readInt());
    }

    public static void writeLittleVecContext(LittleTileVecContext vec, ByteBuf buf) {
        LittleAction.writeContext(vec.context, buf);
        LittleAction.writeLittleVec(vec.vec, buf);
    }

    public static LittleTileVecContext readLittleVecContext(ByteBuf buf) {
        return new LittleTileVecContext(LittleAction.readContext(buf), LittleAction.readLittleVec(buf));
    }

    public static void writeBoxes(LittleBoxes boxes, ByteBuf buf) {
        LittleAction.writePos((ByteBuf)buf, (BlockPos)boxes.pos);
        LittleAction.writeContext(boxes.context, buf);
        buf.writeInt(boxes.size());
        for (LittleTileBox box : boxes) {
            LittleAction.writeLittleBox(box, buf);
        }
    }

    public static LittleBoxes readBoxes(ByteBuf buf) {
        BlockPos pos = LittleAction.readPos((ByteBuf)buf);
        LittleGridContext context = LittleAction.readContext(buf);
        LittleBoxes boxes = new LittleBoxes(pos, context);
        int length = buf.readInt();
        for (int i = 0; i < length; ++i) {
            boxes.add(LittleAction.readLittleBox(buf));
        }
        return boxes;
    }

    public static void writeLittlePos(LittleTilePos pos, ByteBuf buf) {
        LittleAction.writePos((ByteBuf)buf, (BlockPos)pos.pos);
        LittleAction.writeLittleVecContext(pos.contextVec, buf);
    }

    public static LittleTilePos readLittlePos(ByteBuf buf) {
        return new LittleTilePos(LittleAction.readPos((ByteBuf)buf), LittleAction.readLittleVecContext(buf));
    }

    public static void writeLittleVec(LittleTileVec vec, ByteBuf buf) {
        buf.writeInt(vec.x);
        buf.writeInt(vec.y);
        buf.writeInt(vec.z);
    }

    public static LittleTileVec readLittleVec(ByteBuf buf) {
        return new LittleTileVec(buf.readInt(), buf.readInt(), buf.readInt());
    }

    public static void writeSelector(TileSelector selector, ByteBuf buf) {
        LittleAction.writeNBT((ByteBuf)buf, (NBTTagCompound)selector.writeNBT(new NBTTagCompound()));
    }

    public static TileSelector readSelector(ByteBuf buf) {
        return TileSelector.loadSelector(LittleAction.readNBT((ByteBuf)buf));
    }

    public static void writeLittleBox(LittleTileBox box, ByteBuf buf) {
        int[] array = box.getArray();
        buf.writeInt(array.length);
        for (int i = 0; i < array.length; ++i) {
            buf.writeInt(array[i]);
        }
    }

    public static LittleTileBox readLittleBox(ByteBuf buf) {
        int[] array = new int[buf.readInt()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = buf.readInt();
        }
        return LittleTileBox.createBox(array);
    }

    public static boolean needIngredients(EntityPlayer player) {
        return !player.func_184812_l_();
    }

    public static boolean canDrain(EntityPlayer player, LittlePreviews previews) throws NotEnoughIngredientsException {
        if (LittleAction.needIngredients(player)) {
            return LittleAction.canDrain(player, IngredientUtils.getIngredients(previews));
        }
        return true;
    }

    public static boolean drain(EntityPlayer player, LittlePreviews previews) throws NotEnoughIngredientsException {
        if (LittleAction.needIngredients(player)) {
            return LittleAction.drain(player, IngredientUtils.getIngredients(previews));
        }
        return true;
    }

    public static boolean canDrain(EntityPlayer player, Ingredients ingredients) throws NotEnoughIngredientsException {
        if (LittleAction.needIngredients(player)) {
            ColorUnit color;
            List<ItemStack> bags = LittleAction.getBags(player);
            ArrayList<ItemStack> usedBags = new ArrayList<ItemStack>();
            BlockIngredient.BlockIngredients toCheck = ingredients.block != null ? ingredients.block.copy() : null;
            ColorUnit colorUnit = color = ingredients.color != null ? ingredients.color.copy() : null;
            if (color != null && color.isEmpty()) {
                color = null;
            }
            for (ItemStack stack : bags) {
                ItemStack used = stack.func_77946_l();
                if (toCheck != null) {
                    toCheck = ItemTileContainer.drainBlocks(used, toCheck, false);
                }
                if (color != null) {
                    color = ItemTileContainer.drainColor(used, color, false);
                }
                usedBags.add(used);
            }
            if (color != null) {
                throw new NotEnoughIngredientsException.NotEnoughColorException(color);
            }
            if (toCheck != null || ingredients.hasStacks()) {
                List inventory = InventoryUtils.copy((IInventory)player.field_71071_by);
                if (toCheck != null) {
                    BlockIngredient.BlockIngredients additionalIngredients = new BlockIngredient.BlockIngredients();
                    Iterator iterator = inventory.iterator();
                    while (iterator.hasNext()) {
                        ItemStack itemStack = (ItemStack)iterator.next();
                        BlockIngredient leftOver = toCheck.drainItemStack(itemStack);
                        if (leftOver != null) {
                            additionalIngredients.addIngredient(leftOver);
                        }
                        if (itemStack.func_190926_b()) {
                            iterator.remove();
                        }
                        if (!toCheck.isEmpty()) continue;
                        break;
                    }
                    if (!toCheck.isEmpty()) {
                        throw new NotEnoughIngredientsException.NotEnoughVolumeExcepion(toCheck);
                    }
                    LittleAction.addIngredients(usedBags, additionalIngredients, null);
                }
                if (ingredients.hasStacks()) {
                    Iterator<StackIngredient> iterator = ingredients.getStacks().iterator();
                    while (iterator.hasNext()) {
                        StackIngredient stackIngredient = iterator.next();
                        if (stackIngredient.drain(inventory)) {
                            iterator.remove();
                            continue;
                        }
                        throw new NotEnoughIngredientsException.NotEnoughStackException(stackIngredient.stack);
                    }
                }
            }
        }
        return true;
    }

    public static boolean drain(EntityPlayer player, Ingredients ingredients) throws NotEnoughIngredientsException {
        if (LittleAction.needIngredients(player) && LittleAction.canDrain(player, ingredients)) {
            List<ItemStack> bags = LittleAction.getBags(player);
            BlockIngredient.BlockIngredients toCheck = ingredients.block != null ? ingredients.block.copy() : null;
            ColorUnit color = ingredients.color != null ? ingredients.color.copy() : null;
            for (ItemStack stack : bags) {
                if (toCheck != null) {
                    toCheck = ItemTileContainer.drainBlocks(stack, toCheck, false);
                }
                if (color == null) continue;
                color = ItemTileContainer.drainColor(stack, color, false);
            }
            if (toCheck != null || ingredients.hasStacks()) {
                List inventory = InventoryUtils.asList((IInventory)player.field_71071_by);
                if (toCheck != null) {
                    BlockIngredient.BlockIngredients additionalIngredients = new BlockIngredient.BlockIngredients();
                    Iterator iterator = inventory.iterator();
                    while (iterator.hasNext()) {
                        ItemStack itemStack = (ItemStack)iterator.next();
                        BlockIngredient leftOver = toCheck.drainItemStack(itemStack);
                        if (leftOver != null) {
                            additionalIngredients.addIngredient(leftOver);
                        }
                        if (itemStack.func_190926_b()) {
                            iterator.remove();
                        }
                        if (!toCheck.isEmpty()) continue;
                        break;
                    }
                    if (!toCheck.isEmpty()) {
                        throw new NotEnoughIngredientsException.NotEnoughVolumeExcepion(toCheck);
                    }
                    LittleAction.addIngredients(bags, additionalIngredients, null);
                }
                if (ingredients.hasStacks()) {
                    Iterator<StackIngredient> iterator = ingredients.getStacks().iterator();
                    while (iterator.hasNext()) {
                        StackIngredient stackIngredient = iterator.next();
                        if (stackIngredient.drain(inventory)) {
                            iterator.remove();
                            continue;
                        }
                        throw new NotEnoughIngredientsException.NotEnoughStackException(stackIngredient.stack);
                    }
                }
            }
        }
        return true;
    }

    public static void dropPreviews(EntityPlayer player, LittlePreviews previews) {
        for (LittleTilePreview preview : previews) {
            if (!preview.hasBlockIngredient()) continue;
            WorldUtils.dropItem((EntityPlayer)player, (ItemStack)preview.getBlockIngredient(previews.context).getTileItemStack());
        }
    }

    public static LittlePreviews getIngredientsPreviews(List<LittleTile> tiles) {
        LittlePreviews previews = new LittlePreviews(tiles.get(0).getContext());
        previews.addTiles(tiles);
        return previews;
    }

    public static boolean addTilesToInventoryOrDrop(EntityPlayer player, List<LittleTile> tiles) {
        if (LittleAction.needIngredients(player) && !tiles.isEmpty()) {
            LittlePreviews previews = LittleAction.getIngredientsPreviews(tiles);
            try {
                return LittleAction.addPreviewToInventory(player, previews);
            }
            catch (NotEnoughIngredientsException e) {
                LittleAction.dropPreviews(player, previews);
            }
        }
        return true;
    }

    public static boolean addTileToInventory(EntityPlayer player, LittleTile tile) throws NotEnoughIngredientsException {
        LittlePreviews previews = new LittlePreviews(tile.getContext());
        previews.addTile(tile);
        return LittleAction.addPreviewToInventory(player, previews);
    }

    public static boolean addTilesToInventory(EntityPlayer player, List<LittleTile> tiles) throws NotEnoughIngredientsException {
        if (tiles.isEmpty()) {
            return true;
        }
        if (LittleAction.needIngredients(player)) {
            return LittleAction.addPreviewToInventory(player, LittleAction.getIngredientsPreviews(tiles));
        }
        return true;
    }

    public static boolean addPreviewToInventory(EntityPlayer player, LittlePreviews previews) throws NotEnoughIngredientsException {
        if (LittleAction.needIngredients(player)) {
            ColorUnit color = new ColorUnit();
            BlockIngredient.BlockIngredients ingredients = new BlockIngredient.BlockIngredients();
            for (LittleTilePreview preview : previews) {
                if (!preview.canBeConvertedToBlockEntry()) continue;
                ingredients.addIngredient(preview.getBlockIngredient(previews.context));
                color.addColorUnit(ColorUnit.getColors(previews.context, preview));
            }
            return LittleAction.addIngredients(player, ingredients, color);
        }
        return true;
    }

    public static boolean store(List<ItemStack> bags, BlockIngredient.BlockIngredients toCheck, ColorUnit color, boolean simulate) throws NotEnoughIngredientsException {
        if ((toCheck == null || toCheck.isEmpty()) && (color == null || color.isEmpty())) {
            return true;
        }
        for (ItemStack stack : bags) {
            if (toCheck != null) {
                toCheck = ItemTileContainer.storeBlocks(stack, toCheck, true, simulate);
            }
            if (color != null) {
                color = ItemTileContainer.storeColor(stack, color, simulate);
            }
            if (toCheck != null || color != null) continue;
            break;
        }
        if (color == null && toCheck != null) {
            ItemStack stack;
            Iterator<ItemStack> iterator = bags.iterator();
            while (iterator.hasNext() && (toCheck = ItemTileContainer.storeBlocks(stack = iterator.next(), toCheck, false, simulate)) != null) {
            }
        }
        if (color != null && !color.isEmpty()) {
            throw new NotEnoughIngredientsException.NotEnoughColorSpaceException();
        }
        if (toCheck != null && !toCheck.isEmpty()) {
            throw new NotEnoughIngredientsException.NotEnoughVolumeSpaceException();
        }
        return true;
    }

    public static boolean addIngredients(EntityPlayer player, Ingredients ingredients) throws NotEnoughIngredientsException {
        return LittleAction.addIngredients(player, ingredients.block, ingredients.color);
    }

    public static boolean addIngredients(EntityPlayer player, BlockIngredient.BlockIngredients ingredients, ColorUnit unit) throws NotEnoughIngredientsException {
        return LittleAction.addIngredients(player, ingredients, unit, false);
    }

    public static boolean addIngredients(EntityPlayer player, BlockIngredient.BlockIngredients ingredients, ColorUnit unit, boolean simulate) throws NotEnoughIngredientsException {
        List<ItemStack> bags;
        if (LittleAction.needIngredients(player) && LittleAction.store(bags = LittleAction.getBags(player), ingredients != null ? ingredients.copy() : null, unit != null ? unit.copy() : null, true) && !simulate) {
            LittleAction.store(bags, ingredients, unit, false);
        }
        return true;
    }

    public static boolean addIngredients(List<ItemStack> bags, BlockIngredient.BlockIngredients ingredients, ColorUnit unit) throws NotEnoughIngredientsException {
        if (LittleAction.store(bags, ingredients != null ? ingredients.copy() : null, unit != null ? unit.copy() : null, true)) {
            LittleAction.store(bags, ingredients, unit, false);
        }
        return true;
    }

    public static List<ItemStack> getBags(EntityPlayer player) {
        ArrayList<ItemStack> bags = new ArrayList<ItemStack>();
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            if (!(stack.func_77973_b() instanceof ItemTileContainer)) continue;
            bags.add(stack);
        }
        return bags;
    }

    public static boolean canDrainPremadeItemStack(EntityPlayer player, ItemStack toDrain) throws NotEnoughIngredientsException {
        if (!LittleAction.needIngredients(player)) {
            return true;
        }
        String id = ItemPremadeStructure.getPremadeID(toDrain);
        for (ItemStack stack : player.field_71071_by.field_70462_a) {
            if (stack.func_77973_b() != LittleTiles.premade || !ItemPremadeStructure.getPremadeID(stack).equals(id)) continue;
            return true;
        }
        throw new NotEnoughIngredientsException.NotEnoughStackException(toDrain);
    }

    public static void drainPremadeItemStack(EntityPlayer player, ItemStack toDrain) throws NotEnoughIngredientsException {
        if (!LittleAction.needIngredients(player)) {
            return;
        }
        String id = ItemPremadeStructure.getPremadeID(toDrain);
        for (ItemStack stack : player.field_71071_by.field_70462_a) {
            if (stack.func_77973_b() != LittleTiles.premade || !ItemPremadeStructure.getPremadeID(stack).equals(id)) continue;
            stack.func_190918_g(1);
            return;
        }
        throw new NotEnoughIngredientsException.NotEnoughStackException(toDrain);
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean doesBlockSupportedTranslucent(Block block) {
        return block.func_180664_k() == BlockRenderLayer.SOLID || block.func_180664_k() == BlockRenderLayer.TRANSLUCENT;
    }

    public static boolean isBlockValid(Block block) {
        return block.func_149721_r(block.func_176223_P()) || block.func_149686_d(block.func_176223_P()) || block.func_149730_j(block.func_176223_P()) || block instanceof BlockGlass || block instanceof BlockStainedGlass || block instanceof BlockBreakable;
    }
}

