/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.client.tiles;

import com.creativemd.creativecore.common.utils.math.RotationUtils;
import com.creativemd.creativecore.common.utils.math.box.CubeObject;
import com.creativemd.creativecore.common.utils.mc.ColorUtils;
import com.creativemd.littletiles.client.tiles.LittleDynamicCube;
import com.creativemd.littletiles.client.tiles.LittleRenderingCube;
import com.creativemd.littletiles.client.tiles.LittleSlicedOrdinaryRenderingCube;
import com.creativemd.littletiles.common.api.ILittleTile;
import com.creativemd.littletiles.common.tiles.vec.LittleTileSize;
import com.creativemd.littletiles.common.tiles.vec.advanced.LittleSlice;
import com.creativemd.littletiles.common.tiles.vec.advanced.LittleTileSlicedBox;
import com.creativemd.littletiles.common.utils.grid.LittleGridContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import javax.vecmath.Vector3f;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.EnumFaceDirection;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import org.lwjgl.opengl.GL11;

public class LittleSlicedRenderingCube
extends LittleSlicedOrdinaryRenderingCube {
    public LittleRenderingCube cubeOne;
    public LittleRenderingCube cubeTwo;
    public LittleGridContext context;

    public LittleSlicedRenderingCube(LittleGridContext context, CubeObject cube, LittleTileSlicedBox box, Block block, int meta) {
        super(cube, box, block, meta);
        this.context = context;
        this.dynamicCube = new LittleDynamicCube(box.getSlicedCube(context), box.slice, box.getSize());
        EnumFacing.Axis one = RotationUtils.getDifferentAxisFirst((EnumFacing.Axis)box.slice.axis);
        EnumFacing.Axis two = RotationUtils.getDifferentAxisSecond((EnumFacing.Axis)box.slice.axis);
        if (box.hasAdditionalBoxTwo()) {
            this.cubeTwo = new LittleRenderingCube(box.getCube(context), box, block, meta);
            this.cubeTwo.setMin(one, context.toVanillaGrid((float)box.getMinSlice(one)));
            this.cubeTwo.setMax(one, context.toVanillaGrid((float)box.getMaxSlice(one)));
            if (box.slice.isFacingPositive(two)) {
                this.cubeTwo.setMin(two, context.toVanillaGrid((float)box.getMin(two)));
                this.cubeTwo.setMax(two, context.toVanillaGrid((float)box.getMinSlice(two)));
            } else {
                this.cubeTwo.setMin(two, context.toVanillaGrid((float)box.getMaxSlice(two)));
                this.cubeTwo.setMax(two, context.toVanillaGrid((float)box.getMax(two)));
            }
        }
        if (box.hasAdditionalBoxOne()) {
            this.cubeOne = new LittleRenderingCube(box.getCube(context), box, block, meta);
            if (box.slice.isFacingPositive(one)) {
                this.cubeOne.setMin(one, context.toVanillaGrid((float)box.getMin(one)));
                this.cubeOne.setMax(one, context.toVanillaGrid((float)box.getMinSlice(one)));
            } else {
                this.cubeOne.setMin(one, context.toVanillaGrid((float)box.getMaxSlice(one)));
                this.cubeOne.setMax(one, context.toVanillaGrid((float)box.getMax(one)));
            }
            if (box.slice.isFacingPositive(two)) {
                this.cubeOne.setMin(two, this.cubeTwo != null ? context.toVanillaGrid((float)box.getMin(two)) : context.toVanillaGrid((float)box.getMinSlice(two)));
                this.cubeOne.setMax(two, context.toVanillaGrid((float)box.getMaxSlice(two)));
            } else {
                this.cubeOne.setMin(two, context.toVanillaGrid((float)box.getMinSlice(two)));
                this.cubeOne.setMax(two, this.cubeTwo != null ? context.toVanillaGrid((float)box.getMax(two)) : context.toVanillaGrid((float)box.getMaxSlice(two)));
            }
        }
    }

    @Override
    public CubeObject offset(BlockPos pos) {
        return new LittleSlicedRenderingCube(this.context, new CubeObject(this.minX - (float)pos.func_177958_n(), this.minY - (float)pos.func_177956_o(), this.minZ - (float)pos.func_177952_p(), this.maxX - (float)pos.func_177958_n(), this.maxY - (float)pos.func_177956_o(), this.maxZ - (float)pos.func_177952_p(), (CubeObject)this), (LittleTileSlicedBox)this.box, this.block, this.meta);
    }

    @Override
    public void renderCubeLines(double x, double y, double z, float red, float green, float blue, float alpha) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        LittleTileSlicedBox box = (LittleTileSlicedBox)this.box;
        EnumFacing.Axis one = RotationUtils.getDifferentAxisFirst((EnumFacing.Axis)box.slice.axis);
        EnumFacing.Axis two = RotationUtils.getDifferentAxisSecond((EnumFacing.Axis)box.slice.axis);
        LittleTileSize size = box.getSize();
        for (int i = 0; i < EnumFacing.field_82609_l.length; ++i) {
            EnumFacing facing = EnumFacing.field_82609_l[i];
            if (!(one == facing.func_176740_k() && this.cubeOne != null && facing != box.slice.getEmptySide(one) || two == facing.func_176740_k() && this.cubeTwo != null && facing != box.slice.getEmptySide(two))) {
                LittleSlicedOrdinaryRenderingCube.renderFaceLine(this.dynamicCube, facing, facing.func_176740_k() == box.slice.axis, red, green, blue, alpha);
            }
            if (this.cubeOne != null && facing != box.slice.getEmptySide(one)) {
                LittleSlicedRenderingCube.renderFaceLine((CubeObject)this.cubeOne, facing, false, red, green, blue, alpha);
            }
            if (this.cubeTwo == null || facing == box.slice.getEmptySide(two) || this.cubeOne != null && facing == box.slice.getEmptySide(one).func_176734_d()) continue;
            LittleSlicedRenderingCube.renderFaceLine((CubeObject)this.cubeTwo, facing, false, red, green, blue, alpha);
        }
        GlStateManager.func_179094_E();
    }

    @Override
    public void renderCubePreview(double x, double y, double z, ILittleTile iTile) {
        Vec3d color = ColorUtils.IntToVec((int)this.color);
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        GlStateManager.func_179091_B();
        GlStateManager.func_179131_c((float)((float)color.field_72450_a), (float)((float)color.field_72448_b), (float)((float)color.field_72449_c), (float)((float)(Math.sin((double)System.nanoTime() / 2.0E8) * 0.2 + 0.5) * iTile.getPreviewAlphaFactor()));
        LittleTileSlicedBox box = (LittleTileSlicedBox)this.box;
        EnumFacing.Axis one = RotationUtils.getDifferentAxisFirst((EnumFacing.Axis)box.slice.axis);
        EnumFacing.Axis two = RotationUtils.getDifferentAxisSecond((EnumFacing.Axis)box.slice.axis);
        LittleTileSize size = box.getSize();
        for (int i = 0; i < EnumFacing.field_82609_l.length; ++i) {
            EnumFacing facing = EnumFacing.field_82609_l[i];
            if (!(one == facing.func_176740_k() && this.cubeOne != null && facing != box.slice.getEmptySide(one) || two == facing.func_176740_k() && this.cubeTwo != null && facing != box.slice.getEmptySide(two))) {
                LittleSlicedOrdinaryRenderingCube.renderFace(this.dynamicCube, facing, facing.func_176740_k() == box.slice.axis, box.slice);
            }
            if (this.cubeOne != null && facing != box.slice.getEmptySide(one)) {
                LittleSlicedRenderingCube.renderFace((CubeObject)this.cubeOne, facing, false, box.slice);
            }
            if (this.cubeTwo == null || facing == box.slice.getEmptySide(two) || this.cubeOne != null && facing == box.slice.getEmptySide(one).func_176734_d()) continue;
            LittleSlicedRenderingCube.renderFace((CubeObject)this.cubeTwo, facing, false, box.slice);
        }
        GlStateManager.func_179121_F();
    }

    public static void renderFaceLine(CubeObject cube, EnumFacing facing, boolean isTraingle, float red, float green, float blue, float alpha) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(3, DefaultVertexFormats.field_181706_f);
        Vector3f vec = new Vector3f();
        EnumFaceDirection face = EnumFaceDirection.func_179027_a((EnumFacing)facing);
        for (int i = 0; i < 4; ++i) {
            vec = cube.get(face.func_179025_a(i), vec);
            if (i == 0) {
                bufferbuilder.func_181662_b((double)vec.x, (double)vec.y, (double)vec.z).func_181666_a(red, green, blue, 0.0f).func_181675_d();
            }
            bufferbuilder.func_181662_b((double)vec.x, (double)vec.y, (double)vec.z).func_181666_a(red, green, blue, alpha).func_181675_d();
        }
        tessellator.func_78381_a();
    }

    public static void renderFace(CubeObject cube, EnumFacing facing, boolean isTraingle, LittleSlice slice) {
        GL11.glBegin((int)9);
        Vec3i normal = facing.func_176730_m();
        GlStateManager.func_187432_a((float)normal.func_177958_n(), (float)normal.func_177956_o(), (float)normal.func_177952_p());
        Vector3f vec = new Vector3f();
        EnumFaceDirection face = EnumFaceDirection.func_179027_a((EnumFacing)facing);
        for (int i = 0; i < 4; ++i) {
            vec = cube.get(face.func_179025_a(i), vec);
            GlStateManager.func_187435_e((float)vec.x, (float)vec.y, (float)vec.z);
        }
        GlStateManager.func_187437_J();
    }

    @Override
    public List<BakedQuad> getBakedQuad(IBlockAccess world, @Nullable BlockPos pos, BlockPos offset, IBlockState state, IBakedModel blockModel, EnumFacing facing, BlockRenderLayer layer, long rand, boolean overrideTint, int defaultColor) {
        LittleTileSlicedBox box = (LittleTileSlicedBox)this.box;
        LittleTileSize size = box.getSize();
        List blockQuads = this.getBakedQuad(world, blockModel, state, facing, pos, layer, rand);
        if (blockQuads.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        boolean isTraingle = facing.func_176740_k() == box.slice.axis;
        Vector3f vec = new Vector3f();
        int color = this.color != -1 ? this.color : defaultColor;
        EnumFacing.Axis one = RotationUtils.getDifferentAxisFirst((EnumFacing.Axis)box.slice.axis);
        EnumFacing.Axis two = RotationUtils.getDifferentAxisSecond((EnumFacing.Axis)box.slice.axis);
        if (!(one == facing.func_176740_k() && this.cubeOne != null && facing != box.slice.getEmptySide(one) || two == facing.func_176740_k() && this.cubeTwo != null && facing != box.slice.getEmptySide(two))) {
            quads.addAll(super.getBakedQuad(world, pos, offset, state, blockModel, facing, layer, rand, overrideTint, defaultColor));
        }
        if (this.cubeOne != null && facing != box.slice.getEmptySide(one)) {
            quads.addAll(this.cubeOne.getBakedQuad(world, pos, offset, state, blockModel, facing, layer, rand, overrideTint, defaultColor));
        }
        if (this.cubeTwo != null && facing != box.slice.getEmptySide(two) && (this.cubeOne == null || facing != box.slice.getEmptySide(one).func_176734_d())) {
            quads.addAll(this.cubeTwo.getBakedQuad(world, pos, offset, state, blockModel, facing, layer, rand, overrideTint, defaultColor));
        }
        return quads;
    }
}

