/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.transmitter;

import io.netty.buffer.ByteBuf;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.TileNetworkList;
import mekanism.api.transmitters.TransmissionType;
import mekanism.common.base.FluidHandlerWrapper;
import mekanism.common.base.IFluidHandlerWrapper;
import mekanism.common.block.states.BlockStateTransmitter;
import mekanism.common.capabilities.CapabilityWrapperManager;
import mekanism.common.tier.BaseTier;
import mekanism.common.tier.PipeTier;
import mekanism.common.tile.transmitter.TileEntitySidedPipe;
import mekanism.common.tile.transmitter.TileEntityTransmitter;
import mekanism.common.transmitters.grid.FluidNetwork;
import mekanism.common.util.CapabilityUtils;
import mekanism.common.util.PipeUtils;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TileEntityMechanicalPipe
extends TileEntityTransmitter<IFluidHandler, FluidNetwork, FluidStack>
implements IFluidHandlerWrapper {
    public PipeTier tier = PipeTier.BASIC;
    public float currentScale;
    public FluidTank buffer = new FluidTank(1000);
    public FluidStack lastWrite;
    public CapabilityWrapperManager<IFluidHandlerWrapper, FluidHandlerWrapper> manager = new CapabilityWrapperManager<IFluidHandlerWrapper, FluidHandlerWrapper>(IFluidHandlerWrapper.class, FluidHandlerWrapper.class);

    @Override
    public BaseTier getBaseTier() {
        return this.tier.getBaseTier();
    }

    @Override
    public void setBaseTier(BaseTier baseTier) {
        this.tier = PipeTier.get(baseTier);
        this.buffer.setCapacity(this.getCapacity());
    }

    @Override
    public void func_73660_a() {
        if (!this.func_145831_w().field_72995_K) {
            this.updateShare();
            IFluidHandler[] connectedAcceptors = PipeUtils.getConnectedAcceptors(this.func_174877_v(), this.func_145831_w());
            for (EnumFacing side : this.getConnections(TileEntitySidedPipe.ConnectionType.PULL)) {
                FluidStack received;
                IFluidHandler container;
                if (connectedAcceptors[side.ordinal()] == null || (container = connectedAcceptors[side.ordinal()]) == null || (received = container.drain(this.getAvailablePull(), false)) == null || received.amount == 0 || this.takeFluid(received, false) != received.amount) continue;
                container.drain(this.takeFluid(received, true), true);
            }
        }
        super.func_73660_a();
    }

    @Override
    public void updateShare() {
        FluidStack last;
        if (this.getTransmitter().hasTransmitterNetwork() && this.getTransmitter().getTransmitterNetworkSize() > 0 && ((last = this.getSaveShare()) != null && (this.lastWrite == null || this.lastWrite.amount != last.amount || this.lastWrite.getFluid() != last.getFluid()) || last == null && this.lastWrite != null)) {
            this.lastWrite = last;
            this.func_70296_d();
        }
    }

    private FluidStack getSaveShare() {
        FluidNetwork transmitterNetwork = (FluidNetwork)this.getTransmitter().getTransmitterNetwork();
        if (this.getTransmitter().hasTransmitterNetwork() && transmitterNetwork.buffer != null) {
            int remain = transmitterNetwork.buffer.amount % transmitterNetwork.transmittersSize();
            int toSave = transmitterNetwork.buffer.amount / transmitterNetwork.transmittersSize();
            if (transmitterNetwork.firstTransmitter().equals(this.getTransmitter())) {
                toSave += remain;
            }
            return PipeUtils.copy(transmitterNetwork.buffer, toSave);
        }
        return null;
    }

    @Override
    public void onChunkUnload() {
        if (!this.func_145831_w().field_72995_K && this.getTransmitter().hasTransmitterNetwork() && this.lastWrite != null && ((FluidNetwork)this.getTransmitter().getTransmitterNetwork()).buffer != null) {
            ((FluidNetwork)this.getTransmitter().getTransmitterNetwork()).buffer.amount -= this.lastWrite.amount;
            if (((FluidNetwork)this.getTransmitter().getTransmitterNetwork()).buffer.amount <= 0) {
                ((FluidNetwork)this.getTransmitter().getTransmitterNetwork()).buffer = null;
            }
        }
        super.onChunkUnload();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTags) {
        super.func_145839_a(nbtTags);
        if (nbtTags.func_74764_b("tier")) {
            this.tier = PipeTier.values()[nbtTags.func_74762_e("tier")];
        }
        this.buffer.setCapacity(this.getCapacity());
        if (nbtTags.func_74764_b("cacheFluid")) {
            this.buffer.setFluid(FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbtTags.func_74775_l("cacheFluid")));
        } else {
            this.buffer.setFluid(null);
        }
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound nbtTags) {
        super.func_189515_b(nbtTags);
        if (this.lastWrite != null && this.lastWrite.amount > 0) {
            nbtTags.func_74782_a("cacheFluid", (NBTBase)this.lastWrite.writeToNBT(new NBTTagCompound()));
        } else {
            nbtTags.func_82580_o("cacheFluid");
        }
        nbtTags.func_74768_a("tier", this.tier.ordinal());
        return nbtTags;
    }

    @Override
    public TransmissionType getTransmissionType() {
        return TransmissionType.FLUID;
    }

    @Override
    public BlockStateTransmitter.TransmitterType getTransmitterType() {
        return BlockStateTransmitter.TransmitterType.MECHANICAL_PIPE;
    }

    @Override
    public boolean isValidAcceptor(TileEntity acceptor, EnumFacing side) {
        return PipeUtils.isValidAcceptorOnSide(acceptor, side);
    }

    @Override
    public boolean isValidTransmitter(TileEntity tileEntity) {
        if (!super.isValidTransmitter(tileEntity)) {
            return false;
        }
        if (!(tileEntity instanceof TileEntityMechanicalPipe)) {
            return true;
        }
        FluidStack buffer = (FluidStack)this.getBufferWithFallback();
        FluidStack otherBuffer = (FluidStack)((TileEntityMechanicalPipe)tileEntity).getBufferWithFallback();
        return buffer == null || otherBuffer == null || buffer.isFluidEqual(otherBuffer);
    }

    @Override
    public FluidNetwork createNewNetwork() {
        return new FluidNetwork();
    }

    @Override
    public FluidNetwork createNetworkByMerging(Collection<FluidNetwork> networks) {
        return new FluidNetwork(networks);
    }

    @Override
    protected boolean canHaveIncompatibleNetworks() {
        return true;
    }

    @Override
    public int getCapacity() {
        return this.tier.getPipeCapacity();
    }

    @Override
    @Nullable
    public FluidStack getBuffer() {
        return this.buffer == null ? null : this.buffer.getFluid();
    }

    @Override
    public void takeShare() {
        if (this.getTransmitter().hasTransmitterNetwork() && ((FluidNetwork)this.getTransmitter().getTransmitterNetwork()).buffer != null && this.lastWrite != null) {
            ((FluidNetwork)this.getTransmitter().getTransmitterNetwork()).buffer.amount -= this.lastWrite.amount;
            this.buffer.setFluid(this.lastWrite);
        }
    }

    @Override
    public int fill(EnumFacing from, @Nullable FluidStack resource, boolean doFill) {
        if (this.getConnectionType(from) == TileEntitySidedPipe.ConnectionType.NORMAL) {
            return this.takeFluid(resource, doFill);
        }
        return 0;
    }

    @Override
    public FluidStack drain(EnumFacing from, int maxDrain, boolean doDrain) {
        return null;
    }

    @Override
    public FluidStack drain(EnumFacing from, @Nullable FluidStack resource, boolean doDrain) {
        return null;
    }

    @Override
    public boolean canFill(EnumFacing from, @Nullable FluidStack fluid) {
        return this.getConnectionType(from) == TileEntitySidedPipe.ConnectionType.NORMAL;
    }

    @Override
    public boolean canDrain(EnumFacing from, @Nullable FluidStack fluid) {
        return false;
    }

    @Override
    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        if (from != null && this.getConnectionType(from) != TileEntitySidedPipe.ConnectionType.NONE) {
            return this.getAllTanks();
        }
        return PipeUtils.EMPTY;
    }

    @Override
    public FluidTankInfo[] getAllTanks() {
        if (this.getTransmitter().hasTransmitterNetwork()) {
            FluidNetwork network = (FluidNetwork)this.getTransmitter().getTransmitterNetwork();
            return new FluidTankInfo[]{new FluidTankInfo(network.getBuffer(), network.getCapacity())};
        }
        return new FluidTankInfo[]{this.buffer.getInfo()};
    }

    public int getPullAmount() {
        return this.tier.getPipePullAmount();
    }

    @Override
    public IFluidHandler getCachedAcceptor(EnumFacing side) {
        TileEntity tile = this.getCachedTile(side);
        if (CapabilityUtils.hasCapability((ICapabilityProvider)tile, CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side.func_176734_d())) {
            return (IFluidHandler)CapabilityUtils.getCapability((ICapabilityProvider)tile, CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side.func_176734_d());
        }
        return null;
    }

    public int getAvailablePull() {
        if (this.getTransmitter().hasTransmitterNetwork()) {
            return Math.min(this.getPullAmount(), ((FluidNetwork)this.getTransmitter().getTransmitterNetwork()).getFluidNeeded());
        }
        return Math.min(this.getPullAmount(), this.buffer.getCapacity() - this.buffer.getFluidAmount());
    }

    public int takeFluid(FluidStack fluid, boolean doEmit) {
        if (this.getTransmitter().hasTransmitterNetwork()) {
            return ((FluidNetwork)this.getTransmitter().getTransmitterNetwork()).emit(fluid, doEmit);
        }
        return this.buffer.fill(fluid, doEmit);
    }

    @Override
    public boolean upgrade(int tierOrdinal) {
        if (this.tier.ordinal() < BaseTier.ULTIMATE.ordinal() && tierOrdinal == this.tier.ordinal() + 1) {
            this.tier = PipeTier.values()[this.tier.ordinal() + 1];
            this.markDirtyTransmitters();
            this.sendDesc = true;
            return true;
        }
        return false;
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) throws Exception {
        this.tier = PipeTier.values()[dataStream.readInt()];
        super.handlePacketData(dataStream);
    }

    @Override
    public TileNetworkList getNetworkedData(TileNetworkList data) {
        data.add(this.tier.ordinal());
        super.getNetworkedData(data);
        return data;
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing side) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, side);
    }

    @Override
    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing side) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.manager.getWrapper(this, side));
        }
        return super.getCapability(capability, side);
    }
}

