/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import javax.annotation.Nonnull;
import mekanism.api.Coord4D;
import mekanism.common.integration.computer.IComputerIntegration;
import mekanism.common.tile.TileEntityThermalEvaporationController;
import mekanism.common.tile.prefab.TileEntityContainerBlock;
import mekanism.common.util.InventoryUtils;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;

public class TileEntityThermalEvaporationBlock
extends TileEntityContainerBlock
implements IComputerIntegration {
    private static final String[] methods = new String[]{"getTemperature", "getHeight", "isFormed", "getInput", "getOutput"};
    public Coord4D master;
    public boolean attempted;

    public TileEntityThermalEvaporationBlock() {
        super("ThermalEvaporationBlock");
        this.inventory = NonNullList.func_191197_a((int)0, (Object)ItemStack.field_190927_a);
    }

    public TileEntityThermalEvaporationBlock(String fullName) {
        super(fullName);
        this.inventory = NonNullList.func_191197_a((int)0, (Object)ItemStack.field_190927_a);
    }

    @Override
    public void onUpdate() {
        if (!this.field_145850_b.field_72995_K && this.ticker == 5 && !this.attempted && this.master == null) {
            this.updateController();
        }
        this.attempted = false;
    }

    public void addToStructure(Coord4D controller) {
        this.master = controller;
    }

    public void controllerGone() {
        this.master = null;
    }

    public void onChunkUnload() {
        TileEntityThermalEvaporationController tile;
        super.onChunkUnload();
        if (this.master != null && (tile = this.getController()) != null) {
            tile.refresh();
        }
    }

    @Override
    public void onNeighborChange(Block block) {
        super.onNeighborChange(block);
        if (!this.field_145850_b.field_72995_K) {
            TileEntityThermalEvaporationController tile = this.getController();
            if (tile != null) {
                tile.refresh();
            } else {
                this.updateController();
            }
        }
    }

    public void updateController() {
        if (!(this instanceof TileEntityThermalEvaporationController)) {
            for (EnumFacing side : EnumFacing.values()) {
                TileEntity check;
                BlockPos checkPos = this.field_174879_c.func_177972_a(side);
                if (!this.field_145850_b.func_175667_e(checkPos) || !((check = this.field_145850_b.func_175625_s(checkPos)) instanceof TileEntityThermalEvaporationBlock) || !(check instanceof TileEntityThermalEvaporationController)) continue;
                ((TileEntityThermalEvaporationController)check).refresh();
                return;
            }
            TileEntityThermalEvaporationController found = new ControllerFinder().find();
            if (found != null) {
                found.refresh();
            }
        }
    }

    public TileEntityThermalEvaporationController getController() {
        TileEntity tile;
        if (this.master != null && (tile = this.master.getTileEntity((IBlockAccess)this.field_145850_b)) instanceof TileEntityThermalEvaporationController) {
            return (TileEntityThermalEvaporationController)tile;
        }
        return null;
    }

    @Override
    public String[] getMethods() {
        return methods;
    }

    @Override
    public Object[] invoke(int method, Object[] args) throws NoSuchMethodException {
        TileEntityThermalEvaporationController controller = this.getController();
        if (controller == null) {
            return new Object[]{"Unformed."};
        }
        switch (method) {
            case 0: {
                return new Object[]{Float.valueOf(controller.temperature)};
            }
            case 1: {
                return new Object[]{controller.height};
            }
            case 2: {
                return new Object[]{controller.structured};
            }
            case 3: {
                return new Object[]{controller.inputTank.getFluidAmount()};
            }
            case 4: {
                return new Object[]{controller.outputTank.getFluidAmount()};
            }
        }
        throw new NoSuchMethodException();
    }

    @Override
    @Nonnull
    public int[] func_180463_a(@Nonnull EnumFacing side) {
        return InventoryUtils.EMPTY;
    }

    @Override
    public boolean isCapabilityDisabled(@Nonnull Capability<?> capability, EnumFacing side) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.isCapabilityDisabled(capability, side);
    }

    public class ControllerFinder {
        public TileEntityThermalEvaporationController found;
        public Set<BlockPos> iterated = new HashSet<BlockPos>();
        private Deque<BlockPos> checkQueue = new LinkedList<BlockPos>();

        public void loop(BlockPos startPos) {
            this.checkQueue.add(startPos);
            while (this.checkQueue.peek() != null) {
                BlockPos checkPos = this.checkQueue.pop();
                if (this.iterated.contains(checkPos)) continue;
                this.iterated.add(checkPos);
                if (!TileEntityThermalEvaporationBlock.this.field_145850_b.func_175667_e(checkPos)) continue;
                TileEntity te = TileEntityThermalEvaporationBlock.this.field_145850_b.func_175625_s(checkPos);
                if (te instanceof TileEntityThermalEvaporationController) {
                    this.found = (TileEntityThermalEvaporationController)te;
                    return;
                }
                if (!(te instanceof TileEntityThermalEvaporationBlock)) continue;
                ((TileEntityThermalEvaporationBlock)te).attempted = true;
                for (EnumFacing side : EnumFacing.field_82609_l) {
                    BlockPos coord = checkPos.func_177972_a(side);
                    if (this.iterated.contains(coord)) continue;
                    this.checkQueue.addLast(coord);
                }
            }
        }

        public TileEntityThermalEvaporationController find() {
            this.loop(TileEntityThermalEvaporationBlock.this.field_174879_c);
            return this.found;
        }
    }
}

