/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import io.netty.buffer.ByteBuf;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.TileNetworkList;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasRegistry;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTank;
import mekanism.api.gas.GasTankInfo;
import mekanism.api.gas.IGasHandler;
import mekanism.api.gas.IGasItem;
import mekanism.common.Mekanism;
import mekanism.common.Upgrade;
import mekanism.common.base.FluidHandlerWrapper;
import mekanism.common.base.IComparatorSupport;
import mekanism.common.base.IFluidHandlerWrapper;
import mekanism.common.base.ISustainedData;
import mekanism.common.base.ITankManager;
import mekanism.common.block.states.BlockStateMachine;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.tile.prefab.TileEntityMachine;
import mekanism.common.util.ChargeUtils;
import mekanism.common.util.FluidContainerUtils;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.PipeUtils;
import mekanism.common.util.TileUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class TileEntityRotaryCondensentrator
extends TileEntityMachine
implements ISustainedData,
IFluidHandlerWrapper,
IGasHandler,
Upgrade.IUpgradeInfoHandler,
ITankManager,
IComparatorSupport {
    private static final int[] GAS_SLOTS = new int[]{0, 1};
    private static final int[] LIQUID_SLOTS = new int[]{2, 3};
    private static final int[] ENERGY_SLOT = new int[]{4};
    public static final int MAX_FLUID = 10000;
    public GasTank gasTank = new GasTank(10000);
    public FluidTank fluidTank = new FluidTank(10000);
    public int mode;
    public int gasOutput = 256;
    public double clientEnergyUsed;
    private int currentRedstoneLevel;

    public TileEntityRotaryCondensentrator() {
        super("machine.rotarycondensentrator", BlockStateMachine.MachineType.ROTARY_CONDENSENTRATOR, 5);
        this.inventory = NonNullList.func_191197_a((int)6, (Object)ItemStack.field_190927_a);
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!this.field_145850_b.field_72995_K) {
            int operations;
            ChargeUtils.discharge(4, this);
            if (this.mode == 0) {
                TileUtils.receiveGas((ItemStack)this.inventory.get(1), this.gasTank);
                if (FluidContainerUtils.isFluidContainer((ItemStack)this.inventory.get(2))) {
                    FluidContainerUtils.handleContainerItemFill(this, this.fluidTank, 2, 3);
                }
                if (this.getEnergy() >= this.energyPerTick && MekanismUtils.canFunction(this) && this.isValidGas(this.gasTank.getGas()) && (this.fluidTank.getFluid() == null || this.fluidTank.getFluid().amount < 10000 && this.gasEquals(this.gasTank.getGas(), this.fluidTank.getFluid()))) {
                    operations = this.getUpgradedUsage();
                    double prev = this.getEnergy();
                    this.setActive(true);
                    this.fluidTank.fill(new FluidStack(this.gasTank.getGas().getGas().getFluid(), operations), true);
                    this.gasTank.draw(operations, true);
                    this.setEnergy(this.getEnergy() - this.energyPerTick * (double)operations);
                    this.clientEnergyUsed = prev - this.getEnergy();
                } else if (this.prevEnergy >= this.getEnergy()) {
                    this.setActive(false);
                }
            } else if (this.mode == 1) {
                TileUtils.drawGas((ItemStack)this.inventory.get(0), this.gasTank);
                TileUtils.emitGas(this, this.gasTank, this.gasOutput, MekanismUtils.getLeft(this.facing));
                if (FluidContainerUtils.isFluidContainer((ItemStack)this.inventory.get(2))) {
                    FluidContainerUtils.handleContainerItemEmpty(this, this.fluidTank, 2, 3);
                }
                if (this.getEnergy() >= this.energyPerTick && MekanismUtils.canFunction(this) && this.isValidFluid(this.fluidTank.getFluid()) && (this.gasTank.getGas() == null || this.gasTank.getStored() < 10000 && this.gasEquals(this.gasTank.getGas(), this.fluidTank.getFluid()))) {
                    operations = this.getUpgradedUsage();
                    double prev = this.getEnergy();
                    this.setActive(true);
                    this.gasTank.receive(new GasStack(GasRegistry.getGas(this.fluidTank.getFluid().getFluid()), operations), true);
                    this.fluidTank.drain(operations, true);
                    this.setEnergy(this.getEnergy() - this.energyPerTick * (double)operations);
                    this.clientEnergyUsed = prev - this.getEnergy();
                } else if (this.prevEnergy >= this.getEnergy()) {
                    this.setActive(false);
                }
            }
            this.prevEnergy = this.getEnergy();
            int newRedstoneLevel = this.getRedstoneLevel();
            if (newRedstoneLevel != this.currentRedstoneLevel) {
                this.field_145850_b.func_175666_e(this.field_174879_c, this.func_145838_q());
                this.currentRedstoneLevel = newRedstoneLevel;
            }
        }
    }

    public int getUpgradedUsage() {
        int possibleProcess = (int)Math.pow(2.0, this.upgradeComponent.getUpgrades(Upgrade.SPEED));
        possibleProcess = this.mode == 0 ? Math.min(Math.min(this.gasTank.getStored(), this.fluidTank.getCapacity() - this.fluidTank.getFluidAmount()), possibleProcess) : Math.min(Math.min(this.fluidTank.getFluidAmount(), this.gasTank.getNeeded()), possibleProcess);
        possibleProcess = Math.min((int)(this.getEnergy() / this.energyPerTick), possibleProcess);
        return possibleProcess;
    }

    public boolean isValidGas(GasStack g) {
        return g != null && g.getGas().hasFluid();
    }

    public boolean gasEquals(GasStack gas, FluidStack fluid) {
        return fluid != null && gas != null && gas.getGas().hasFluid() && gas.getGas().getFluid() == fluid.getFluid();
    }

    public boolean isValidFluid(FluidStack f) {
        return f != null && GasRegistry.getGas(f.getFluid()) != null;
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            int type = dataStream.readInt();
            if (type == 0) {
                this.mode = this.mode == 0 ? 1 : 0;
            }
            for (EntityPlayer player : this.playersUsing) {
                Mekanism.packetHandler.sendTo(new PacketTileEntity.TileEntityMessage(this), (EntityPlayerMP)player);
            }
            return;
        }
        super.handlePacketData(dataStream);
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            this.mode = dataStream.readInt();
            this.clientEnergyUsed = dataStream.readDouble();
            TileUtils.readTankData(dataStream, this.fluidTank);
            TileUtils.readTankData(dataStream, this.gasTank);
        }
    }

    @Override
    public TileNetworkList getNetworkedData(TileNetworkList data) {
        super.getNetworkedData(data);
        data.add(this.mode);
        data.add(this.clientEnergyUsed);
        TileUtils.addTankData(data, this.fluidTank);
        TileUtils.addTankData(data, this.gasTank);
        return data;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTags) {
        super.func_145839_a(nbtTags);
        this.mode = nbtTags.func_74762_e("mode");
        this.gasTank.read(nbtTags.func_74775_l("gasTank"));
        if (nbtTags.func_74764_b("fluidTank")) {
            this.fluidTank.readFromNBT(nbtTags.func_74775_l("fluidTank"));
        }
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound nbtTags) {
        super.func_189515_b(nbtTags);
        nbtTags.func_74768_a("mode", this.mode);
        nbtTags.func_74782_a("gasTank", (NBTBase)this.gasTank.write(new NBTTagCompound()));
        if (this.fluidTank.getFluid() != null) {
            nbtTags.func_74782_a("fluidTank", (NBTBase)this.fluidTank.writeToNBT(new NBTTagCompound()));
        }
        return nbtTags;
    }

    @Override
    public int receiveGas(EnumFacing side, GasStack stack, boolean doTransfer) {
        return this.gasTank.receive(stack, doTransfer);
    }

    @Override
    public GasStack drawGas(EnumFacing side, int amount, boolean doTransfer) {
        return this.gasTank.draw(amount, doTransfer);
    }

    @Override
    public boolean canDrawGas(EnumFacing side, Gas type) {
        return this.mode == 1 && side == MekanismUtils.getLeft(this.facing) && this.gasTank.canDraw(type);
    }

    @Override
    public boolean canReceiveGas(EnumFacing side, Gas type) {
        return this.mode == 0 && side == MekanismUtils.getLeft(this.facing) && this.gasTank.canReceive(type);
    }

    @Override
    @Nonnull
    public GasTankInfo[] getTankInfo() {
        return new GasTankInfo[]{this.gasTank};
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing side) {
        if (this.isCapabilityDisabled(capability, side)) {
            return false;
        }
        return capability == Capabilities.GAS_HANDLER_CAPABILITY || capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, side);
    }

    @Override
    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing side) {
        if (this.isCapabilityDisabled(capability, side)) {
            return null;
        }
        if (capability == Capabilities.GAS_HANDLER_CAPABILITY) {
            return (T)Capabilities.GAS_HANDLER_CAPABILITY.cast((Object)this);
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)new FluidHandlerWrapper(this, side));
        }
        return super.getCapability(capability, side);
    }

    @Override
    public boolean isCapabilityDisabled(@Nonnull Capability<?> capability, EnumFacing side) {
        if (capability == Capabilities.GAS_HANDLER_CAPABILITY) {
            return side != null && side != MekanismUtils.getLeft(this.facing);
        }
        return super.isCapabilityDisabled(capability, side);
    }

    @Override
    public void writeSustainedData(ItemStack itemStack) {
        if (this.fluidTank.getFluid() != null) {
            ItemDataUtils.setCompound(itemStack, "fluidTank", this.fluidTank.getFluid().writeToNBT(new NBTTagCompound()));
        }
        if (this.gasTank.getGas() != null) {
            ItemDataUtils.setCompound(itemStack, "gasTank", this.gasTank.getGas().write(new NBTTagCompound()));
        }
    }

    @Override
    public void readSustainedData(ItemStack itemStack) {
        this.fluidTank.setFluid(FluidStack.loadFluidStackFromNBT((NBTTagCompound)ItemDataUtils.getCompound(itemStack, "fluidTank")));
        this.gasTank.setGas(GasStack.readFromNBT(ItemDataUtils.getCompound(itemStack, "gasTank")));
    }

    @Override
    public int fill(EnumFacing from, @Nullable FluidStack resource, boolean doFill) {
        if (this.canFill(from, resource)) {
            return this.fluidTank.fill(resource, doFill);
        }
        return 0;
    }

    @Override
    public FluidStack drain(EnumFacing from, @Nullable FluidStack resource, boolean doDrain) {
        if (resource != null && this.fluidTank.getFluid() != null && this.fluidTank.getFluid().getFluid() == resource.getFluid()) {
            return this.drain(from, resource.amount, doDrain);
        }
        return null;
    }

    @Override
    public boolean canFill(EnumFacing from, @Nullable FluidStack fluid) {
        return fluid != null && this.mode == 1 && from == MekanismUtils.getRight(this.facing) && (this.fluidTank.getFluid() == null ? this.isValidFluid(new FluidStack(fluid, 1)) : this.fluidTank.getFluid().isFluidEqual(fluid));
    }

    @Override
    public boolean canDrain(EnumFacing from, @Nullable FluidStack fluid) {
        return this.mode == 0 && from == MekanismUtils.getRight(this.facing);
    }

    @Override
    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        if (from == MekanismUtils.getRight(this.facing)) {
            return new FluidTankInfo[]{this.fluidTank.getInfo()};
        }
        return PipeUtils.EMPTY;
    }

    @Override
    public FluidTankInfo[] getAllTanks() {
        return new FluidTankInfo[]{this.fluidTank.getInfo()};
    }

    @Override
    public FluidStack drain(EnumFacing from, int maxDrain, boolean doDrain) {
        if (this.canDrain(from, null)) {
            return this.fluidTank.drain(maxDrain, doDrain);
        }
        return null;
    }

    @Override
    public List<String> getInfo(Upgrade upgrade) {
        return upgrade == Upgrade.SPEED ? upgrade.getExpScaledInfo(this) : upgrade.getMultScaledInfo(this);
    }

    @Override
    public Object[] getTanks() {
        return new Object[]{this.gasTank, this.fluidTank};
    }

    @Override
    @Nonnull
    public int[] func_180463_a(@Nonnull EnumFacing side) {
        if (side == MekanismUtils.getLeft(this.facing)) {
            return GAS_SLOTS;
        }
        if (side == MekanismUtils.getRight(this.facing)) {
            return LIQUID_SLOTS;
        }
        return ENERGY_SLOT;
    }

    @Override
    public boolean func_94041_b(int slot, @Nonnull ItemStack stack) {
        if (slot == 0) {
            return stack.func_77973_b() instanceof IGasItem;
        }
        if (slot == 2) {
            return FluidContainerUtils.isFluidContainer(stack);
        }
        if (slot == 4) {
            return ChargeUtils.canBeDischarged(stack);
        }
        return false;
    }

    @Override
    public int getRedstoneLevel() {
        if (this.mode == 0) {
            return MekanismUtils.redstoneLevelFromContents(this.gasTank.getStored(), this.gasTank.getMaxGas());
        }
        return MekanismUtils.redstoneLevelFromContents(this.fluidTank.getFluidAmount(), this.fluidTank.getCapacity());
    }
}

