/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tier;

import java.util.function.Consumer;
import mekanism.common.block.states.BlockStateMachine;
import mekanism.common.tier.BaseTier;
import mekanism.common.tier.ITier;
import net.minecraft.util.ResourceLocation;

public enum FactoryTier implements ITier
{
    BASIC(3, new ResourceLocation("mekanism", "gui/factory/GuiBasicFactory.png")),
    ADVANCED(5, new ResourceLocation("mekanism", "gui/factory/GuiAdvancedFactory.png")),
    ELITE(7, new ResourceLocation("mekanism", "gui/factory/GuiEliteFactory.png"));

    public final int processes;
    public final ResourceLocation guiLocation;
    private final BaseTier baseTier;

    private FactoryTier(int process, ResourceLocation gui) {
        this.processes = process;
        this.guiLocation = gui;
        this.baseTier = BaseTier.values()[this.ordinal()];
    }

    @Override
    public BaseTier getBaseTier() {
        return this.baseTier;
    }

    public static void forEnabled(Consumer<FactoryTier> consumer) {
        if (BlockStateMachine.MachineType.BASIC_FACTORY.isEnabled()) {
            consumer.accept(BASIC);
        }
        if (BlockStateMachine.MachineType.ADVANCED_FACTORY.isEnabled()) {
            consumer.accept(ADVANCED);
        }
        if (BlockStateMachine.MachineType.ELITE_FACTORY.isEnabled()) {
            consumer.accept(ELITE);
        }
    }
}

