/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.justenoughdimensions.event;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import fi.dy.masa.justenoughdimensions.JustEnoughDimensions;
import fi.dy.masa.justenoughdimensions.config.DimensionConfig;
import fi.dy.masa.justenoughdimensions.util.JEDStringUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.event.terraingen.BiomeEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class JEDEventHandlerClient {
    private static final Map<ResourceLocation, Integer> FOLIAGE_COLORS = new HashMap<ResourceLocation, Integer>();
    private static final Map<ResourceLocation, Integer> GRASS_COLORS = new HashMap<ResourceLocation, Integer>();
    private static final Map<ResourceLocation, Integer> WATER_COLORS = new HashMap<ResourceLocation, Integer>();
    private static boolean hasFoliageColors;
    private static boolean hasGrassColors;
    private static boolean hasWaterColors;

    @SubscribeEvent
    public void onGetFoliageColor(BiomeEvent.GetFoliageColor event) {
        if (hasFoliageColors) {
            event.setNewColor(JEDEventHandlerClient.getColor(DimensionConfig.ColorType.FOLIAGE, event.getBiome(), event.getOriginalColor()));
        }
    }

    @SubscribeEvent
    public void onGetGrassColor(BiomeEvent.GetGrassColor event) {
        if (hasGrassColors) {
            event.setNewColor(JEDEventHandlerClient.getColor(DimensionConfig.ColorType.GRASS, event.getBiome(), event.getOriginalColor()));
        }
    }

    @SubscribeEvent
    public void onGetWaterColor(BiomeEvent.GetWaterColor event) {
        if (hasWaterColors) {
            event.setNewColor(JEDEventHandlerClient.getColor(DimensionConfig.ColorType.WATER, event.getBiome(), event.getOriginalColor()));
        }
    }

    public static void setColors(DimensionConfig.ColorType type, @Nullable Map<ResourceLocation, Integer> colorsIn) {
        Map<ResourceLocation, Integer> colors = JEDEventHandlerClient.getColorMap(type);
        colors.clear();
        if (colorsIn != null) {
            colors.putAll(colorsIn);
        }
        JEDEventHandlerClient.setFlag(type, !colors.isEmpty());
    }

    private static int getColor(DimensionConfig.ColorType type, Biome biome, int defaultColor) {
        Integer color = JEDEventHandlerClient.getColorMap(type).get(biome.getRegistryName());
        return color != null ? color : defaultColor;
    }

    @Nullable
    public static Map<ResourceLocation, Integer> getColorMap(@Nullable JsonObject obj, DimensionConfig.ColorType type) {
        String key = type.getKeyName();
        if (obj != null && obj.has(key) && obj.get(key).isJsonArray()) {
            HashMap<ResourceLocation, Integer> colors = new HashMap<ResourceLocation, Integer>();
            JsonArray arr = obj.getAsJsonArray(key);
            for (JsonElement el : arr) {
                JsonObject o;
                if (!el.isJsonObject() || !(o = el.getAsJsonObject()).has("color")) continue;
                String strColor = o.get("color").getAsString();
                if (o.has("biome")) {
                    colors.put(new ResourceLocation(o.get("biome").getAsString()), JEDStringUtils.hexStringToInt(strColor));
                    continue;
                }
                if (!o.has("biome_regex")) continue;
                JEDEventHandlerClient.addColorForBiomeRegex(o.get("biome_regex").getAsString(), JEDStringUtils.hexStringToInt(strColor), colors);
            }
            return colors;
        }
        return null;
    }

    private static void addColorForBiomeRegex(String regex, int color, Map<ResourceLocation, Integer> colors) {
        try {
            Pattern pattern = Pattern.compile(regex);
            for (ResourceLocation rl : Biome.field_185377_q.func_148742_b()) {
                if (!pattern.matcher(rl.toString()).matches()) continue;
                colors.put(rl, color);
            }
        }
        catch (PatternSyntaxException e) {
            JustEnoughDimensions.logger.warn("DimensionConfig.addColorForBiomeRegex(): Invalid regular expression", (Throwable)e);
        }
    }

    private static Map<ResourceLocation, Integer> getColorMap(DimensionConfig.ColorType type) {
        switch (type) {
            case FOLIAGE: {
                return FOLIAGE_COLORS;
            }
            case GRASS: {
                return GRASS_COLORS;
            }
            case WATER: {
                return WATER_COLORS;
            }
        }
        return FOLIAGE_COLORS;
    }

    private static void setFlag(DimensionConfig.ColorType type, boolean value) {
        switch (type) {
            case FOLIAGE: {
                hasFoliageColors = value;
                break;
            }
            case GRASS: {
                hasGrassColors = value;
                break;
            }
            case WATER: {
                hasWaterColors = value;
                break;
            }
        }
    }
}

