/*
 * Decompiled with CFR 0.152.
 */
package mcjty.tools.varia;

import com.google.gson.JsonObject;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;

public class Tools {
    public static Map<String, String> modSourceID = null;

    public static String findModID(Object obj) {
        String path;
        if (modSourceID == null) {
            modSourceID = new HashMap<String, String>();
            for (ModContainer mod : Loader.instance().getModList()) {
                modSourceID.put(mod.getSource().getName(), mod.getModId());
            }
            modSourceID.put("1.8.0.jar", "minecraft");
            modSourceID.put("1.8.8.jar", "minecraft");
            modSourceID.put("1.8.9.jar", "minecraft");
            modSourceID.put("Forge", "minecraft");
        }
        try {
            path = obj instanceof Class ? ((Class)obj).getProtectionDomain().getCodeSource().getLocation().toString() : obj.getClass().getProtectionDomain().getCodeSource().getLocation().toString();
        }
        catch (Exception e) {
            return "<Unknown>";
        }
        try {
            path = URLDecoder.decode(path, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return "<Unknown>";
        }
        String modName = "<Unknown>";
        for (String s : modSourceID.keySet()) {
            if (!path.contains(s)) continue;
            modName = modSourceID.get(s);
            break;
        }
        if (modName.equals("Minecraft Coder Pack")) {
            modName = "minecraft";
        } else if (modName.equals("Forge")) {
            modName = "minecraft";
        }
        return modName;
    }

    public static Pair<Float, ItemStack> parseStackWithFactor(String name, Logger logger) {
        int i;
        for (i = 0; i < name.length() && (Character.isDigit(name.charAt(i)) || name.charAt(i) == '.'); ++i) {
        }
        if (i < name.length() && name.charAt(i) == '=') {
            float v;
            String f = name.substring(0, i);
            try {
                v = Float.parseFloat(f);
            }
            catch (NumberFormatException e) {
                v = 1.0f;
            }
            return Pair.of((Object)Float.valueOf(v), (Object)Tools.parseStack(name.substring(i + 1), logger));
        }
        return Pair.of((Object)Float.valueOf(1.0f), (Object)Tools.parseStack(name, logger));
    }

    public static Pair<Float, ItemStack> parseStackWithFactor(JsonObject obj, Logger logger) {
        ItemStack stack;
        float factor = 1.0f;
        if (obj.has("factor")) {
            factor = obj.get("factor").getAsFloat();
        }
        if ((stack = Tools.parseStack(obj, logger)) == null) {
            return null;
        }
        return Pair.of((Object)Float.valueOf(factor), (Object)stack);
    }

    @Nonnull
    public static ItemStack parseStack(String name, Logger logger) {
        if (name.contains("/")) {
            NBTTagCompound nbt;
            String[] split = StringUtils.split((String)name, (String)"/");
            ItemStack stack = Tools.parseStackNoNBT(split[0], logger);
            if (stack.func_190926_b()) {
                return stack;
            }
            try {
                nbt = JsonToNBT.func_180713_a((String)split[1]);
            }
            catch (NBTException e) {
                logger.log(Level.ERROR, "Error parsing NBT in '" + name + "'!");
                return ItemStack.field_190927_a;
            }
            stack.func_77982_d(nbt);
            return stack;
        }
        return Tools.parseStackNoNBT(name, logger);
    }

    @Nullable
    public static ItemStack parseStack(JsonObject obj, Logger logger) {
        if (obj.has("empty")) {
            return ItemStack.field_190927_a;
        }
        String name = obj.get("item").getAsString();
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(name));
        if (item == null) {
            logger.log(Level.ERROR, "Unknown item '" + name + "'!");
            return null;
        }
        ItemStack stack = new ItemStack(item);
        if (obj.has("damage")) {
            stack.func_77964_b(obj.get("damage").getAsInt());
        }
        if (obj.has("count")) {
            stack.func_190920_e(obj.get("count").getAsInt());
        }
        if (obj.has("nbt")) {
            String nbt = obj.get("nbt").toString();
            NBTTagCompound tag = null;
            try {
                tag = JsonToNBT.func_180713_a((String)nbt);
            }
            catch (NBTException e) {
                logger.log(Level.ERROR, "Error parsing json '" + nbt + "'!");
                return ItemStack.field_190927_a;
            }
            stack.func_77982_d(tag);
        }
        return stack;
    }

    private static ItemStack parseStackNoNBT(String name, Logger logger) {
        if (name.contains("@")) {
            String[] split = StringUtils.split((String)name, (String)"@");
            Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(split[0]));
            if (item == null) {
                return ItemStack.field_190927_a;
            }
            int meta = 0;
            try {
                meta = Integer.parseInt(split[1]);
            }
            catch (NumberFormatException e) {
                logger.log(Level.ERROR, "Unknown item '" + name + "'!");
                return ItemStack.field_190927_a;
            }
            return new ItemStack(item, 1, meta);
        }
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(name));
        if (item == null) {
            return ItemStack.field_190927_a;
        }
        return new ItemStack(item);
    }
}

