/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.librarianlib.features.utilities.client;

import java.nio.ByteOrder;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

@SideOnly(value=Side.CLIENT)
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J8\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0003J8\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\rH\u0003JX\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\bH\u0007Jf\u0010\u001a\u001a\u00020\u00042\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\bH\u0007J\u0018\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u00062\u0006\u0010 \u001a\u00020\u0006H\u0007\u00a8\u0006!"}, d2={"Lcom/teamwizardry/librarianlib/features/utilities/client/BlockRenderUtils;", "", "()V", "putColorMultiplier", "", "buf", "Lnet/minecraft/client/renderer/BufferBuilder;", "red", "", "green", "blue", "alpha", "p_178978_4_", "", "putRGBA_F4", "relIndex", "renderBlockToVB", "state", "Lnet/minecraft/block/state/IBlockState;", "access", "Lnet/minecraft/world/IBlockAccess;", "pos", "Lnet/minecraft/util/math/BlockPos;", "renderPos", "buffer", "brightness", "renderQuadsToBuffer", "quads", "", "Lnet/minecraft/client/renderer/block/model/BakedQuad;", "transferVB", "from", "to", "librarianlib-1.12.2"})
public final class BlockRenderUtils {
    public static final BlockRenderUtils INSTANCE;

    @JvmStatic
    public static final void transferVB(@NotNull BufferBuilder from, @NotNull BufferBuilder to) {
        Intrinsics.checkParameterIsNotNull((Object)from, (String)"from");
        Intrinsics.checkParameterIsNotNull((Object)to, (String)"to");
        to.func_178981_a(from.func_178966_f().asIntBuffer().array());
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final void renderQuadsToBuffer(@NotNull List<? extends BakedQuad> quads, @NotNull IBlockState state, @NotNull IBlockAccess access, @NotNull BlockPos pos2, @NotNull BlockPos renderPos, @NotNull BufferBuilder buf, float red, float green, float blue, float brightness, float alpha) {
        Intrinsics.checkParameterIsNotNull(quads, (String)"quads");
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        Intrinsics.checkParameterIsNotNull((Object)access, (String)"access");
        Intrinsics.checkParameterIsNotNull((Object)pos2, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)renderPos, (String)"renderPos");
        Intrinsics.checkParameterIsNotNull((Object)buf, (String)"buf");
        int n = 0;
        int n2 = ((Collection)quads).size();
        while (n < n2) {
            Vec3i normal;
            void i;
            BakedQuad bakedquad = quads.get((int)i);
            buf.func_178981_a(bakedquad.func_178209_a());
            if (bakedquad.func_178212_b()) {
                Minecraft minecraft = Minecraft.func_71410_x();
                Intrinsics.checkExpressionValueIsNotNull((Object)minecraft, (String)"Minecraft.getMinecraft()");
                int l = minecraft.func_184125_al().func_186724_a(state, access, pos2, bakedquad.func_178211_c());
                float redMul = (float)(l >> 16 & 0xFF) / 255.0f;
                float blueMul = (float)(l >> 8 & 0xFF) / 255.0f;
                float greenMul = (float)(l & 0xFF) / 255.0f;
                BlockRenderUtils.putColorMultiplier(buf, redMul * brightness, blueMul * brightness, greenMul * brightness, alpha, 4);
                BlockRenderUtils.putColorMultiplier(buf, redMul * brightness, blueMul * brightness, greenMul * brightness, alpha, 3);
                BlockRenderUtils.putColorMultiplier(buf, redMul * brightness, blueMul * brightness, greenMul * brightness, alpha, 2);
                BlockRenderUtils.putColorMultiplier(buf, redMul * brightness, blueMul * brightness, greenMul * brightness, alpha, 1);
            } else {
                BlockRenderUtils.putRGBA_F4(buf, red * brightness, green * brightness, blue * brightness, alpha, 4);
                BlockRenderUtils.putRGBA_F4(buf, red * brightness, green * brightness, blue * brightness, alpha, 3);
                BlockRenderUtils.putRGBA_F4(buf, red * brightness, green * brightness, blue * brightness, alpha, 2);
                BlockRenderUtils.putRGBA_F4(buf, red * brightness, green * brightness, blue * brightness, alpha, 1);
            }
            EnumFacing enumFacing = bakedquad.func_178210_d();
            Intrinsics.checkExpressionValueIsNotNull((Object)enumFacing, (String)"bakedquad.face");
            Vec3i vec3i = normal = enumFacing.func_176730_m();
            Intrinsics.checkExpressionValueIsNotNull((Object)vec3i, (String)"normal");
            buf.func_178975_e((float)vec3i.func_177958_n(), (float)normal.func_177956_o(), (float)normal.func_177952_p());
            buf.func_178987_a((double)renderPos.func_177958_n(), (double)renderPos.func_177956_o(), (double)renderPos.func_177952_p());
            ++i;
        }
    }

    @JvmStatic
    private static final void putRGBA_F4(BufferBuilder buf, float red, float green, float blue, float alpha, int relIndex) {
        int index = buf.func_78909_a(relIndex);
        int r = MathHelper.func_76125_a((int)((int)(red * 255.0f)), (int)0, (int)255);
        int g = MathHelper.func_76125_a((int)((int)(green * 255.0f)), (int)0, (int)255);
        int b = MathHelper.func_76125_a((int)((int)(blue * 255.0f)), (int)0, (int)255);
        int a = MathHelper.func_76125_a((int)((int)(alpha * 255.0f)), (int)0, (int)255);
        buf.putColorRGBA(index, r, g, b, a);
    }

    @JvmStatic
    private static final void putColorMultiplier(BufferBuilder buf, float red, float green, float blue, float alpha, int p_178978_4_) {
        int index = buf.func_78909_a(p_178978_4_);
        int color2 = buf.func_178966_f().asIntBuffer().get(index);
        if (Intrinsics.areEqual((Object)ByteOrder.nativeOrder(), (Object)ByteOrder.LITTLE_ENDIAN)) {
            int newRed = (int)((float)(color2 & 0xFF) * red);
            int newGreen = (int)((float)(color2 >> 8 & 0xFF) * green);
            int newBlue = (int)((float)(color2 >> 16 & 0xFF) * blue);
            int newAlpha = (int)((float)(color2 >> 24 & 0xFF) * alpha);
            color2 = ((newAlpha << 24 | newBlue) << 16 | newGreen) << 8 | newRed;
        } else {
            int newRed = (int)((float)(color2 >> 24 & 0xFF) * red);
            int newGreen = (int)((float)(color2 >> 16 & 0xFF) * green);
            int newBlue = (int)((float)(color2 >> 8 & 0xFF) * blue);
            int newAlpha = (int)((float)(color2 & 0xFF) * alpha);
            color2 = ((newRed << 24 | newGreen) << 16 | newBlue) << 8 | newAlpha;
        }
        buf.func_178966_f().asIntBuffer().put(index, color2);
    }

    @JvmStatic
    public static final void renderBlockToVB(@NotNull IBlockState state, @NotNull IBlockAccess access, @NotNull BlockPos pos2, @NotNull BlockPos renderPos, @NotNull BufferBuilder buffer, float red, float green, float blue, float brightness, float alpha) {
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        Intrinsics.checkParameterIsNotNull((Object)access, (String)"access");
        Intrinsics.checkParameterIsNotNull((Object)pos2, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)renderPos, (String)"renderPos");
        Intrinsics.checkParameterIsNotNull((Object)buffer, (String)"buffer");
        IBlockState newState = state.func_185899_b(access, pos2);
        Minecraft minecraft = Minecraft.func_71410_x();
        Intrinsics.checkExpressionValueIsNotNull((Object)minecraft, (String)"Minecraft.getMinecraft()");
        BlockRendererDispatcher blockRendererDispatcher = minecraft.func_175602_ab();
        Intrinsics.checkExpressionValueIsNotNull((Object)blockRendererDispatcher, (String)"Minecraft.getMinecraft().blockRendererDispatcher");
        IBakedModel model = blockRendererDispatcher.func_175023_a().func_178125_b(newState);
        for (EnumFacing enumfacing : EnumFacing.values()) {
            if (!newState.func_185894_c(access, pos2, enumfacing)) continue;
            List list2 = model.func_188616_a(newState, enumfacing, 0L);
            Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"model.getQuads(newState, enumfacing, 0L)");
            IBlockState iBlockState = newState;
            Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"newState");
            BlockRenderUtils.renderQuadsToBuffer(list2, iBlockState, access, pos2, renderPos, buffer, red, green, blue, brightness, alpha);
        }
        List list3 = model.func_188616_a(newState, null, 0L);
        Intrinsics.checkExpressionValueIsNotNull((Object)list3, (String)"model.getQuads(newState, null, 0L)");
        IBlockState iBlockState = newState;
        Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"newState");
        BlockRenderUtils.renderQuadsToBuffer(list3, iBlockState, access, pos2, renderPos, buffer, red, green, blue, brightness, alpha);
    }

    private BlockRenderUtils() {
    }

    static {
        BlockRenderUtils blockRenderUtils;
        INSTANCE = blockRenderUtils = new BlockRenderUtils();
    }
}

