/*
 * Decompiled with CFR 0.152.
 */
package gregtech.loaders.recipe;

import gregtech.api.items.OreDictNames;
import gregtech.api.metatileentity.ITieredMetaTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.recipes.ModHandler;
import gregtech.api.unification.material.MarkerMaterials;
import gregtech.api.unification.material.Materials;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.unification.stack.UnificationEntry;
import gregtech.common.ConfigHolder;
import gregtech.common.blocks.BlockBoilerCasing;
import gregtech.common.blocks.BlockFireboxCasing;
import gregtech.common.blocks.BlockMachineCasing;
import gregtech.common.blocks.BlockMetalCasing;
import gregtech.common.blocks.BlockMultiblockCasing;
import gregtech.common.blocks.BlockTurbineCasing;
import gregtech.common.blocks.BlockWarningSign;
import gregtech.common.blocks.BlockWireCoil;
import gregtech.common.blocks.MetaBlocks;
import gregtech.common.items.MetaItems;
import gregtech.common.metatileentities.MetaTileEntities;
import gregtech.loaders.recipe.CraftingComponent;
import java.util.Arrays;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;

public class MetaTileEntityLoader {
    /*
     * Opcode count of 15672 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    public static void init() {
        ModHandler.addShapedRecipe("casing_ulv", MetaBlocks.MACHINE_CASING.getItemVariant(BlockMachineCasing.MachineCasingType.ULV), "PPP", "PwP", "PPP", Character.valueOf('P'), new UnificationEntry(OrePrefix.plate, Materials.WroughtIron));
        ModHandler.addShapedRecipe("casing_lv", MetaBlocks.MACHINE_CASING.getItemVariant(BlockMachineCasing.MachineCasingType.LV), "PPP", "PwP", "PPP", Character.valueOf('P'), new UnificationEntry(OrePrefix.plate, Materials.Steel));
        ModHandler.addShapedRecipe("casing_mv", MetaBlocks.MACHINE_CASING.getItemVariant(BlockMachineCasing.MachineCasingType.MV), "PPP", "PwP", "PPP", Character.valueOf('P'), new UnificationEntry(OrePrefix.plate, Materials.Aluminium));
        ModHandler.addShapedRecipe("casing_hv", MetaBlocks.MACHINE_CASING.getItemVariant(BlockMachineCasing.MachineCasingType.HV), "PPP", "PwP", "PPP", Character.valueOf('P'), new UnificationEntry(OrePrefix.plate, Materials.StainlessSteel));
        ModHandler.addShapedRecipe("casing_ev", MetaBlocks.MACHINE_CASING.getItemVariant(BlockMachineCasing.MachineCasingType.EV), "PPP", "PwP", "PPP", Character.valueOf('P'), new UnificationEntry(OrePrefix.plate, Materials.Titanium));
        ModHandler.addShapedRecipe("casing_iv", MetaBlocks.MACHINE_CASING.getItemVariant(BlockMachineCasing.MachineCasingType.IV), "PPP", "PwP", "PPP", Character.valueOf('P'), new UnificationEntry(OrePrefix.plate, Materials.TungstenSteel));
        ModHandler.addShapedRecipe("casing_luv", MetaBlocks.MACHINE_CASING.getItemVariant(BlockMachineCasing.MachineCasingType.LuV), "PPP", "PwP", "PPP", Character.valueOf('P'), new UnificationEntry(OrePrefix.plate, Materials.Chrome));
        ModHandler.addShapedRecipe("casing_zpm", MetaBlocks.MACHINE_CASING.getItemVariant(BlockMachineCasing.MachineCasingType.ZPM), "PPP", "PwP", "PPP", Character.valueOf('P'), new UnificationEntry(OrePrefix.plate, Materials.Iridium));
        ModHandler.addShapedRecipe("casing_uv", MetaBlocks.MACHINE_CASING.getItemVariant(BlockMachineCasing.MachineCasingType.UV), "PPP", "PwP", "PPP", Character.valueOf('P'), new UnificationEntry(OrePrefix.plate, Materials.Osmium));
        ModHandler.addShapedRecipe("casing_max", MetaBlocks.MACHINE_CASING.getItemVariant(BlockMachineCasing.MachineCasingType.MAX), "PPP", "PwP", "PPP", Character.valueOf('P'), new UnificationEntry(OrePrefix.plate, Materials.Darmstadtium));
        ModHandler.addShapedRecipe("casing_primitive_bricks", MetaBlocks.METAL_CASING.getItemVariant(BlockMetalCasing.MetalCasingType.PRIMITIVE_BRICKS, 1), "XX", "XX", Character.valueOf('X'), MetaItems.FIRECLAY_BRICK);
        ModHandler.addShapedRecipe("casing_coke_bricks", MetaBlocks.METAL_CASING.getItemVariant(BlockMetalCasing.MetalCasingType.COKE_BRICKS, 1), "XX", "XX", Character.valueOf('X'), MetaItems.COKE_OVEN_BRICK);
        ModHandler.addShapedRecipe("casing_bronze_bricks", MetaBlocks.METAL_CASING.getItemVariant(BlockMetalCasing.MetalCasingType.BRONZE_BRICKS, 3), "PhP", "PBP", "PwP", Character.valueOf('P'), new UnificationEntry(OrePrefix.plate, Materials.Bronze), Character.valueOf('B'), new ItemStack(Blocks.field_150336_V, 1));
        ModHandler.addShapedRecipe("casing_steel_solid", MetaBlocks.METAL_CASING.getItemVariant(BlockMetalCasing.MetalCasingType.STEEL_SOLID, 3), "PhP", "PFP", "PwP", Character.valueOf('P'), new UnificationEntry(OrePrefix.plate, Materials.Steel), Character.valueOf('F'), new UnificationEntry(OrePrefix.frameGt, Materials.Steel));
        ModHandler.addShapedRecipe("casing_titanium_stable", MetaBlocks.METAL_CASING.getItemVariant(BlockMetalCasing.MetalCasingType.TITANIUM_STABLE, 3), "PhP", "PFP", "PwP", Character.valueOf('P'), new UnificationEntry(OrePrefix.plate, Materials.Titanium), Character.valueOf('F'), new UnificationEntry(OrePrefix.frameGt, Materials.Titanium));
        ModHandler.addShapedRecipe("casing_invar_heatproof", MetaBlocks.METAL_CASING.getItemVariant(BlockMetalCasing.MetalCasingType.INVAR_HEATPROOF, 3), "PhP", "PFP", "PwP", Character.valueOf('P'), new UnificationEntry(OrePrefix.plate, Materials.Invar), Character.valueOf('F'), new UnificationEntry(OrePrefix.frameGt, Materials.Invar));
        ModHandler.addShapedRecipe("casing_aluminium_frostproof", MetaBlocks.METAL_CASING.getItemVariant(BlockMetalCasing.MetalCasingType.ALUMINIUM_FROSTPROOF, 3), "PhP", "PFP", "PwP", Character.valueOf('P'), new UnificationEntry(OrePrefix.plate, Materials.Aluminium), Character.valueOf('F'), new UnificationEntry(OrePrefix.frameGt, Materials.Aluminium));
        ModHandler.addShapedRecipe("casing_stainless_clean", MetaBlocks.METAL_CASING.getItemVariant(BlockMetalCasing.MetalCasingType.STAINLESS_CLEAN, 3), "PhP", "PFP", "PwP", Character.valueOf('P'), new UnificationEntry(OrePrefix.plate, Materials.StainlessSteel), Character.valueOf('F'), new UnificationEntry(OrePrefix.frameGt, Materials.StainlessSteel));
        ModHandler.addShapedRecipe("casing_tungstensteel_robust", MetaBlocks.METAL_CASING.getItemVariant(BlockMetalCasing.MetalCasingType.TUNGSTENSTEEL_ROBUST, 3), "PhP", "PFP", "PwP", Character.valueOf('P'), new UnificationEntry(OrePrefix.plate, Materials.TungstenSteel), Character.valueOf('F'), new UnificationEntry(OrePrefix.frameGt, Materials.TungstenSteel));
        ModHandler.addShapedRecipe("casing_steel_turbine_casing", MetaBlocks.TURBINE_CASING.getItemVariant(BlockTurbineCasing.TurbineCasingType.STEEL_TURBINE_CASING, 3), "PhP", "PFP", "PwP", Character.valueOf('P'), new UnificationEntry(OrePrefix.plate, Materials.Magnalium), Character.valueOf('F'), new UnificationEntry(OrePrefix.frameGt, Materials.BlueSteel));
        ModHandler.addShapedRecipe("casing_stainless_turbine_casing", MetaBlocks.TURBINE_CASING.getItemVariant(BlockTurbineCasing.TurbineCasingType.STAINLESS_TURBINE_CASING, 3), "PhP", "PFP", "PwP", Character.valueOf('P'), new UnificationEntry(OrePrefix.plate, Materials.StainlessSteel), Character.valueOf('F'), MetaBlocks.TURBINE_CASING.getItemVariant(BlockTurbineCasing.TurbineCasingType.STEEL_TURBINE_CASING));
        ModHandler.addShapedRecipe("casing_titanium_turbine_casing", MetaBlocks.TURBINE_CASING.getItemVariant(BlockTurbineCasing.TurbineCasingType.TITANIUM_TURBINE_CASING, 3), "PhP", "PFP", "PwP", Character.valueOf('P'), new UnificationEntry(OrePrefix.plate, Materials.Titanium), Character.valueOf('F'), MetaBlocks.TURBINE_CASING.getItemVariant(BlockTurbineCasing.TurbineCasingType.STEEL_TURBINE_CASING));
        ModHandler.addShapedRecipe("casing_tungstensteel_turbine_casing", MetaBlocks.TURBINE_CASING.getItemVariant(BlockTurbineCasing.TurbineCasingType.TUNGSTENSTEEL_TURBINE_CASING, 3), "PhP", "PFP", "PwP", Character.valueOf('P'), new UnificationEntry(OrePrefix.plate, Materials.TungstenSteel), Character.valueOf('F'), MetaBlocks.TURBINE_CASING.getItemVariant(BlockTurbineCasing.TurbineCasingType.STEEL_TURBINE_CASING));
        ModHandler.addShapedRecipe("casing_bronze_pipe", MetaBlocks.BOILER_CASING.getItemVariant(BlockBoilerCasing.BoilerCasingType.BRONZE_PIPE, 3), "PIP", "IFI", "PIP", Character.valueOf('P'), new UnificationEntry(OrePrefix.plate, Materials.Bronze), Character.valueOf('F'), new UnificationEntry(OrePrefix.frameGt, Materials.Bronze), Character.valueOf('I'), new UnificationEntry(OrePrefix.pipeMedium, Materials.Bronze));
        ModHandler.addShapedRecipe("casing_steel_pipe", MetaBlocks.BOILER_CASING.getItemVariant(BlockBoilerCasing.BoilerCasingType.STEEL_PIPE, 3), "PIP", "IFI", "PIP", Character.valueOf('P'), new UnificationEntry(OrePrefix.plate, Materials.Steel), Character.valueOf('F'), new UnificationEntry(OrePrefix.frameGt, Materials.Steel), Character.valueOf('I'), new UnificationEntry(OrePrefix.pipeMedium, Materials.Steel));
        ModHandler.addShapedRecipe("casing_titanium_pipe", MetaBlocks.BOILER_CASING.getItemVariant(BlockBoilerCasing.BoilerCasingType.TITANIUM_PIPE, 3), "PIP", "IFI", "PIP", Character.valueOf('P'), new UnificationEntry(OrePrefix.plate, Materials.Titanium), Character.valueOf('F'), new UnificationEntry(OrePrefix.frameGt, Materials.Titanium), Character.valueOf('I'), new UnificationEntry(OrePrefix.pipeMedium, Materials.Titanium));
        ModHandler.addShapedRecipe("casing_tungstensteel_pipe", MetaBlocks.BOILER_CASING.getItemVariant(BlockBoilerCasing.BoilerCasingType.TUNGSTENSTEEL_PIPE, 3), "PIP", "IFI", "PIP", Character.valueOf('P'), new UnificationEntry(OrePrefix.plate, Materials.TungstenSteel), Character.valueOf('F'), new UnificationEntry(OrePrefix.frameGt, Materials.TungstenSteel), Character.valueOf('I'), new UnificationEntry(OrePrefix.pipeMedium, Materials.TungstenSteel));
        ModHandler.addShapedRecipe("casing_bronze_firebox", MetaBlocks.BOILER_FIREBOX_CASING.getItemVariant(BlockFireboxCasing.FireboxCasingType.BRONZE_FIREBOX, 3), "PSP", "SFS", "PSP", Character.valueOf('P'), new UnificationEntry(OrePrefix.plate, Materials.Bronze), Character.valueOf('F'), new UnificationEntry(OrePrefix.frameGt, Materials.Bronze), Character.valueOf('S'), new UnificationEntry(OrePrefix.stick, Materials.Bronze));
        ModHandler.addShapedRecipe("casing_steel_firebox", MetaBlocks.BOILER_FIREBOX_CASING.getItemVariant(BlockFireboxCasing.FireboxCasingType.STEEL_FIREBOX, 3), "PSP", "SFS", "PSP", Character.valueOf('P'), new UnificationEntry(OrePrefix.plate, Materials.Steel), Character.valueOf('F'), new UnificationEntry(OrePrefix.frameGt, Materials.Steel), Character.valueOf('S'), new UnificationEntry(OrePrefix.stick, Materials.Steel));
        ModHandler.addShapedRecipe("casing_titanium_firebox", MetaBlocks.BOILER_FIREBOX_CASING.getItemVariant(BlockFireboxCasing.FireboxCasingType.TITANIUM_FIREBOX, 3), "PSP", "SFS", "PSP", Character.valueOf('P'), new UnificationEntry(OrePrefix.plate, Materials.Titanium), Character.valueOf('F'), new UnificationEntry(OrePrefix.frameGt, Materials.Titanium), Character.valueOf('S'), new UnificationEntry(OrePrefix.stick, Materials.Titanium));
        ModHandler.addShapedRecipe("casing_tungstensteel_firebox", MetaBlocks.BOILER_FIREBOX_CASING.getItemVariant(BlockFireboxCasing.FireboxCasingType.TUNGSTENSTEEL_FIREBOX, 3), "PSP", "SFS", "PSP", Character.valueOf('P'), new UnificationEntry(OrePrefix.plate, Materials.TungstenSteel), Character.valueOf('F'), new UnificationEntry(OrePrefix.frameGt, Materials.TungstenSteel), Character.valueOf('S'), new UnificationEntry(OrePrefix.stick, Materials.TungstenSteel));
        for (BlockWireCoil.CoilType coilType : BlockWireCoil.CoilType.values()) {
            if (coilType.getMaterial() == null) continue;
            ItemStack outputStack = MetaBlocks.WIRE_COIL.getItemVariant(coilType);
            ModHandler.addShapedRecipe(String.format("heating_coil_%s", coilType.func_176610_l()), outputStack, "XXX", "XwX", "XXX", Character.valueOf('X'), new UnificationEntry(OrePrefix.wireGtDouble, coilType.getMaterial()));
        }
        ModHandler.addShapedRecipe("casing_bronze_gearbox", MetaBlocks.TURBINE_CASING.getItemVariant(BlockTurbineCasing.TurbineCasingType.BRONZE_GEARBOX, 3), "PhP", "GFG", "PwP", Character.valueOf('P'), new UnificationEntry(OrePrefix.plate, Materials.Bronze), Character.valueOf('F'), new UnificationEntry(OrePrefix.frameGt, Materials.Bronze), Character.valueOf('G'), new UnificationEntry(OrePrefix.gear, Materials.Bronze));
        ModHandler.addShapedRecipe("casing_steel_gearbox", MetaBlocks.TURBINE_CASING.getItemVariant(BlockTurbineCasing.TurbineCasingType.STEEL_GEARBOX, 3), "PhP", "GFG", "PwP", Character.valueOf('P'), new UnificationEntry(OrePrefix.plate, Materials.Steel), Character.valueOf('F'), new UnificationEntry(OrePrefix.frameGt, Materials.Steel), Character.valueOf('G'), new UnificationEntry(OrePrefix.gear, Materials.Steel));
        ModHandler.addShapedRecipe("casing_titanium_gearbox", MetaBlocks.TURBINE_CASING.getItemVariant(BlockTurbineCasing.TurbineCasingType.TITANIUM_GEARBOX, 3), "PhP", "GFG", "PwP", Character.valueOf('P'), new UnificationEntry(OrePrefix.plate, Materials.Steel), Character.valueOf('F'), new UnificationEntry(OrePrefix.frameGt, Materials.Titanium), Character.valueOf('G'), new UnificationEntry(OrePrefix.gear, Materials.Titanium));
        ModHandler.addShapedRecipe("casing_grate_casing", MetaBlocks.MUTLIBLOCK_CASING.getItemVariant(BlockMultiblockCasing.MultiblockCasingType.GRATE_CASING, 3), "PVP", "PFP", "PMP", Character.valueOf('P'), new ItemStack(Blocks.field_150411_aY, 1), Character.valueOf('F'), new UnificationEntry(OrePrefix.frameGt, Materials.Steel), Character.valueOf('M'), MetaItems.ELECTRIC_MOTOR_MV, Character.valueOf('V'), new UnificationEntry(OrePrefix.rotor, Materials.Steel));
        ModHandler.addShapedRecipe("casing_assembler_casing", MetaBlocks.MUTLIBLOCK_CASING.getItemVariant(BlockMultiblockCasing.MultiblockCasingType.ASSEMBLER_CASING, 3), "PVP", "PFP", "PMP", Character.valueOf('P'), new UnificationEntry(OrePrefix.circuit, MarkerMaterials.Tier.Elite), Character.valueOf('F'), new UnificationEntry(OrePrefix.frameGt, Materials.TungstenSteel), Character.valueOf('M'), MetaItems.ELECTRIC_MOTOR_IV, Character.valueOf('V'), new UnificationEntry(OrePrefix.circuit, MarkerMaterials.Tier.Elite));
        ModHandler.addShapedRecipe("warning_sign_yellow_stripes", MetaBlocks.WARNING_SIGN.getItemVariant(BlockWarningSign.SignType.YELLOW_STRIPES), "Y  ", " M ", "  B", Character.valueOf('M'), MetaBlocks.METAL_CASING.getItemVariant(BlockMetalCasing.MetalCasingType.STEEL_SOLID), Character.valueOf('Y'), "dyeYellow", Character.valueOf('B'), "dyeBlack");
        ModHandler.addShapedRecipe("warning_sign_small_yellow_stripes", MetaBlocks.WARNING_SIGN.getItemVariant(BlockWarningSign.SignType.SMALL_YELLOW_STRIPES), "  Y", " M ", "B  ", Character.valueOf('M'), MetaBlocks.METAL_CASING.getItemVariant(BlockMetalCasing.MetalCasingType.STEEL_SOLID), Character.valueOf('Y'), "dyeYellow", Character.valueOf('B'), "dyeBlack");
        ModHandler.addShapedRecipe("warning_sign_radioactive_hazard", MetaBlocks.WARNING_SIGN.getItemVariant(BlockWarningSign.SignType.RADIOACTIVE_HAZARD), " YB", " M ", "   ", Character.valueOf('M'), MetaBlocks.METAL_CASING.getItemVariant(BlockMetalCasing.MetalCasingType.STEEL_SOLID), Character.valueOf('Y'), "dyeYellow", Character.valueOf('B'), "dyeBlack");
        ModHandler.addShapedRecipe("warning_sign_bio_hazard", MetaBlocks.WARNING_SIGN.getItemVariant(BlockWarningSign.SignType.BIO_HAZARD), " Y ", " MB", "   ", Character.valueOf('M'), MetaBlocks.METAL_CASING.getItemVariant(BlockMetalCasing.MetalCasingType.STEEL_SOLID), Character.valueOf('Y'), "dyeYellow", Character.valueOf('B'), "dyeBlack");
        ModHandler.addShapedRecipe("warning_sign_explosion_hazard", MetaBlocks.WARNING_SIGN.getItemVariant(BlockWarningSign.SignType.EXPLOSION_HAZARD), " Y ", " M ", "  B", Character.valueOf('M'), MetaBlocks.METAL_CASING.getItemVariant(BlockMetalCasing.MetalCasingType.STEEL_SOLID), Character.valueOf('Y'), "dyeYellow", Character.valueOf('B'), "dyeBlack");
        ModHandler.addShapedRecipe("warning_sign_fire_hazard", MetaBlocks.WARNING_SIGN.getItemVariant(BlockWarningSign.SignType.FIRE_HAZARD), " Y ", " M ", " B ", Character.valueOf('M'), MetaBlocks.METAL_CASING.getItemVariant(BlockMetalCasing.MetalCasingType.STEEL_SOLID), Character.valueOf('Y'), "dyeYellow", Character.valueOf('B'), "dyeBlack");
        ModHandler.addShapedRecipe("warning_sign_acid_hazard", MetaBlocks.WARNING_SIGN.getItemVariant(BlockWarningSign.SignType.ACID_HAZARD), " Y ", " M ", "B  ", Character.valueOf('M'), MetaBlocks.METAL_CASING.getItemVariant(BlockMetalCasing.MetalCasingType.STEEL_SOLID), Character.valueOf('Y'), "dyeYellow", Character.valueOf('B'), "dyeBlack");
        ModHandler.addShapedRecipe("warning_sign_magic_hazard", MetaBlocks.WARNING_SIGN.getItemVariant(BlockWarningSign.SignType.MAGIC_HAZARD), " Y ", "BM ", "   ", Character.valueOf('M'), MetaBlocks.METAL_CASING.getItemVariant(BlockMetalCasing.MetalCasingType.STEEL_SOLID), Character.valueOf('Y'), "dyeYellow", Character.valueOf('B'), "dyeBlack");
        ModHandler.addShapedRecipe("warning_sign_frost_hazard", MetaBlocks.WARNING_SIGN.getItemVariant(BlockWarningSign.SignType.FROST_HAZARD), "BY ", " M ", "   ", Character.valueOf('M'), MetaBlocks.METAL_CASING.getItemVariant(BlockMetalCasing.MetalCasingType.STEEL_SOLID), Character.valueOf('Y'), "dyeYellow", Character.valueOf('B'), "dyeBlack");
        ModHandler.addShapedRecipe("warning_sign_noise_hazard", MetaBlocks.WARNING_SIGN.getItemVariant(BlockWarningSign.SignType.NOISE_HAZARD), "   ", " M ", "BY ", Character.valueOf('M'), MetaBlocks.METAL_CASING.getItemVariant(BlockMetalCasing.MetalCasingType.STEEL_SOLID), Character.valueOf('Y'), "dyeYellow", Character.valueOf('B'), "dyeBlack");
        ModHandler.addShapelessRecipe("yellow_stripes_to_steel_solid_casing", MetaBlocks.METAL_CASING.getItemVariant(BlockMetalCasing.MetalCasingType.STEEL_SOLID), MetaBlocks.WARNING_SIGN.getItemVariant(BlockWarningSign.SignType.YELLOW_STRIPES));
        ModHandler.addShapelessRecipe("small_yellow_stripes_to_steel_solid_casing", MetaBlocks.METAL_CASING.getItemVariant(BlockMetalCasing.MetalCasingType.STEEL_SOLID), MetaBlocks.WARNING_SIGN.getItemVariant(BlockWarningSign.SignType.SMALL_YELLOW_STRIPES));
        ModHandler.addShapelessRecipe("radioactive_hazard_to_steel_solid_casing", MetaBlocks.METAL_CASING.getItemVariant(BlockMetalCasing.MetalCasingType.STEEL_SOLID), MetaBlocks.WARNING_SIGN.getItemVariant(BlockWarningSign.SignType.RADIOACTIVE_HAZARD));
        ModHandler.addShapelessRecipe("bio_hazard_to_steel_solid_casing", MetaBlocks.METAL_CASING.getItemVariant(BlockMetalCasing.MetalCasingType.STEEL_SOLID), MetaBlocks.WARNING_SIGN.getItemVariant(BlockWarningSign.SignType.BIO_HAZARD));
        ModHandler.addShapelessRecipe("explosion_hazard_to_steel_solid_casing", MetaBlocks.METAL_CASING.getItemVariant(BlockMetalCasing.MetalCasingType.STEEL_SOLID), MetaBlocks.WARNING_SIGN.getItemVariant(BlockWarningSign.SignType.EXPLOSION_HAZARD));
        ModHandler.addShapelessRecipe("fire_hazard_to_steel_solid_casing", MetaBlocks.METAL_CASING.getItemVariant(BlockMetalCasing.MetalCasingType.STEEL_SOLID), MetaBlocks.WARNING_SIGN.getItemVariant(BlockWarningSign.SignType.FIRE_HAZARD));
        ModHandler.addShapelessRecipe("acid_hazard_to_steel_solid_casing", MetaBlocks.METAL_CASING.getItemVariant(BlockMetalCasing.MetalCasingType.STEEL_SOLID), MetaBlocks.WARNING_SIGN.getItemVariant(BlockWarningSign.SignType.ACID_HAZARD));
        ModHandler.addShapelessRecipe("magic_hazard_to_steel_solid_casing", MetaBlocks.METAL_CASING.getItemVariant(BlockMetalCasing.MetalCasingType.STEEL_SOLID), MetaBlocks.WARNING_SIGN.getItemVariant(BlockWarningSign.SignType.MAGIC_HAZARD));
        ModHandler.addShapelessRecipe("frost_hazard_to_steel_solid_casing", MetaBlocks.METAL_CASING.getItemVariant(BlockMetalCasing.MetalCasingType.STEEL_SOLID), MetaBlocks.WARNING_SIGN.getItemVariant(BlockWarningSign.SignType.FROST_HAZARD));
        ModHandler.addShapelessRecipe("noise_hazard_to_steel_solid_casing", MetaBlocks.METAL_CASING.getItemVariant(BlockMetalCasing.MetalCasingType.STEEL_SOLID), MetaBlocks.WARNING_SIGN.getItemVariant(BlockWarningSign.SignType.NOISE_HAZARD));
        if (ConfigHolder.harderMachineHulls) {
            ModHandler.addShapedRecipe("hull_ulv", MetaTileEntities.HULL[0].getStackForm(), "PHP", "CMC", Character.valueOf('M'), MetaBlocks.MACHINE_CASING.getItemVariant(BlockMachineCasing.MachineCasingType.ULV), Character.valueOf('C'), new UnificationEntry(OrePrefix.cableGtSingle, Materials.RedAlloy), Character.valueOf('H'), new UnificationEntry(OrePrefix.plate, Materials.WroughtIron), Character.valueOf('P'), new UnificationEntry(OrePrefix.plate, Materials.Wood));
            ModHandler.addShapedRecipe("hull_lv", MetaTileEntities.HULL[1].getStackForm(), "PHP", "CMC", Character.valueOf('M'), MetaBlocks.MACHINE_CASING.getItemVariant(BlockMachineCasing.MachineCasingType.LV), Character.valueOf('C'), new UnificationEntry(OrePrefix.cableGtSingle, Materials.Tin), Character.valueOf('H'), new UnificationEntry(OrePrefix.plate, Materials.Steel), Character.valueOf('P'), new UnificationEntry(OrePrefix.plate, Materials.WroughtIron));
            ModHandler.addShapedRecipe("hull_mv", MetaTileEntities.HULL[2].getStackForm(), "PHP", "CMC", Character.valueOf('M'), MetaBlocks.MACHINE_CASING.getItemVariant(BlockMachineCasing.MachineCasingType.MV), Character.valueOf('C'), new UnificationEntry(OrePrefix.cableGtSingle, Materials.Copper), Character.valueOf('H'), new UnificationEntry(OrePrefix.plate, Materials.Aluminium), Character.valueOf('P'), new UnificationEntry(OrePrefix.plate, Materials.WroughtIron));
            ModHandler.addShapedRecipe("hull_hv", MetaTileEntities.HULL[3].getStackForm(), "PHP", "CMC", Character.valueOf('M'), MetaBlocks.MACHINE_CASING.getItemVariant(BlockMachineCasing.MachineCasingType.HV), Character.valueOf('C'), new UnificationEntry(OrePrefix.cableGtSingle, Materials.Gold), Character.valueOf('H'), new UnificationEntry(OrePrefix.plate, Materials.StainlessSteel), Character.valueOf('P'), new UnificationEntry(OrePrefix.plate, Materials.Plastic));
            ModHandler.addShapedRecipe("hull_ev", MetaTileEntities.HULL[4].getStackForm(), "PHP", "CMC", Character.valueOf('M'), MetaBlocks.MACHINE_CASING.getItemVariant(BlockMachineCasing.MachineCasingType.EV), Character.valueOf('C'), new UnificationEntry(OrePrefix.cableGtSingle, Materials.Aluminium), Character.valueOf('H'), new UnificationEntry(OrePrefix.plate, Materials.Titanium), Character.valueOf('P'), new UnificationEntry(OrePrefix.plate, Materials.Plastic));
            ModHandler.addShapedRecipe("hull_iv", MetaTileEntities.HULL[5].getStackForm(), "PHP", "CMC", Character.valueOf('M'), MetaBlocks.MACHINE_CASING.getItemVariant(BlockMachineCasing.MachineCasingType.IV), Character.valueOf('C'), new UnificationEntry(OrePrefix.cableGtSingle, Materials.Tungsten), Character.valueOf('H'), new UnificationEntry(OrePrefix.plate, Materials.TungstenSteel), Character.valueOf('P'), new UnificationEntry(OrePrefix.plate, Materials.Plastic));
            ModHandler.addShapedRecipe("hull_luv", MetaTileEntities.HULL[6].getStackForm(), "PHP", "CMC", Character.valueOf('M'), MetaBlocks.MACHINE_CASING.getItemVariant(BlockMachineCasing.MachineCasingType.LuV), Character.valueOf('C'), new UnificationEntry(OrePrefix.cableGtSingle, Materials.VanadiumGallium), Character.valueOf('H'), new UnificationEntry(OrePrefix.plate, Materials.Chrome), Character.valueOf('P'), new UnificationEntry(OrePrefix.plate, Materials.Plastic));
            ModHandler.addShapedRecipe("hull_zpm", MetaTileEntities.HULL[7].getStackForm(), "PHP", "CMC", Character.valueOf('M'), MetaBlocks.MACHINE_CASING.getItemVariant(BlockMachineCasing.MachineCasingType.ZPM), Character.valueOf('C'), new UnificationEntry(OrePrefix.cableGtSingle, Materials.Naquadah), Character.valueOf('H'), new UnificationEntry(OrePrefix.plate, Materials.Iridium), Character.valueOf('P'), new UnificationEntry(OrePrefix.plate, Materials.Polytetrafluoroethylene));
            ModHandler.addShapedRecipe("hull_uv", MetaTileEntities.HULL[8].getStackForm(), "PHP", "CMC", Character.valueOf('M'), MetaBlocks.MACHINE_CASING.getItemVariant(BlockMachineCasing.MachineCasingType.UV), Character.valueOf('C'), new UnificationEntry(OrePrefix.wireGtQuadruple, Materials.NaquadahAlloy), Character.valueOf('H'), new UnificationEntry(OrePrefix.plate, Materials.Osmium), Character.valueOf('P'), new UnificationEntry(OrePrefix.plate, Materials.Polytetrafluoroethylene));
            ModHandler.addShapedRecipe("hull_max", MetaTileEntities.HULL[9].getStackForm(), "PHP", "CMC", Character.valueOf('M'), MetaBlocks.MACHINE_CASING.getItemVariant(BlockMachineCasing.MachineCasingType.MAX), Character.valueOf('C'), new UnificationEntry(OrePrefix.wireGtSingle, MarkerMaterials.Tier.Superconductor), Character.valueOf('H'), new UnificationEntry(OrePrefix.plate, Materials.Darmstadtium), Character.valueOf('P'), new UnificationEntry(OrePrefix.plate, Materials.Polytetrafluoroethylene));
        } else {
            ModHandler.addShapedRecipe("hull_ulv", MetaTileEntities.HULL[0].getStackForm(), "CMC", Character.valueOf('M'), MetaBlocks.MACHINE_CASING.getItemVariant(BlockMachineCasing.MachineCasingType.ULV), Character.valueOf('C'), new UnificationEntry(OrePrefix.cableGtSingle, Materials.RedAlloy));
            ModHandler.addShapedRecipe("hull_lv", MetaTileEntities.HULL[1].getStackForm(), "CMC", Character.valueOf('M'), MetaBlocks.MACHINE_CASING.getItemVariant(BlockMachineCasing.MachineCasingType.LV), Character.valueOf('C'), new UnificationEntry(OrePrefix.cableGtSingle, Materials.Tin));
            ModHandler.addShapedRecipe("hull_mv", MetaTileEntities.HULL[2].getStackForm(), "CMC", Character.valueOf('M'), MetaBlocks.MACHINE_CASING.getItemVariant(BlockMachineCasing.MachineCasingType.MV), Character.valueOf('C'), new UnificationEntry(OrePrefix.cableGtSingle, Materials.Copper));
            ModHandler.addShapedRecipe("hull_hv", MetaTileEntities.HULL[3].getStackForm(), "CMC", Character.valueOf('M'), MetaBlocks.MACHINE_CASING.getItemVariant(BlockMachineCasing.MachineCasingType.HV), Character.valueOf('C'), new UnificationEntry(OrePrefix.cableGtSingle, Materials.Gold));
            ModHandler.addShapedRecipe("hull_ev", MetaTileEntities.HULL[4].getStackForm(), "CMC", Character.valueOf('M'), MetaBlocks.MACHINE_CASING.getItemVariant(BlockMachineCasing.MachineCasingType.EV), Character.valueOf('C'), new UnificationEntry(OrePrefix.cableGtSingle, Materials.Aluminium));
            ModHandler.addShapedRecipe("hull_iv", MetaTileEntities.HULL[5].getStackForm(), "CMC", Character.valueOf('M'), MetaBlocks.MACHINE_CASING.getItemVariant(BlockMachineCasing.MachineCasingType.IV), Character.valueOf('C'), new UnificationEntry(OrePrefix.cableGtSingle, Materials.Tungsten));
            ModHandler.addShapedRecipe("hull_luv", MetaTileEntities.HULL[6].getStackForm(), "CMC", Character.valueOf('M'), MetaBlocks.MACHINE_CASING.getItemVariant(BlockMachineCasing.MachineCasingType.LuV), Character.valueOf('C'), new UnificationEntry(OrePrefix.cableGtSingle, Materials.VanadiumGallium));
            ModHandler.addShapedRecipe("hull_zpm", MetaTileEntities.HULL[7].getStackForm(), "CMC", Character.valueOf('M'), MetaBlocks.MACHINE_CASING.getItemVariant(BlockMachineCasing.MachineCasingType.ZPM), Character.valueOf('C'), new UnificationEntry(OrePrefix.cableGtSingle, Materials.Naquadah));
            ModHandler.addShapedRecipe("hull_uv", MetaTileEntities.HULL[8].getStackForm(), "CMC", Character.valueOf('M'), MetaBlocks.MACHINE_CASING.getItemVariant(BlockMachineCasing.MachineCasingType.UV), Character.valueOf('C'), new UnificationEntry(OrePrefix.wireGtQuadruple, Materials.NaquadahAlloy));
            ModHandler.addShapedRecipe("hull_max", MetaTileEntities.HULL[9].getStackForm(), "CMC", Character.valueOf('M'), MetaBlocks.MACHINE_CASING.getItemVariant(BlockMachineCasing.MachineCasingType.MAX), Character.valueOf('C'), new UnificationEntry(OrePrefix.wireGtSingle, MarkerMaterials.Tier.Superconductor));
        }
        ModHandler.addShapedRecipe("transformer_lv", MetaTileEntities.TRANSFORMER[0].getStackForm(), " BB", "CM ", " BB", Character.valueOf('M'), MetaTileEntities.HULL[0].getStackForm(), Character.valueOf('C'), new UnificationEntry(OrePrefix.cableGtSingle, Materials.Tin), Character.valueOf('B'), new UnificationEntry(OrePrefix.cableGtSingle, Materials.Lead));
        ModHandler.addShapedRecipe("transformer_mv", MetaTileEntities.TRANSFORMER[1].getStackForm(), " BB", "CM ", " BB", Character.valueOf('M'), MetaTileEntities.HULL[1].getStackForm(), Character.valueOf('C'), new UnificationEntry(OrePrefix.cableGtSingle, Materials.Copper), Character.valueOf('B'), new UnificationEntry(OrePrefix.cableGtSingle, Materials.Tin));
        ModHandler.addShapedRecipe("transformer_hv", MetaTileEntities.TRANSFORMER[2].getStackForm(), " BB", "CM ", " BB", Character.valueOf('M'), MetaTileEntities.HULL[2].getStackForm(), Character.valueOf('C'), new UnificationEntry(OrePrefix.cableGtSingle, Materials.Gold), Character.valueOf('B'), new UnificationEntry(OrePrefix.cableGtSingle, Materials.Copper));
        ModHandler.addShapedRecipe("transformer_ev", MetaTileEntities.TRANSFORMER[3].getStackForm(), "KBB", "CM ", "KBB", Character.valueOf('M'), MetaTileEntities.HULL[3].getStackForm(), Character.valueOf('C'), new UnificationEntry(OrePrefix.cableGtSingle, Materials.Aluminium), Character.valueOf('B'), new UnificationEntry(OrePrefix.cableGtSingle, Materials.Gold), Character.valueOf('K'), new UnificationEntry(OrePrefix.circuit, MarkerMaterials.Tier.Advanced));
        ModHandler.addShapedRecipe("transformer_iv", MetaTileEntities.TRANSFORMER[4].getStackForm(), "KBB", "CM ", "KBB", Character.valueOf('M'), MetaTileEntities.HULL[4].getStackForm(), Character.valueOf('C'), new UnificationEntry(OrePrefix.cableGtSingle, Materials.Tungsten), Character.valueOf('B'), new UnificationEntry(OrePrefix.cableGtSingle, Materials.Aluminium), Character.valueOf('K'), new UnificationEntry(OrePrefix.circuit, MarkerMaterials.Tier.Advanced));
        ModHandler.addShapedRecipe("transformer_luv", MetaTileEntities.TRANSFORMER[5].getStackForm(), "KBB", "CM ", "KBB", Character.valueOf('M'), MetaTileEntities.HULL[5].getStackForm(), Character.valueOf('C'), new UnificationEntry(OrePrefix.cableGtSingle, Materials.VanadiumGallium), Character.valueOf('B'), new UnificationEntry(OrePrefix.cableGtSingle, Materials.Tungsten), Character.valueOf('K'), new UnificationEntry(OrePrefix.circuit, MarkerMaterials.Tier.Extreme));
        ModHandler.addShapedRecipe("transformer_zpm", MetaTileEntities.TRANSFORMER[6].getStackForm(), "KBB", "CM ", "KBB", Character.valueOf('M'), MetaTileEntities.HULL[6].getStackForm(), Character.valueOf('C'), new UnificationEntry(OrePrefix.cableGtSingle, Materials.Naquadah), Character.valueOf('B'), new UnificationEntry(OrePrefix.cableGtSingle, Materials.VanadiumGallium), Character.valueOf('K'), new UnificationEntry(OrePrefix.circuit, MarkerMaterials.Tier.Extreme));
        ModHandler.addShapedRecipe("transformer_uv", MetaTileEntities.TRANSFORMER[7].getStackForm(), "KBB", "CM ", "KBB", Character.valueOf('M'), MetaTileEntities.HULL[7].getStackForm(), Character.valueOf('C'), new UnificationEntry(OrePrefix.wireGtQuadruple, Materials.NaquadahAlloy), Character.valueOf('B'), new UnificationEntry(OrePrefix.cableGtSingle, Materials.Naquadah), Character.valueOf('K'), new UnificationEntry(OrePrefix.circuit, MarkerMaterials.Tier.Elite));
        ModHandler.addShapedRecipe("transformer_max", MetaTileEntities.TRANSFORMER[8].getStackForm(), "KBB", "CM ", "KBB", Character.valueOf('M'), MetaTileEntities.HULL[8].getStackForm(), Character.valueOf('C'), new UnificationEntry(OrePrefix.wireGtSingle, MarkerMaterials.Tier.Superconductor), Character.valueOf('B'), new UnificationEntry(OrePrefix.wireGtQuadruple, Materials.NaquadahAlloy), Character.valueOf('K'), new UnificationEntry(OrePrefix.circuit, MarkerMaterials.Tier.Elite));
        ModHandler.addShapedRecipe("energy_output_hatch_ulv", MetaTileEntities.ENERGY_OUTPUT_HATCH[0].getStackForm(), " MC", Character.valueOf('M'), MetaTileEntities.HULL[0].getStackForm(), Character.valueOf('C'), new UnificationEntry(OrePrefix.cableGtSingle, Materials.Lead));
        ModHandler.addShapedRecipe("energy_output_hatch_lv", MetaTileEntities.ENERGY_OUTPUT_HATCH[1].getStackForm(), " MC", Character.valueOf('M'), MetaTileEntities.HULL[1].getStackForm(), Character.valueOf('C'), new UnificationEntry(OrePrefix.cableGtSingle, Materials.Tin));
        ModHandler.addShapedRecipe("energy_output_hatch_mv", MetaTileEntities.ENERGY_OUTPUT_HATCH[2].getStackForm(), " MC", Character.valueOf('M'), MetaTileEntities.HULL[2].getStackForm(), Character.valueOf('C'), new UnificationEntry(OrePrefix.cableGtSingle, Materials.Copper));
        ModHandler.addShapedRecipe("energy_output_hatch_hv", MetaTileEntities.ENERGY_OUTPUT_HATCH[3].getStackForm(), " MC", Character.valueOf('M'), MetaTileEntities.HULL[3].getStackForm(), Character.valueOf('C'), new UnificationEntry(OrePrefix.cableGtSingle, Materials.Gold));
        ModHandler.addShapedRecipe("energy_output_hatch_ev", MetaTileEntities.ENERGY_OUTPUT_HATCH[4].getStackForm(), " MC", Character.valueOf('M'), MetaTileEntities.HULL[4].getStackForm(), Character.valueOf('C'), new UnificationEntry(OrePrefix.cableGtSingle, Materials.Aluminium));
        ModHandler.addShapedRecipe("energy_output_hatch_iv", MetaTileEntities.ENERGY_OUTPUT_HATCH[5].getStackForm(), " MC", Character.valueOf('M'), MetaTileEntities.HULL[5].getStackForm(), Character.valueOf('C'), new UnificationEntry(OrePrefix.cableGtSingle, Materials.Tungsten));
        ModHandler.addShapedRecipe("energy_output_hatch_luv", MetaTileEntities.ENERGY_OUTPUT_HATCH[6].getStackForm(), " MC", Character.valueOf('M'), MetaTileEntities.HULL[6].getStackForm(), Character.valueOf('C'), new UnificationEntry(OrePrefix.cableGtSingle, Materials.VanadiumGallium));
        ModHandler.addShapedRecipe("energy_output_hatch_zpm", MetaTileEntities.ENERGY_OUTPUT_HATCH[7].getStackForm(), " MC", Character.valueOf('M'), MetaTileEntities.HULL[7].getStackForm(), Character.valueOf('C'), new UnificationEntry(OrePrefix.cableGtSingle, Materials.Naquadah));
        ModHandler.addShapedRecipe("energy_output_hatch_uv", MetaTileEntities.ENERGY_OUTPUT_HATCH[8].getStackForm(), " MC", Character.valueOf('M'), MetaTileEntities.HULL[8].getStackForm(), Character.valueOf('C'), new UnificationEntry(OrePrefix.wireGtQuadruple, Materials.NaquadahAlloy));
        ModHandler.addShapedRecipe("energy_output_hatch_max", MetaTileEntities.ENERGY_OUTPUT_HATCH[9].getStackForm(), " MC", Character.valueOf('M'), MetaTileEntities.HULL[9].getStackForm(), Character.valueOf('C'), new UnificationEntry(OrePrefix.wireGtSingle, MarkerMaterials.Tier.Superconductor));
        ModHandler.addShapedRecipe("energy_input_hatch_ulv", MetaTileEntities.ENERGY_INPUT_HATCH[0].getStackForm(), "CM ", Character.valueOf('M'), MetaTileEntities.HULL[0].getStackForm(), Character.valueOf('C'), new UnificationEntry(OrePrefix.cableGtSingle, Materials.Lead));
        ModHandler.addShapedRecipe("energy_input_hatch_lv", MetaTileEntities.ENERGY_INPUT_HATCH[1].getStackForm(), "CM ", Character.valueOf('M'), MetaTileEntities.HULL[1].getStackForm(), Character.valueOf('C'), new UnificationEntry(OrePrefix.cableGtSingle, Materials.Tin));
        ModHandler.addShapedRecipe("energy_input_hatch_mv", MetaTileEntities.ENERGY_INPUT_HATCH[2].getStackForm(), "CM ", Character.valueOf('M'), MetaTileEntities.HULL[2].getStackForm(), Character.valueOf('C'), new UnificationEntry(OrePrefix.cableGtSingle, Materials.Copper));
        ModHandler.addShapedRecipe("energy_input_hatch_hv", MetaTileEntities.ENERGY_INPUT_HATCH[3].getStackForm(), "CM ", Character.valueOf('M'), MetaTileEntities.HULL[3].getStackForm(), Character.valueOf('C'), new UnificationEntry(OrePrefix.cableGtSingle, Materials.Gold));
        ModHandler.addShapedRecipe("energy_input_hatch_ev", MetaTileEntities.ENERGY_INPUT_HATCH[4].getStackForm(), "CM ", Character.valueOf('M'), MetaTileEntities.HULL[4].getStackForm(), Character.valueOf('C'), new UnificationEntry(OrePrefix.cableGtSingle, Materials.Aluminium));
        ModHandler.addShapedRecipe("energy_input_hatch_iv", MetaTileEntities.ENERGY_INPUT_HATCH[5].getStackForm(), "CM ", Character.valueOf('M'), MetaTileEntities.HULL[5].getStackForm(), Character.valueOf('C'), new UnificationEntry(OrePrefix.cableGtSingle, Materials.Tungsten));
        ModHandler.addShapedRecipe("energy_input_hatch_luv", MetaTileEntities.ENERGY_INPUT_HATCH[6].getStackForm(), "CM ", Character.valueOf('M'), MetaTileEntities.HULL[6].getStackForm(), Character.valueOf('C'), new UnificationEntry(OrePrefix.cableGtSingle, Materials.VanadiumGallium));
        ModHandler.addShapedRecipe("energy_input_hatch_zpm", MetaTileEntities.ENERGY_INPUT_HATCH[7].getStackForm(), "CM ", Character.valueOf('M'), MetaTileEntities.HULL[7].getStackForm(), Character.valueOf('C'), new UnificationEntry(OrePrefix.cableGtSingle, Materials.Naquadah));
        ModHandler.addShapedRecipe("energy_input_hatch_uv", MetaTileEntities.ENERGY_INPUT_HATCH[8].getStackForm(), "CM ", Character.valueOf('M'), MetaTileEntities.HULL[8].getStackForm(), Character.valueOf('C'), new UnificationEntry(OrePrefix.wireGtQuadruple, Materials.NaquadahAlloy));
        ModHandler.addShapedRecipe("energy_input_hatch_max", MetaTileEntities.ENERGY_INPUT_HATCH[9].getStackForm(), "CM ", Character.valueOf('M'), MetaTileEntities.HULL[9].getStackForm(), Character.valueOf('C'), new UnificationEntry(OrePrefix.wireGtSingle, MarkerMaterials.Tier.Superconductor));
        ModHandler.addShapedRecipe("fluid_import_hatch_ulv", MetaTileEntities.FLUID_IMPORT_HATCH[0].getStackForm(), "G", "M", Character.valueOf('M'), MetaTileEntities.HULL[0].getStackForm(), Character.valueOf('G'), new ItemStack(Blocks.field_150359_w));
        ModHandler.addShapedRecipe("fluid_import_hatch_lv", MetaTileEntities.FLUID_IMPORT_HATCH[1].getStackForm(), "G", "M", Character.valueOf('M'), MetaTileEntities.HULL[1].getStackForm(), Character.valueOf('G'), new ItemStack(Blocks.field_150359_w));
        ModHandler.addShapedRecipe("fluid_import_hatch_mv", MetaTileEntities.FLUID_IMPORT_HATCH[2].getStackForm(), "G", "M", Character.valueOf('M'), MetaTileEntities.HULL[2].getStackForm(), Character.valueOf('G'), new ItemStack(Blocks.field_150359_w));
        ModHandler.addShapedRecipe("fluid_import_hatch_hv", MetaTileEntities.FLUID_IMPORT_HATCH[3].getStackForm(), "G", "M", Character.valueOf('M'), MetaTileEntities.HULL[3].getStackForm(), Character.valueOf('G'), new ItemStack(Blocks.field_150359_w));
        ModHandler.addShapedRecipe("fluid_import_hatch_ev", MetaTileEntities.FLUID_IMPORT_HATCH[4].getStackForm(), "G", "M", Character.valueOf('M'), MetaTileEntities.HULL[4].getStackForm(), Character.valueOf('G'), new ItemStack(Blocks.field_150359_w));
        ModHandler.addShapedRecipe("fluid_import_hatch_iv", MetaTileEntities.FLUID_IMPORT_HATCH[5].getStackForm(), "G", "M", Character.valueOf('M'), MetaTileEntities.HULL[5].getStackForm(), Character.valueOf('G'), new ItemStack(Blocks.field_150359_w));
        ModHandler.addShapedRecipe("fluid_import_hatch_luv", MetaTileEntities.FLUID_IMPORT_HATCH[6].getStackForm(), "G", "M", Character.valueOf('M'), MetaTileEntities.HULL[6].getStackForm(), Character.valueOf('G'), new ItemStack(Blocks.field_150359_w));
        ModHandler.addShapedRecipe("fluid_import_hatch_zpm", MetaTileEntities.FLUID_IMPORT_HATCH[7].getStackForm(), "G", "M", Character.valueOf('M'), MetaTileEntities.HULL[7].getStackForm(), Character.valueOf('G'), new ItemStack(Blocks.field_150359_w));
        ModHandler.addShapedRecipe("fluid_import_hatch_uv", MetaTileEntities.FLUID_IMPORT_HATCH[8].getStackForm(), "G", "M", Character.valueOf('M'), MetaTileEntities.HULL[8].getStackForm(), Character.valueOf('G'), new ItemStack(Blocks.field_150359_w));
        ModHandler.addShapedRecipe("fluid_import_hatch_max", MetaTileEntities.FLUID_IMPORT_HATCH[9].getStackForm(), "G", "M", Character.valueOf('M'), MetaTileEntities.HULL[9].getStackForm(), Character.valueOf('G'), new ItemStack(Blocks.field_150359_w));
        ModHandler.addShapedRecipe("fluid_export_hatch_ulv", MetaTileEntities.FLUID_EXPORT_HATCH[0].getStackForm(), "M", "G", Character.valueOf('M'), MetaTileEntities.HULL[0].getStackForm(), Character.valueOf('G'), new ItemStack(Blocks.field_150359_w, 1));
        ModHandler.addShapedRecipe("fluid_export_hatch_lv", MetaTileEntities.FLUID_EXPORT_HATCH[1].getStackForm(), "M", "G", Character.valueOf('M'), MetaTileEntities.HULL[1].getStackForm(), Character.valueOf('G'), new ItemStack(Blocks.field_150359_w, 1));
        ModHandler.addShapedRecipe("fluid_export_hatch_mv", MetaTileEntities.FLUID_EXPORT_HATCH[2].getStackForm(), "M", "G", Character.valueOf('M'), MetaTileEntities.HULL[2].getStackForm(), Character.valueOf('G'), new ItemStack(Blocks.field_150359_w, 1));
        ModHandler.addShapedRecipe("fluid_export_hatch_hv", MetaTileEntities.FLUID_EXPORT_HATCH[3].getStackForm(), "M", "G", Character.valueOf('M'), MetaTileEntities.HULL[3].getStackForm(), Character.valueOf('G'), new ItemStack(Blocks.field_150359_w, 1));
        ModHandler.addShapedRecipe("fluid_export_hatch_ev", MetaTileEntities.FLUID_EXPORT_HATCH[4].getStackForm(), "M", "G", Character.valueOf('M'), MetaTileEntities.HULL[4].getStackForm(), Character.valueOf('G'), new ItemStack(Blocks.field_150359_w, 1));
        ModHandler.addShapedRecipe("fluid_export_hatch_iv", MetaTileEntities.FLUID_EXPORT_HATCH[5].getStackForm(), "M", "G", Character.valueOf('M'), MetaTileEntities.HULL[5].getStackForm(), Character.valueOf('G'), new ItemStack(Blocks.field_150359_w, 1));
        ModHandler.addShapedRecipe("fluid_export_hatch_luv", MetaTileEntities.FLUID_EXPORT_HATCH[6].getStackForm(), "M", "G", Character.valueOf('M'), MetaTileEntities.HULL[6].getStackForm(), Character.valueOf('G'), new ItemStack(Blocks.field_150359_w));
        ModHandler.addShapedRecipe("fluid_export_hatch_zpm", MetaTileEntities.FLUID_EXPORT_HATCH[7].getStackForm(), "M", "G", Character.valueOf('M'), MetaTileEntities.HULL[7].getStackForm(), Character.valueOf('G'), new ItemStack(Blocks.field_150359_w));
        ModHandler.addShapedRecipe("fluid_export_hatch_uv", MetaTileEntities.FLUID_EXPORT_HATCH[8].getStackForm(), "M", "G", Character.valueOf('M'), MetaTileEntities.HULL[8].getStackForm(), Character.valueOf('G'), new ItemStack(Blocks.field_150359_w));
        ModHandler.addShapedRecipe("fluid_export_hatch_max", MetaTileEntities.FLUID_EXPORT_HATCH[9].getStackForm(), "M", "G", Character.valueOf('M'), MetaTileEntities.HULL[9].getStackForm(), Character.valueOf('G'), new ItemStack(Blocks.field_150359_w));
        ModHandler.addShapedRecipe("item_import_bus_ulv", MetaTileEntities.ITEM_IMPORT_BUS[0].getStackForm(), new Object[]{"C", "M", Character.valueOf('M'), MetaTileEntities.HULL[0].getStackForm(), Character.valueOf('C'), OreDictNames.chestWood});
        ModHandler.addShapedRecipe("item_import_bus_lv", MetaTileEntities.ITEM_IMPORT_BUS[1].getStackForm(), new Object[]{"C", "M", Character.valueOf('M'), MetaTileEntities.HULL[1].getStackForm(), Character.valueOf('C'), OreDictNames.chestWood});
        ModHandler.addShapedRecipe("item_import_bus_mv", MetaTileEntities.ITEM_IMPORT_BUS[2].getStackForm(), new Object[]{"C", "M", Character.valueOf('M'), MetaTileEntities.HULL[2].getStackForm(), Character.valueOf('C'), OreDictNames.chestWood});
        ModHandler.addShapedRecipe("item_import_bus_hv", MetaTileEntities.ITEM_IMPORT_BUS[3].getStackForm(), new Object[]{"C", "M", Character.valueOf('M'), MetaTileEntities.HULL[3].getStackForm(), Character.valueOf('C'), OreDictNames.chestWood});
        ModHandler.addShapedRecipe("item_import_bus_ev", MetaTileEntities.ITEM_IMPORT_BUS[4].getStackForm(), new Object[]{"C", "M", Character.valueOf('M'), MetaTileEntities.HULL[4].getStackForm(), Character.valueOf('C'), OreDictNames.chestWood});
        ModHandler.addShapedRecipe("item_import_bus_iv", MetaTileEntities.ITEM_IMPORT_BUS[5].getStackForm(), new Object[]{"C", "M", Character.valueOf('M'), MetaTileEntities.HULL[5].getStackForm(), Character.valueOf('C'), OreDictNames.chestWood});
        ModHandler.addShapedRecipe("item_import_bus_luv", MetaTileEntities.ITEM_IMPORT_BUS[6].getStackForm(), new Object[]{"C", "M", Character.valueOf('M'), MetaTileEntities.HULL[6].getStackForm(), Character.valueOf('C'), OreDictNames.chestWood});
        ModHandler.addShapedRecipe("item_import_bus_zpm", MetaTileEntities.ITEM_IMPORT_BUS[7].getStackForm(), new Object[]{"C", "M", Character.valueOf('M'), MetaTileEntities.HULL[7].getStackForm(), Character.valueOf('C'), OreDictNames.chestWood});
        ModHandler.addShapedRecipe("item_import_bus_uv", MetaTileEntities.ITEM_IMPORT_BUS[8].getStackForm(), new Object[]{"C", "M", Character.valueOf('M'), MetaTileEntities.HULL[8].getStackForm(), Character.valueOf('C'), OreDictNames.chestWood});
        ModHandler.addShapedRecipe("item_import_bus_max", MetaTileEntities.ITEM_IMPORT_BUS[9].getStackForm(), new Object[]{"C", "M", Character.valueOf('M'), MetaTileEntities.HULL[9].getStackForm(), Character.valueOf('C'), OreDictNames.chestWood});
        ModHandler.addShapedRecipe("item_export_bus_ulv", MetaTileEntities.ITEM_EXPORT_BUS[0].getStackForm(), new Object[]{"M", "C", Character.valueOf('M'), MetaTileEntities.HULL[0].getStackForm(), Character.valueOf('C'), OreDictNames.chestWood});
        ModHandler.addShapedRecipe("item_export_bus_lv", MetaTileEntities.ITEM_EXPORT_BUS[1].getStackForm(), new Object[]{"M", "C", Character.valueOf('M'), MetaTileEntities.HULL[1].getStackForm(), Character.valueOf('C'), OreDictNames.chestWood});
        ModHandler.addShapedRecipe("item_export_bus_mv", MetaTileEntities.ITEM_EXPORT_BUS[2].getStackForm(), new Object[]{"M", "C", Character.valueOf('M'), MetaTileEntities.HULL[2].getStackForm(), Character.valueOf('C'), OreDictNames.chestWood});
        ModHandler.addShapedRecipe("item_export_bus_hv", MetaTileEntities.ITEM_EXPORT_BUS[3].getStackForm(), new Object[]{"M", "C", Character.valueOf('M'), MetaTileEntities.HULL[3].getStackForm(), Character.valueOf('C'), OreDictNames.chestWood});
        ModHandler.addShapedRecipe("item_export_bus_ev", MetaTileEntities.ITEM_EXPORT_BUS[4].getStackForm(), new Object[]{"M", "C", Character.valueOf('M'), MetaTileEntities.HULL[4].getStackForm(), Character.valueOf('C'), OreDictNames.chestWood});
        ModHandler.addShapedRecipe("item_export_bus_iv", MetaTileEntities.ITEM_EXPORT_BUS[5].getStackForm(), new Object[]{"M", "C", Character.valueOf('M'), MetaTileEntities.HULL[5].getStackForm(), Character.valueOf('C'), OreDictNames.chestWood});
        ModHandler.addShapedRecipe("item_export_bus_luv", MetaTileEntities.ITEM_EXPORT_BUS[6].getStackForm(), new Object[]{"M", "C", Character.valueOf('M'), MetaTileEntities.HULL[6].getStackForm(), Character.valueOf('C'), OreDictNames.chestWood});
        ModHandler.addShapedRecipe("item_export_bus_zpm", MetaTileEntities.ITEM_EXPORT_BUS[7].getStackForm(), new Object[]{"M", "C", Character.valueOf('M'), MetaTileEntities.HULL[7].getStackForm(), Character.valueOf('C'), OreDictNames.chestWood});
        ModHandler.addShapedRecipe("item_export_bus_uv", MetaTileEntities.ITEM_EXPORT_BUS[8].getStackForm(), new Object[]{"M", "C", Character.valueOf('M'), MetaTileEntities.HULL[8].getStackForm(), Character.valueOf('C'), OreDictNames.chestWood});
        ModHandler.addShapedRecipe("item_export_bus_max", MetaTileEntities.ITEM_EXPORT_BUS[9].getStackForm(), new Object[]{"M", "C", Character.valueOf('M'), MetaTileEntities.HULL[9].getStackForm(), Character.valueOf('C'), OreDictNames.chestWood});
        ModHandler.addShapedRecipe("battery_buffer_ulv_1x1", MetaTileEntities.BATTERY_BUFFER[0][0].getStackForm(), new Object[]{"WTW", "WMW", Character.valueOf('M'), MetaTileEntities.HULL[0].getStackForm(), Character.valueOf('W'), new UnificationEntry(OrePrefix.wireGtSingle, Materials.Lead), Character.valueOf('T'), OreDictNames.chestWood});
        ModHandler.addShapedRecipe("battery_buffer_lv_1x1", MetaTileEntities.BATTERY_BUFFER[1][0].getStackForm(), new Object[]{"WTW", "WMW", Character.valueOf('M'), MetaTileEntities.HULL[1].getStackForm(), Character.valueOf('W'), new UnificationEntry(OrePrefix.wireGtSingle, Materials.Tin), Character.valueOf('T'), OreDictNames.chestWood});
        ModHandler.addShapedRecipe("battery_buffer_mv_1x1", MetaTileEntities.BATTERY_BUFFER[2][0].getStackForm(), new Object[]{"WTW", "WMW", Character.valueOf('M'), MetaTileEntities.HULL[2].getStackForm(), Character.valueOf('W'), new UnificationEntry(OrePrefix.wireGtSingle, Materials.Copper), Character.valueOf('T'), OreDictNames.chestWood});
        ModHandler.addShapedRecipe("battery_buffer_hv_1x1", MetaTileEntities.BATTERY_BUFFER[3][0].getStackForm(), new Object[]{"WTW", "WMW", Character.valueOf('M'), MetaTileEntities.HULL[3].getStackForm(), Character.valueOf('W'), new UnificationEntry(OrePrefix.wireGtSingle, Materials.Gold), Character.valueOf('T'), OreDictNames.chestWood});
        ModHandler.addShapedRecipe("battery_buffer_ev_1x1", MetaTileEntities.BATTERY_BUFFER[4][0].getStackForm(), new Object[]{"WTW", "WMW", Character.valueOf('M'), MetaTileEntities.HULL[4].getStackForm(), Character.valueOf('W'), new UnificationEntry(OrePrefix.wireGtSingle, Materials.Aluminium), Character.valueOf('T'), OreDictNames.chestWood});
        ModHandler.addShapedRecipe("battery_buffer_iv_1x1", MetaTileEntities.BATTERY_BUFFER[5][0].getStackForm(), new Object[]{"WTW", "WMW", Character.valueOf('M'), MetaTileEntities.HULL[5].getStackForm(), Character.valueOf('W'), new UnificationEntry(OrePrefix.wireGtSingle, Materials.Tungsten), Character.valueOf('T'), OreDictNames.chestWood});
        ModHandler.addShapedRecipe("battery_buffer_luv_1x1", MetaTileEntities.BATTERY_BUFFER[6][0].getStackForm(), new Object[]{"WTW", "WMW", Character.valueOf('M'), MetaTileEntities.HULL[6].getStackForm(), Character.valueOf('W'), new UnificationEntry(OrePrefix.wireGtSingle, Materials.VanadiumGallium), Character.valueOf('T'), OreDictNames.chestWood});
        ModHandler.addShapedRecipe("battery_buffer_zpm_1x1", MetaTileEntities.BATTERY_BUFFER[7][0].getStackForm(), new Object[]{"WTW", "WMW", Character.valueOf('M'), MetaTileEntities.HULL[7].getStackForm(), Character.valueOf('W'), new UnificationEntry(OrePrefix.wireGtSingle, Materials.Naquadah), Character.valueOf('T'), OreDictNames.chestWood});
        ModHandler.addShapedRecipe("battery_buffer_uv_1x1", MetaTileEntities.BATTERY_BUFFER[8][0].getStackForm(), new Object[]{"WTW", "WMW", Character.valueOf('M'), MetaTileEntities.HULL[8].getStackForm(), Character.valueOf('W'), new UnificationEntry(OrePrefix.wireGtSingle, Materials.NaquadahAlloy), Character.valueOf('T'), OreDictNames.chestWood});
        ModHandler.addShapedRecipe("battery_buffer_max_1x1", MetaTileEntities.BATTERY_BUFFER[9][0].getStackForm(), new Object[]{"WTW", "WMW", Character.valueOf('M'), MetaTileEntities.HULL[9].getStackForm(), Character.valueOf('W'), new UnificationEntry(OrePrefix.wireGtSingle, MarkerMaterials.Tier.Superconductor), Character.valueOf('T'), OreDictNames.chestWood});
        ModHandler.addShapedRecipe("battery_buffer_ulv_2x2", MetaTileEntities.BATTERY_BUFFER[0][1].getStackForm(), new Object[]{"WTW", "WMW", Character.valueOf('M'), MetaTileEntities.HULL[0].getStackForm(), Character.valueOf('W'), new UnificationEntry(OrePrefix.wireGtQuadruple, Materials.Lead), Character.valueOf('T'), OreDictNames.chestWood});
        ModHandler.addShapedRecipe("battery_buffer_lv_2x2", MetaTileEntities.BATTERY_BUFFER[1][1].getStackForm(), new Object[]{"WTW", "WMW", Character.valueOf('M'), MetaTileEntities.HULL[1].getStackForm(), Character.valueOf('W'), new UnificationEntry(OrePrefix.wireGtQuadruple, Materials.Tin), Character.valueOf('T'), OreDictNames.chestWood});
        ModHandler.addShapedRecipe("battery_buffer_mv_2x2", MetaTileEntities.BATTERY_BUFFER[2][1].getStackForm(), new Object[]{"WTW", "WMW", Character.valueOf('M'), MetaTileEntities.HULL[2].getStackForm(), Character.valueOf('W'), new UnificationEntry(OrePrefix.wireGtQuadruple, Materials.Copper), Character.valueOf('T'), OreDictNames.chestWood});
        ModHandler.addShapedRecipe("battery_buffer_hv_2x2", MetaTileEntities.BATTERY_BUFFER[3][1].getStackForm(), new Object[]{"WTW", "WMW", Character.valueOf('M'), MetaTileEntities.HULL[3].getStackForm(), Character.valueOf('W'), new UnificationEntry(OrePrefix.wireGtQuadruple, Materials.Gold), Character.valueOf('T'), OreDictNames.chestWood});
        ModHandler.addShapedRecipe("battery_buffer_ev_2x2", MetaTileEntities.BATTERY_BUFFER[4][1].getStackForm(), new Object[]{"WTW", "WMW", Character.valueOf('M'), MetaTileEntities.HULL[4].getStackForm(), Character.valueOf('W'), new UnificationEntry(OrePrefix.wireGtQuadruple, Materials.Aluminium), Character.valueOf('T'), OreDictNames.chestWood});
        ModHandler.addShapedRecipe("battery_buffer_iv_2x2", MetaTileEntities.BATTERY_BUFFER[5][1].getStackForm(), new Object[]{"WTW", "WMW", Character.valueOf('M'), MetaTileEntities.HULL[5].getStackForm(), Character.valueOf('W'), new UnificationEntry(OrePrefix.wireGtQuadruple, Materials.Tungsten), Character.valueOf('T'), OreDictNames.chestWood});
        ModHandler.addShapedRecipe("battery_buffer_luv_2x2", MetaTileEntities.BATTERY_BUFFER[6][1].getStackForm(), new Object[]{"WTW", "WMW", Character.valueOf('M'), MetaTileEntities.HULL[6].getStackForm(), Character.valueOf('W'), new UnificationEntry(OrePrefix.wireGtQuadruple, Materials.VanadiumGallium), Character.valueOf('T'), OreDictNames.chestWood});
        ModHandler.addShapedRecipe("battery_buffer_zpm_2x2", MetaTileEntities.BATTERY_BUFFER[7][1].getStackForm(), new Object[]{"WTW", "WMW", Character.valueOf('M'), MetaTileEntities.HULL[7].getStackForm(), Character.valueOf('W'), new UnificationEntry(OrePrefix.wireGtQuadruple, Materials.Naquadah), Character.valueOf('T'), OreDictNames.chestWood});
        ModHandler.addShapedRecipe("battery_buffer_uv_2x2", MetaTileEntities.BATTERY_BUFFER[8][1].getStackForm(), new Object[]{"WTW", "WMW", Character.valueOf('M'), MetaTileEntities.HULL[8].getStackForm(), Character.valueOf('W'), new UnificationEntry(OrePrefix.wireGtQuadruple, Materials.NaquadahAlloy), Character.valueOf('T'), OreDictNames.chestWood});
        ModHandler.addShapedRecipe("battery_buffer_max_2x2", MetaTileEntities.BATTERY_BUFFER[9][1].getStackForm(), new Object[]{"WTW", "WMW", Character.valueOf('M'), MetaTileEntities.HULL[9].getStackForm(), Character.valueOf('W'), new UnificationEntry(OrePrefix.wireGtQuadruple, MarkerMaterials.Tier.Superconductor), Character.valueOf('T'), OreDictNames.chestWood});
        ModHandler.addShapedRecipe("battery_buffer_ulv_3x3", MetaTileEntities.BATTERY_BUFFER[0][2].getStackForm(), new Object[]{"WTW", "WMW", Character.valueOf('M'), MetaTileEntities.HULL[0].getStackForm(), Character.valueOf('W'), new UnificationEntry(OrePrefix.wireGtOctal, Materials.Lead), Character.valueOf('T'), OreDictNames.chestWood});
        ModHandler.addShapedRecipe("battery_buffer_lv_3x3", MetaTileEntities.BATTERY_BUFFER[1][2].getStackForm(), new Object[]{"WTW", "WMW", Character.valueOf('M'), MetaTileEntities.HULL[1].getStackForm(), Character.valueOf('W'), new UnificationEntry(OrePrefix.wireGtOctal, Materials.Tin), Character.valueOf('T'), OreDictNames.chestWood});
        ModHandler.addShapedRecipe("battery_buffer_mv_3x3", MetaTileEntities.BATTERY_BUFFER[2][2].getStackForm(), new Object[]{"WTW", "WMW", Character.valueOf('M'), MetaTileEntities.HULL[2].getStackForm(), Character.valueOf('W'), new UnificationEntry(OrePrefix.wireGtOctal, Materials.Copper), Character.valueOf('T'), OreDictNames.chestWood});
        ModHandler.addShapedRecipe("battery_buffer_hv_3x3", MetaTileEntities.BATTERY_BUFFER[3][2].getStackForm(), new Object[]{"WTW", "WMW", Character.valueOf('M'), MetaTileEntities.HULL[3].getStackForm(), Character.valueOf('W'), new UnificationEntry(OrePrefix.wireGtOctal, Materials.Gold), Character.valueOf('T'), OreDictNames.chestWood});
        ModHandler.addShapedRecipe("battery_buffer_ev_3x3", MetaTileEntities.BATTERY_BUFFER[4][2].getStackForm(), new Object[]{"WTW", "WMW", Character.valueOf('M'), MetaTileEntities.HULL[4].getStackForm(), Character.valueOf('W'), new UnificationEntry(OrePrefix.wireGtOctal, Materials.Aluminium), Character.valueOf('T'), OreDictNames.chestWood});
        ModHandler.addShapedRecipe("battery_buffer_iv_3x3", MetaTileEntities.BATTERY_BUFFER[5][2].getStackForm(), new Object[]{"WTW", "WMW", Character.valueOf('M'), MetaTileEntities.HULL[5].getStackForm(), Character.valueOf('W'), new UnificationEntry(OrePrefix.wireGtOctal, Materials.Tungsten), Character.valueOf('T'), OreDictNames.chestWood});
        ModHandler.addShapedRecipe("battery_buffer_luv_3x3", MetaTileEntities.BATTERY_BUFFER[6][2].getStackForm(), new Object[]{"WTW", "WMW", Character.valueOf('M'), MetaTileEntities.HULL[6].getStackForm(), Character.valueOf('W'), new UnificationEntry(OrePrefix.wireGtOctal, Materials.VanadiumGallium), Character.valueOf('T'), OreDictNames.chestWood});
        ModHandler.addShapedRecipe("battery_buffer_zpm_3x3", MetaTileEntities.BATTERY_BUFFER[7][2].getStackForm(), new Object[]{"WTW", "WMW", Character.valueOf('M'), MetaTileEntities.HULL[7].getStackForm(), Character.valueOf('W'), new UnificationEntry(OrePrefix.wireGtOctal, Materials.Naquadah), Character.valueOf('T'), OreDictNames.chestWood});
        ModHandler.addShapedRecipe("battery_buffer_uv_3x3", MetaTileEntities.BATTERY_BUFFER[8][2].getStackForm(), new Object[]{"WTW", "WMW", Character.valueOf('M'), MetaTileEntities.HULL[8].getStackForm(), Character.valueOf('W'), new UnificationEntry(OrePrefix.wireGtOctal, Materials.NaquadahAlloy), Character.valueOf('T'), OreDictNames.chestWood});
        ModHandler.addShapedRecipe("battery_buffer_max_3x3", MetaTileEntities.BATTERY_BUFFER[9][2].getStackForm(), new Object[]{"WTW", "WMW", Character.valueOf('M'), MetaTileEntities.HULL[9].getStackForm(), Character.valueOf('W'), new UnificationEntry(OrePrefix.wireGtOctal, MarkerMaterials.Tier.Superconductor), Character.valueOf('T'), OreDictNames.chestWood});
        ModHandler.addShapedRecipe("battery_buffer_ulv_4x4", MetaTileEntities.BATTERY_BUFFER[0][3].getStackForm(), new Object[]{"WTW", "WMW", Character.valueOf('M'), MetaTileEntities.HULL[0].getStackForm(), Character.valueOf('W'), new UnificationEntry(OrePrefix.wireGtHex, Materials.Lead), Character.valueOf('T'), OreDictNames.chestWood});
        ModHandler.addShapedRecipe("battery_buffer_lv_4x4", MetaTileEntities.BATTERY_BUFFER[1][3].getStackForm(), new Object[]{"WTW", "WMW", Character.valueOf('M'), MetaTileEntities.HULL[1].getStackForm(), Character.valueOf('W'), new UnificationEntry(OrePrefix.wireGtHex, Materials.Tin), Character.valueOf('T'), OreDictNames.chestWood});
        ModHandler.addShapedRecipe("battery_buffer_mv_4x4", MetaTileEntities.BATTERY_BUFFER[2][3].getStackForm(), new Object[]{"WTW", "WMW", Character.valueOf('M'), MetaTileEntities.HULL[2].getStackForm(), Character.valueOf('W'), new UnificationEntry(OrePrefix.wireGtHex, Materials.Copper), Character.valueOf('T'), OreDictNames.chestWood});
        ModHandler.addShapedRecipe("battery_buffer_hv_4x4", MetaTileEntities.BATTERY_BUFFER[3][3].getStackForm(), new Object[]{"WTW", "WMW", Character.valueOf('M'), MetaTileEntities.HULL[3].getStackForm(), Character.valueOf('W'), new UnificationEntry(OrePrefix.wireGtHex, Materials.Gold), Character.valueOf('T'), OreDictNames.chestWood});
        ModHandler.addShapedRecipe("battery_buffer_ev_4x4", MetaTileEntities.BATTERY_BUFFER[4][3].getStackForm(), new Object[]{"WTW", "WMW", Character.valueOf('M'), MetaTileEntities.HULL[4].getStackForm(), Character.valueOf('W'), new UnificationEntry(OrePrefix.wireGtHex, Materials.Aluminium), Character.valueOf('T'), OreDictNames.chestWood});
        ModHandler.addShapedRecipe("battery_buffer_iv_4x4", MetaTileEntities.BATTERY_BUFFER[5][3].getStackForm(), new Object[]{"WTW", "WMW", Character.valueOf('M'), MetaTileEntities.HULL[5].getStackForm(), Character.valueOf('W'), new UnificationEntry(OrePrefix.wireGtHex, Materials.Tungsten), Character.valueOf('T'), OreDictNames.chestWood});
        ModHandler.addShapedRecipe("battery_buffer_luv_4x4", MetaTileEntities.BATTERY_BUFFER[6][3].getStackForm(), new Object[]{"WTW", "WMW", Character.valueOf('M'), MetaTileEntities.HULL[6].getStackForm(), Character.valueOf('W'), new UnificationEntry(OrePrefix.wireGtHex, Materials.VanadiumGallium), Character.valueOf('T'), OreDictNames.chestWood});
        ModHandler.addShapedRecipe("battery_buffer_zpm_4x4", MetaTileEntities.BATTERY_BUFFER[7][3].getStackForm(), new Object[]{"WTW", "WMW", Character.valueOf('M'), MetaTileEntities.HULL[7].getStackForm(), Character.valueOf('W'), new UnificationEntry(OrePrefix.wireGtHex, Materials.Naquadah), Character.valueOf('T'), OreDictNames.chestWood});
        ModHandler.addShapedRecipe("battery_buffer_uv_4x4", MetaTileEntities.BATTERY_BUFFER[8][3].getStackForm(), new Object[]{"WTW", "WMW", Character.valueOf('M'), MetaTileEntities.HULL[8].getStackForm(), Character.valueOf('W'), new UnificationEntry(OrePrefix.wireGtHex, Materials.NaquadahAlloy), Character.valueOf('T'), OreDictNames.chestWood});
        ModHandler.addShapedRecipe("battery_buffer_max_4x4", MetaTileEntities.BATTERY_BUFFER[9][3].getStackForm(), new Object[]{"WTW", "WMW", Character.valueOf('M'), MetaTileEntities.HULL[9].getStackForm(), Character.valueOf('W'), new UnificationEntry(OrePrefix.wireGtHex, MarkerMaterials.Tier.Superconductor), Character.valueOf('T'), OreDictNames.chestWood});
        ModHandler.addShapedRecipe("charger_ulv", MetaTileEntities.CHARGER[0].getStackForm(), new Object[]{"WTW", "WMW", "BCB", Character.valueOf('M'), MetaTileEntities.HULL[0].getStackForm(), Character.valueOf('W'), new UnificationEntry(OrePrefix.wireGtHex, Materials.Lead), Character.valueOf('T'), OreDictNames.chestWood, Character.valueOf('B'), MetaItems.BATTERY_RE_ULV_TANTALUM, Character.valueOf('C'), new UnificationEntry(OrePrefix.circuit, MarkerMaterials.Tier.Primitive)});
        ModHandler.addShapedRecipe("charger_lv", MetaTileEntities.CHARGER[1].getStackForm(), new Object[]{"WTW", "WMW", "BCB", Character.valueOf('M'), MetaTileEntities.HULL[1].getStackForm(), Character.valueOf('W'), new UnificationEntry(OrePrefix.wireGtHex, Materials.Tin), Character.valueOf('T'), OreDictNames.chestWood, Character.valueOf('B'), MetaItems.BATTERY_RE_LV_LITHIUM, Character.valueOf('C'), new UnificationEntry(OrePrefix.circuit, MarkerMaterials.Tier.Basic)});
        ModHandler.addShapedRecipe("charger_mv", MetaTileEntities.CHARGER[2].getStackForm(), new Object[]{"WTW", "WMW", "BCB", Character.valueOf('M'), MetaTileEntities.HULL[2].getStackForm(), Character.valueOf('W'), new UnificationEntry(OrePrefix.wireGtHex, Materials.Copper), Character.valueOf('T'), OreDictNames.chestWood, Character.valueOf('B'), MetaItems.BATTERY_RE_MV_LITHIUM, Character.valueOf('C'), new UnificationEntry(OrePrefix.circuit, MarkerMaterials.Tier.Good)});
        ModHandler.addShapedRecipe("charger_hv", MetaTileEntities.CHARGER[3].getStackForm(), new Object[]{"WTW", "WMW", "BCB", Character.valueOf('M'), MetaTileEntities.HULL[3].getStackForm(), Character.valueOf('W'), new UnificationEntry(OrePrefix.wireGtHex, Materials.Gold), Character.valueOf('T'), OreDictNames.chestWood, Character.valueOf('B'), MetaItems.BATTERY_RE_HV_LITHIUM, Character.valueOf('C'), new UnificationEntry(OrePrefix.circuit, MarkerMaterials.Tier.Advanced)});
        ModHandler.addShapedRecipe("charger_ev", MetaTileEntities.CHARGER[4].getStackForm(), new Object[]{"WTW", "WMW", "BCB", Character.valueOf('M'), MetaTileEntities.HULL[4].getStackForm(), Character.valueOf('W'), new UnificationEntry(OrePrefix.wireGtHex, Materials.Aluminium), Character.valueOf('T'), OreDictNames.chestWood, Character.valueOf('B'), new UnificationEntry(OrePrefix.battery, MarkerMaterials.Tier.Master), Character.valueOf('C'), new UnificationEntry(OrePrefix.circuit, MarkerMaterials.Tier.Extreme)});
        ModHandler.addShapedRecipe("charger_iv", MetaTileEntities.CHARGER[5].getStackForm(), new Object[]{"WTW", "WMW", "BCB", Character.valueOf('M'), MetaTileEntities.HULL[5].getStackForm(), Character.valueOf('W'), new UnificationEntry(OrePrefix.wireGtHex, Materials.Tungsten), Character.valueOf('T'), OreDictNames.chestWood, Character.valueOf('B'), MetaItems.ENERGY_LAPOTRONIC_ORB, Character.valueOf('C'), new UnificationEntry(OrePrefix.circuit, MarkerMaterials.Tier.Elite)});
        ModHandler.addShapedRecipe("charger_luv", MetaTileEntities.CHARGER[6].getStackForm(), new Object[]{"WTW", "WMW", "BCB", Character.valueOf('M'), MetaTileEntities.HULL[6].getStackForm(), Character.valueOf('W'), new UnificationEntry(OrePrefix.wireGtHex, Materials.VanadiumGallium), Character.valueOf('T'), OreDictNames.chestWood, Character.valueOf('B'), MetaItems.ENERGY_LAPOTRONIC_ORB2, Character.valueOf('C'), new UnificationEntry(OrePrefix.circuit, MarkerMaterials.Tier.Master)});
        ModHandler.addShapedRecipe("charger_zpm", MetaTileEntities.CHARGER[7].getStackForm(), new Object[]{"WTW", "WMW", "BCB", Character.valueOf('M'), MetaTileEntities.HULL[7].getStackForm(), Character.valueOf('W'), new UnificationEntry(OrePrefix.wireGtHex, Materials.Naquadah), Character.valueOf('T'), OreDictNames.chestWood, Character.valueOf('B'), MetaItems.ENERGY_LAPOTRONIC_ORB2, Character.valueOf('C'), new UnificationEntry(OrePrefix.circuit, MarkerMaterials.Tier.Ultimate)});
        ModHandler.addShapedRecipe("charger_uv", MetaTileEntities.CHARGER[8].getStackForm(), new Object[]{"WTW", "WMW", "BCB", Character.valueOf('M'), MetaTileEntities.HULL[8].getStackForm(), Character.valueOf('W'), new UnificationEntry(OrePrefix.wireGtHex, Materials.NaquadahAlloy), Character.valueOf('T'), OreDictNames.chestWood, Character.valueOf('B'), MetaItems.ZPM2, Character.valueOf('C'), new UnificationEntry(OrePrefix.circuit, MarkerMaterials.Tier.Superconductor)});
        ModHandler.addShapedRecipe("charger_max", MetaTileEntities.CHARGER[9].getStackForm(), new Object[]{"WTW", "WMW", "BCB", Character.valueOf('M'), MetaTileEntities.HULL[9].getStackForm(), Character.valueOf('W'), new UnificationEntry(OrePrefix.wireGtHex, MarkerMaterials.Tier.Superconductor), Character.valueOf('T'), OreDictNames.chestWood, Character.valueOf('B'), MetaItems.ZPM2, Character.valueOf('C'), new UnificationEntry(OrePrefix.circuit, MarkerMaterials.Tier.Infinite)});
        ModHandler.addShapedRecipe("rotor_holder_hv", MetaTileEntities.ROTOR_HOLDER[0].getStackForm(), "WHW", "WRW", "WWW", Character.valueOf('H'), MetaTileEntities.HULL[3].getStackForm(), Character.valueOf('W'), new UnificationEntry(OrePrefix.wireGtHex, Materials.Gold), Character.valueOf('R'), new UnificationEntry(OrePrefix.gear, Materials.StainlessSteel));
        ModHandler.addShapedRecipe("rotor_holder_luv", MetaTileEntities.ROTOR_HOLDER[1].getStackForm(), "WHW", "WRW", "WWW", Character.valueOf('H'), MetaTileEntities.HULL[6].getStackForm(), Character.valueOf('W'), new UnificationEntry(OrePrefix.wireGtHex, Materials.YttriumBariumCuprate), Character.valueOf('R'), new UnificationEntry(OrePrefix.gear, Materials.Chrome));
        ModHandler.addShapedRecipe("rotor_holder_max", MetaTileEntities.ROTOR_HOLDER[2].getStackForm(), "WHW", "WRW", "WWW", Character.valueOf('H'), MetaTileEntities.HULL[9].getStackForm(), Character.valueOf('W'), new UnificationEntry(OrePrefix.wireGtHex, MarkerMaterials.Tier.Superconductor), Character.valueOf('R'), new UnificationEntry(OrePrefix.gear, Materials.HSSS));
        ModHandler.addShapedRecipe("bronze_hull", MetaBlocks.MACHINE_CASING.getItemVariant(BlockMachineCasing.MachineCasingType.BRONZE_HULL), "PPP", "PhP", "PPP", Character.valueOf('P'), new UnificationEntry(OrePrefix.plate, Materials.Bronze));
        ModHandler.addShapedRecipe("bronze_bricks_hull", MetaBlocks.MACHINE_CASING.getItemVariant(BlockMachineCasing.MachineCasingType.BRONZE_BRICKS_HULL), "PPP", "PhP", "BBB", Character.valueOf('P'), new UnificationEntry(OrePrefix.plate, Materials.Bronze), Character.valueOf('B'), new ItemStack(Blocks.field_150336_V));
        ModHandler.addShapedRecipe("steel_hull", MetaBlocks.MACHINE_CASING.getItemVariant(BlockMachineCasing.MachineCasingType.STEEL_HULL), "PPP", "PhP", "PPP", Character.valueOf('P'), new UnificationEntry(OrePrefix.plate, Materials.Steel));
        ModHandler.addShapedRecipe("steel_bricks_hull", MetaBlocks.MACHINE_CASING.getItemVariant(BlockMachineCasing.MachineCasingType.STEEL_BRICKS_HULL), "PPP", "PhP", "BBB", Character.valueOf('P'), new UnificationEntry(OrePrefix.plate, Materials.Steel), Character.valueOf('B'), new ItemStack(Blocks.field_150336_V));
        ModHandler.addShapedRecipe("steam_boiler_coal_bronze", MetaTileEntities.STEAM_BOILER_COAL_BRONZE.getStackForm(), new Object[]{"PPP", "P P", "BFB", Character.valueOf('F'), OreDictNames.craftingFurnace, Character.valueOf('P'), new UnificationEntry(OrePrefix.plate, Materials.Bronze), Character.valueOf('B'), new ItemStack(Blocks.field_150336_V)});
        ModHandler.addShapedRecipe("steam_boiler_coal_steel", MetaTileEntities.STEAM_BOILER_COAL_STEEL.getStackForm(), new Object[]{"PPP", "P P", "BFB", Character.valueOf('F'), OreDictNames.craftingFurnace, Character.valueOf('P'), new UnificationEntry(OrePrefix.plate, Materials.Steel), Character.valueOf('B'), new ItemStack(Blocks.field_150336_V)});
        ModHandler.addShapedRecipe("steam_boiler_lava_bronze", MetaTileEntities.STEAM_BOILER_LAVA_BRONZE.getStackForm(), "PPP", "GGG", "PMP", Character.valueOf('M'), MetaBlocks.MACHINE_CASING.getItemVariant(BlockMachineCasing.MachineCasingType.BRONZE_BRICKS_HULL), Character.valueOf('P'), new UnificationEntry(OrePrefix.plate, Materials.Bronze), Character.valueOf('G'), new ItemStack(Blocks.field_150359_w, 1));
        ModHandler.addShapedRecipe("steam_boiler_lava_steel", MetaTileEntities.STEAM_BOILER_LAVA_STEEL.getStackForm(), "PPP", "GGG", "PMP", Character.valueOf('M'), MetaBlocks.MACHINE_CASING.getItemVariant(BlockMachineCasing.MachineCasingType.STEEL_BRICKS_HULL), Character.valueOf('P'), new UnificationEntry(OrePrefix.plate, Materials.Steel), Character.valueOf('G'), new ItemStack(Blocks.field_150359_w, 1));
        ModHandler.addShapedRecipe("steam_boiler_solar_bronze", MetaTileEntities.STEAM_BOILER_SOLAR_BRONZE.getStackForm(), "GGG", "SSS", "PMP", Character.valueOf('M'), MetaBlocks.MACHINE_CASING.getItemVariant(BlockMachineCasing.MachineCasingType.BRONZE_BRICKS_HULL), Character.valueOf('P'), new UnificationEntry(OrePrefix.pipeSmall, Materials.Bronze), Character.valueOf('S'), new UnificationEntry(OrePrefix.plate, Materials.Silver), Character.valueOf('G'), new ItemStack(Blocks.field_150359_w));
        ModHandler.addShapedRecipe("steam_furnace_bronze", MetaTileEntities.STEAM_FURNACE_BRONZE.getStackForm(), new Object[]{"XXX", "XMX", "XFX", Character.valueOf('M'), MetaBlocks.MACHINE_CASING.getItemVariant(BlockMachineCasing.MachineCasingType.BRONZE_BRICKS_HULL), Character.valueOf('X'), new UnificationEntry(OrePrefix.pipeSmall, Materials.Bronze), Character.valueOf('F'), OreDictNames.craftingFurnace});
        ModHandler.addShapedRecipe("steam_furnace_steel", MetaTileEntities.STEAM_FURNACE_STEEL.getStackForm(), new Object[]{"XXX", "XMX", "XFX", Character.valueOf('M'), MetaBlocks.MACHINE_CASING.getItemVariant(BlockMachineCasing.MachineCasingType.STEEL_BRICKS_HULL), Character.valueOf('X'), new UnificationEntry(OrePrefix.pipeSmall, Materials.Bronze), Character.valueOf('F'), OreDictNames.craftingFurnace});
        ModHandler.addShapedRecipe("steam_macerator_bronze", MetaTileEntities.STEAM_MACERATOR_BRONZE.getStackForm(), new Object[]{"DXD", "XMX", "PXP", Character.valueOf('M'), MetaBlocks.MACHINE_CASING.getItemVariant(BlockMachineCasing.MachineCasingType.BRONZE_HULL), Character.valueOf('X'), new UnificationEntry(OrePrefix.pipeSmall, Materials.Bronze), Character.valueOf('P'), OreDictNames.craftingPiston, Character.valueOf('D'), new UnificationEntry(OrePrefix.gem, Materials.Diamond)});
        ModHandler.addShapedRecipe("steam_macerator_steel", MetaTileEntities.STEAM_MACERATOR_STEEL.getStackForm(), new Object[]{"DXD", "XMX", "PXP", Character.valueOf('M'), MetaBlocks.MACHINE_CASING.getItemVariant(BlockMachineCasing.MachineCasingType.STEEL_HULL), Character.valueOf('X'), new UnificationEntry(OrePrefix.pipeSmall, Materials.Steel), Character.valueOf('P'), OreDictNames.craftingPiston, Character.valueOf('D'), new UnificationEntry(OrePrefix.gem, Materials.Diamond)});
        ModHandler.addShapedRecipe("steam_extractor_bronze", MetaTileEntities.STEAM_EXTRACTOR_BRONZE.getStackForm(), new Object[]{"XXX", "PMG", "XXX", Character.valueOf('M'), MetaBlocks.MACHINE_CASING.getItemVariant(BlockMachineCasing.MachineCasingType.BRONZE_HULL), Character.valueOf('X'), new UnificationEntry(OrePrefix.pipeSmall, Materials.Bronze), Character.valueOf('P'), OreDictNames.craftingPiston, Character.valueOf('G'), new ItemStack(Blocks.field_150359_w)});
        ModHandler.addShapedRecipe("steam_extractor_steel", MetaTileEntities.STEAM_EXTRACTOR_STEEL.getStackForm(), new Object[]{"XXX", "PMG", "XXX", Character.valueOf('M'), MetaBlocks.MACHINE_CASING.getItemVariant(BlockMachineCasing.MachineCasingType.STEEL_HULL), Character.valueOf('X'), new UnificationEntry(OrePrefix.pipeSmall, Materials.Steel), Character.valueOf('P'), OreDictNames.craftingPiston, Character.valueOf('G'), new ItemStack(Blocks.field_150359_w)});
        ModHandler.addShapedRecipe("steam_hammer_bronze", MetaTileEntities.STEAM_HAMMER_BRONZE.getStackForm(), new Object[]{"XPX", "XMX", "XAX", Character.valueOf('M'), MetaBlocks.MACHINE_CASING.getItemVariant(BlockMachineCasing.MachineCasingType.BRONZE_HULL), Character.valueOf('X'), new UnificationEntry(OrePrefix.pipeSmall, Materials.Bronze), Character.valueOf('P'), OreDictNames.craftingPiston, Character.valueOf('A'), OreDictNames.craftingAnvil});
        ModHandler.addShapedRecipe("steam_hammer_steel", MetaTileEntities.STEAM_HAMMER_STEEL.getStackForm(), new Object[]{"XPX", "XMX", "XAX", Character.valueOf('M'), MetaBlocks.MACHINE_CASING.getItemVariant(BlockMachineCasing.MachineCasingType.STEEL_HULL), Character.valueOf('X'), new UnificationEntry(OrePrefix.pipeSmall, Materials.Steel), Character.valueOf('P'), OreDictNames.craftingPiston, Character.valueOf('A'), OreDictNames.craftingAnvil});
        ModHandler.addShapedRecipe("steam_compressor_bronze", MetaTileEntities.STEAM_COMPRESSOR_BRONZE.getStackForm(), new Object[]{"XXX", "PMP", "XXX", Character.valueOf('M'), MetaBlocks.MACHINE_CASING.getItemVariant(BlockMachineCasing.MachineCasingType.BRONZE_HULL), Character.valueOf('X'), new UnificationEntry(OrePrefix.pipeSmall, Materials.Bronze), Character.valueOf('P'), OreDictNames.craftingPiston});
        ModHandler.addShapedRecipe("steam_compressor_steel", MetaTileEntities.STEAM_COMPRESSOR_STEEL.getStackForm(), new Object[]{"XXX", "PMP", "XXX", Character.valueOf('M'), MetaBlocks.MACHINE_CASING.getItemVariant(BlockMachineCasing.MachineCasingType.STEEL_HULL), Character.valueOf('X'), new UnificationEntry(OrePrefix.pipeSmall, Materials.Steel), Character.valueOf('P'), OreDictNames.craftingPiston});
        ModHandler.addShapedRecipe("steam_alloy_smelter_bronze", MetaTileEntities.STEAM_ALLOY_SMELTER_BRONZE.getStackForm(), new Object[]{"XXX", "FMF", "XXX", Character.valueOf('M'), MetaBlocks.MACHINE_CASING.getItemVariant(BlockMachineCasing.MachineCasingType.BRONZE_BRICKS_HULL), Character.valueOf('X'), new UnificationEntry(OrePrefix.pipeSmall, Materials.Bronze), Character.valueOf('F'), OreDictNames.craftingFurnace});
        ModHandler.addShapedRecipe("steam_alloy_smelter_steel", MetaTileEntities.STEAM_ALLOY_SMELTER_STEEL.getStackForm(), new Object[]{"XXX", "FMF", "XXX", Character.valueOf('M'), MetaBlocks.MACHINE_CASING.getItemVariant(BlockMachineCasing.MachineCasingType.STEEL_BRICKS_HULL), Character.valueOf('X'), new UnificationEntry(OrePrefix.pipeSmall, Materials.Steel), Character.valueOf('F'), OreDictNames.craftingFurnace});
        ModHandler.addShapedRecipe("bronze_primitive_blast_furnace", MetaTileEntities.PRIMITIVE_BLAST_FURNACE.getStackForm(), new Object[]{"PFP", "FwF", "PFP", Character.valueOf('P'), MetaBlocks.METAL_CASING.getItemVariant(BlockMetalCasing.MetalCasingType.PRIMITIVE_BRICKS), Character.valueOf('F'), OreDictNames.craftingFurnace});
        ModHandler.addShapedRecipe("coke_oven", MetaTileEntities.COKE_OVEN.getStackForm(), "PIP", "IwI", "PIP", Character.valueOf('P'), MetaBlocks.METAL_CASING.getItemVariant(BlockMetalCasing.MetalCasingType.COKE_BRICKS), Character.valueOf('I'), new UnificationEntry(OrePrefix.plate, Materials.Iron));
        ModHandler.addShapelessRecipe("coke_oven_hatch", MetaTileEntities.COKE_OVEN_HATCH.getStackForm(), MetaBlocks.METAL_CASING.getItemVariant(BlockMetalCasing.MetalCasingType.COKE_BRICKS), MetaTileEntities.BRONZE_TANK.getStackForm());
        ModHandler.addShapedRecipe("electric_blast_furnace", MetaTileEntities.ELECTRIC_BLAST_FURNACE.getStackForm(), new Object[]{"FFF", "CMC", "WCW", Character.valueOf('M'), MetaBlocks.METAL_CASING.getItemVariant(BlockMetalCasing.MetalCasingType.INVAR_HEATPROOF), Character.valueOf('F'), OreDictNames.craftingFurnace, Character.valueOf('C'), new UnificationEntry(OrePrefix.circuit, MarkerMaterials.Tier.Basic), Character.valueOf('W'), new UnificationEntry(OrePrefix.cableGtSingle, Materials.Tin)});
        ModHandler.addShapedRecipe("vacuum_freezer", MetaTileEntities.VACUUM_FREEZER.getStackForm(), "PPP", "CMC", "WCW", Character.valueOf('M'), MetaBlocks.METAL_CASING.getItemVariant(BlockMetalCasing.MetalCasingType.ALUMINIUM_FROSTPROOF), Character.valueOf('P'), MetaItems.ELECTRIC_PUMP_HV, Character.valueOf('C'), new UnificationEntry(OrePrefix.circuit, MarkerMaterials.Tier.Extreme), Character.valueOf('W'), new UnificationEntry(OrePrefix.cableGtSingle, Materials.Gold));
        ModHandler.addShapedRecipe("implosion_compressor", MetaTileEntities.IMPLOSION_COMPRESSOR.getStackForm(), "OOO", "CMC", "WCW", Character.valueOf('M'), MetaBlocks.METAL_CASING.getItemVariant(BlockMetalCasing.MetalCasingType.STEEL_SOLID), Character.valueOf('O'), new UnificationEntry(OrePrefix.stone, Materials.Obsidian), Character.valueOf('C'), new UnificationEntry(OrePrefix.circuit, MarkerMaterials.Tier.Advanced), Character.valueOf('W'), new UnificationEntry(OrePrefix.cableGtSingle, Materials.Aluminium));
        ModHandler.addShapedRecipe("distillation_tower", MetaTileEntities.DISTILLATION_TOWER.getStackForm(), "CBC", "FMF", "CBC", Character.valueOf('M'), MetaBlocks.MACHINE_CASING.getItemVariant(BlockMachineCasing.MachineCasingType.EV), Character.valueOf('B'), new UnificationEntry(OrePrefix.pipeLarge, Materials.StainlessSteel), Character.valueOf('C'), new UnificationEntry(OrePrefix.circuit, MarkerMaterials.Tier.Extreme), Character.valueOf('F'), MetaItems.ELECTRIC_PUMP_EV);
        ModHandler.addShapedRecipe("cracking_unit", MetaTileEntities.CRACKER.getStackForm(), "CEC", "PHP", "CEC", Character.valueOf('C'), MetaBlocks.WIRE_COIL.getItemVariant(BlockWireCoil.CoilType.CUPRONICKEL), Character.valueOf('E'), MetaItems.ELECTRIC_PUMP_HV, Character.valueOf('P'), new UnificationEntry(OrePrefix.circuit, MarkerMaterials.Tier.Extreme), Character.valueOf('H'), MetaTileEntities.HULL[3].getStackForm());
        ModHandler.addShapedRecipe("pyrolyse_oven", MetaTileEntities.PYROLYSE_OVEN.getStackForm(), "WEP", "EME", "WCP", Character.valueOf('M'), MetaTileEntities.HULL[2].getStackForm(), Character.valueOf('W'), MetaItems.ELECTRIC_PISTON_MV, Character.valueOf('P'), new UnificationEntry(OrePrefix.wireGtQuadruple, Materials.Cupronickel), Character.valueOf('E'), new UnificationEntry(OrePrefix.circuit, MarkerMaterials.Tier.Good), Character.valueOf('C'), MetaItems.ELECTRIC_PUMP_MV);
        ModHandler.addShapedRecipe("diesel_engine", MetaTileEntities.DIESEL_ENGINE.getStackForm(), "PCP", "EME", "GWG", Character.valueOf('M'), MetaTileEntities.HULL[4].getStackForm(), Character.valueOf('P'), MetaItems.ELECTRIC_PISTON_EV, Character.valueOf('E'), MetaItems.ELECTRIC_MOTOR_EV, Character.valueOf('C'), new UnificationEntry(OrePrefix.circuit, MarkerMaterials.Tier.Extreme), Character.valueOf('W'), new UnificationEntry(OrePrefix.wireGtSingle, Materials.TungstenSteel), Character.valueOf('G'), new UnificationEntry(OrePrefix.gear, Materials.Titanium));
        ModHandler.addShapedRecipe("engine_intake_casing", MetaBlocks.MUTLIBLOCK_CASING.getItemVariant(BlockMultiblockCasing.MultiblockCasingType.ENGINE_INTAKE_CASING), "PhP", "RFR", "PwP", Character.valueOf('R'), new UnificationEntry(OrePrefix.pipeMedium, Materials.Titanium), Character.valueOf('F'), MetaBlocks.METAL_CASING.getItemVariant(BlockMetalCasing.MetalCasingType.TITANIUM_STABLE), Character.valueOf('P'), new UnificationEntry(OrePrefix.rotor, Materials.Titanium));
        ModHandler.addShapedRecipe("multi_furnace", MetaTileEntities.MULTI_FURNACE.getStackForm(), "PPP", "ASA", "CAC", Character.valueOf('P'), Blocks.field_150460_al, Character.valueOf('A'), new UnificationEntry(OrePrefix.circuit, MarkerMaterials.Tier.Advanced), Character.valueOf('S'), MetaBlocks.METAL_CASING.getItemVariant(BlockMetalCasing.MetalCasingType.INVAR_HEATPROOF), Character.valueOf('C'), new UnificationEntry(OrePrefix.cableGtSingle, Materials.AnnealedCopper));
        ModHandler.addShapedRecipe("large_steam_turbine", MetaTileEntities.LARGE_STEAM_TURBINE.getStackForm(), "PSP", "SAS", "CSC", Character.valueOf('S'), new UnificationEntry(OrePrefix.gear, Materials.Steel), Character.valueOf('P'), new UnificationEntry(OrePrefix.circuit, MarkerMaterials.Tier.Advanced), Character.valueOf('A'), MetaTileEntities.HULL[3].getStackForm(), Character.valueOf('C'), new UnificationEntry(OrePrefix.pipeLarge, Materials.Steel));
        ModHandler.addShapedRecipe("large_gas_turbine", MetaTileEntities.LARGE_GAS_TURBINE.getStackForm(), "PSP", "SAS", "CSC", Character.valueOf('S'), new UnificationEntry(OrePrefix.gear, Materials.StainlessSteel), Character.valueOf('P'), new UnificationEntry(OrePrefix.circuit, MarkerMaterials.Tier.Extreme), Character.valueOf('A'), MetaTileEntities.HULL[4].getStackForm(), Character.valueOf('C'), new UnificationEntry(OrePrefix.pipeLarge, Materials.StainlessSteel));
        ModHandler.addShapedRecipe("large_plasma_turbine", MetaTileEntities.LARGE_PLASMA_TURBINE.getStackForm(), "PSP", "SAS", "CSC", Character.valueOf('S'), new UnificationEntry(OrePrefix.gear, Materials.TungstenSteel), Character.valueOf('P'), new UnificationEntry(OrePrefix.circuit, MarkerMaterials.Tier.Elite), Character.valueOf('A'), MetaTileEntities.HULL[8].getStackForm(), Character.valueOf('C'), new UnificationEntry(OrePrefix.pipeLarge, Materials.TungstenSteel));
        ModHandler.addShapedRecipe("large_bronze_boiler", MetaTileEntities.LARGE_BRONZE_BOILER.getStackForm(), "PSP", "SAS", "PSP", Character.valueOf('P'), new UnificationEntry(OrePrefix.cableGtSingle, Materials.Tin), Character.valueOf('S'), new UnificationEntry(OrePrefix.circuit, MarkerMaterials.Tier.Basic), Character.valueOf('A'), MetaBlocks.METAL_CASING.getItemVariant(BlockMetalCasing.MetalCasingType.BRONZE_BRICKS));
        ModHandler.addShapedRecipe("large_steel_boiler", MetaTileEntities.LARGE_STEEL_BOILER.getStackForm(), "PSP", "SAS", "PSP", Character.valueOf('P'), new UnificationEntry(OrePrefix.cableGtSingle, Materials.Copper), Character.valueOf('S'), new UnificationEntry(OrePrefix.circuit, MarkerMaterials.Tier.Advanced), Character.valueOf('A'), MetaBlocks.METAL_CASING.getItemVariant(BlockMetalCasing.MetalCasingType.STEEL_SOLID));
        ModHandler.addShapedRecipe("large_titanium_boiler", MetaTileEntities.LARGE_TITANIUM_BOILER.getStackForm(), "PSP", "SAS", "PSP", Character.valueOf('P'), new UnificationEntry(OrePrefix.cableGtSingle, Materials.Gold), Character.valueOf('S'), new UnificationEntry(OrePrefix.circuit, MarkerMaterials.Tier.Extreme), Character.valueOf('A'), MetaBlocks.METAL_CASING.getItemVariant(BlockMetalCasing.MetalCasingType.TITANIUM_STABLE));
        ModHandler.addShapedRecipe("large_tungstensteel_boiler", MetaTileEntities.LARGE_TUNGSTENSTEEL_BOILER.getStackForm(), "PSP", "SAS", "PSP", Character.valueOf('P'), new UnificationEntry(OrePrefix.cableGtSingle, Materials.Aluminium), Character.valueOf('S'), new UnificationEntry(OrePrefix.circuit, MarkerMaterials.Tier.Elite), Character.valueOf('A'), MetaBlocks.METAL_CASING.getItemVariant(BlockMetalCasing.MetalCasingType.TUNGSTENSTEEL_ROBUST));
        ModHandler.addShapedRecipe("diesel_generator_lv", MetaTileEntities.DIESEL_GENERATOR[0].getStackForm(), "PCP", "EME", "GWG", Character.valueOf('M'), MetaTileEntities.HULL[1].getStackForm(), Character.valueOf('P'), MetaItems.ELECTRIC_PISTON_LV, Character.valueOf('E'), MetaItems.ELECTRIC_MOTOR_LV, Character.valueOf('C'), new UnificationEntry(OrePrefix.circuit, MarkerMaterials.Tier.Basic), Character.valueOf('W'), new UnificationEntry(OrePrefix.cableGtSingle, Materials.Tin), Character.valueOf('G'), new UnificationEntry(OrePrefix.gear, Materials.Steel));
        ModHandler.addShapedRecipe("diesel_generator_mv", MetaTileEntities.DIESEL_GENERATOR[1].getStackForm(), "PCP", "EME", "GWG", Character.valueOf('M'), MetaTileEntities.HULL[2].getStackForm(), Character.valueOf('P'), MetaItems.ELECTRIC_PISTON_MV, Character.valueOf('E'), MetaItems.ELECTRIC_MOTOR_MV, Character.valueOf('C'), new UnificationEntry(OrePrefix.circuit, MarkerMaterials.Tier.Good), Character.valueOf('W'), new UnificationEntry(OrePrefix.cableGtSingle, Materials.Copper), Character.valueOf('G'), new UnificationEntry(OrePrefix.gear, Materials.Aluminium));
        ModHandler.addShapedRecipe("diesel_generator_hv", MetaTileEntities.DIESEL_GENERATOR[2].getStackForm(), "PCP", "EME", "GWG", Character.valueOf('M'), MetaTileEntities.HULL[3].getStackForm(), Character.valueOf('P'), MetaItems.ELECTRIC_PISTON_HV, Character.valueOf('E'), MetaItems.ELECTRIC_MOTOR_HV, Character.valueOf('C'), new UnificationEntry(OrePrefix.circuit, MarkerMaterials.Tier.Advanced), Character.valueOf('W'), new UnificationEntry(OrePrefix.cableGtSingle, Materials.Gold), Character.valueOf('G'), new UnificationEntry(OrePrefix.gear, Materials.StainlessSteel));
        ModHandler.addShapedRecipe("gas_turbine_lv", MetaTileEntities.GAS_TURBINE[0].getStackForm(), "CRC", "RMR", "EWE", Character.valueOf('M'), MetaTileEntities.HULL[1].getStackForm(), Character.valueOf('E'), MetaItems.ELECTRIC_MOTOR_LV, Character.valueOf('R'), new UnificationEntry(OrePrefix.rotor, Materials.Tin), Character.valueOf('C'), new UnificationEntry(OrePrefix.circuit, MarkerMaterials.Tier.Basic), Character.valueOf('W'), new UnificationEntry(OrePrefix.cableGtSingle, Materials.Tin));
        ModHandler.addShapedRecipe("gas_turbine_mv", MetaTileEntities.GAS_TURBINE[1].getStackForm(), "CRC", "RMR", "EWE", Character.valueOf('M'), MetaTileEntities.HULL[2].getStackForm(), Character.valueOf('E'), MetaItems.ELECTRIC_MOTOR_MV, Character.valueOf('R'), new UnificationEntry(OrePrefix.rotor, Materials.Bronze), Character.valueOf('C'), new UnificationEntry(OrePrefix.circuit, MarkerMaterials.Tier.Good), Character.valueOf('W'), new UnificationEntry(OrePrefix.cableGtSingle, Materials.Copper));
        ModHandler.addShapedRecipe("gas_turbine_hv", MetaTileEntities.GAS_TURBINE[2].getStackForm(), "CRC", "RMR", "EWE", Character.valueOf('M'), MetaTileEntities.HULL[3].getStackForm(), Character.valueOf('E'), MetaItems.ELECTRIC_MOTOR_HV, Character.valueOf('R'), new UnificationEntry(OrePrefix.rotor, Materials.Steel), Character.valueOf('C'), new UnificationEntry(OrePrefix.circuit, MarkerMaterials.Tier.Advanced), Character.valueOf('W'), new UnificationEntry(OrePrefix.cableGtSingle, Materials.Gold));
        ModHandler.addShapedRecipe("steam_turbine_lv", MetaTileEntities.STEAM_TURBINE[0].getStackForm(), "PCP", "RMR", "EWE", Character.valueOf('M'), MetaTileEntities.HULL[1].getStackForm(), Character.valueOf('E'), MetaItems.ELECTRIC_MOTOR_LV, Character.valueOf('R'), new UnificationEntry(OrePrefix.rotor, Materials.Tin), Character.valueOf('C'), new UnificationEntry(OrePrefix.circuit, MarkerMaterials.Tier.Basic), Character.valueOf('W'), new UnificationEntry(OrePrefix.cableGtSingle, Materials.Tin), Character.valueOf('P'), new UnificationEntry(OrePrefix.pipeSmall, Materials.Bronze));
        ModHandler.addShapedRecipe("steam_turbine_mv", MetaTileEntities.STEAM_TURBINE[1].getStackForm(), "PCP", "RMR", "EWE", Character.valueOf('M'), MetaTileEntities.HULL[2].getStackForm(), Character.valueOf('E'), MetaItems.ELECTRIC_MOTOR_MV, Character.valueOf('R'), new UnificationEntry(OrePrefix.rotor, Materials.Bronze), Character.valueOf('C'), new UnificationEntry(OrePrefix.circuit, MarkerMaterials.Tier.Good), Character.valueOf('W'), new UnificationEntry(OrePrefix.cableGtSingle, Materials.Copper), Character.valueOf('P'), new UnificationEntry(OrePrefix.pipeSmall, Materials.Steel));
        ModHandler.addShapedRecipe("steam_turbine_hv", MetaTileEntities.STEAM_TURBINE[2].getStackForm(), "PCP", "RMR", "EWE", Character.valueOf('M'), MetaTileEntities.HULL[3].getStackForm(), Character.valueOf('E'), MetaItems.ELECTRIC_MOTOR_HV, Character.valueOf('R'), new UnificationEntry(OrePrefix.rotor, Materials.Steel), Character.valueOf('C'), new UnificationEntry(OrePrefix.circuit, MarkerMaterials.Tier.Advanced), Character.valueOf('W'), new UnificationEntry(OrePrefix.cableGtSingle, Materials.Gold), Character.valueOf('P'), new UnificationEntry(OrePrefix.pipeSmall, Materials.StainlessSteel));
        ModHandler.addShapedRecipe("magic_energy_absorber", MetaTileEntities.MAGIC_ENERGY_ABSORBER.getStackForm(), "PCP", "PMP", "PCP", Character.valueOf('M'), MetaTileEntities.HULL[4].getStackForm(), Character.valueOf('P'), MetaItems.SENSOR_EV, Character.valueOf('C'), new UnificationEntry(OrePrefix.circuit, MarkerMaterials.Tier.Extreme));
        MetaTileEntityLoader.registerMachineRecipe((MetaTileEntity[])MetaTileEntities.ALLOY_SMELTER, (Object[])new Object[]{"ECE", "CMC", "WCW", Character.valueOf('M'), CraftingComponent.HULL, Character.valueOf('E'), CraftingComponent.CIRCUIT, Character.valueOf('W'), CraftingComponent.CABLE, Character.valueOf('C'), CraftingComponent.COIL_HEATING_DOUBLE});
        MetaTileEntityLoader.registerMachineRecipe((MetaTileEntity[])MetaTileEntities.ASSEMBLER, (Object[])new Object[]{"ACA", "VMV", "WCW", Character.valueOf('M'), CraftingComponent.HULL, Character.valueOf('V'), CraftingComponent.CONVEYOR, Character.valueOf('A'), CraftingComponent.ROBOT_ARM, Character.valueOf('C'), CraftingComponent.CIRCUIT, Character.valueOf('W'), CraftingComponent.CABLE});
        MetaTileEntityLoader.registerMachineRecipe((MetaTileEntity[])MetaTileEntities.BENDER, (Object[])new Object[]{"PwP", "CMC", "EWE", Character.valueOf('M'), CraftingComponent.HULL, Character.valueOf('E'), CraftingComponent.MOTOR, Character.valueOf('P'), CraftingComponent.PISTON, Character.valueOf('C'), CraftingComponent.CIRCUIT, Character.valueOf('W'), CraftingComponent.CABLE});
        MetaTileEntityLoader.registerMachineRecipe((MetaTileEntity[])MetaTileEntities.CANNER, (Object[])new Object[]{"WPW", "CMC", "GGG", Character.valueOf('M'), CraftingComponent.HULL, Character.valueOf('P'), CraftingComponent.PUMP, Character.valueOf('C'), CraftingComponent.CIRCUIT, Character.valueOf('W'), CraftingComponent.CABLE, Character.valueOf('G'), CraftingComponent.GLASS});
        MetaTileEntityLoader.registerMachineRecipe((MetaTileEntity[])MetaTileEntities.COMPRESSOR, (Object[])new Object[]{" C ", "PMP", "WCW", Character.valueOf('M'), CraftingComponent.HULL, Character.valueOf('P'), CraftingComponent.PISTON, Character.valueOf('C'), CraftingComponent.CIRCUIT, Character.valueOf('W'), CraftingComponent.CABLE});
        MetaTileEntityLoader.registerMachineRecipe((MetaTileEntity[])MetaTileEntities.CUTTER, (Object[])new Object[]{"WCG", "VMB", "CWE", Character.valueOf('M'), CraftingComponent.HULL, Character.valueOf('E'), CraftingComponent.MOTOR, Character.valueOf('V'), CraftingComponent.CONVEYOR, Character.valueOf('C'), CraftingComponent.CIRCUIT, Character.valueOf('W'), CraftingComponent.CABLE, Character.valueOf('G'), CraftingComponent.GLASS, Character.valueOf('B'), OreDictNames.craftingDiamondBlade});
        MetaTileEntityLoader.registerMachineRecipe((MetaTileEntity[])MetaTileEntities.ELECTRIC_FURNACE, (Object[])new Object[]{"ECE", "CMC", "WCW", Character.valueOf('M'), CraftingComponent.HULL, Character.valueOf('E'), CraftingComponent.CIRCUIT, Character.valueOf('W'), CraftingComponent.CABLE, Character.valueOf('C'), CraftingComponent.COIL_HEATING});
        MetaTileEntityLoader.registerMachineRecipe((MetaTileEntity[])MetaTileEntities.EXTRACTOR, (Object[])new Object[]{"GCG", "EMP", "WCW", Character.valueOf('M'), CraftingComponent.HULL, Character.valueOf('E'), CraftingComponent.PISTON, Character.valueOf('P'), CraftingComponent.PUMP, Character.valueOf('C'), CraftingComponent.CIRCUIT, Character.valueOf('W'), CraftingComponent.CABLE, Character.valueOf('G'), CraftingComponent.GLASS});
        MetaTileEntityLoader.registerMachineRecipe((MetaTileEntity[])MetaTileEntities.EXTRUDER, (Object[])new Object[]{"CCE", "XMP", "CCE", Character.valueOf('M'), CraftingComponent.HULL, Character.valueOf('X'), CraftingComponent.PISTON, Character.valueOf('E'), CraftingComponent.CIRCUIT, Character.valueOf('P'), CraftingComponent.PIPE, Character.valueOf('C'), CraftingComponent.COIL_HEATING_DOUBLE});
        MetaTileEntityLoader.registerMachineRecipe((MetaTileEntity[])MetaTileEntities.LATHE, (Object[])new Object[]{"WCW", "EMD", "CWP", Character.valueOf('M'), CraftingComponent.HULL, Character.valueOf('E'), CraftingComponent.MOTOR, Character.valueOf('P'), CraftingComponent.PISTON, Character.valueOf('C'), CraftingComponent.CIRCUIT, Character.valueOf('W'), CraftingComponent.CABLE, Character.valueOf('D'), CraftingComponent.DIAMOND});
        MetaTileEntityLoader.registerMachineRecipe((MetaTileEntity[])MetaTileEntities.MACERATOR, (Object[])new Object[]{"PEG", "WWM", "CCW", Character.valueOf('M'), CraftingComponent.HULL, Character.valueOf('E'), CraftingComponent.MOTOR, Character.valueOf('P'), CraftingComponent.PISTON, Character.valueOf('C'), CraftingComponent.CIRCUIT, Character.valueOf('W'), CraftingComponent.CABLE, Character.valueOf('G'), CraftingComponent.GRINDER});
        MetaTileEntityLoader.registerMachineRecipe((MetaTileEntity[])MetaTileEntities.MICROWAVE, (Object[])new Object[]{"LWC", "LMR", "LEC", Character.valueOf('M'), CraftingComponent.HULL, Character.valueOf('E'), CraftingComponent.MOTOR, Character.valueOf('R'), CraftingComponent.EMITTER, Character.valueOf('C'), CraftingComponent.CIRCUIT, Character.valueOf('W'), CraftingComponent.CABLE, Character.valueOf('L'), new UnificationEntry(OrePrefix.plate, Materials.Lead)});
        MetaTileEntityLoader.registerMachineRecipe((MetaTileEntity[])MetaTileEntities.WIREMILL, (Object[])new Object[]{"EWE", "CMC", "EWE", Character.valueOf('M'), CraftingComponent.HULL, Character.valueOf('E'), CraftingComponent.MOTOR, Character.valueOf('C'), CraftingComponent.CIRCUIT, Character.valueOf('W'), CraftingComponent.CABLE});
        MetaTileEntityLoader.registerMachineRecipe((MetaTileEntity[])MetaTileEntities.CENTRIFUGE, (Object[])new Object[]{"CEC", "WMW", "CEC", Character.valueOf('M'), CraftingComponent.HULL, Character.valueOf('E'), CraftingComponent.MOTOR, Character.valueOf('C'), CraftingComponent.CIRCUIT, Character.valueOf('W'), CraftingComponent.CABLE});
        MetaTileEntityLoader.registerMachineRecipe((MetaTileEntity[])MetaTileEntities.ELECTROLYZER, (Object[])new Object[]{"IGI", "IMI", "CWC", Character.valueOf('M'), CraftingComponent.HULL, Character.valueOf('C'), CraftingComponent.CIRCUIT, Character.valueOf('W'), CraftingComponent.CABLE, Character.valueOf('I'), CraftingComponent.WIRE, Character.valueOf('G'), CraftingComponent.GLASS});
        MetaTileEntityLoader.registerMachineRecipe((MetaTileEntity[])MetaTileEntities.THERMAL_CENTRIFUGE, (Object[])new Object[]{"CEC", "OMO", "WEW", Character.valueOf('M'), CraftingComponent.HULL, Character.valueOf('E'), CraftingComponent.MOTOR, Character.valueOf('C'), CraftingComponent.CIRCUIT, Character.valueOf('W'), CraftingComponent.CABLE, Character.valueOf('O'), CraftingComponent.COIL_HEATING_DOUBLE});
        MetaTileEntityLoader.registerMachineRecipe((MetaTileEntity[])MetaTileEntities.ORE_WASHER, (Object[])new Object[]{"RGR", "CEC", "WMW", Character.valueOf('M'), CraftingComponent.HULL, Character.valueOf('R'), CraftingComponent.ROTOR, Character.valueOf('E'), CraftingComponent.MOTOR, Character.valueOf('C'), CraftingComponent.CIRCUIT, Character.valueOf('W'), CraftingComponent.CABLE, Character.valueOf('G'), CraftingComponent.GLASS});
        MetaTileEntityLoader.registerMachineRecipe((MetaTileEntity[])MetaTileEntities.PACKER, (Object[])new Object[]{"BCB", "RMV", "WCW", Character.valueOf('M'), CraftingComponent.HULL, Character.valueOf('R'), CraftingComponent.ROBOT_ARM, Character.valueOf('V'), CraftingComponent.CONVEYOR, Character.valueOf('C'), CraftingComponent.CIRCUIT, Character.valueOf('W'), CraftingComponent.CABLE, Character.valueOf('B'), OreDictNames.chestWood});
        MetaTileEntityLoader.registerMachineRecipe((MetaTileEntity[])MetaTileEntities.UNPACKER, (Object[])new Object[]{"BCB", "VMR", "WCW", Character.valueOf('M'), CraftingComponent.HULL, Character.valueOf('R'), CraftingComponent.ROBOT_ARM, Character.valueOf('V'), CraftingComponent.CONVEYOR, Character.valueOf('C'), CraftingComponent.CIRCUIT, Character.valueOf('W'), CraftingComponent.CABLE, Character.valueOf('B'), OreDictNames.chestWood});
        MetaTileEntityLoader.registerMachineRecipe((MetaTileEntity[])MetaTileEntities.CHEMICAL_REACTOR, (Object[])new Object[]{"GRG", "WEW", "CMC", Character.valueOf('M'), CraftingComponent.HULL, Character.valueOf('R'), CraftingComponent.ROTOR, Character.valueOf('E'), CraftingComponent.MOTOR, Character.valueOf('C'), CraftingComponent.CIRCUIT, Character.valueOf('W'), CraftingComponent.CABLE, Character.valueOf('G'), CraftingComponent.GLASS});
        MetaTileEntityLoader.registerMachineRecipe((MetaTileEntity[])MetaTileEntities.FLUID_CANNER, (Object[])new Object[]{"GCG", "GMG", "WPW", Character.valueOf('M'), CraftingComponent.HULL, Character.valueOf('P'), CraftingComponent.PUMP, Character.valueOf('C'), CraftingComponent.CIRCUIT, Character.valueOf('W'), CraftingComponent.CABLE, Character.valueOf('G'), CraftingComponent.GLASS});
        MetaTileEntityLoader.registerMachineRecipe((MetaTileEntity[])MetaTileEntities.BREWERY, (Object[])new Object[]{"GPG", "WMW", "CBC", Character.valueOf('M'), CraftingComponent.HULL, Character.valueOf('P'), CraftingComponent.PUMP, Character.valueOf('B'), CraftingComponent.STICK_DISTILLATION, Character.valueOf('C'), CraftingComponent.CIRCUIT, Character.valueOf('W'), CraftingComponent.CABLE, Character.valueOf('G'), new ItemStack(Blocks.field_150359_w)});
        MetaTileEntityLoader.registerMachineRecipe((MetaTileEntity[])MetaTileEntities.FERMENTER, (Object[])new Object[]{"WPW", "GMG", "WCW", Character.valueOf('M'), CraftingComponent.HULL, Character.valueOf('P'), CraftingComponent.PUMP, Character.valueOf('C'), CraftingComponent.CIRCUIT, Character.valueOf('W'), CraftingComponent.CABLE, Character.valueOf('G'), CraftingComponent.GLASS});
        MetaTileEntityLoader.registerMachineRecipe((MetaTileEntity[])MetaTileEntities.FLUID_EXTRACTOR, (Object[])new Object[]{"GCG", "PME", "WCW", Character.valueOf('M'), CraftingComponent.HULL, Character.valueOf('E'), CraftingComponent.PISTON, Character.valueOf('P'), CraftingComponent.PUMP, Character.valueOf('C'), CraftingComponent.CIRCUIT, Character.valueOf('W'), CraftingComponent.CABLE, Character.valueOf('G'), CraftingComponent.GLASS});
        MetaTileEntityLoader.registerMachineRecipe((MetaTileEntity[])MetaTileEntities.FLUID_SOLIDIFIER, (Object[])new Object[]{"PGP", "WMW", "CBC", Character.valueOf('M'), CraftingComponent.HULL, Character.valueOf('P'), CraftingComponent.PUMP, Character.valueOf('C'), CraftingComponent.CIRCUIT, Character.valueOf('W'), CraftingComponent.CABLE, Character.valueOf('G'), CraftingComponent.GLASS, Character.valueOf('B'), OreDictNames.chestWood});
        MetaTileEntityLoader.registerMachineRecipe((MetaTileEntity[])MetaTileEntities.DISTILLERY, (Object[])new Object[]{"GBG", "CMC", "WPW", Character.valueOf('M'), CraftingComponent.HULL, Character.valueOf('P'), CraftingComponent.PUMP, Character.valueOf('B'), CraftingComponent.STICK_DISTILLATION, Character.valueOf('C'), CraftingComponent.CIRCUIT, Character.valueOf('W'), CraftingComponent.CABLE, Character.valueOf('G'), CraftingComponent.GLASS});
        MetaTileEntityLoader.registerMachineRecipe((MetaTileEntity[])MetaTileEntities.CHEMICAL_BATH, (Object[])new Object[]{"VGW", "PGV", "CMC", Character.valueOf('M'), CraftingComponent.HULL, Character.valueOf('P'), CraftingComponent.PUMP, Character.valueOf('V'), CraftingComponent.CONVEYOR, Character.valueOf('C'), CraftingComponent.CIRCUIT, Character.valueOf('W'), CraftingComponent.CABLE, Character.valueOf('G'), CraftingComponent.GLASS});
        MetaTileEntityLoader.registerMachineRecipe((MetaTileEntity[])MetaTileEntities.POLARIZER, (Object[])new Object[]{"ZSZ", "WMW", "ZSZ", Character.valueOf('M'), CraftingComponent.HULL, Character.valueOf('S'), CraftingComponent.STICK_ELECTROMAGNETIC, Character.valueOf('Z'), CraftingComponent.COIL_ELECTRIC, Character.valueOf('W'), CraftingComponent.CABLE});
        MetaTileEntityLoader.registerMachineRecipe((MetaTileEntity[])MetaTileEntities.ELECTROMAGNETIC_SEPARATOR, (Object[])new Object[]{"VWZ", "WMS", "CWZ", Character.valueOf('M'), CraftingComponent.HULL, Character.valueOf('S'), CraftingComponent.STICK_ELECTROMAGNETIC, Character.valueOf('Z'), CraftingComponent.COIL_ELECTRIC, Character.valueOf('V'), CraftingComponent.CONVEYOR, Character.valueOf('C'), CraftingComponent.CIRCUIT, Character.valueOf('W'), CraftingComponent.CABLE});
        MetaTileEntityLoader.registerMachineRecipe((MetaTileEntity[])MetaTileEntities.AUTOCLAVE, (Object[])new Object[]{"IGI", "IMI", "CPC", Character.valueOf('M'), CraftingComponent.HULL, Character.valueOf('P'), CraftingComponent.PUMP, Character.valueOf('C'), CraftingComponent.CIRCUIT, Character.valueOf('I'), CraftingComponent.PLATE, Character.valueOf('G'), CraftingComponent.GLASS});
        MetaTileEntityLoader.registerMachineRecipe((MetaTileEntity[])MetaTileEntities.MIXER, (Object[])new Object[]{"GRG", "GEG", "CMC", Character.valueOf('M'), CraftingComponent.HULL, Character.valueOf('E'), CraftingComponent.MOTOR, Character.valueOf('R'), CraftingComponent.ROTOR, Character.valueOf('C'), CraftingComponent.CIRCUIT, Character.valueOf('G'), CraftingComponent.GLASS});
        MetaTileEntityLoader.registerMachineRecipe((MetaTileEntity[])MetaTileEntities.LASER_ENGRAVER, (Object[])new Object[]{"PEP", "CMC", "WCW", Character.valueOf('M'), CraftingComponent.HULL, Character.valueOf('E'), CraftingComponent.EMITTER, Character.valueOf('P'), CraftingComponent.PISTON, Character.valueOf('C'), CraftingComponent.CIRCUIT, Character.valueOf('W'), CraftingComponent.CABLE});
        MetaTileEntityLoader.registerMachineRecipe((MetaTileEntity[])MetaTileEntities.FORMING_PRESS, (Object[])new Object[]{"WPW", "CMC", "WPW", Character.valueOf('M'), CraftingComponent.HULL, Character.valueOf('P'), CraftingComponent.PISTON, Character.valueOf('C'), CraftingComponent.CIRCUIT, Character.valueOf('W'), CraftingComponent.CABLE});
        MetaTileEntityLoader.registerMachineRecipe((MetaTileEntity[])MetaTileEntities.FORGE_HAMMER, (Object[])new Object[]{"WPW", "CMC", "WAW", Character.valueOf('M'), CraftingComponent.HULL, Character.valueOf('P'), CraftingComponent.PISTON, Character.valueOf('C'), CraftingComponent.CIRCUIT, Character.valueOf('W'), CraftingComponent.CABLE, Character.valueOf('A'), OreDictNames.craftingAnvil});
        MetaTileEntityLoader.registerMachineRecipe((MetaTileEntity[])MetaTileEntities.FLUID_HEATER, (Object[])new Object[]{"OGO", "PMP", "WCW", Character.valueOf('M'), CraftingComponent.HULL, Character.valueOf('P'), CraftingComponent.PUMP, Character.valueOf('O'), CraftingComponent.COIL_HEATING_DOUBLE, Character.valueOf('C'), CraftingComponent.CIRCUIT, Character.valueOf('W'), CraftingComponent.CABLE, Character.valueOf('G'), CraftingComponent.GLASS});
        MetaTileEntityLoader.registerMachineRecipe((MetaTileEntity[])MetaTileEntities.SIFTER, (Object[])new Object[]{"WFW", "PMP", "CFC", Character.valueOf('M'), CraftingComponent.HULL, Character.valueOf('P'), CraftingComponent.PISTON, Character.valueOf('F'), MetaItems.ITEM_FILTER, Character.valueOf('C'), CraftingComponent.CIRCUIT, Character.valueOf('W'), CraftingComponent.CABLE});
        MetaTileEntityLoader.registerMachineRecipe((MetaTileEntity[])MetaTileEntities.ARC_FURNACE, (Object[])new Object[]{"WGW", "CMC", "PPP", Character.valueOf('M'), CraftingComponent.HULL, Character.valueOf('P'), CraftingComponent.PLATE, Character.valueOf('C'), CraftingComponent.CIRCUIT, Character.valueOf('W'), CraftingComponent.CABLE_QUAD, Character.valueOf('G'), new UnificationEntry(OrePrefix.ingot, Materials.Graphite)});
        MetaTileEntityLoader.registerMachineRecipe((MetaTileEntity[])MetaTileEntities.PLASMA_ARC_FURNACE, (Object[])new Object[]{"WGW", "CMC", "TPT", Character.valueOf('M'), CraftingComponent.HULL, Character.valueOf('P'), CraftingComponent.PLATE, Character.valueOf('C'), CraftingComponent.CIRCUIT, Character.valueOf('W'), CraftingComponent.CABLE_QUAD, Character.valueOf('T'), CraftingComponent.PUMP, Character.valueOf('G'), new UnificationEntry(OrePrefix.ingot, Materials.Graphite)});
        MetaTileEntityLoader.registerMachineRecipe((MetaTileEntity[])MetaTileEntities.PUMP, (Object[])new Object[]{"WGW", "GMG", "TGT", Character.valueOf('M'), CraftingComponent.HULL, Character.valueOf('W'), CraftingComponent.CIRCUIT, Character.valueOf('G'), CraftingComponent.PUMP, Character.valueOf('T'), CraftingComponent.PISTON});
        MetaTileEntityLoader.registerMachineRecipe((MetaTileEntity[])MetaTileEntities.FISHER, (Object[])new Object[]{"WTW", "PMP", "TGT", Character.valueOf('M'), CraftingComponent.HULL, Character.valueOf('W'), CraftingComponent.CIRCUIT, Character.valueOf('G'), CraftingComponent.PUMP, Character.valueOf('T'), CraftingComponent.MOTOR, Character.valueOf('P'), CraftingComponent.PISTON});
        MetaTileEntityLoader.registerMachineRecipe((MetaTileEntity[])MetaTileEntities.AIR_COLLECTOR, (Object[])new Object[]{"WFW", "PHP", "WCW", Character.valueOf('W'), Blocks.field_150411_aY, Character.valueOf('F'), MetaItems.FLUID_FILTER, Character.valueOf('P'), CraftingComponent.PUMP, Character.valueOf('H'), CraftingComponent.HULL, Character.valueOf('C'), CraftingComponent.CIRCUIT});
        MetaTileEntityLoader.registerMachineRecipe((MetaTileEntity[])MetaTileEntities.ITEM_COLLECTOR, (Object[])new Object[]{"MRM", "RHR", "CWC", Character.valueOf('M'), CraftingComponent.MOTOR, Character.valueOf('R'), CraftingComponent.ROTOR, Character.valueOf('H'), CraftingComponent.HULL, Character.valueOf('C'), CraftingComponent.CIRCUIT, Character.valueOf('W'), CraftingComponent.CABLE});
        MetaTileEntityLoader.registerMachineRecipe((MetaTileEntity[])MetaTileEntities.BLOCK_BREAKER, (Object[])new Object[]{"MGM", "CHC", "WSW", Character.valueOf('M'), CraftingComponent.MOTOR, Character.valueOf('H'), CraftingComponent.HULL, Character.valueOf('C'), CraftingComponent.CIRCUIT, Character.valueOf('W'), CraftingComponent.CABLE, Character.valueOf('S'), Blocks.field_150486_ae, Character.valueOf('G'), MetaItems.COMPONENT_GRINDER_DIAMOND});
        MetaTileEntityLoader.registerMachineRecipe((MetaTileEntity[])MetaTileEntities.QUANTUM_CHEST, (Object[])new Object[]{"CPC", "PHP", "CFC", Character.valueOf('C'), CraftingComponent.CIRCUIT, Character.valueOf('P'), CraftingComponent.PLATE, Character.valueOf('F'), CraftingComponent.FIELD_GENERATOR, Character.valueOf('H'), CraftingComponent.HULL});
        MetaTileEntityLoader.registerMachineRecipe((MetaTileEntity[])MetaTileEntities.QUANTUM_TANK, (Object[])new Object[]{"CFC", "PHP", "CPC", Character.valueOf('C'), CraftingComponent.CIRCUIT, Character.valueOf('P'), CraftingComponent.PLATE, Character.valueOf('F'), CraftingComponent.FIELD_GENERATOR, Character.valueOf('H'), CraftingComponent.HULL});
        ModHandler.addShapelessRecipe("small_wooden_chest", MetaTileEntities.SMALL_WOODEN_CHEST.getStackForm(8), "chest", Character.valueOf('s'));
        ModHandler.addShapelessRecipe("wooden_chest", MetaTileEntities.WOODEN_CHEST.getStackForm(), "chest", Character.valueOf('r'));
        ModHandler.addShapedRecipe("bronze_chest", MetaTileEntities.BRONZE_CHEST.getStackForm(), "XXX", "X X", "XXX", Character.valueOf('X'), new UnificationEntry(OrePrefix.plate, Materials.Bronze));
        ModHandler.addShapedRecipe("steel_chest", MetaTileEntities.STEEL_CHEST.getStackForm(), "XXX", "X X", "XXX", Character.valueOf('X'), new UnificationEntry(OrePrefix.plate, Materials.Steel));
        ModHandler.addShapedRecipe("stainless_steel_chest", MetaTileEntities.STAINLESS_STEEL_CHEST.getStackForm(), "XXX", "X X", "XXX", Character.valueOf('X'), new UnificationEntry(OrePrefix.plate, Materials.StainlessSteel));
        ModHandler.addShapedRecipe("titanium_chest", MetaTileEntities.TITANIUM_CHEST.getStackForm(), "XXX", "X X", "XXX", Character.valueOf('X'), new UnificationEntry(OrePrefix.plate, Materials.Titanium));
        ModHandler.addShapedRecipe("tungsten_steel_chest", MetaTileEntities.TUNGSTENSTEEL_CHEST.getStackForm(), "XXX", "X X", "XXX", Character.valueOf('X'), new UnificationEntry(OrePrefix.plate, Materials.TungstenSteel));
        ModHandler.addShapedRecipe("wooden_tank", MetaTileEntities.WOODEN_TANK.getStackForm(), "XYX", "Y Y", "XYX", Character.valueOf('X'), new UnificationEntry(OrePrefix.plank, Materials.Wood), Character.valueOf('Y'), new UnificationEntry(OrePrefix.blockGlass));
        ModHandler.addShapedRecipe("bronze_tank", MetaTileEntities.BRONZE_TANK.getStackForm(), "XYX", "Y Y", "XYX", Character.valueOf('X'), new UnificationEntry(OrePrefix.plate, Materials.Bronze), Character.valueOf('Y'), new UnificationEntry(OrePrefix.blockGlass));
        ModHandler.addShapedRecipe("steel_tank", MetaTileEntities.STEEL_TANK.getStackForm(), "XYX", "Y Y", "XYX", Character.valueOf('X'), new UnificationEntry(OrePrefix.plate, Materials.Steel), Character.valueOf('Y'), new UnificationEntry(OrePrefix.blockGlass));
        ModHandler.addShapedRecipe("stainless_steel_tank", MetaTileEntities.STAINLESS_STEEL_TANK.getStackForm(), "XYX", "Y Y", "XYX", Character.valueOf('X'), new UnificationEntry(OrePrefix.plate, Materials.StainlessSteel), Character.valueOf('Y'), new UnificationEntry(OrePrefix.blockGlass));
        ModHandler.addShapedRecipe("titanium_tank", MetaTileEntities.TITANIUM_TANK.getStackForm(), "XYX", "Y Y", "XYX", Character.valueOf('X'), new UnificationEntry(OrePrefix.plate, Materials.Titanium), Character.valueOf('Y'), new UnificationEntry(OrePrefix.blockGlass));
        ModHandler.addShapedRecipe("tungsten_steel_tank", MetaTileEntities.TUNGSTENSTEEL_TANK.getStackForm(), "XYX", "Y Y", "XYX", Character.valueOf('X'), new UnificationEntry(OrePrefix.plate, Materials.TungstenSteel), Character.valueOf('Y'), new UnificationEntry(OrePrefix.blockGlass));
        ModHandler.addShapedRecipe("tesla_coil", MetaTileEntities.TESLA_COIL.getStackForm(), "XXX", "YHY", "XXX", Character.valueOf('X'), new UnificationEntry(OrePrefix.wireGtQuadruple, Materials.Copper), Character.valueOf('Y'), MetaItems.EMITTER_MV, Character.valueOf('H'), MetaTileEntities.HULL[2].getStackForm());
    }

    public static <T extends MetaTileEntity> void registerMachineRecipe(T[] metaTileEntities, Object ... recipe) {
        for (T metaTileEntity : metaTileEntities) {
            ModHandler.addShapedRecipe(((MetaTileEntity)metaTileEntity).getMetaName(), ((MetaTileEntity)metaTileEntity).getStackForm(), MetaTileEntityLoader.prepareRecipe(((ITieredMetaTileEntity)metaTileEntity).getTier(), Arrays.copyOf(recipe, recipe.length)));
        }
    }

    private static Object[] prepareRecipe(int tier, Object ... recipe) {
        for (int i = 3; i < recipe.length; ++i) {
            if (!(recipe[i] instanceof CraftingComponent)) continue;
            recipe[i] = ((CraftingComponent)((Object)recipe[i])).getIngredient(tier);
        }
        return recipe;
    }
}

