/*
 * Decompiled with CFR 0.152.
 */
package gregtech.integration.jei.recipe;

import codechicken.lib.util.ItemNBTUtils;
import gnu.trove.map.TObjectIntMap;
import gregtech.api.recipes.CountableIngredient;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.unification.OreDictUnifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;

public class GTRecipeWrapper
implements IRecipeWrapper {
    private final RecipeMap<?> recipeMap;
    private final Recipe recipe;

    public GTRecipeWrapper(RecipeMap<?> recipeMap, Recipe recipe) {
        this.recipeMap = recipeMap;
        this.recipe = recipe;
    }

    public void getIngredients(IIngredients ingredients) {
        List recipeOutputs;
        List<CountableIngredient> recipeInputs;
        if (!this.recipe.getInputs().isEmpty()) {
            recipeInputs = this.recipe.getInputs();
            ArrayList<List<ItemStack>> matchingInputs = new ArrayList<List<ItemStack>>(recipeInputs.size());
            for (CountableIngredient ingredient : recipeInputs) {
                List<ItemStack> ingredientValues = Arrays.stream(ingredient.getIngredient().func_193365_a()).map(ItemStack::func_77946_l).sorted(OreDictUnifier.getItemStackComparator()).collect(Collectors.toList());
                ingredientValues.forEach(stack -> {
                    if (ingredient.getCount() == 0) {
                        ItemNBTUtils.setBoolean((ItemStack)stack, (String)"not_consumed", (boolean)true);
                        stack.func_190920_e(1);
                    } else {
                        stack.func_190920_e(ingredient.getCount());
                    }
                });
                matchingInputs.add(ingredientValues);
            }
            ingredients.setInputLists(ItemStack.class, matchingInputs);
        }
        if (!this.recipe.getFluidInputs().isEmpty()) {
            recipeInputs = this.recipe.getFluidInputs().stream().map(FluidStack::copy).collect(Collectors.toList());
            recipeInputs.forEach(stack -> {
                if (stack.amount == 0) {
                    if (stack.tag == null) {
                        stack.tag = new NBTTagCompound();
                    }
                    stack.tag.func_74757_a("not_consumed", true);
                    stack.amount = 1;
                }
            });
            ingredients.setInputs(FluidStack.class, recipeInputs);
        }
        if (!this.recipe.getOutputs().isEmpty() || !this.recipe.getChancedOutputs().isEmpty()) {
            recipeOutputs = this.recipe.getOutputs().stream().map(ItemStack::func_77946_l).collect(Collectors.toList());
            TObjectIntMap<ItemStack> chancedOutputs = this.recipe.getChancedOutputs();
            for (ItemStack chancedStack : chancedOutputs.keySet()) {
                int outputChance = chancedOutputs.get((Object)chancedStack);
                chancedStack = chancedStack.func_77946_l();
                ItemNBTUtils.setInteger((ItemStack)chancedStack, (String)"chance", (int)outputChance);
                recipeOutputs.add(chancedStack);
            }
            recipeOutputs.sort(Comparator.comparing(stack -> ItemNBTUtils.getInteger((ItemStack)stack, (String)"chance")));
            ingredients.setOutputs(ItemStack.class, recipeOutputs);
        }
        if (!this.recipe.getFluidOutputs().isEmpty()) {
            recipeOutputs = this.recipe.getFluidOutputs().stream().map(FluidStack::copy).collect(Collectors.toList());
            ingredients.setOutputs(FluidStack.class, recipeOutputs);
        }
    }

    public void addTooltip(int slotIndex, boolean input, Object ingredient, List<String> tooltip) {
        NBTTagCompound tagCompound;
        if (ingredient instanceof ItemStack) {
            tagCompound = ((ItemStack)ingredient).func_77978_p();
        } else if (ingredient instanceof FluidStack) {
            tagCompound = ((FluidStack)ingredient).tag;
        } else {
            throw new IllegalArgumentException("Unknown ingredient type: " + ingredient.getClass());
        }
        if (tagCompound != null && tagCompound.func_74764_b("chance")) {
            String chanceString = Recipe.formatChanceValue(tagCompound.func_74762_e("chance"));
            tooltip.add(I18n.func_135052_a((String)"gregtech.recipe.chance", (Object[])new Object[]{chanceString}));
        } else if (tagCompound != null && tagCompound.func_74764_b("not_consumed")) {
            tooltip.add(I18n.func_135052_a((String)"gregtech.recipe.not_consumed", (Object[])new Object[0]));
        }
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        minecraft.field_71466_p.func_78276_b(I18n.func_135052_a((String)"gregtech.recipe.total", (Object[])new Object[]{Math.abs(this.recipe.getEUt()) * this.recipe.getDuration()}), 0, 70, 0x111111);
        minecraft.field_71466_p.func_78276_b(I18n.func_135052_a((String)(this.recipe.getEUt() >= 0 ? "gregtech.recipe.eu" : "gregtech.recipe.eu_inverted"), (Object[])new Object[]{Math.abs(this.recipe.getEUt())}), 0, 80, 0x111111);
        minecraft.field_71466_p.func_78276_b(I18n.func_135052_a((String)"gregtech.recipe.duration", (Object[])new Object[]{Float.valueOf((float)this.recipe.getDuration() / 20.0f)}), 0, 90, 0x111111);
        int baseYPosition = 100;
        for (String propertyKey : this.recipe.getPropertyKeys()) {
            minecraft.field_71466_p.func_78276_b(I18n.func_135052_a((String)("gregtech.recipe." + propertyKey), (Object[])new Object[]{this.recipe.getProperty(propertyKey)}), 0, baseYPosition, 0x111111);
            baseYPosition += 10;
        }
    }
}

