/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tools;

import gregtech.api.items.toolitem.IToolStats;
import gregtech.api.items.toolitem.ToolMetaItem;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.material.type.SolidMaterial;
import gregtech.api.util.function.Task;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLog;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class TreeChopTask
implements Task {
    private static final int MAX_BLOCKS_SEARCH_PER_TICK = 1024;
    private static final int MAX_BLOCKS_TO_SEARCH = 8192;
    private final Stack<MultiFacing> moveStack = new Stack();
    private final BlockPos.MutableBlockPos currentPos = new BlockPos.MutableBlockPos();
    private final BlockPos startBlockPos;
    private final Set<BlockPos> visitedBlockPos = new HashSet<BlockPos>();
    private final List<BlockPos> woodBlockPos = new ArrayList<BlockPos>();
    private boolean finishedSearchingBlocks = false;
    private int currentWoodBlockIndex = 0;
    private final World world;
    private final EntityPlayerMP player;
    private final ItemStack itemStack;

    public TreeChopTask(BlockPos startPos, World world, EntityPlayerMP player, ItemStack toolStack) {
        this.startBlockPos = startPos.func_185334_h();
        this.currentPos.func_189533_g((Vec3i)startPos);
        this.world = world;
        this.itemStack = toolStack.func_77946_l();
        this.player = player;
    }

    @Override
    public boolean run() {
        boolean isPlayerConnected;
        ItemStack itemInMainHand = this.player.func_184614_ca();
        boolean isPlayerNear = this.player.field_70170_p == this.world && this.currentPos.func_177954_c(this.player.field_70165_t, (double)this.currentPos.func_177956_o(), this.player.field_70161_v) <= 1024.0;
        boolean bl = isPlayerConnected = this.player.field_71135_a.field_147371_a.func_150724_d() && isPlayerNear;
        if (!isPlayerConnected || itemInMainHand.func_190926_b() || !this.isItemEqual(itemInMainHand)) {
            return false;
        }
        ToolMetaItem toolMetaItem = (ToolMetaItem)this.itemStack.func_77973_b();
        ToolMetaItem.MetaToolValueItem toolValueItem = (ToolMetaItem.MetaToolValueItem)toolMetaItem.getItem(this.itemStack);
        if (toolValueItem == null) {
            return false;
        }
        IToolStats toolStats = toolValueItem.getToolStats();
        int damagePerBlockBreak = toolStats.getToolDamagePerBlockBreak(this.itemStack);
        if (!this.finishedSearchingBlocks) {
            boolean bl2 = this.finishedSearchingBlocks = !this.attemptSearchWoodBlocks() || this.visitedBlockPos.size() >= 8192;
            if (this.finishedSearchingBlocks) {
                this.woodBlockPos.sort(new WoodBlockComparator());
            }
            return true;
        }
        if (toolMetaItem.isUsable(itemInMainHand, damagePerBlockBreak) && this.tryBreakAny()) {
            toolMetaItem.damageItem(itemInMainHand, damagePerBlockBreak, false);
            return true;
        }
        return false;
    }

    private boolean isItemEqual(ItemStack heldItem) {
        if (heldItem.func_77973_b() != this.itemStack.func_77973_b() || heldItem.func_77952_i() != this.itemStack.func_77952_i() || heldItem.func_77973_b() instanceof ToolMetaItem) {
            return false;
        }
        SolidMaterial heldToolMaterial = ToolMetaItem.getToolMaterial(heldItem);
        SolidMaterial toolMaterial = ToolMetaItem.getToolMaterial(this.itemStack);
        return toolMaterial == heldToolMaterial;
    }

    private boolean tryBreakAny() {
        if (this.woodBlockPos.size() > this.currentWoodBlockIndex) {
            BlockPos woodPos;
            IBlockState blockState;
            if (TreeChopTask.isLogOrLeavesBlock(blockState = this.world.func_180495_p(woodPos = this.woodBlockPos.get(this.currentWoodBlockIndex++))) == 1) {
                blockState.func_177230_c().func_180653_a(this.world, woodPos, blockState, 1.0f, 0);
                this.world.func_175698_g(woodPos);
                return true;
            }
            return true;
        }
        return false;
    }

    private boolean attemptSearchWoodBlocks() {
        int blocksSearchedNow = 0;
        int validWoodBlocksFound = 0;
        block0: while (blocksSearchedNow <= 1024) {
            ++blocksSearchedNow;
            for (MultiFacing facing : MultiFacing.VALUES) {
                IBlockState blockState;
                int blockType;
                facing.move(this.currentPos);
                if (!this.visitedBlockPos.contains(this.currentPos) && (blockType = TreeChopTask.isLogOrLeavesBlock(blockState = this.world.func_180495_p((BlockPos)this.currentPos))) > 0) {
                    BlockPos immutablePos = this.currentPos.func_185334_h();
                    this.visitedBlockPos.add(immutablePos);
                    if (blockType == 1) {
                        this.woodBlockPos.add(immutablePos);
                    }
                    ++validWoodBlocksFound;
                    this.moveStack.add(facing.getOpposite());
                    continue block0;
                }
                facing.getOpposite().move(this.currentPos);
            }
            if (this.moveStack.isEmpty()) break;
            this.moveStack.pop().move(this.currentPos);
        }
        return validWoodBlocksFound > 0;
    }

    public static int isLogOrLeavesBlock(IBlockState blockState) {
        if (blockState.func_177230_c() instanceof BlockLog) {
            return 1;
        }
        if (blockState.func_177230_c() instanceof BlockLeaves) {
            return 2;
        }
        Item itemBlock = Item.func_150898_a((Block)blockState.func_177230_c());
        ItemStack blockStack = new ItemStack(itemBlock, 1, blockState.func_177230_c().func_180651_a(blockState));
        Set<String> blocks = OreDictUnifier.getOreDictionaryNames(blockStack);
        if (blocks.contains("logWood")) {
            return 1;
        }
        if (blocks.contains("treeLeaves")) {
            return 2;
        }
        return 0;
    }

    private static enum MultiFacing {
        DOWN(1, new Vec3i(0, -1, 0)),
        UP(0, new Vec3i(0, 1, 0)),
        NORTH(3, new Vec3i(0, 0, -1)),
        SOUTH(2, new Vec3i(0, 0, 1)),
        WEST(5, new Vec3i(-1, 0, 0)),
        EAST(4, new Vec3i(1, 0, 0)),
        NORTH_DOWN(11, new Vec3i(0, -1, -1)),
        SOUTH_DOWN(10, new Vec3i(0, -1, 1)),
        WEST_DOWN(13, new Vec3i(-1, -1, 0)),
        EAST_DOWN(12, new Vec3i(1, -1, 0)),
        NORTH_UP(7, new Vec3i(0, 1, -1)),
        SOUTH_UP(6, new Vec3i(0, 1, 1)),
        WEST_UP(9, new Vec3i(-1, 1, 0)),
        EAST_UP(8, new Vec3i(1, 1, 0)),
        NORTH_WEST_DOWN(21, new Vec3i(-1, -1, -1)),
        NORTH_EAST_DOWN(20, new Vec3i(-1, -1, 1)),
        SOUTH_WEST_DOWN(19, new Vec3i(-1, -1, 1)),
        SOUTH_EAST_DOWN(18, new Vec3i(1, -1, 1)),
        NORTH_WEST_UP(17, new Vec3i(-1, 1, -1)),
        NORTH_EAST_UP(16, new Vec3i(1, 1, -1)),
        SOUTH_WEST_UP(15, new Vec3i(1, 1, -1)),
        SOUTH_EAST_UP(14, new Vec3i(1, 1, 1));

        private final int oppositeIndex;
        private final Vec3i direction;
        private static final MultiFacing[] VALUES;

        private MultiFacing(int oppositeIndex, Vec3i direction) {
            this.oppositeIndex = oppositeIndex;
            this.direction = direction;
        }

        public void move(BlockPos.MutableBlockPos blockPos) {
            blockPos.func_181079_c(blockPos.func_177958_n() + this.direction.func_177958_n(), blockPos.func_177956_o() + this.direction.func_177956_o(), blockPos.func_177952_p() + this.direction.func_177952_p());
        }

        public MultiFacing getOpposite() {
            return VALUES[this.oppositeIndex];
        }

        static {
            VALUES = MultiFacing.values();
        }
    }

    private class WoodBlockComparator
    implements Comparator<BlockPos> {
        private WoodBlockComparator() {
        }

        @Override
        public int compare(BlockPos o1, BlockPos o2) {
            int a = -Integer.compare(o1.func_177956_o(), o2.func_177956_o());
            if (a != 0) {
                return a;
            }
            return Integer.compare(this.distance(o1), this.distance(o2));
        }

        private int distance(BlockPos pos) {
            int diffX = pos.func_177958_n() - TreeChopTask.this.startBlockPos.func_177958_n();
            int diffZ = pos.func_177952_p() - TreeChopTask.this.startBlockPos.func_177952_p();
            return diffX * diffX + diffZ * diffZ;
        }
    }
}

