/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.multipart;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.raytracer.CuboidRayTraceResult;
import codechicken.lib.raytracer.IndexedCuboid6;
import codechicken.lib.render.BlockRenderer;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Vector3;
import codechicken.lib.vec.uv.IconTransformation;
import codechicken.multipart.IRedstonePart;
import codechicken.multipart.NormalOcclusionTest;
import codechicken.multipart.NormallyOccludedPart;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.TNormalOcclusionPart;
import codechicken.multipart.TPartialOcclusionPart;
import codechicken.multipart.TileMultipart;
import com.google.common.collect.Lists;
import gnu.trove.map.TIntIntMap;
import gnu.trove.map.hash.TIntIntHashMap;
import gregtech.api.capability.GregtechTileCapabilities;
import gregtech.api.cover.CoverBehavior;
import gregtech.api.cover.ICoverable;
import gregtech.api.pipenet.PipeNet;
import gregtech.api.pipenet.WorldPipeNet;
import gregtech.api.pipenet.block.BlockPipe;
import gregtech.api.pipenet.block.IPipeType;
import gregtech.api.pipenet.tile.AttachmentType;
import gregtech.api.pipenet.tile.IPipeTile;
import gregtech.api.pipenet.tile.PipeCoverableImplementation;
import gregtech.api.unification.material.type.Material;
import gregtech.api.util.ParticleHandlerUtil;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

public abstract class PipeMultiPart<PipeType extends Enum<PipeType>, NodeDataType>
extends TMultiPart
implements TNormalOcclusionPart,
TPartialOcclusionPart,
IRedstonePart,
IPipeTile<PipeType, NodeDataType>,
ICapabilityProvider {
    private BlockPipe<PipeType, NodeDataType, ?> pipeBlock;
    private PipeType pipeType;
    private Material material;
    protected int insulationColor = 0x777777;
    private NodeDataType cachedNodeData;
    private final PipeCoverableImplementation coverableImplementation = new PipeCoverableImplementation(this);
    private TIntIntMap blockedConnectionsMap = new TIntIntHashMap();
    private int blockedConnections = 0;
    protected int activeConnections;
    protected Cuboid6 centerBox;
    protected List<Cuboid6> sidedConnections = new ArrayList<Cuboid6>();
    protected boolean isBeingReplaced = false;

    protected PipeMultiPart() {
    }

    public PipeMultiPart(IPipeTile<PipeType, NodeDataType> sourceTile) {
        this.transferDataFrom(sourceTile);
    }

    protected abstract PipeMultiPart<PipeType, NodeDataType> toTickablePart();

    @Override
    public void transferDataFrom(IPipeTile<PipeType, NodeDataType> sourceTile) {
        this.insulationColor = sourceTile.getInsulationColor();
        this.pipeBlock = sourceTile.getPipeBlock();
        this.pipeType = sourceTile.getPipeType();
        this.material = sourceTile.getPipeMaterial();
        this.blockedConnectionsMap = sourceTile.getBlockedConnectionsMap();
        sourceTile.getCoverableImplementation().transferDataTo(this.getCoverableImplementation());
        if (sourceTile instanceof PipeMultiPart) {
            PipeMultiPart sourcePart = (PipeMultiPart)sourceTile;
            this.activeConnections = sourcePart.activeConnections;
            this.centerBox = sourcePart.centerBox;
            this.sidedConnections = sourcePart.sidedConnections;
        }
        this.recomputeBlockedConnections();
        this.reinitializeShape();
    }

    @Override
    public World getPipeWorld() {
        return this.tile().func_145831_w();
    }

    @Override
    public BlockPos getPipePos() {
        return this.tile().func_174877_v();
    }

    @Override
    public PipeCoverableImplementation getCoverableImplementation() {
        return this.coverableImplementation;
    }

    @Override
    public int getBlockedConnections() {
        return this.blockedConnections;
    }

    private int getMark() {
        return this.insulationColor == 0x777777 ? 0 : this.insulationColor;
    }

    @Override
    public int getInsulationColor() {
        return this.insulationColor;
    }

    @Override
    public Material getPipeMaterial() {
        return this.material;
    }

    @Override
    public TIntIntMap getBlockedConnectionsMap() {
        return new TIntIntHashMap(this.blockedConnectionsMap);
    }

    @Override
    public boolean isConnectionBlocked(AttachmentType type, EnumFacing side) {
        int blockedConnections = this.blockedConnectionsMap.get(type.ordinal());
        return (blockedConnections & 1 << side.func_176745_a()) > 0;
    }

    @Override
    public void setConnectionBlocked(AttachmentType attachmentType, EnumFacing side, boolean blocked) {
        int blockedConnections = this.blockedConnectionsMap.get(attachmentType.ordinal());
        this.blockedConnectionsMap.put(attachmentType.ordinal(), this.withSideConnectionBlocked(blockedConnections, side, blocked));
        this.recomputeBlockedConnections();
        this.updateActualConnections();
        if (!this.getPipeWorld().field_72995_K) {
            this.updateSideBlockedConnection(side);
            MCDataOutput writeStream = this.getWriteStream();
            writeStream.writeByte(3);
            writeStream.writeVarInt(this.blockedConnections);
            this.markAsDirty();
        }
    }

    private void recomputeBlockedConnections() {
        int resultBlockedConnections = 0;
        for (int blockedConnections : this.blockedConnectionsMap.values()) {
            resultBlockedConnections |= blockedConnections;
        }
        this.blockedConnections = resultBlockedConnections;
    }

    private void updateSideBlockedConnection(EnumFacing side) {
        Object worldPipeNet = this.getPipeBlock().getWorldPipeNet(this.getPipeWorld());
        boolean isSideBlocked = false;
        int sideIndex = 1 << side.func_176745_a();
        for (int blockedConnections : this.blockedConnectionsMap.values()) {
            isSideBlocked |= (blockedConnections & sideIndex) > 0;
        }
        ((WorldPipeNet)((Object)worldPipeNet)).updateBlockedConnections(this.getPipePos(), side, isSideBlocked);
    }

    private int withSideConnectionBlocked(int blockedConnections, EnumFacing side, boolean blocked) {
        int index = 1 << side.func_176745_a();
        if (blocked) {
            return blockedConnections | index;
        }
        return blockedConnections & ~index;
    }

    @Override
    public IPipeTile<PipeType, NodeDataType> setSupportsTicking() {
        if (this.supportsTicking()) {
            return this;
        }
        PipeMultiPart<PipeType, NodeDataType> newPart = this.toTickablePart();
        this.isBeingReplaced = true;
        newPart.isBeingReplaced = true;
        TileMultipart tileMultipart = this.tile();
        tileMultipart.remPart((TMultiPart)this);
        TileMultipart.addPart((World)tileMultipart.func_145831_w(), (BlockPos)tileMultipart.func_174877_v(), newPart);
        return newPart;
    }

    @Override
    public boolean canPlaceCoverOnSide(EnumFacing side) {
        Cuboid6 plateBox = ICoverable.getCoverPlateBox(side, this.getCoverableImplementation().getCoverPlateThickness(), true);
        NormallyOccludedPart part = new NormallyOccludedPart(plateBox);
        return this.tile().canReplacePart((TMultiPart)this, (TMultiPart)part);
    }

    @Override
    public void setInsulationColor(int color) {
        this.insulationColor = color;
        if (!this.world().field_72995_K) {
            this.sendDescUpdate();
            ((WorldPipeNet)((Object)this.pipeBlock.getWorldPipeNet(this.world()))).updateMark(this.pos(), this.getMark());
        }
    }

    @Override
    public BlockPipe<PipeType, NodeDataType, ?> getPipeBlock() {
        return this.pipeBlock;
    }

    @Override
    public PipeType getPipeType() {
        return this.pipeType;
    }

    @Override
    public NodeDataType getNodeData() {
        if (this.cachedNodeData == null) {
            this.cachedNodeData = this.getPipeBlock().createProperties(this);
        }
        return this.cachedNodeData;
    }

    @Override
    public <T> T getCapabilityInternal(Capability<T> capability, EnumFacing side) {
        if (capability == GregtechTileCapabilities.CAPABILITY_COVERABLE) {
            return (T)GregtechTileCapabilities.CAPABILITY_COVERABLE.cast((Object)this.getCoverableImplementation());
        }
        return null;
    }

    @Override
    @Nullable
    public final <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        boolean isCoverable = capability == GregtechTileCapabilities.CAPABILITY_COVERABLE;
        CoverBehavior coverBehavior = facing == null ? null : this.getCoverableImplementation().getCoverAtSide(facing);
        T defaultValue = this.getCapabilityInternal(capability, facing);
        if (isCoverable) {
            return defaultValue;
        }
        if (coverBehavior == null && facing != null) {
            boolean isBlocked = (this.blockedConnections & 1 << facing.func_176745_a()) > 0;
            return isBlocked ? null : (T)defaultValue;
        }
        if (coverBehavior != null) {
            return coverBehavior.getCapability(capability, defaultValue);
        }
        return defaultValue;
    }

    public final boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return this.getCapability(capability, facing) != null;
    }

    public void onWorldJoin() {
        super.onWorldJoin();
        this.coverableImplementation.updateInputRedstoneSignals();
    }

    public boolean occlusionTest(TMultiPart part) {
        return NormalOcclusionTest.apply((TNormalOcclusionPart)this, (TMultiPart)part);
    }

    public Iterable<ItemStack> getDrops() {
        return Lists.newArrayList((Object[])new ItemStack[]{this.getDropStack()});
    }

    public ItemStack pickItem(CuboidRayTraceResult hit) {
        if (hit.cuboid6.data instanceof ICoverable.CoverSideData) {
            EnumFacing coverSide = ((ICoverable.CoverSideData)hit.cuboid6.data).side;
            CoverBehavior coverBehavior = this.getCoverableImplementation().getCoverAtSide(coverSide);
            return coverBehavior == null ? ItemStack.field_190927_a : coverBehavior.getCoverDefinition().getDropItemStack();
        }
        return this.getDropStack();
    }

    private ItemStack getDropStack() {
        return this.getPipeBlock().getDropItem(this);
    }

    private void reinitializeShape() {
        this.centerBox = BlockPipe.getSideBox(null, ((IPipeType)this.getPipeType()).getThickness());
        this.updateSidedConnections(false);
    }

    private void updateSidedConnections(boolean notify) {
        float thickness = ((IPipeType)this.getPipeType()).getThickness();
        this.sidedConnections.clear();
        for (EnumFacing side : EnumFacing.field_82609_l) {
            int sideIndex = side.func_176745_a();
            if ((this.activeConnections & 1 << sideIndex) <= 0 || (this.blockedConnections & 1 << sideIndex) != 0) continue;
            this.sidedConnections.add(BlockPipe.getSideBox(side, thickness));
        }
        TileMultipart tileMultipart = this.tile();
        if (tileMultipart != null && notify) {
            tileMultipart.notifyPartChange((TMultiPart)this);
            tileMultipart.markRender();
        }
    }

    private boolean isMultipartConnectionBlocked(EnumFacing side) {
        int blockedConnections = this.blockedConnectionsMap.get(AttachmentType.MULTIPART.ordinal());
        return (blockedConnections & 1 << side.func_176745_a()) > 0;
    }

    private void updateMultipartBlockedConnections() {
        TileMultipart tileMultipart = this.tile();
        if (tileMultipart == null || tileMultipart.func_145837_r()) {
            return;
        }
        float thickness = ((IPipeType)this.getPipeType()).getThickness();
        for (EnumFacing cableSide : EnumFacing.field_82609_l) {
            boolean wasConnectionBlocked;
            Cuboid6 sideBox = BlockPipe.getSideBox(cableSide, thickness);
            NormallyOccludedPart part = new NormallyOccludedPart(sideBox);
            boolean isConnectionBlocked = !tileMultipart.canReplacePart((TMultiPart)this, (TMultiPart)part);
            if (isConnectionBlocked == (wasConnectionBlocked = this.isMultipartConnectionBlocked(cableSide))) continue;
            this.setConnectionBlocked(AttachmentType.MULTIPART, cableSide, isConnectionBlocked);
        }
    }

    private void updateActualConnections() {
        int lastActualConnections = this.activeConnections;
        TileMultipart tileMultipart = this.tile();
        if (tileMultipart != null && !tileMultipart.func_145837_r()) {
            this.activeConnections = this.pipeBlock.getActualConnections(this, (IBlockAccess)tileMultipart.func_145831_w());
        }
        if (lastActualConnections != this.activeConnections) {
            this.updateSidedConnections(true);
        }
    }

    public void onAdded() {
        if (!this.isBeingReplaced) {
            this.updateMultipartBlockedConnections();
            this.updateActualConnections();
            this.isBeingReplaced = false;
            if (!this.world().field_72995_K) {
                ((WorldPipeNet)((Object)this.getPipeBlock().getWorldPipeNet(this.world()))).addNode(this.pos(), this.getNodeData(), this.getMark(), this.getBlockedConnections(), this.pipeBlock.getActiveNodeConnections((IBlockAccess)this.world(), this.pos(), this) > 0);
            }
        }
        this.reinitializeShape();
    }

    public boolean activate(EntityPlayer player, CuboidRayTraceResult hit, ItemStack item, EnumHand hand) {
        return this.getPipeBlock().onPipeActivated(player, hand, hit, this);
    }

    public void click(EntityPlayer player, CuboidRayTraceResult hit, ItemStack item) {
        EnumFacing coverSide = ICoverable.traceCoverSide((RayTraceResult)hit);
        if (coverSide == null) {
            return;
        }
        CoverBehavior coverBehavior = this.getCoverableImplementation().getCoverAtSide(coverSide);
        if (coverBehavior == null) {
            return;
        }
        coverBehavior.onLeftClick(player, hit);
    }

    public int strongPowerLevel(int side) {
        return 0;
    }

    public int weakPowerLevel(int side) {
        CoverBehavior coverBehavior = this.getCoverableImplementation().getCoverAtSide(EnumFacing.field_82609_l[side].func_176734_d());
        return coverBehavior == null ? 0 : coverBehavior.getRedstoneSignalOutput();
    }

    public boolean canConnectRedstone(int side) {
        CoverBehavior coverBehavior = this.getCoverableImplementation().getCoverAtSide(EnumFacing.field_82609_l[side]);
        return coverBehavior != null && coverBehavior.canConnectRedstone();
    }

    public void onRemoved() {
        if (!this.isBeingReplaced && !this.world().field_72995_K) {
            ((WorldPipeNet)((Object)this.pipeBlock.getWorldPipeNet(this.world()))).removeNode(this.pos());
            this.getCoverableImplementation().dropAllCovers();
        }
    }

    public void onPartChanged(TMultiPart part) {
        if (part != this) {
            this.scheduleTick(1);
            this.coverableImplementation.updateInputRedstoneSignals();
        }
    }

    public void onNeighborChanged() {
        this.scheduleTick(1);
        this.coverableImplementation.updateInputRedstoneSignals();
    }

    public void scheduledTick() {
        this.updateMultipartBlockedConnections();
        this.updateActualConnections();
        if (!this.world().field_72995_K) {
            this.getWriteStream().writeByte(1);
            this.updateActiveNodeStatus();
        }
    }

    public void updateActiveNodeStatus() {
        boolean changed;
        int activeConnections = this.pipeBlock.getActiveNodeConnections((IBlockAccess)this.world(), this.pos(), this);
        boolean isActiveNode = (activeConnections &= ~this.getBlockedConnections()) > 0;
        Object pipeNet = ((WorldPipeNet)((Object)this.pipeBlock.getWorldPipeNet(this.world()))).getNetFromPos(this.pos());
        if (pipeNet != null && (changed = ((PipeNet)pipeNet).markNodeAsActive(this.pos(), isActiveNode))) {
            this.onModeChange(isActiveNode);
        }
    }

    protected void onModeChange(boolean isActiveNow) {
    }

    public void sendDescUpdate() {
        MCDataOutput writeStream = this.getWriteStream();
        writeStream.writeByte(0);
        this.writeDesc(writeStream);
    }

    public void save(NBTTagCompound tag) {
        tag.func_74778_a("PipeBlock", ((ResourceLocation)Block.field_149771_c.func_177774_c(this.pipeBlock)).toString());
        tag.func_74768_a("PipeType", ((Enum)this.pipeType).ordinal());
        tag.func_74778_a("PipeMaterial", this.material.toString());
        tag.func_74768_a("InsulationColor", this.insulationColor);
        tag.func_74768_a("ActiveConnections", this.activeConnections);
        NBTTagCompound blockedConnectionsTag = new NBTTagCompound();
        for (int attachmentType : this.blockedConnectionsMap.keys()) {
            int blockedConnections = this.blockedConnectionsMap.get(attachmentType);
            blockedConnectionsTag.func_74768_a(Integer.toString(attachmentType), blockedConnections);
        }
        tag.func_74782_a("BlockedConnectionsMap", (NBTBase)blockedConnectionsTag);
        this.getCoverableImplementation().readFromNBT(tag);
    }

    public void load(NBTTagCompound tag) {
        ResourceLocation pipeBlockName = new ResourceLocation(tag.func_74779_i("PipeBlock"));
        this.pipeBlock = (BlockPipe)Block.field_149771_c.func_82594_a((Object)pipeBlockName);
        this.pipeType = ((Enum[])this.pipeBlock.getPipeTypeClass().getEnumConstants())[tag.func_74762_e("PipeType")];
        this.material = (Material)Material.MATERIAL_REGISTRY.func_82594_a(tag.func_74779_i("PipeMaterial"));
        this.insulationColor = tag.func_74762_e("InsulationColor");
        this.activeConnections = tag.func_74762_e("ActiveConnections");
        this.blockedConnectionsMap.clear();
        NBTTagCompound blockedConnectionsTag = tag.func_74775_l("BlockedConnectionsMap");
        for (String attachmentTypeKey : blockedConnectionsTag.func_150296_c()) {
            int attachmentType = Integer.parseInt(attachmentTypeKey);
            int blockedConnections = blockedConnectionsTag.func_74762_e(attachmentTypeKey);
            this.blockedConnectionsMap.put(attachmentType, blockedConnections);
        }
        if (tag.func_74764_b("BlockedConnections")) {
            int blockedConnections = tag.func_74762_e("BlockedConnections");
            this.blockedConnectionsMap.put(AttachmentType.MULTIPART.ordinal(), blockedConnections);
        }
        this.recomputeBlockedConnections();
        this.getCoverableImplementation().writeToNBT(tag);
        this.reinitializeShape();
    }

    public void writeDesc(MCDataOutput packet) {
        packet.writeVarInt(Block.field_149771_c.func_148757_b(this.pipeBlock));
        packet.writeEnum(this.pipeType);
        packet.writeVarInt(Material.MATERIAL_REGISTRY.getIDForObject(this.material));
        packet.writeInt(this.insulationColor);
        packet.writeVarInt(this.activeConnections);
        packet.writeVarInt(this.blockedConnections);
        PacketBuffer packetBuffer = new PacketBuffer(Unpooled.buffer());
        this.getCoverableImplementation().writeInitialSyncData(packetBuffer);
        byte[] dataArray = packetBuffer.array();
        packet.writeVarInt(dataArray.length);
        packet.writeArray(dataArray);
    }

    public void readDesc(MCDataInput packet) {
        this.pipeBlock = (BlockPipe)Block.field_149771_c.func_148754_a(packet.readVarInt());
        this.pipeType = packet.readEnum(this.pipeBlock.getPipeTypeClass());
        this.material = Material.MATERIAL_REGISTRY.getObjectById(packet.readVarInt());
        this.insulationColor = packet.readInt();
        this.activeConnections = packet.readVarInt();
        this.blockedConnections = packet.readVarInt();
        byte[] dataArray = packet.readArray(packet.readVarInt());
        this.getCoverableImplementation().readInitialSyncData(new PacketBuffer(Unpooled.wrappedBuffer((byte[])dataArray)));
        this.reinitializeShape();
    }

    public void read(MCDataInput packet) {
        byte packetType = packet.readByte();
        if (packetType == 0) {
            this.readDesc(packet);
        } else if (packetType == 1) {
            this.updateActualConnections();
        } else if (packetType == 2) {
            int dataId = packet.readVarInt();
            byte[] payload = packet.readArray(packet.readVarInt());
            PacketBuffer buffer = new PacketBuffer(Unpooled.wrappedBuffer((byte[])payload));
            this.getCoverableImplementation().readCustomData(dataId, buffer);
        } else if (packetType == 3) {
            this.blockedConnections = packet.readVarInt();
        }
        this.tile().markRender();
    }

    @Override
    public void writeCoverCustomData(int id, Consumer<PacketBuffer> writer) {
        MCDataOutput writeStream = this.getWriteStream();
        writeStream.writeByte(2);
        writeStream.writeVarInt(id);
        PacketBuffer packetBuffer = new PacketBuffer(Unpooled.buffer());
        writer.accept(packetBuffer);
        byte[] dataArray = packetBuffer.array();
        writeStream.writeVarInt(dataArray.length);
        writeStream.writeArray(dataArray);
    }

    public Iterable<IndexedCuboid6> getSubParts() {
        ArrayList<IndexedCuboid6> result = new ArrayList<IndexedCuboid6>();
        result.add(new IndexedCuboid6(null, this.centerBox));
        for (Cuboid6 sidedBox : this.sidedConnections) {
            result.add(new IndexedCuboid6(null, sidedBox));
        }
        this.getCoverableImplementation().addCoverCollisionBoundingBox(result, false);
        return result;
    }

    public Iterable<Cuboid6> getCollisionBoxes() {
        ArrayList<Cuboid6> result = new ArrayList<Cuboid6>();
        result.add(this.centerBox);
        result.addAll(this.sidedConnections);
        this.getCoverableImplementation().addCoverCollisionBoundingBox(result, false);
        return result;
    }

    public Iterable<Cuboid6> getOcclusionBoxes() {
        ArrayList<Cuboid6> result = new ArrayList<Cuboid6>();
        result.add(this.centerBox);
        this.getCoverableImplementation().addCoverCollisionBoundingBox(result, true);
        return result;
    }

    public Iterable<Cuboid6> getPartialOcclusionBoxes() {
        ArrayList<Cuboid6> result = new ArrayList<Cuboid6>(this.sidedConnections);
        this.getCoverableImplementation().addCoverCollisionBoundingBox(result, false);
        return result;
    }

    public boolean allowCompleteOcclusion() {
        return true;
    }

    @Override
    public void notifyBlockUpdate() {
        this.tile().notifyTileChange();
        this.updateActiveNodeStatus();
        this.updateActualConnections();
        if (!this.world().field_72995_K) {
            this.getWriteStream().writeByte(1);
            this.updateActiveNodeStatus();
        }
    }

    @Override
    public void scheduleChunkForRenderUpdate() {
        this.tile().markRender();
    }

    @Override
    public boolean isValidTile() {
        return this.tile() != null && !this.tile().func_145837_r();
    }

    @Override
    public void markAsDirty() {
        this.tile().func_70296_d();
    }

    @SideOnly(value=Side.CLIENT)
    public void renderBreaking(Vector3 pos, TextureAtlasSprite texture, CCRenderState ccrs) {
        ccrs.setPipeline(new IVertexOperation[]{pos.translation(), new IconTransformation(texture)});
        BlockRenderer.renderCuboid((CCRenderState)ccrs, (Cuboid6)this.centerBox, (int)0);
        for (Cuboid6 sidedConnection : this.sidedConnections) {
            BlockRenderer.renderCuboid((CCRenderState)ccrs, (Cuboid6)sidedConnection, (int)0);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public abstract Pair<TextureAtlasSprite, Integer> getParticleTexture();

    public void addHitEffects(CuboidRayTraceResult hit, ParticleManager manager) {
        Pair<TextureAtlasSprite, Integer> atlasSprite = this.getParticleTexture();
        ParticleHandlerUtil.addHitEffects(this.world(), hit, (TextureAtlasSprite)atlasSprite.getLeft(), (Integer)atlasSprite.getRight(), manager);
    }

    public void addDestroyEffects(CuboidRayTraceResult hit, ParticleManager manager) {
        Pair<TextureAtlasSprite, Integer> atlasSprite = this.getParticleTexture();
        ParticleHandlerUtil.addBlockDestroyEffects(this.world(), hit, (TextureAtlasSprite)atlasSprite.getLeft(), (int)((Integer)atlasSprite.getRight()), manager);
    }
}

