/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.multipart;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.Translation;
import codechicken.lib.vec.Vector3;
import gregtech.api.capability.GregtechCapabilities;
import gregtech.api.pipenet.tile.IPipeTile;
import gregtech.common.multipart.CableMultiPartTickable;
import gregtech.common.multipart.GTMultipartFactory;
import gregtech.common.multipart.PipeMultiPart;
import gregtech.common.pipelike.cable.Insulation;
import gregtech.common.pipelike.cable.WireProperties;
import gregtech.common.pipelike.cable.tile.CableEnergyContainer;
import gregtech.common.render.CableRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

public class CableMultiPart
extends PipeMultiPart<Insulation, WireProperties> {
    private CableEnergyContainer energyContainer;

    CableMultiPart() {
    }

    public CableMultiPart(IPipeTile<Insulation, WireProperties> sourceTile) {
        super(sourceTile);
    }

    public ResourceLocation getType() {
        return GTMultipartFactory.CABLE_PART_KEY;
    }

    @Override
    protected PipeMultiPart<Insulation, WireProperties> toTickablePart() {
        return new CableMultiPartTickable(this);
    }

    @Override
    public boolean supportsTicking() {
        return false;
    }

    public CableEnergyContainer getEnergyContainer() {
        if (this.energyContainer == null) {
            this.energyContainer = new CableEnergyContainer(this);
        }
        return this.energyContainer;
    }

    @Override
    public <T> T getCapabilityInternal(Capability<T> capability, EnumFacing facing) {
        if (capability == GregtechCapabilities.CAPABILITY_ENERGY_CONTAINER) {
            return (T)this.getEnergyContainer();
        }
        return super.getCapabilityInternal(capability, facing);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean renderStatic(Vector3 pos, BlockRenderLayer layer, CCRenderState ccrs) {
        if (MinecraftForgeClient.getRenderLayer() == BlockRenderLayer.CUTOUT) {
            CableRenderer.INSTANCE.renderCableBlock(this.getPipeMaterial(), (Insulation)this.getPipeType(), this.getInsulationColor(), ccrs, new IVertexOperation[]{new Translation(pos)}, this.activeConnections);
            this.getCoverableImplementation().renderCovers(ccrs, new Matrix4().translate(pos));
            return true;
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Pair<TextureAtlasSprite, Integer> getParticleTexture() {
        return CableRenderer.INSTANCE.getParticleTexture(this);
    }
}

