/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.steam.boiler;

import gregtech.api.capability.impl.FilteredFluidHandler;
import gregtech.api.capability.impl.FluidTankList;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.widgets.TankWidget;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.MetaTileEntityHolder;
import gregtech.api.recipes.ModHandler;
import gregtech.api.render.Textures;
import gregtech.common.metatileentities.steam.boiler.SteamBoiler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;

public class SteamLavaBoiler
extends SteamBoiler {
    private FluidTank lavaFluidTank;
    public static final int LAVA_PER_OPERATION = 100;

    public SteamLavaBoiler(ResourceLocation metaTileEntityId, boolean isHighPressure) {
        super(metaTileEntityId, isHighPressure, Textures.LAVA_BOILER_OVERLAY, 100);
    }

    @Override
    public MetaTileEntity createMetaTileEntity(MetaTileEntityHolder holder) {
        return new SteamLavaBoiler(this.metaTileEntityId, this.isHighPressure);
    }

    @Override
    protected FluidTankList createImportFluidHandler() {
        FluidTankList superHandler = super.createImportFluidHandler();
        this.lavaFluidTank = new FilteredFluidHandler(16000).setFillPredicate(ModHandler::isLava);
        return new FluidTankList(false, superHandler, new IFluidTank[]{this.lavaFluidTank});
    }

    @Override
    protected void tryConsumeNewFuel() {
        if (this.lavaFluidTank.getFluidAmount() >= 100) {
            this.lavaFluidTank.drain(100, true);
            this.setFuelMaxBurnTime(100);
        }
    }

    @Override
    protected ModularUI createUI(EntityPlayer entityPlayer) {
        return this.createUITemplate(entityPlayer).widget(new TankWidget((IFluidTank)this.lavaFluidTank, 108, 17, 11, 55).setBackgroundTexture(this.getGuiTexture("bar_%s_empty"))).build(this.getHolder(), entityPlayer);
    }
}

