/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.electric;

import gregtech.api.capability.impl.RecipeLogicEnergy;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.MetaTileEntityHolder;
import gregtech.api.metatileentity.SimpleMachineMetaTileEntity;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.render.OrientedOverlayRenderer;
import gregtech.api.util.GTUtility;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class MetaTileEntityMacerator
extends SimpleMachineMetaTileEntity {
    private int outputAmount;

    public MetaTileEntityMacerator(ResourceLocation metaTileEntityId, RecipeMap<?> recipeMap, int outputAmount, OrientedOverlayRenderer renderer, int tier) {
        super(metaTileEntityId, recipeMap, renderer, tier);
        this.outputAmount = outputAmount;
        this.initializeInventory();
    }

    @Override
    protected RecipeLogicEnergy createWorkable(RecipeMap<?> recipeMap) {
        return new RecipeLogicEnergy(this, recipeMap, () -> this.energyContainer){

            @Override
            protected int getByproductChanceMultiplier(Recipe recipe) {
                int byproductChanceMultiplier = 1;
                byte tier = GTUtility.getTierByVoltage(this.getMaxVoltage());
                if (tier > 2) {
                    byproductChanceMultiplier = 1 << tier - 2;
                }
                return byproductChanceMultiplier;
            }
        };
    }

    @Override
    protected IItemHandlerModifiable createExportItemHandler() {
        return new ItemStackHandler(this.outputAmount);
    }

    @Override
    public MetaTileEntity createMetaTileEntity(MetaTileEntityHolder holder) {
        return new MetaTileEntityMacerator(this.metaTileEntityId, this.workable.recipeMap, this.outputAmount, this.renderer, this.getTier());
    }
}

