/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.items.behaviors;

import gregtech.api.capability.GregtechTileCapabilities;
import gregtech.api.cover.ICoverable;
import gregtech.api.items.metaitem.stats.IItemBehaviour;
import gregtech.api.util.GTUtility;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class CrowbarBehaviour
implements IItemBehaviour {
    private final int cost;

    public CrowbarBehaviour(int cost) {
        this.cost = cost;
    }

    @Override
    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos blockPos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        IBlockState blockState = world.func_180495_p(blockPos);
        if (GTUtility.doDamageItem(stack, this.cost, true)) {
            EnumFacing coverSide;
            if (blockState.func_177230_c() instanceof BlockRailBase) {
                if (world.field_72995_K) {
                    return EnumActionResult.SUCCESS;
                }
                if (player.func_70093_af()) {
                    if (this.tryBreakRailBlock(blockState, world, blockPos, player)) {
                        GTUtility.doDamageItem(stack, this.cost, false);
                        return EnumActionResult.SUCCESS;
                    }
                    return EnumActionResult.FAIL;
                }
                if (this.tryRotateRailBlock(blockState, world, blockPos)) {
                    GTUtility.doDamageItem(stack, this.cost, false);
                    return EnumActionResult.SUCCESS;
                }
                return EnumActionResult.FAIL;
            }
            TileEntity tileEntity = world.func_175625_s(blockPos);
            ICoverable coverable = tileEntity == null ? null : (ICoverable)tileEntity.getCapability(GregtechTileCapabilities.CAPABILITY_COVERABLE, null);
            EnumFacing enumFacing = coverSide = coverable == null ? null : ICoverable.rayTraceCoverableSide(coverable, player);
            if (coverSide != null && coverable.getCoverAtSide(coverSide) != null) {
                if (world.field_72995_K) {
                    return EnumActionResult.SUCCESS;
                }
                boolean result = coverable.removeCover(coverSide);
                GTUtility.doDamageItem(stack, this.cost, false);
                return result ? EnumActionResult.SUCCESS : EnumActionResult.PASS;
            }
        }
        return EnumActionResult.PASS;
    }

    private boolean tryBreakRailBlock(IBlockState blockState, World world, BlockPos blockPos, EntityPlayer player) {
        if (world.canMineBlockBody(player, blockPos) && blockState.func_177230_c().canHarvestBlock((IBlockAccess)world, blockPos, player)) {
            for (ItemStack drops : blockState.func_177230_c().getDrops((IBlockAccess)world, blockPos, blockState, 0)) {
                Block.func_180635_a((World)world, (BlockPos)blockPos, (ItemStack)drops);
            }
            blockState.func_177230_c().func_176206_d(world, blockPos, blockState);
            blockState.func_177230_c().func_176208_a(world, blockPos, blockState, player);
            blockState.func_177230_c().func_180663_b(world, blockPos, blockState);
            world.func_175698_g(blockPos);
            return true;
        }
        return false;
    }

    private boolean tryRotateRailBlock(IBlockState blockState, World world, BlockPos blockPos) {
        BlockRailBase blockRailBase = (BlockRailBase)blockState.func_177230_c();
        int rotation = ((BlockRailBase.EnumRailDirection)blockState.func_177229_b(blockRailBase.func_176560_l())).ordinal() + 1;
        if (rotation >= BlockRailBase.EnumRailDirection.values().length) {
            rotation = 0;
        }
        return world.func_175656_a(blockPos, blockState.func_177226_a(blockRailBase.func_176560_l(), (Comparable)BlockRailBase.EnumRailDirection.values()[rotation]));
    }
}

