/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers.filter;

import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.Widget;
import gregtech.api.gui.widgets.LabelWidget;
import gregtech.api.gui.widgets.SlotWidget;
import gregtech.api.util.IDirtyNotifiable;
import gregtech.common.covers.filter.AbstractItemFilter;
import gregtech.common.covers.filter.FilterTypeRegistry;
import gregtech.common.covers.filter.ItemFilterWrapper;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class ItemFilterContainer
implements INBTSerializable<NBTTagCompound> {
    private final IDirtyNotifiable dirtyNotifiable;
    private final ItemStackHandler filterInventory;
    private final ItemFilterWrapper filterWrapper;

    public ItemFilterContainer(IDirtyNotifiable dirtyNotifiable) {
        this.dirtyNotifiable = dirtyNotifiable;
        this.filterWrapper = new ItemFilterWrapper(dirtyNotifiable);
        this.filterInventory = new ItemStackHandler(1){

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return FilterTypeRegistry.getItemFilterForStack(stack) != null;
            }

            public int getSlotLimit(int slot) {
                return 1;
            }

            protected void onLoad() {
                ItemFilterContainer.this.onFilterSlotChange(false);
            }

            protected void onContentsChanged(int slot) {
                ItemFilterContainer.this.onFilterSlotChange(true);
            }
        };
    }

    public ItemStackHandler getFilterInventory() {
        return this.filterInventory;
    }

    public void initUI(int y, Consumer<Widget> widgetGroup) {
        widgetGroup.accept(new LabelWidget(10, y, "cover.conveyor.item_filter.title", new Object[0]));
        widgetGroup.accept(new SlotWidget((IItemHandlerModifiable)this.filterInventory, 0, 10, y + 15).setBackgroundTexture(GuiTextures.SLOT, GuiTextures.FILTER_SLOT_OVERLAY));
        this.filterWrapper.initUI(y + 15 + 18 + 5, widgetGroup);
    }

    protected void onFilterSlotChange(boolean notify) {
        ItemStack filterStack = this.filterInventory.getStackInSlot(0);
        AbstractItemFilter newItemFilter = FilterTypeRegistry.getItemFilterForStack(filterStack);
        AbstractItemFilter currentItemFilter = this.filterWrapper.getItemFilter();
        if (newItemFilter == null) {
            if (currentItemFilter != null) {
                this.filterWrapper.setItemFilter(null);
                this.filterWrapper.setBlacklistFilter(false);
                if (notify) {
                    this.filterWrapper.onFilterInstanceChange();
                }
            }
        } else if (currentItemFilter == null || newItemFilter.getClass() != currentItemFilter.getClass()) {
            this.filterWrapper.setItemFilter(newItemFilter);
            if (notify) {
                this.filterWrapper.onFilterInstanceChange();
            }
        }
    }

    public void setMaxStackSize(int maxStackSize) {
        this.filterWrapper.setMaxStackSize(maxStackSize);
    }

    public int getMaxMatchSlots() {
        return this.filterWrapper.getMaxMatchSlots();
    }

    public int getSlotStackSize(int slotIndex) {
        return this.filterWrapper.getSlotStackSize(slotIndex);
    }

    public int matchItemStack(ItemStack itemStack) {
        return this.filterWrapper.matchItemStack(itemStack);
    }

    public boolean testItemStack(ItemStack itemStack) {
        return this.matchItemStack(itemStack) >= 0;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tagCompound = new NBTTagCompound();
        tagCompound.func_74782_a("FilterInventory", (NBTBase)this.filterInventory.serializeNBT());
        tagCompound.func_74757_a("IsBlacklist", this.filterWrapper.isBlacklistFilter());
        tagCompound.func_74768_a("MaxStackSize", this.filterWrapper.getMaxStackSize());
        if (this.filterWrapper.getItemFilter() != null) {
            NBTTagCompound filterInventory = new NBTTagCompound();
            this.filterWrapper.getItemFilter().writeToNBT(filterInventory);
            tagCompound.func_74782_a("Filter", (NBTBase)filterInventory);
        }
        return tagCompound;
    }

    public void deserializeNBT(NBTTagCompound tagCompound) {
        this.filterInventory.deserializeNBT(tagCompound.func_74775_l("FilterInventory"));
        this.filterWrapper.setBlacklistFilter(tagCompound.func_74767_n("IsBlacklist"));
        if (tagCompound.func_74764_b("MaxStackSize")) {
            this.filterWrapper.setMaxStackSize(tagCompound.func_74762_e("MaxStackSize"));
        }
        if (this.filterWrapper.getItemFilter() != null) {
            if (tagCompound.func_74764_b("ItemFilter") || tagCompound.func_74764_b("OreDictionaryFilter")) {
                this.filterWrapper.getItemFilter().readFromNBT(tagCompound);
            } else {
                NBTTagCompound filterInventory = tagCompound.func_74775_l("Filter");
                this.filterWrapper.getItemFilter().readFromNBT(filterInventory);
            }
        }
    }
}

