/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers.filter;

import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.Widget;
import gregtech.api.gui.widgets.ToggleButtonWidget;
import gregtech.api.util.IDirtyNotifiable;
import gregtech.common.covers.filter.AbstractFluidFilter;
import gregtech.common.covers.filter.WidgetGroupFluidFilter;
import java.util.function.Consumer;
import net.minecraftforge.fluids.FluidStack;

public class FluidFilterWrapper {
    private final IDirtyNotifiable dirtyNotifiable;
    private boolean isBlacklistFilter = false;
    private AbstractFluidFilter currentFluidFilter;

    public FluidFilterWrapper(IDirtyNotifiable dirtyNotifiable) {
        this.dirtyNotifiable = dirtyNotifiable;
    }

    public void initUI(int y, Consumer<Widget> widgetGroup) {
        widgetGroup.accept(new ToggleButtonWidget(146, y, 20, 20, GuiTextures.BUTTON_BLACKLIST, this::isBlacklistFilter, this::setBlacklistFilter).setTooltipText("cover.filter.blacklist"));
        widgetGroup.accept(new WidgetGroupFluidFilter(y, this::getFluidFilter));
    }

    public void setFluidFilter(AbstractFluidFilter fluidFilter) {
        this.currentFluidFilter = fluidFilter;
        if (this.currentFluidFilter != null) {
            this.currentFluidFilter.setDirtyNotifiable(this.dirtyNotifiable);
        }
    }

    public AbstractFluidFilter getFluidFilter() {
        return this.currentFluidFilter;
    }

    public void onFilterInstanceChange() {
        this.dirtyNotifiable.markAsDirty();
    }

    public void setBlacklistFilter(boolean blacklistFilter) {
        this.isBlacklistFilter = blacklistFilter;
        this.dirtyNotifiable.markAsDirty();
    }

    public boolean isBlacklistFilter() {
        return this.isBlacklistFilter;
    }

    public boolean testFluidStack(FluidStack fluidStack) {
        boolean result = true;
        if (this.currentFluidFilter != null) {
            result = this.currentFluidFilter.testFluid(fluidStack);
        }
        if (this.isBlacklistFilter) {
            result = !result;
        }
        return result;
    }
}

