/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.unification.ore;

import com.google.common.base.Preconditions;
import gregtech.api.unification.material.MarkerMaterials;
import gregtech.api.unification.material.MaterialIconType;
import gregtech.api.unification.material.Materials;
import gregtech.api.unification.material.type.DustMaterial;
import gregtech.api.unification.material.type.GemMaterial;
import gregtech.api.unification.material.type.IngotMaterial;
import gregtech.api.unification.material.type.Material;
import gregtech.api.unification.material.type.SolidMaterial;
import gregtech.api.unification.ore.IOreRegistrationHandler;
import gregtech.api.unification.stack.MaterialStack;
import gregtech.api.util.GTUtility;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.Validate;

public enum OrePrefix {
    ore("Ores", -1L, null, MaterialIconType.ore, Flags.ENABLE_UNIFICATION | Flags.DISALLOW_RECYCLING, mat -> mat instanceof DustMaterial && mat.hasFlag(DustMaterial.MatFlags.GENERATE_ORE)),
    oreBlackgranite("Black Granite Ores", -1L, null, MaterialIconType.ore, Flags.ENABLE_UNIFICATION | Flags.DISALLOW_RECYCLING, mat -> mat instanceof DustMaterial && mat.hasFlag(DustMaterial.MatFlags.GENERATE_ORE)),
    oreRedgranite("Red Granite Ores", -1L, null, MaterialIconType.ore, Flags.ENABLE_UNIFICATION | Flags.DISALLOW_RECYCLING, mat -> mat instanceof DustMaterial && mat.hasFlag(DustMaterial.MatFlags.GENERATE_ORE)),
    oreMarble("Marble Ores", -1L, null, MaterialIconType.ore, Flags.ENABLE_UNIFICATION | Flags.DISALLOW_RECYCLING, mat -> mat instanceof DustMaterial && mat.hasFlag(DustMaterial.MatFlags.GENERATE_ORE)),
    oreBasalt("Basalt Ores", -1L, null, MaterialIconType.ore, Flags.ENABLE_UNIFICATION | Flags.DISALLOW_RECYCLING, mat -> mat instanceof DustMaterial && mat.hasFlag(DustMaterial.MatFlags.GENERATE_ORE)),
    oreSand("Sand Ores", -1L, null, MaterialIconType.ore, Flags.ENABLE_UNIFICATION | Flags.DISALLOW_RECYCLING, null),
    oreGravel("Gravel Ores", -1L, null, MaterialIconType.ore, Flags.ENABLE_UNIFICATION | Flags.DISALLOW_RECYCLING, null),
    oreNetherrack("Netherrack Ores", -1L, null, MaterialIconType.ore, Flags.ENABLE_UNIFICATION | Flags.DISALLOW_RECYCLING, mat -> mat instanceof DustMaterial && mat.hasFlag(DustMaterial.MatFlags.GENERATE_ORE)),
    oreEndstone("Endstone Ores", -1L, null, MaterialIconType.ore, Flags.ENABLE_UNIFICATION | Flags.DISALLOW_RECYCLING, mat -> mat instanceof DustMaterial && mat.hasFlag(DustMaterial.MatFlags.GENERATE_ORE)),
    crushedCentrifuged("Centrifuged Ores", -1L, null, MaterialIconType.crushedCentrifuged, Flags.ENABLE_UNIFICATION | Flags.DISALLOW_RECYCLING, mat -> mat instanceof DustMaterial && mat.hasFlag(DustMaterial.MatFlags.GENERATE_ORE)),
    crushedPurified("Purified Ores", -1L, null, MaterialIconType.crushedPurified, Flags.ENABLE_UNIFICATION | Flags.DISALLOW_RECYCLING, mat -> mat instanceof DustMaterial && mat.hasFlag(DustMaterial.MatFlags.GENERATE_ORE)),
    crushed("Crushed Ores", -1L, null, MaterialIconType.crushed, Flags.ENABLE_UNIFICATION | Flags.DISALLOW_RECYCLING, mat -> mat instanceof DustMaterial && mat.hasFlag(DustMaterial.MatFlags.GENERATE_ORE)),
    shard("Crystallised Shards", -1L, null, null, Flags.ENABLE_UNIFICATION | Flags.DISALLOW_RECYCLING, null),
    clump("Clumps", -1L, null, null, Flags.ENABLE_UNIFICATION | Flags.DISALLOW_RECYCLING, null),
    reduced("Reduced Gravels", -1L, null, null, Flags.ENABLE_UNIFICATION | Flags.DISALLOW_RECYCLING, null),
    crystalline("Crystallised Metals", -1L, null, null, Flags.ENABLE_UNIFICATION | Flags.DISALLOW_RECYCLING, null),
    cleanGravel("Clean Gravels", -1L, null, null, Flags.ENABLE_UNIFICATION | Flags.DISALLOW_RECYCLING, null),
    dirtyGravel("Dirty Gravels", -1L, null, null, Flags.ENABLE_UNIFICATION | Flags.DISALLOW_RECYCLING, null),
    ingotHot("Hot Ingots", 3628800L, null, MaterialIconType.ingotHot, Flags.ENABLE_UNIFICATION | Flags.DISALLOW_RECYCLING, mat -> mat instanceof IngotMaterial && ((IngotMaterial)mat).blastFurnaceTemperature > 1750),
    ingot("Ingots", 3628800L, null, MaterialIconType.ingot, Flags.ENABLE_UNIFICATION | Flags.DISALLOW_RECYCLING, mat -> mat instanceof IngotMaterial),
    gem("Gemstones", 3628800L, null, MaterialIconType.gem, Flags.ENABLE_UNIFICATION, mat -> mat instanceof GemMaterial),
    gemChipped("Chipped Gemstones", 907200L, null, MaterialIconType.gemChipped, Flags.ENABLE_UNIFICATION, mat -> mat instanceof GemMaterial),
    gemFlawed("Flawed Gemstones", 1814400L, null, MaterialIconType.gemFlawed, Flags.ENABLE_UNIFICATION, mat -> mat instanceof GemMaterial),
    gemFlawless("Flawless Gemstones", 7257600L, null, MaterialIconType.gemFlawless, Flags.ENABLE_UNIFICATION, mat -> mat instanceof GemMaterial),
    gemExquisite("Exquisite Gemstones", 14515200L, null, MaterialIconType.gemExquisite, Flags.ENABLE_UNIFICATION, mat -> mat instanceof GemMaterial),
    dustTiny("Tiny Dusts", 403200L, null, MaterialIconType.dustTiny, Flags.ENABLE_UNIFICATION | Flags.DISALLOW_RECYCLING, mat -> mat instanceof DustMaterial),
    dustSmall("Small Dusts", 907200L, null, MaterialIconType.dustSmall, Flags.ENABLE_UNIFICATION | Flags.DISALLOW_RECYCLING, mat -> mat instanceof DustMaterial),
    dustImpure("Impure Dusts", 3628800L, null, MaterialIconType.dustImpure, Flags.ENABLE_UNIFICATION | Flags.DISALLOW_RECYCLING, mat -> mat instanceof DustMaterial && mat.hasFlag(DustMaterial.MatFlags.GENERATE_ORE)),
    dustPure("Purified Dusts", 3628800L, null, MaterialIconType.dustPure, Flags.ENABLE_UNIFICATION | Flags.DISALLOW_RECYCLING, mat -> mat instanceof DustMaterial && mat.hasFlag(DustMaterial.MatFlags.GENERATE_ORE)),
    dust("Dusts", 3628800L, null, MaterialIconType.dust, Flags.ENABLE_UNIFICATION | Flags.DISALLOW_RECYCLING, mat -> mat instanceof DustMaterial),
    nugget("Nuggets", 403200L, null, MaterialIconType.nugget, Flags.ENABLE_UNIFICATION | Flags.DISALLOW_RECYCLING, mat -> mat instanceof IngotMaterial),
    plateDense("Dense Plates", 32659200L, null, MaterialIconType.plateDense, Flags.ENABLE_UNIFICATION, mat -> mat instanceof IngotMaterial && mat.hasFlag(DustMaterial.MatFlags.GENERATE_PLATE | IngotMaterial.MatFlags.GENERATE_DENSE) && !mat.hasFlag(DustMaterial.MatFlags.NO_SMASHING)),
    plate("Plates", 3628800L, null, MaterialIconType.plate, Flags.ENABLE_UNIFICATION, mat -> mat instanceof DustMaterial && mat.hasFlag(DustMaterial.MatFlags.GENERATE_PLATE)),
    compressed("Compressed Materials", 7257600L, null, null, Flags.ENABLE_UNIFICATION, null),
    foil("Foils", 907200L, null, MaterialIconType.foil, Flags.ENABLE_UNIFICATION, mat -> mat instanceof IngotMaterial && mat.hasFlag(IngotMaterial.MatFlags.GENERATE_FOIL)),
    stickLong("Long Sticks/Rods", 3628800L, null, MaterialIconType.stickLong, Flags.ENABLE_UNIFICATION, mat -> mat instanceof SolidMaterial && mat.hasFlag(SolidMaterial.MatFlags.GENERATE_LONG_ROD)),
    stick("Sticks/Rods", 1814400L, null, MaterialIconType.stick, Flags.ENABLE_UNIFICATION, mat -> mat instanceof SolidMaterial && mat.hasFlag(SolidMaterial.MatFlags.GENERATE_ROD)),
    bolt("Bolts", 453600L, null, MaterialIconType.bolt, Flags.ENABLE_UNIFICATION, mat -> mat instanceof SolidMaterial && mat.hasFlag(IngotMaterial.MatFlags.GENERATE_BOLT_SCREW)),
    screw("Screws", 403200L, null, MaterialIconType.screw, Flags.ENABLE_UNIFICATION, mat -> mat instanceof IngotMaterial && mat.hasFlag(IngotMaterial.MatFlags.GENERATE_BOLT_SCREW)),
    ring("Rings", 907200L, null, MaterialIconType.ring, Flags.ENABLE_UNIFICATION, mat -> mat instanceof SolidMaterial && mat.hasFlag(IngotMaterial.MatFlags.GENERATE_RING)),
    springSmall("Small Springs", 907200L, null, MaterialIconType.springSmall, Flags.ENABLE_UNIFICATION, mat -> mat instanceof IngotMaterial && mat.hasFlag(IngotMaterial.MatFlags.GENERATE_SPRING_SMALL) && !mat.hasFlag(DustMaterial.MatFlags.NO_SMASHING)),
    spring("Springs", 3628800L, null, MaterialIconType.spring, Flags.ENABLE_UNIFICATION, mat -> mat instanceof IngotMaterial && mat.hasFlag(IngotMaterial.MatFlags.GENERATE_SPRING) && !mat.hasFlag(DustMaterial.MatFlags.NO_SMASHING)),
    wireFine("Fine Wires", 453600L, null, MaterialIconType.wireFine, Flags.ENABLE_UNIFICATION, mat -> mat instanceof IngotMaterial && mat.hasFlag(IngotMaterial.MatFlags.GENERATE_FINE_WIRE)),
    rotor("Rotors", 15422400L, null, MaterialIconType.rotor, Flags.ENABLE_UNIFICATION, mat -> mat instanceof IngotMaterial && mat.hasFlag(IngotMaterial.MatFlags.GENERATE_ROTOR)),
    gearSmall("Small Gears", 3628800L, null, MaterialIconType.gearSmall, Flags.ENABLE_UNIFICATION, mat -> mat instanceof IngotMaterial && mat.hasFlag(IngotMaterial.MatFlags.GENERATE_SMALL_GEAR)),
    gear("Gears", 14515200L, null, MaterialIconType.gear, Flags.ENABLE_UNIFICATION, mat -> mat instanceof SolidMaterial && mat.hasFlag(SolidMaterial.MatFlags.GENERATE_GEAR)),
    lens("Lenses", 2721600L, null, MaterialIconType.lens, Flags.ENABLE_UNIFICATION, mat -> mat instanceof GemMaterial && mat.hasFlag(GemMaterial.MatFlags.GENERATE_LENSE)),
    toolHeadSword("Sword Blades", 7257600L, null, MaterialIconType.toolHeadSword, Flags.ENABLE_UNIFICATION, Conditions.isToolMaterial),
    toolHeadPickaxe("Pickaxe Heads", 10886400L, null, MaterialIconType.toolHeadPickaxe, Flags.ENABLE_UNIFICATION, Conditions.isToolMaterial),
    toolHeadShovel("Shovel Heads", 3628800L, null, MaterialIconType.toolHeadShovel, Flags.ENABLE_UNIFICATION, Conditions.isToolMaterial),
    toolHeadUniversalSpade("Universal Spade Heads", 3628800L, null, MaterialIconType.toolHeadUniversalSpade, Flags.ENABLE_UNIFICATION, Conditions.isToolMaterial),
    toolHeadAxe("Axe Heads", 10886400L, null, MaterialIconType.toolHeadAxe, Flags.ENABLE_UNIFICATION, Conditions.isToolMaterial),
    toolHeadHoe("Hoe Heads", 7257600L, null, MaterialIconType.toolHeadHoe, Flags.ENABLE_UNIFICATION, Conditions.isToolMaterial),
    toolHeadSense("Sense Blades", 10886400L, null, MaterialIconType.toolHeadSense, Flags.ENABLE_UNIFICATION, Conditions.isToolMaterial),
    toolHeadFile("File Heads", 7257600L, null, MaterialIconType.toolHeadFile, Flags.ENABLE_UNIFICATION, Conditions.isToolMaterial),
    toolHeadHammer("Hammer Heads", 21772800L, null, MaterialIconType.toolHeadHammer, Flags.ENABLE_UNIFICATION, Conditions.isToolMaterial),
    toolHeadSaw("Saw Blades", 7257600L, null, MaterialIconType.toolHeadSaw, Flags.ENABLE_UNIFICATION, Conditions.isToolMaterial),
    toolHeadBuzzSaw("Buzzsaw Blades", 14515200L, null, MaterialIconType.toolHeadBuzzSaw, Flags.ENABLE_UNIFICATION, Conditions.isToolMaterial),
    toolHeadScrewdriver("Screwdriver Tips", 3628800L, null, MaterialIconType.toolHeadScrewdriver, Flags.ENABLE_UNIFICATION, Conditions.isToolMaterial),
    toolHeadDrill("Drill Tips", 14515200L, null, MaterialIconType.toolHeadDrill, Flags.ENABLE_UNIFICATION, Conditions.isToolMaterial),
    toolHeadChainsaw("Chainsaw Tips", 7257600L, null, MaterialIconType.toolHeadChainsaw, Flags.ENABLE_UNIFICATION, Conditions.isToolMaterial),
    toolHeadWrench("Wrench Tips", 14515200L, null, MaterialIconType.toolHeadWrench, Flags.ENABLE_UNIFICATION, Conditions.isToolMaterial),
    turbineBlade("Turbine Blades", 18144000L, null, MaterialIconType.turbineBlade, Flags.ENABLE_UNIFICATION, Conditions.isToolMaterial),
    glass("Glasses", -1L, Materials.Glass, null, Flags.SELF_REFERENCING | Flags.DISALLOW_RECYCLING, null),
    paneGlass("Glass Panes", -1L, MarkerMaterials.Color.Colorless, null, Flags.SELF_REFERENCING | Flags.DISALLOW_RECYCLING, null),
    blockGlass("Glass Blocks", -1L, MarkerMaterials.Color.Colorless, null, Flags.SELF_REFERENCING | Flags.DISALLOW_RECYCLING, null),
    blockWool("Wool Blocks", -1L, MarkerMaterials.Color.Colorless, null, Flags.SELF_REFERENCING | Flags.DISALLOW_RECYCLING, null),
    block("Storage Blocks", 32659200L, null, MaterialIconType.block, Flags.ENABLE_UNIFICATION, null),
    log("Logs", -1L, null, null, Flags.DISALLOW_RECYCLING, null),
    plank("Planks", -1L, null, null, Flags.DISALLOW_RECYCLING, null),
    stone("Stones", -1L, Materials.Stone, null, Flags.SELF_REFERENCING | Flags.DISALLOW_RECYCLING, null),
    cobblestone("Cobblestones", -1L, Materials.Stone, null, Flags.SELF_REFERENCING | Flags.DISALLOW_RECYCLING, null),
    rock("Rocks", -1L, Materials.Stone, null, Flags.SELF_REFERENCING | Flags.DISALLOW_RECYCLING, null),
    stoneCobble("Cobblestones", -1L, Materials.Stone, null, Flags.SELF_REFERENCING | Flags.DISALLOW_RECYCLING, null),
    frameGt("Frame Boxes", 4989600L, null, null, Flags.ENABLE_UNIFICATION, material -> material instanceof IngotMaterial && material.hasFlag(SolidMaterial.MatFlags.GENERATE_ROD | DustMaterial.MatFlags.GENERATE_PLATE)),
    pipeTiny("Tiny Pipes", 1814400L, null, MaterialIconType.pipeTiny, Flags.ENABLE_UNIFICATION, null),
    pipeSmall("Small Pipes", 3628800L, null, MaterialIconType.pipeSmall, Flags.ENABLE_UNIFICATION, null),
    pipeMedium("Medium Pipes", 10886400L, null, MaterialIconType.pipeMedium, Flags.ENABLE_UNIFICATION, null),
    pipeLarge("Large pipes", 21772800L, null, MaterialIconType.pipeLarge, Flags.ENABLE_UNIFICATION, null),
    wireGtHex("Hex wires", 29030400L, null, null, Flags.ENABLE_UNIFICATION, null),
    wireGtOctal("Octal wires", 14515200L, null, null, Flags.ENABLE_UNIFICATION, null),
    wireGtQuadruple("Quadruple wires", 7257600L, null, null, Flags.ENABLE_UNIFICATION, null),
    wireGtDouble("Double wires", 3628800L, null, null, Flags.ENABLE_UNIFICATION, null),
    wireGtSingle("Single wires", 1814400L, null, null, Flags.ENABLE_UNIFICATION, null),
    cableGtHex("Hex cables", 29030400L, null, null, Flags.ENABLE_UNIFICATION, null),
    cableGtOctal("Octal cables", 14515200L, null, null, Flags.ENABLE_UNIFICATION, null),
    cableGtQuadruple("Quadruple cables", 7257600L, null, null, Flags.ENABLE_UNIFICATION, null),
    cableGtDouble("Double cables", 3628800L, null, null, Flags.ENABLE_UNIFICATION, null),
    cableGtSingle("Single cables", 1814400L, null, null, Flags.ENABLE_UNIFICATION, null),
    craftingLens("Crafting Ingredients", -1L, null, null, Flags.DISALLOW_RECYCLING, null),
    dye("Dyes", -1L, null, null, Flags.DISALLOW_RECYCLING, null),
    batterySingleUse("Single Use Batteries", -1L, null, null, Flags.DISALLOW_RECYCLING, null),
    battery("Reusable Batteries", -1L, null, null, Flags.DISALLOW_RECYCLING, null),
    circuit("Circuits", -1L, null, null, Flags.ENABLE_UNIFICATION | Flags.DISALLOW_RECYCLING, null),
    chipset("Chipsets", -1L, null, null, Flags.ENABLE_UNIFICATION | Flags.DISALLOW_RECYCLING, null);

    public final String categoryName;
    public final boolean isUnificationEnabled;
    public final boolean isSelfReferencing;
    public final boolean isRecyclingDisallowed;
    public final boolean isFluidContainer;
    @Nullable
    public final Predicate<Material> generationCondition;
    @Nullable
    public final MaterialIconType materialIconType;
    public final long materialAmount;
    @Nullable
    public Material materialType;
    private final List<IOreRegistrationHandler> oreProcessingHandlers = new ArrayList<IOreRegistrationHandler>();
    private final Set<Material> ignoredMaterials = new HashSet<Material>();
    private final Set<Material> generatedMaterials = new HashSet<Material>();
    private boolean isMarkerPrefix = false;
    public byte maxStackSize = (byte)64;
    public final List<MaterialStack> secondaryMaterials = new ArrayList<MaterialStack>();
    public float heatDamage = 0.0f;
    private static final ThreadLocal<OrePrefix> currentProcessingPrefix;
    private static final ThreadLocal<Material> currentMaterial;

    private static void excludeAllGems(Material material) {
        gem.setIgnored(material);
        gemChipped.setIgnored(material);
        gemFlawed.setIgnored(material);
        gemFlawless.setIgnored(material);
        gemExquisite.setIgnored(material);
    }

    private OrePrefix(String categoryName, long materialAmount, Material material, MaterialIconType materialIconType, long flags, Predicate<Material> condition) {
        this.categoryName = categoryName;
        this.materialAmount = materialAmount;
        this.isSelfReferencing = (flags & Flags.SELF_REFERENCING) != 0L;
        this.isUnificationEnabled = (flags & Flags.ENABLE_UNIFICATION) != 0L;
        this.isRecyclingDisallowed = (flags & Flags.DISALLOW_RECYCLING) != 0L;
        this.isFluidContainer = (flags & Flags.FLUID_CONTAINER) != 0L;
        this.materialIconType = materialIconType;
        this.generationCondition = condition;
        if (this.isSelfReferencing) {
            Preconditions.checkNotNull((Object)material, (Object)"Material is null for self-referencing OrePrefix");
            this.materialType = material;
        }
    }

    public void addSecondaryMaterial(MaterialStack secondaryMaterial) {
        Preconditions.checkNotNull((Object)secondaryMaterial, (Object)"secondaryMaterial");
        this.secondaryMaterials.add(secondaryMaterial);
    }

    public void setMarkerPrefix(boolean isMarkerPrefix) {
        this.isMarkerPrefix = isMarkerPrefix;
    }

    public long getMaterialAmount(Material material) {
        if (this == block) {
            if (material == Materials.Glowstone || material == Materials.NetherQuartz || material == Materials.Brick || material == Materials.Clay) {
                return 14515200L;
            }
            if (material == Materials.Glass || material == Materials.Ice || material == Materials.Obsidian) {
                return 3628800L;
            }
        }
        return this.materialAmount;
    }

    public static OrePrefix getPrefix(String prefixName) {
        return OrePrefix.getPrefix(prefixName, null);
    }

    public static OrePrefix getPrefix(String prefixName, @Nullable OrePrefix replacement) {
        try {
            return Enum.valueOf(OrePrefix.class, prefixName);
        }
        catch (IllegalArgumentException invalidPrefixName) {
            return replacement;
        }
    }

    public boolean doGenerateItem(Material material) {
        return !this.isSelfReferencing && this.generationCondition != null && !this.isIgnored(material) && this.generationCondition.test(material);
    }

    public boolean addProcessingHandler(IOreRegistrationHandler ... processingHandler) {
        Preconditions.checkNotNull((Object)processingHandler);
        Validate.noNullElements((Object[])processingHandler);
        return this.oreProcessingHandlers.addAll(Arrays.asList(processingHandler));
    }

    public <T extends Material> void addProcessingHandler(Class<T> materialFilter, BiConsumer<OrePrefix, T> handler) {
        this.addProcessingHandler((orePrefix, material) -> {
            if (materialFilter.isAssignableFrom(material.getClass())) {
                handler.accept(orePrefix, material);
            }
        });
    }

    public void processOreRegistration(@Nullable Material material) {
        if (this.isSelfReferencing && material == null) {
            material = this.materialType;
        }
        if (material != null) {
            this.generatedMaterials.add(material);
        }
    }

    public static void runMaterialHandlers() {
        for (OrePrefix orePrefix : OrePrefix.values()) {
            orePrefix.runGeneratedMaterialHandlers();
        }
    }

    public static OrePrefix getCurrentProcessingPrefix() {
        return currentProcessingPrefix.get();
    }

    public static Material getCurrentMaterial() {
        return currentMaterial.get();
    }

    private void runGeneratedMaterialHandlers() {
        currentProcessingPrefix.set(this);
        for (Material registeredMaterial : this.generatedMaterials) {
            currentMaterial.set(registeredMaterial);
            for (IOreRegistrationHandler registrationHandler : this.oreProcessingHandlers) {
                registrationHandler.processMaterial(this, registeredMaterial);
            }
            currentMaterial.set(null);
        }
        this.generatedMaterials.clear();
        currentProcessingPrefix.set(null);
    }

    @SideOnly(value=Side.CLIENT)
    public String getLocalNameForItem(Material material) {
        String specfiedUnlocalized = "item." + material.toString() + "." + this.name();
        if (I18n.func_188566_a((String)specfiedUnlocalized)) {
            return I18n.func_135052_a((String)specfiedUnlocalized, (Object[])new Object[0]);
        }
        String unlocalized = "item.material.oreprefix." + this.name();
        String matLocalized = material.getLocalizedName();
        String formatted = I18n.func_135052_a((String)unlocalized, (Object[])new Object[]{matLocalized});
        return formatted.equals(unlocalized) ? matLocalized : formatted;
    }

    public boolean isIgnored(Material material) {
        return this.ignoredMaterials.contains(material);
    }

    public void setIgnored(Material material) {
        this.ignoredMaterials.add(material);
    }

    public boolean isMarkerPrefix() {
        return this.isMarkerPrefix;
    }

    static {
        OrePrefix.ingotHot.heatDamage = 3.0f;
        OrePrefix.ingotHot.maxStackSize = (byte)16;
        OrePrefix.gemFlawless.maxStackSize = (byte)32;
        OrePrefix.gemExquisite.maxStackSize = (byte)16;
        OrePrefix.plateDense.maxStackSize = (byte)8;
        OrePrefix.rotor.maxStackSize = (byte)16;
        OrePrefix.gear.maxStackSize = (byte)16;
        OrePrefix.toolHeadSword.maxStackSize = (byte)16;
        OrePrefix.toolHeadPickaxe.maxStackSize = (byte)16;
        OrePrefix.toolHeadShovel.maxStackSize = (byte)16;
        OrePrefix.toolHeadUniversalSpade.maxStackSize = (byte)16;
        OrePrefix.toolHeadAxe.maxStackSize = (byte)16;
        OrePrefix.toolHeadHoe.maxStackSize = (byte)16;
        OrePrefix.toolHeadSense.maxStackSize = (byte)16;
        OrePrefix.toolHeadFile.maxStackSize = (byte)16;
        OrePrefix.toolHeadHammer.maxStackSize = (byte)16;
        OrePrefix.toolHeadSaw.maxStackSize = (byte)16;
        OrePrefix.toolHeadBuzzSaw.maxStackSize = (byte)16;
        OrePrefix.toolHeadScrewdriver.maxStackSize = (byte)16;
        OrePrefix.toolHeadDrill.maxStackSize = (byte)16;
        OrePrefix.toolHeadChainsaw.maxStackSize = (byte)16;
        OrePrefix.toolHeadWrench.maxStackSize = (byte)16;
        craftingLens.setMarkerPrefix(true);
        dye.setMarkerPrefix(true);
        batterySingleUse.setMarkerPrefix(true);
        battery.setMarkerPrefix(true);
        circuit.setMarkerPrefix(true);
        chipset.setMarkerPrefix(true);
        gem.setIgnored(Materials.Diamond);
        gem.setIgnored(Materials.Emerald);
        gem.setIgnored(Materials.Lapis);
        gem.setIgnored(Materials.NetherQuartz);
        gem.setIgnored(Materials.Coal);
        OrePrefix.excludeAllGems(Materials.Charcoal);
        OrePrefix.excludeAllGems(Materials.NetherStar);
        OrePrefix.excludeAllGems(Materials.EnderPearl);
        OrePrefix.excludeAllGems(Materials.EnderEye);
        OrePrefix.excludeAllGems(Materials.Flint);
        dust.setIgnored(Materials.Redstone);
        dust.setIgnored(Materials.Glowstone);
        dust.setIgnored(Materials.Gunpowder);
        dust.setIgnored(Materials.Sugar);
        dust.setIgnored(Materials.Blaze);
        stick.setIgnored(Materials.Wood);
        stick.setIgnored(Materials.Bone);
        stick.setIgnored(Materials.Blaze);
        stick.setIgnored(Materials.Paper);
        ingot.setIgnored(Materials.Iron);
        ingot.setIgnored(Materials.Gold);
        ingot.setIgnored(Materials.Wood);
        ingot.setIgnored(Materials.Paper);
        nugget.setIgnored(Materials.Wood);
        nugget.setIgnored(Materials.Gold);
        nugget.setIgnored(Materials.Paper);
        nugget.setIgnored(Materials.Iron);
        plate.setIgnored(Materials.Paper);
        block.setIgnored(Materials.Iron);
        block.setIgnored(Materials.Gold);
        block.setIgnored(Materials.Lapis);
        block.setIgnored(Materials.Emerald);
        block.setIgnored(Materials.Redstone);
        block.setIgnored(Materials.Diamond);
        block.setIgnored(Materials.Coal);
        block.setIgnored(Materials.Glass);
        block.setIgnored(Materials.Marble);
        block.setIgnored(Materials.GraniteRed);
        block.setIgnored(Materials.Stone);
        block.setIgnored(Materials.Glowstone);
        block.setIgnored(Materials.Endstone);
        block.setIgnored(Materials.Wheat);
        block.setIgnored(Materials.Oilsands);
        block.setIgnored(Materials.Wood);
        block.setIgnored(Materials.RawRubber);
        block.setIgnored(Materials.Clay);
        block.setIgnored(Materials.Brick);
        block.setIgnored(Materials.Bone);
        block.setIgnored(Materials.NetherQuartz);
        block.setIgnored(Materials.Ice);
        block.setIgnored(Materials.Netherrack);
        block.setIgnored(Materials.Concrete);
        block.setIgnored(Materials.Blaze);
        ore.addSecondaryMaterial(new MaterialStack(Materials.Stone, OrePrefix.dust.materialAmount));
        oreRedgranite.addSecondaryMaterial(new MaterialStack(Materials.GraniteRed, OrePrefix.dust.materialAmount));
        oreBlackgranite.addSecondaryMaterial(new MaterialStack(Materials.GraniteBlack, OrePrefix.dust.materialAmount));
        oreBasalt.addSecondaryMaterial(new MaterialStack(Materials.Basalt, OrePrefix.dust.materialAmount));
        oreMarble.addSecondaryMaterial(new MaterialStack(Materials.Marble, OrePrefix.dust.materialAmount));
        oreSand.addSecondaryMaterial(new MaterialStack(Materials.SiliconDioxide, OrePrefix.dustTiny.materialAmount));
        oreGravel.addSecondaryMaterial(new MaterialStack(Materials.Flint, OrePrefix.dustTiny.materialAmount));
        oreNetherrack.addSecondaryMaterial(new MaterialStack(Materials.Netherrack, OrePrefix.dust.materialAmount));
        oreEndstone.addSecondaryMaterial(new MaterialStack(Materials.Endstone, OrePrefix.dust.materialAmount));
        crushed.addSecondaryMaterial(new MaterialStack(Materials.Stone, OrePrefix.dust.materialAmount));
        toolHeadDrill.addSecondaryMaterial(new MaterialStack(Materials.Steel, OrePrefix.plate.materialAmount * 4L));
        toolHeadChainsaw.addSecondaryMaterial(new MaterialStack(Materials.Steel, OrePrefix.plate.materialAmount * 4L + OrePrefix.ring.materialAmount * 2L));
        toolHeadWrench.addSecondaryMaterial(new MaterialStack(Materials.Steel, OrePrefix.ring.materialAmount + OrePrefix.screw.materialAmount * 2L));
        currentProcessingPrefix = new ThreadLocal();
        currentMaterial = new ThreadLocal();
    }

    public static class Conditions {
        public static Predicate<Material> isToolMaterial = mat -> mat instanceof SolidMaterial && ((SolidMaterial)mat).toolDurability > 0;
    }

    public static class Flags {
        public static final long ENABLE_UNIFICATION = GTUtility.createFlag(0);
        public static final long SELF_REFERENCING = GTUtility.createFlag(1);
        public static final long FLUID_CONTAINER = GTUtility.createFlag(2);
        public static final long DISALLOW_RECYCLING = GTUtility.createFlag(3);
    }
}

