/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipes.machines;

import gregtech.api.recipes.CountableIngredient;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.recipes.builders.SimpleRecipeBuilder;
import gregtech.api.recipes.ingredients.NBTIngredient;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

public class RecipeMapFluidCanner
extends RecipeMap<SimpleRecipeBuilder> {
    public RecipeMapFluidCanner(String unlocalizedName, int minInputs, int maxInputs, int minOutputs, int maxOutputs, int minFluidInputs, int maxFluidInputs, int minFluidOutputs, int maxFluidOutputs, int amperage, SimpleRecipeBuilder defaultRecipe) {
        super(unlocalizedName, minInputs, maxInputs, minOutputs, maxOutputs, minFluidInputs, maxFluidInputs, minFluidOutputs, maxFluidOutputs, defaultRecipe);
    }

    @Override
    public boolean canInputFluidForce(Fluid fluid) {
        return true;
    }

    @Override
    @Nullable
    public Recipe findRecipe(long voltage, List<ItemStack> inputs, List<FluidStack> fluidInputs, int outputFluidTankCapacity) {
        Recipe recipe = super.findRecipe(voltage, inputs, fluidInputs, outputFluidTankCapacity);
        if (inputs.size() == 0 || inputs.get(0).func_190926_b() || recipe != null) {
            return recipe;
        }
        if (!inputs.get(0).hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) {
            return null;
        }
        ItemStack inputStack = inputs.get(0).func_77946_l();
        inputStack.func_190920_e(1);
        ItemStack fluidHandlerItemStack = inputStack.func_77946_l();
        IFluidHandlerItem fluidHandlerItem = (IFluidHandlerItem)fluidHandlerItemStack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
        if (fluidHandlerItem == null) {
            return null;
        }
        FluidStack containerFluid = fluidHandlerItem.drain(Integer.MAX_VALUE, true);
        if (containerFluid != null) {
            return ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)this.recipeBuilder()).inputs(new CountableIngredient(new NBTIngredient(inputStack), 1))).outputs(fluidHandlerItem.getContainer())).fluidOutputs(containerFluid)).duration(Math.max(16, containerFluid.amount / 64))).EUt(4)).build().getResult();
        }
        if (!fluidInputs.isEmpty() && fluidInputs.get(0) != null) {
            FluidStack inputFluid = fluidInputs.get(0).copy();
            inputFluid.amount = fluidHandlerItem.fill(inputFluid, true);
            if (inputFluid.amount > 0) {
                return ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)this.recipeBuilder()).inputs(new CountableIngredient(new NBTIngredient(inputStack), 1))).fluidInputs(inputFluid)).outputs(fluidHandlerItem.getContainer())).duration(Math.max(16, inputFluid.amount / 64))).EUt(4)).build().getResult();
            }
        }
        return null;
    }
}

