/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity.multiblock;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.ColourMultiplier;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.MetaTileEntityHolder;
import gregtech.api.metatileentity.multiblock.IMultiblockAbilityPart;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.multiblock.BlockPattern;
import gregtech.api.multiblock.BlockWorldState;
import gregtech.api.multiblock.IPatternCenterPredicate;
import gregtech.api.multiblock.PatternMatchContext;
import gregtech.api.render.ICubeRenderer;
import gregtech.api.util.GTUtility;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;

public abstract class MultiblockControllerBase
extends MetaTileEntity {
    protected BlockPattern structurePattern;
    private final Map<MultiblockAbility<Object>, List<Object>> multiblockAbilities = new HashMap<MultiblockAbility<Object>, List<Object>>();
    private final List<IMultiblockPart> multiblockParts = new ArrayList<IMultiblockPart>();
    private boolean structureFormed;

    public MultiblockControllerBase(ResourceLocation metaTileEntityId) {
        super(metaTileEntityId);
        this.reinitializeStructurePattern();
    }

    protected void reinitializeStructurePattern() {
        this.structurePattern = this.createStructurePattern();
    }

    @Override
    public void update() {
        super.update();
        if (!this.getWorld().field_72995_K) {
            if (this.getTimer() % 20L == 0L) {
                this.checkStructurePattern();
            }
            if (this.isStructureFormed()) {
                this.updateFormedValid();
            }
        }
    }

    protected abstract void updateFormedValid();

    protected abstract BlockPattern createStructurePattern();

    public abstract ICubeRenderer getBaseTexture(IMultiblockPart var1);

    public boolean shouldRenderOverlay(IMultiblockPart sourcePart) {
        return true;
    }

    public int getLightValue(IMultiblockPart sourcePart) {
        return 0;
    }

    protected boolean checkStructureComponents(List<IMultiblockPart> parts, Map<MultiblockAbility<Object>, List<Object>> abilities) {
        return true;
    }

    @Override
    public final int getLightValue() {
        return this.getLightValue(null);
    }

    public static Predicate<BlockWorldState> tilePredicate(BiFunction<BlockWorldState, MetaTileEntity, Boolean> predicate) {
        return blockWorldState -> {
            TileEntity tileEntity = blockWorldState.getTileEntity();
            if (!(tileEntity instanceof MetaTileEntityHolder)) {
                return false;
            }
            MetaTileEntity metaTileEntity = ((MetaTileEntityHolder)tileEntity).getMetaTileEntity();
            if (((Boolean)predicate.apply((BlockWorldState)blockWorldState, metaTileEntity)).booleanValue()) {
                if (metaTileEntity instanceof IMultiblockPart) {
                    Set partsFound = blockWorldState.getMatchContext().getOrCreate("MultiblockParts", HashSet::new);
                    partsFound.add((IMultiblockPart)((Object)metaTileEntity));
                }
                return true;
            }
            return false;
        };
    }

    public static Predicate<BlockWorldState> abilityPartPredicate(MultiblockAbility<?> ... allowedAbilities) {
        return MultiblockControllerBase.tilePredicate((state, tile) -> tile instanceof IMultiblockAbilityPart && ArrayUtils.contains((Object[])allowedAbilities, ((IMultiblockAbilityPart)((Object)tile)).getAbility()));
    }

    public static Predicate<BlockWorldState> partPredicate(Class<? extends IMultiblockPart> baseClass) {
        return MultiblockControllerBase.tilePredicate((state, tile) -> tile instanceof IMultiblockPart && baseClass.isAssignableFrom(tile.getClass()));
    }

    public static Predicate<BlockWorldState> statePredicate(IBlockState ... allowedStates) {
        return blockWorldState -> ArrayUtils.contains((Object[])allowedStates, (Object)blockWorldState.getBlockState());
    }

    public static Predicate<BlockWorldState> blockPredicate(Block ... block) {
        return blockWorldState -> ArrayUtils.contains((Object[])block, (Object)blockWorldState.getBlockState().func_177230_c());
    }

    public static Predicate<BlockWorldState> isAirPredicate() {
        return blockWorldState -> blockWorldState.getBlockState().func_177230_c().isAir(blockWorldState.getBlockState(), (IBlockAccess)blockWorldState.getWorld(), blockWorldState.getPos());
    }

    public IPatternCenterPredicate selfPredicate() {
        return BlockWorldState.wrap(MultiblockControllerBase.tilePredicate((state, tile) -> tile.metaTileEntityId.equals((Object)this.metaTileEntityId)));
    }

    public Predicate<BlockWorldState> countMatch(String key, Predicate<BlockWorldState> original) {
        return blockWorldState -> {
            if (original.test((BlockWorldState)blockWorldState)) {
                blockWorldState.getLayerContext().increment(key, 1);
                return true;
            }
            return false;
        };
    }

    @Override
    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        this.getBaseTexture(null).render(renderState, translation, (IVertexOperation[])ArrayUtils.add((Object[])pipeline, (Object)new ColourMultiplier(GTUtility.convertRGBtoOpaqueRGBA_CL(this.getPaintingColorForRendering()))));
    }

    @Override
    public Pair<TextureAtlasSprite, Integer> getParticleTexture() {
        return Pair.of((Object)this.getBaseTexture(null).getParticleSprite(), (Object)this.getPaintingColor());
    }

    protected void checkStructurePattern() {
        EnumFacing facing = this.getFrontFacing().func_176734_d();
        PatternMatchContext context = this.structurePattern.checkPatternAt(this.getWorld(), this.getPos(), facing);
        if (context != null && !this.structureFormed) {
            Set rawPartsSet = context.getOrCreate("MultiblockParts", HashSet::new);
            ArrayList<IMultiblockPart> parts = new ArrayList<IMultiblockPart>(rawPartsSet);
            parts.sort(Comparator.comparing(it -> ((MetaTileEntity)((Object)it)).getPos().hashCode()));
            for (IMultiblockPart part2 : parts) {
                if (!part2.isAttachedToMultiBlock()) continue;
                return;
            }
            HashMap<MultiblockAbility<Object>, List<Object>> abilities = new HashMap<MultiblockAbility<Object>, List<Object>>();
            for (IMultiblockPart multiblockPart : parts) {
                if (!(multiblockPart instanceof IMultiblockAbilityPart)) continue;
                IMultiblockAbilityPart abilityPart = (IMultiblockAbilityPart)multiblockPart;
                List abilityInstancesList = abilities.computeIfAbsent(abilityPart.getAbility(), k -> new ArrayList());
                abilityPart.registerAbilities(abilityInstancesList);
            }
            if (this.checkStructureComponents(parts, abilities)) {
                parts.forEach(part -> part.addToMultiBlock(this));
                this.multiblockParts.addAll(parts);
                this.multiblockAbilities.putAll(abilities);
                this.structureFormed = true;
                this.writeCustomData(400, buf -> buf.writeBoolean(true));
                this.formStructure(context);
            }
        } else if (context == null && this.structureFormed) {
            this.invalidateStructure();
        }
    }

    protected void formStructure(PatternMatchContext context) {
    }

    public void invalidateStructure() {
        this.multiblockParts.forEach(part -> part.removeFromMultiBlock(this));
        this.multiblockAbilities.clear();
        this.multiblockParts.clear();
        this.structureFormed = false;
        this.writeCustomData(400, buf -> buf.writeBoolean(false));
    }

    @Override
    public void onRemoval() {
        super.onRemoval();
        if (!this.getWorld().field_72995_K && this.structureFormed) {
            this.multiblockParts.forEach(part -> part.removeFromMultiBlock(this));
        }
    }

    public <T> List<T> getAbilities(MultiblockAbility<T> ability) {
        List rawList = this.multiblockAbilities.getOrDefault(ability, Collections.emptyList());
        return Collections.unmodifiableList(rawList);
    }

    public List<IMultiblockPart> getMultiblockParts() {
        return Collections.unmodifiableList(this.multiblockParts);
    }

    @Override
    public void writeInitialSyncData(PacketBuffer buf) {
        super.writeInitialSyncData(buf);
        buf.writeBoolean(this.structureFormed);
    }

    @Override
    public void receiveInitialSyncData(PacketBuffer buf) {
        super.receiveInitialSyncData(buf);
        this.structureFormed = buf.readBoolean();
    }

    @Override
    public void receiveCustomData(int dataId, PacketBuffer buf) {
        super.receiveCustomData(dataId, buf);
        if (dataId == 400) {
            this.structureFormed = buf.readBoolean();
        }
    }

    public boolean isStructureFormed() {
        return this.structureFormed;
    }
}

