/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.gui.widgets;

import gregtech.api.gui.IPositionedRectangularWidget;
import gregtech.api.gui.Widget;
import gregtech.api.util.MCGuiUtil;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TextFieldWidget
extends Widget
implements IPositionedRectangularWidget {
    @SideOnly(value=Side.CLIENT)
    protected GuiTextField textField;
    protected int maxStringLength = 32;
    protected Predicate<String> textValidator;
    protected final Supplier<String> textSupplier;
    protected final Consumer<String> textResponder;
    protected String currentString;

    public TextFieldWidget(int xPosition, int yPosition, int width, int height, boolean enableBackground, Supplier<String> textSupplier, Consumer<String> textResponder) {
        if (TextFieldWidget.isClientSide()) {
            FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
            this.textField = new GuiTextField(0, fontRenderer, xPosition, yPosition, width, height);
            this.textField.func_146205_d(true);
            this.textField.func_146185_a(enableBackground);
            this.textField.func_146203_f(this.maxStringLength);
            this.textField.func_175207_a(MCGuiUtil.createTextFieldResponder(this::onTextChanged));
        }
        this.textSupplier = textSupplier;
        this.textResponder = textResponder;
    }

    @Override
    public int getXPosition() {
        return this.textField.field_146209_f;
    }

    @Override
    public int getYPosition() {
        return this.textField.field_146210_g;
    }

    @Override
    public int getWidth() {
        return this.textField.field_146218_h;
    }

    @Override
    public int getHeight() {
        return this.textField.field_146219_i;
    }

    @Override
    public void drawInBackground(int mouseX, int mouseY) {
        super.drawInBackground(mouseX, mouseY);
        this.textField.func_146194_f();
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        return this.textField.func_146192_a(mouseX, mouseY, button);
    }

    @Override
    public boolean keyTyped(char charTyped, int keyCode) {
        return this.textField.func_146201_a(charTyped, keyCode);
    }

    @Override
    public void detectAndSendChanges() {
        super.detectAndSendChanges();
        if (!this.textSupplier.get().equals(this.currentString)) {
            this.currentString = this.textSupplier.get();
            this.writeUpdateInfo(1, buffer -> buffer.func_180714_a(this.currentString));
        }
    }

    @Override
    public void readUpdateInfo(int id, PacketBuffer buffer) {
        super.readUpdateInfo(id, buffer);
        if (id == 1) {
            this.currentString = buffer.func_150789_c(Short.MAX_VALUE);
            this.textField.func_146180_a(this.currentString);
        }
    }

    protected void onTextChanged(String newTextString) {
        if (this.textValidator.test(newTextString)) {
            this.writeClientAction(1, buffer -> buffer.func_180714_a(newTextString));
        }
    }

    @Override
    public void handleClientAction(int id, PacketBuffer buffer) {
        super.handleClientAction(id, buffer);
        if (id == 1) {
            String clientText = buffer.func_150789_c(Short.MAX_VALUE);
            if (this.textValidator.test(clientText = clientText.substring(0, Math.min(clientText.length(), this.maxStringLength)))) {
                this.currentString = clientText;
                this.textResponder.accept(clientText);
            }
        }
    }

    public TextFieldWidget setTextColor(int textColor) {
        if (TextFieldWidget.isClientSide()) {
            this.textField.func_146193_g(textColor);
        }
        return this;
    }

    public TextFieldWidget setMaxStringLength(int maxStringLength) {
        this.maxStringLength = maxStringLength;
        if (TextFieldWidget.isClientSide()) {
            this.textField.func_146203_f(maxStringLength);
        }
        return this;
    }

    public TextFieldWidget setValidator(Predicate<String> validator) {
        this.textValidator = validator;
        if (TextFieldWidget.isClientSide()) {
            this.textField.func_175205_a(validator::test);
        }
        return this;
    }

    private static boolean isClientSide() {
        return FMLCommonHandler.instance().getSide().isClient();
    }
}

