/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.gui.widgets;

import com.google.common.base.Preconditions;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.resources.TextureArea;
import gregtech.api.gui.widgets.AbstractPositionedRectangleWidget;
import gregtech.api.util.function.FloatConsumer;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.MathHelper;

public class SliderWidget
extends AbstractPositionedRectangleWidget {
    public static final BiFunction<String, Float, String> DEFAULT_TEXT_SUPPLIER = (name, value) -> I18n.func_135052_a((String)name, (Object[])new Object[]{value.intValue()});
    private int sliderWidth = 8;
    private TextureArea backgroundArea = GuiTextures.SLIDER_BACKGROUND;
    private TextureArea sliderIcon = GuiTextures.SLIDER_ICON;
    private BiFunction<String, Float, String> textSupplier = DEFAULT_TEXT_SUPPLIER;
    private int textColor = 0xFFFFFF;
    private final float min;
    private final float max;
    private final String name;
    private final FloatConsumer responder;
    private boolean isPositionSent;
    private String displayString;
    private float sliderPosition;
    public boolean isMouseDown;

    public SliderWidget(String name, int xPosition, int yPosition, int width, int height, float min, float max, float currentValue, FloatConsumer responder) {
        super(xPosition, yPosition, width, height);
        Preconditions.checkNotNull((Object)responder, (Object)"responder");
        Preconditions.checkNotNull((Object)name, (Object)"name");
        this.min = min;
        this.max = max;
        this.name = name;
        this.responder = responder;
        this.sliderPosition = (currentValue - min) / (max - min);
    }

    public SliderWidget setSliderIcon(@Nonnull TextureArea sliderIcon) {
        Preconditions.checkNotNull((Object)sliderIcon, (Object)"sliderIcon");
        this.sliderIcon = sliderIcon;
        return this;
    }

    public SliderWidget setBackground(@Nullable TextureArea background) {
        this.backgroundArea = background;
        return this;
    }

    public SliderWidget setSliderWidth(int sliderWidth) {
        this.sliderWidth = sliderWidth;
        return this;
    }

    public SliderWidget setTextColor(int textColor) {
        this.textColor = textColor;
        return this;
    }

    @Override
    public void detectAndSendChanges() {
        if (!this.isPositionSent) {
            this.writeUpdateInfo(1, buffer -> buffer.writeFloat(this.sliderPosition));
            this.isPositionSent = true;
        }
    }

    public float getSliderValue() {
        return this.min + (this.max - this.min) * this.sliderPosition;
    }

    protected String getDisplayString() {
        return this.textSupplier.apply(this.name, Float.valueOf(this.getSliderValue()));
    }

    @Override
    public void drawInBackground(int mouseX, int mouseY) {
        if (this.backgroundArea != null) {
            this.backgroundArea.draw(this.xPosition, this.yPosition, this.width, this.height);
        }
        if (this.displayString == null) {
            this.displayString = this.getDisplayString();
        }
        this.sliderIcon.draw(this.xPosition + (int)(this.sliderPosition * (float)(this.width - 8)), this.yPosition, this.sliderWidth, this.height);
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        fontRenderer.func_78276_b(this.displayString, this.xPosition + this.width / 2 - fontRenderer.func_78256_a(this.displayString) / 2, this.yPosition + this.height / 2 - fontRenderer.field_78288_b / 2, this.textColor);
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    public boolean mouseDragged(int mouseX, int mouseY, int button, long timeDragged) {
        if (this.isMouseDown) {
            this.sliderPosition = (float)(mouseX - (this.xPosition + 4)) / (float)(this.width - 8);
            if (this.sliderPosition < 0.0f) {
                this.sliderPosition = 0.0f;
            }
            if (this.sliderPosition > 1.0f) {
                this.sliderPosition = 1.0f;
            }
            this.displayString = this.getDisplayString();
            this.writeClientAction(1, buffer -> buffer.writeFloat(this.sliderPosition));
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        if (SliderWidget.isMouseOver(this.xPosition, this.yPosition, this.width, this.height, mouseX, mouseY)) {
            this.sliderPosition = (float)(mouseX - (this.xPosition + 4)) / (float)(this.width - 8);
            if (this.sliderPosition < 0.0f) {
                this.sliderPosition = 0.0f;
            }
            if (this.sliderPosition > 1.0f) {
                this.sliderPosition = 1.0f;
            }
            this.displayString = this.getDisplayString();
            this.isMouseDown = true;
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseReleased(int mouseX, int mouseY, int button) {
        this.isMouseDown = false;
        return false;
    }

    @Override
    public void handleClientAction(int id, PacketBuffer buffer) {
        if (id == 1) {
            this.sliderPosition = buffer.readFloat();
            this.sliderPosition = MathHelper.func_76131_a((float)this.sliderPosition, (float)0.0f, (float)1.0f);
            this.responder.apply(this.getSliderValue());
        }
    }

    @Override
    public void readUpdateInfo(int id, PacketBuffer buffer) {
        if (id == 1) {
            this.sliderPosition = buffer.readFloat();
            this.sliderPosition = MathHelper.func_76131_a((float)this.sliderPosition, (float)0.0f, (float)1.0f);
            this.displayString = this.getDisplayString();
        }
    }
}

