/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.gui.widgets;

import gregtech.api.gui.widgets.AbstractPositionedWidget;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.network.PacketBuffer;

public class SimpleTextWidget
extends AbstractPositionedWidget {
    protected String formatLocale;
    protected int color;
    protected Supplier<String> textSupplier;
    protected String lastText = "";

    public SimpleTextWidget(int xPosition, int yPosition, String formatLocale, int color, Supplier<String> textSupplier) {
        super(xPosition, yPosition);
        this.color = color;
        this.formatLocale = formatLocale;
        this.textSupplier = textSupplier;
    }

    public SimpleTextWidget(int xPosition, int yPosition, String formatLocale, Supplier<String> textSupplier) {
        this(xPosition, yPosition, formatLocale, 0x404040, textSupplier);
    }

    @Override
    public void drawInBackground(int mouseX, int mouseY) {
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        String text = this.formatLocale.isEmpty() ? (I18n.func_188566_a((String)this.lastText) ? I18n.func_135052_a((String)this.lastText, (Object[])new Object[0]) : this.lastText) : I18n.func_135052_a((String)this.formatLocale, (Object[])new Object[]{this.lastText});
        fontRenderer.func_78276_b(text, this.xPosition - fontRenderer.func_78256_a(text) / 2, this.yPosition - fontRenderer.field_78288_b / 2, this.color);
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    public void detectAndSendChanges() {
        if (!this.textSupplier.get().equals(this.lastText)) {
            this.lastText = this.textSupplier.get();
            this.writeUpdateInfo(1, buffer -> buffer.func_180714_a(this.lastText));
        }
    }

    @Override
    public void readUpdateInfo(int id, PacketBuffer buffer) {
        if (id == 1) {
            this.lastText = buffer.func_150789_c(Short.MAX_VALUE);
        }
    }
}

