/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.cover;

import codechicken.lib.raytracer.CuboidRayTraceResult;
import codechicken.lib.raytracer.IndexedCuboid6;
import codechicken.lib.raytracer.RayTracer;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.ColourMultiplier;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Vector3;
import gregtech.api.cover.CoverBehavior;
import gregtech.api.cover.CoverDefinition;
import gregtech.api.pipenet.block.BlockPipe;
import gregtech.api.render.Textures;
import gregtech.api.util.GTUtility;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public interface ICoverable {
    public static final Transformation REVERSE_HORIZONTAL_ROTATION = new Rotation(Math.PI, new Vector3(0.0, 1.0, 0.0)).at(Vector3.center);
    public static final Transformation REVERSE_VERTICAL_ROTATION = new Rotation(Math.PI, new Vector3(1.0, 0.0, 0.0)).at(Vector3.center);

    public World getWorld();

    public BlockPos getPos();

    public long getTimer();

    public void markDirty();

    public boolean isValid();

    public <T> T getCapability(Capability<T> var1, EnumFacing var2);

    public boolean placeCoverOnSide(EnumFacing var1, ItemStack var2, CoverDefinition var3);

    public boolean removeCover(EnumFacing var1);

    public boolean canPlaceCoverOnSide(EnumFacing var1);

    public CoverBehavior getCoverAtSide(EnumFacing var1);

    public void writeCoverData(CoverBehavior var1, int var2, Consumer<PacketBuffer> var3);

    public int getInputRedstoneSignal(EnumFacing var1, boolean var2);

    public ItemStack getStackForm();

    public double getCoverPlateThickness();

    public int getPaintingColor();

    public boolean shouldRenderBackSide();

    public void notifyBlockUpdate();

    public void scheduleRenderUpdate();

    @SideOnly(value=Side.CLIENT)
    default public void renderCovers(CCRenderState renderState, Matrix4 translation) {
        renderState.lightMatrix.locate((IBlockAccess)this.getWorld(), this.getPos());
        double coverPlateThickness = this.getCoverPlateThickness();
        IVertexOperation[] platePipeline = new IVertexOperation[]{new ColourMultiplier(GTUtility.convertRGBtoOpaqueRGBA_CL(this.getPaintingColor()))};
        IVertexOperation[] coverPipeline = new IVertexOperation[]{renderState.lightMatrix};
        for (EnumFacing sideFacing : EnumFacing.values()) {
            CoverBehavior coverBehavior = this.getCoverAtSide(sideFacing);
            if (coverBehavior == null) continue;
            Cuboid6 plateBox = ICoverable.getCoverPlateBox(sideFacing, coverPlateThickness, false);
            double coverOffset = ICoverable.getCoverOffset(sideFacing);
            if (coverPlateThickness > 0.0) {
                renderState.preRenderWorld((IBlockAccess)this.getWorld(), this.getPos());
                plateBox.expand(coverOffset);
                TextureAtlasSprite casingSide = coverBehavior.getPlateSprite();
                for (EnumFacing coverPlateSide : EnumFacing.field_82609_l) {
                    Textures.renderFace(renderState, translation, platePipeline, coverPlateSide, plateBox, casingSide);
                }
                plateBox.expand(-coverOffset);
            }
            plateBox.expand(coverOffset * 10.0);
            coverBehavior.renderCover(renderState, translation.copy(), coverPipeline, plateBox);
            if (coverPlateThickness != 0.0 || !this.shouldRenderBackSide()) continue;
            plateBox.expand(-coverOffset * -20.0);
            Matrix4 backTranslation = translation.copy();
            if (sideFacing.func_176740_k().func_176720_b()) {
                REVERSE_VERTICAL_ROTATION.apply(backTranslation);
            } else {
                REVERSE_HORIZONTAL_ROTATION.apply(backTranslation);
            }
            backTranslation.translate((double)(-sideFacing.func_82601_c()), (double)(-sideFacing.func_96559_d()), (double)(-sideFacing.func_82599_e()));
            coverBehavior.renderCover(renderState, backTranslation, coverPipeline, plateBox);
        }
    }

    default public void addCoverCollisionBoundingBox(List<? super IndexedCuboid6> collisionList, boolean offsetSide) {
        double plateThickness = this.getCoverPlateThickness();
        if (plateThickness > 0.0) {
            for (EnumFacing side : EnumFacing.field_82609_l) {
                double coverOffset = ICoverable.getCoverOffset(side);
                if (this.getCoverAtSide(side) == null) continue;
                Cuboid6 coverBox = ICoverable.getCoverPlateBox(side, plateThickness, offsetSide);
                coverBox.expand(coverOffset);
                CoverSideData coverSideData = new CoverSideData(side);
                collisionList.add((IndexedCuboid6)new IndexedCuboid6((Object)coverSideData, coverBox));
            }
        }
    }

    public static boolean doesCoverCollide(EnumFacing side, List<IndexedCuboid6> collisionBox, double plateThickness) {
        if (plateThickness > 0.0) {
            Cuboid6 coverPlateBox = ICoverable.getCoverPlateBox(side, plateThickness, false);
            for (Cuboid6 cuboid6 : collisionBox) {
                if (!cuboid6.intersects(coverPlateBox)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public static EnumFacing rayTraceCoverableSide(ICoverable coverable, EntityPlayer player) {
        RayTraceResult result = RayTracer.retraceBlock((World)coverable.getWorld(), (EntityPlayer)player, (BlockPos)coverable.getPos());
        if (result == null || result.field_72313_a != RayTraceResult.Type.BLOCK) {
            return null;
        }
        return ICoverable.traceCoverSide(result);
    }

    public static EnumFacing traceCoverSide(RayTraceResult result) {
        if (result instanceof CuboidRayTraceResult) {
            CuboidRayTraceResult rayTraceResult = (CuboidRayTraceResult)result;
            if (rayTraceResult.cuboid6.data == null) {
                return ICoverable.determineGridSideHit(result);
            }
            if (rayTraceResult.cuboid6.data instanceof CoverSideData) {
                return ((CoverSideData)rayTraceResult.cuboid6.data).side;
            }
            if (rayTraceResult.cuboid6.data instanceof BlockPipe.PipeConnectionData) {
                return ((BlockPipe.PipeConnectionData)rayTraceResult.cuboid6.data).side;
            }
            if (rayTraceResult.cuboid6.data instanceof PrimaryBoxData) {
                PrimaryBoxData primaryBoxData = (PrimaryBoxData)rayTraceResult.cuboid6.data;
                return primaryBoxData.usePlacementGrid ? ICoverable.determineGridSideHit(result) : result.field_178784_b;
            }
            return null;
        }
        return ICoverable.determineGridSideHit(result);
    }

    public static EnumFacing determineGridSideHit(RayTraceResult result) {
        return GTUtility.determineWrenchingSide(result.field_178784_b, (float)(result.field_72307_f.field_72450_a - (double)result.func_178782_a().func_177958_n()), (float)(result.field_72307_f.field_72448_b - (double)result.func_178782_a().func_177956_o()), (float)(result.field_72307_f.field_72449_c - (double)result.func_178782_a().func_177952_p()));
    }

    public static Cuboid6 getCoverPlateBox(EnumFacing side, double plateThickness, boolean offsetSide) {
        double offset = offsetSide ? 0.15625 : 0.0;
        Cuboid6 coverPlateBox = new Cuboid6(offset, 0.0, offset, 1.0 - offset, plateThickness, 1.0 - offset);
        coverPlateBox.apply(Rotation.sideOrientation((int)side.func_176745_a(), (int)0).at(Vector3.center));
        return coverPlateBox;
    }

    public static double getCoverOffset(EnumFacing side) {
        EnumFacing.Axis axis = side.func_176740_k();
        double sideMultiplier = axis == EnumFacing.Axis.Y ? 3.0 : (double)(axis == EnumFacing.Axis.X ? 2 : 1);
        return sideMultiplier * 1.0E-4;
    }

    public static class CoverSideData {
        public final EnumFacing side;

        public CoverSideData(EnumFacing side) {
            this.side = side;
        }
    }

    public static class PrimaryBoxData {
        public final boolean usePlacementGrid;

        public PrimaryBoxData(boolean usePlacementGrid) {
            this.usePlacementGrid = usePlacementGrid;
        }
    }
}

