/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.block.machines;

import codechicken.lib.block.property.unlisted.UnlistedIntegerProperty;
import codechicken.lib.block.property.unlisted.UnlistedStringProperty;
import codechicken.lib.raytracer.CuboidRayTraceResult;
import codechicken.lib.raytracer.IndexedCuboid6;
import codechicken.lib.raytracer.RayTracer;
import codechicken.lib.vec.Cuboid6;
import com.google.common.collect.Lists;
import gregtech.api.GregTechAPI;
import gregtech.api.block.BlockCustomParticle;
import gregtech.api.capability.GregtechCapabilities;
import gregtech.api.capability.tool.IScrewdriverItem;
import gregtech.api.capability.tool.IWrenchItem;
import gregtech.api.cover.ICoverable;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.MetaTileEntityHolder;
import gregtech.api.render.MetaTileEntityRenderer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

public class BlockMachine
extends BlockCustomParticle
implements ITileEntityProvider {
    private static final List<IndexedCuboid6> EMPTY_COLLISION_BOX = Lists.newArrayList((Object[])new IndexedCuboid6[]{new IndexedCuboid6(null, Cuboid6.full)});
    private static final IUnlistedProperty<String> HARVEST_TOOL = new UnlistedStringProperty("harvest_tool");
    private static final IUnlistedProperty<Integer> HARVEST_LEVEL = new UnlistedIntegerProperty("harvest_level");
    public static final PropertyBool OPAQUE = PropertyBool.func_177716_a((String)"opaque");
    protected ThreadLocal<MetaTileEntity> tileEntities = new ThreadLocal();

    public BlockMachine() {
        super(Material.field_151573_f);
        this.func_149647_a(GregTechAPI.TAB_GREGTECH);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149711_c(6.0f);
        this.func_149752_b(6.0f);
        this.func_149663_c("unnamed");
        this.setHarvestLevel("wrench", 1);
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)OPAQUE, (Comparable)Boolean.valueOf(true)));
    }

    @Nullable
    public String getHarvestTool(IBlockState state) {
        return (String)((IExtendedBlockState)state).getValue(HARVEST_TOOL);
    }

    public int getHarvestLevel(IBlockState state) {
        Integer value = (Integer)((IExtendedBlockState)state).getValue(HARVEST_LEVEL);
        return value == null ? 0 : value;
    }

    public boolean func_176214_u(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)OPAQUE);
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        MetaTileEntity metaTileEntity = BlockMachine.getMetaTileEntity(worldIn, pos);
        if (metaTileEntity == null) {
            return state;
        }
        return ((IExtendedBlockState)state).withProperty(HARVEST_TOOL, (Object)metaTileEntity.getHarvestTool()).withProperty(HARVEST_LEVEL, (Object)metaTileEntity.getHarvestLevel());
    }

    protected BlockStateContainer func_180661_e() {
        return new ExtendedBlockState((Block)this, new IProperty[]{OPAQUE}, new IUnlistedProperty[]{HARVEST_TOOL, HARVEST_LEVEL});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)OPAQUE, (Comparable)Boolean.valueOf(meta % 2 == 0));
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)OPAQUE) != false ? 0 : 1;
    }

    public boolean canCreatureSpawn(IBlockState state, IBlockAccess world, BlockPos pos, EntityLiving.SpawnPlacementType type) {
        return false;
    }

    public static MetaTileEntity getMetaTileEntity(IBlockAccess blockAccess, BlockPos pos) {
        TileEntity holder = blockAccess.func_175625_s(pos);
        return holder instanceof MetaTileEntityHolder ? ((MetaTileEntityHolder)holder).getMetaTileEntity() : null;
    }

    private List<IndexedCuboid6> getCollisionBox(IBlockAccess blockAccess, BlockPos pos) {
        MetaTileEntity metaTileEntity = BlockMachine.getMetaTileEntity(blockAccess, pos);
        if (metaTileEntity == null) {
            return EMPTY_COLLISION_BOX;
        }
        ArrayList<IndexedCuboid6> collisionList = new ArrayList<IndexedCuboid6>();
        metaTileEntity.addCollisionBoundingBox(collisionList);
        metaTileEntity.addCoverCollisionBoundingBox(collisionList, false);
        return collisionList;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        MetaTileEntity metaTileEntity = BlockMachine.getMetaTileEntity((IBlockAccess)world, pos);
        if (metaTileEntity == null) {
            return ItemStack.field_190927_a;
        }
        if (target instanceof CuboidRayTraceResult) {
            return metaTileEntity.getPickItem((CuboidRayTraceResult)target, player);
        }
        return ItemStack.field_190927_a;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
        for (Cuboid6 cuboid6 : this.getCollisionBox((IBlockAccess)worldIn, pos)) {
            AxisAlignedBB offsetBox = cuboid6.aabb().func_186670_a(pos);
            if (!offsetBox.func_72326_a(entityBox)) continue;
            collidingBoxes.add(offsetBox);
        }
    }

    @Nullable
    public RayTraceResult func_180636_a(IBlockState blockState, World worldIn, BlockPos pos, Vec3d start, Vec3d end) {
        return RayTracer.rayTraceCuboidsClosest((Vec3d)start, (Vec3d)end, (BlockPos)pos, this.getCollisionBox((IBlockAccess)worldIn, pos));
    }

    public boolean rotateBlock(World world, BlockPos pos, EnumFacing axis) {
        MetaTileEntity metaTileEntity = BlockMachine.getMetaTileEntity((IBlockAccess)world, pos);
        if (metaTileEntity == null || !metaTileEntity.isValidFrontFacing(axis) || metaTileEntity.getFrontFacing() == axis || !metaTileEntity.hasFrontFacing()) {
            return false;
        }
        metaTileEntity.setFrontFacing(axis);
        return true;
    }

    @Nullable
    public EnumFacing[] getValidRotations(World world, BlockPos pos) {
        MetaTileEntity metaTileEntity = BlockMachine.getMetaTileEntity((IBlockAccess)world, pos);
        if (metaTileEntity == null || !metaTileEntity.hasFrontFacing()) {
            return null;
        }
        return (EnumFacing[])Arrays.stream(EnumFacing.field_82609_l).filter(metaTileEntity::isValidFrontFacing).toArray(EnumFacing[]::new);
    }

    public boolean recolorBlock(World world, BlockPos pos, EnumFacing side, EnumDyeColor color) {
        MetaTileEntity metaTileEntity = BlockMachine.getMetaTileEntity((IBlockAccess)world, pos);
        if (metaTileEntity == null || metaTileEntity.getPaintingColor() == color.field_193351_w) {
            return false;
        }
        metaTileEntity.setPaintingColor(color.field_193351_w);
        return true;
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        MetaTileEntityHolder holder = (MetaTileEntityHolder)worldIn.func_175625_s(pos);
        MetaTileEntity sampleMetaTileEntity = GregTechAPI.META_TILE_ENTITY_REGISTRY.getObjectById(stack.func_77952_i());
        if (holder != null && sampleMetaTileEntity != null) {
            EnumFacing placeFacing;
            MetaTileEntity metaTileEntity = holder.setMetaTileEntity(sampleMetaTileEntity);
            if (stack.func_77942_o()) {
                metaTileEntity.initFromItemStackData(stack.func_77978_p());
            }
            if (metaTileEntity.isValidFrontFacing(placeFacing = placer.func_174811_aO().func_176734_d())) {
                metaTileEntity.setFrontFacing(placeFacing);
            }
        }
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        MetaTileEntity metaTileEntity = BlockMachine.getMetaTileEntity((IBlockAccess)worldIn, pos);
        if (metaTileEntity != null) {
            NonNullList inventoryContents = NonNullList.func_191196_a();
            metaTileEntity.clearMachineInventory((NonNullList<ItemStack>)inventoryContents);
            for (ItemStack itemStack : inventoryContents) {
                Block.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)itemStack);
            }
            metaTileEntity.dropAllCovers();
            metaTileEntity.onRemoval();
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        MetaTileEntity metaTileEntity;
        MetaTileEntity metaTileEntity2 = metaTileEntity = this.tileEntities.get() == null ? BlockMachine.getMetaTileEntity(world, pos) : this.tileEntities.get();
        if (metaTileEntity == null) {
            return;
        }
        ItemStack itemStack = new ItemStack(Item.func_150898_a((Block)this), 1, GregTechAPI.META_TILE_ENTITY_REGISTRY.getIdByObjectName(metaTileEntity.metaTileEntityId));
        NBTTagCompound tagCompound = new NBTTagCompound();
        metaTileEntity.writeItemStackData(tagCompound);
        if (!tagCompound.func_82582_d()) {
            itemStack.func_77982_d(tagCompound);
        }
        drops.add((Object)itemStack);
        metaTileEntity.getDrops(drops, (EntityPlayer)this.harvesters.get());
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        MetaTileEntity metaTileEntity = BlockMachine.getMetaTileEntity((IBlockAccess)worldIn, pos);
        CuboidRayTraceResult rayTraceResult = (CuboidRayTraceResult)RayTracer.retraceBlock((World)worldIn, (EntityPlayer)playerIn, (BlockPos)pos);
        ItemStack itemStack = playerIn.func_184586_b(hand);
        if (metaTileEntity == null || rayTraceResult == null) {
            return false;
        }
        if (itemStack.hasCapability(GregtechCapabilities.CAPABILITY_SCREWDRIVER, null)) {
            IScrewdriverItem screwdriver = (IScrewdriverItem)itemStack.getCapability(GregtechCapabilities.CAPABILITY_SCREWDRIVER, null);
            if (screwdriver.damageItem(1, true) && metaTileEntity.onCoverScrewdriverClick(playerIn, hand, rayTraceResult)) {
                screwdriver.damageItem(1, false);
                return true;
            }
            return false;
        }
        if (itemStack.hasCapability(GregtechCapabilities.CAPABILITY_WRENCH, null)) {
            IWrenchItem wrenchItem = (IWrenchItem)itemStack.getCapability(GregtechCapabilities.CAPABILITY_WRENCH, null);
            EnumFacing wrenchDirection = ICoverable.determineGridSideHit((RayTraceResult)rayTraceResult);
            if (wrenchItem.damageItem(2, true) && metaTileEntity.onWrenchClick(playerIn, hand, wrenchDirection, rayTraceResult)) {
                wrenchItem.damageItem(1, false);
                return true;
            }
            return false;
        }
        return metaTileEntity.onCoverRightClick(playerIn, hand, rayTraceResult);
    }

    public void func_180649_a(World worldIn, BlockPos pos, EntityPlayer playerIn) {
        MetaTileEntity metaTileEntity = BlockMachine.getMetaTileEntity((IBlockAccess)worldIn, pos);
        if (metaTileEntity == null) {
            return;
        }
        CuboidRayTraceResult rayTraceResult = (CuboidRayTraceResult)RayTracer.retraceBlock((World)worldIn, (EntityPlayer)playerIn, (BlockPos)pos);
        if (rayTraceResult != null) {
            metaTileEntity.onCoverLeftClick(playerIn, rayTraceResult);
        }
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, @Nullable EnumFacing side) {
        MetaTileEntity metaTileEntity = BlockMachine.getMetaTileEntity(world, pos);
        return metaTileEntity != null && metaTileEntity.canConnectRedstone(side == null ? null : side.func_176734_d());
    }

    public boolean shouldCheckWeakPower(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }

    public int func_180656_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        MetaTileEntity metaTileEntity = BlockMachine.getMetaTileEntity(blockAccess, pos);
        return metaTileEntity == null ? 0 : metaTileEntity.getOutputRedstoneSignal(side == null ? null : side.func_176734_d());
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        MetaTileEntity metaTileEntity = BlockMachine.getMetaTileEntity((IBlockAccess)worldIn, pos);
        if (metaTileEntity != null) {
            metaTileEntity.updateInputRedstoneSignals();
        }
    }

    public int func_180641_l(IBlockState blockState, World worldIn, BlockPos pos) {
        MetaTileEntity metaTileEntity = BlockMachine.getMetaTileEntity((IBlockAccess)worldIn, pos);
        return metaTileEntity == null ? 0 : metaTileEntity.getComparatorValue();
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack stack) {
        this.tileEntities.set(te == null ? null : ((MetaTileEntityHolder)te).getMetaTileEntity());
        super.func_180657_a(worldIn, player, pos, state, te, stack);
        this.tileEntities.set(null);
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    @Nullable
    public MetaTileEntityHolder createNewTileEntity(@Nullable World worldIn, int meta) {
        return new MetaTileEntityHolder();
    }

    @SideOnly(value=Side.CLIENT)
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return MetaTileEntityRenderer.BLOCK_RENDER_TYPE;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public boolean func_149662_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)OPAQUE);
    }

    public boolean func_149686_d(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)OPAQUE);
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        MetaTileEntity metaTileEntity = BlockMachine.getMetaTileEntity(worldIn, pos);
        return metaTileEntity == null ? BlockFaceShape.SOLID : metaTileEntity.getCoverFaceShape(face);
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        MetaTileEntity metaTileEntity = BlockMachine.getMetaTileEntity(world, pos);
        return metaTileEntity == null ? 0 : metaTileEntity.getLightValue();
    }

    public int getLightOpacity(IBlockState state, IBlockAccess world, BlockPos pos) {
        MetaTileEntity metaTileEntity = BlockMachine.getMetaTileEntity(world, pos);
        return metaTileEntity == null ? 255 : metaTileEntity.getLightOpacity();
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        for (ResourceLocation metaTileEntityId : GregTechAPI.META_TILE_ENTITY_REGISTRY.func_148742_b()) {
            int metaId = GregTechAPI.META_TILE_ENTITY_REGISTRY.getIdByObjectName(metaTileEntityId);
            items.add((Object)new ItemStack((Block)this, 1, metaId));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected Pair<TextureAtlasSprite, Integer> getParticleTexture(World world, BlockPos blockPos) {
        return MetaTileEntityRenderer.INSTANCE.getParticleTexture((IBlockAccess)world, blockPos);
    }
}

