/*
 * Decompiled with CFR 0.152.
 */
package leviathan143.loottweaker.common.lib;

import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.stream.JsonWriter;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.api.data.DataMap;
import crafttweaker.api.data.IData;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import leviathan143.loottweaker.common.LootTweakerMain;
import leviathan143.loottweaker.common.darkmagic.CommonMethodHandles;
import leviathan143.loottweaker.common.zenscript.ZenLootConditionWrapper;
import leviathan143.loottweaker.common.zenscript.ZenLootFunctionWrapper;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraft.world.storage.loot.functions.SetCount;
import net.minecraft.world.storage.loot.functions.SetDamage;
import net.minecraft.world.storage.loot.functions.SetMetadata;
import net.minecraft.world.storage.loot.functions.SetNBT;

public class LootUtils {
    public static final LootCondition[] NO_CONDITIONS = new LootCondition[0];
    public static final LootEntry[] NO_ENTRIES = new LootEntry[0];
    public static final LootFunction[] NO_FUNCTIONS = new LootFunction[0];
    public static final LootPool[] NO_POOLS = new LootPool[0];

    public static void dump(World world, ResourceLocation tableLoc, File dumpTarget) {
        if (world.field_72995_K) {
            return;
        }
        LootTable table = world.func_184146_ak().func_186521_a(tableLoc);
        try {
            dumpTarget.getParentFile().mkdirs();
            dumpTarget.createNewFile();
            FileWriter writer = new FileWriter(dumpTarget);
            try {
                JsonWriter dumper = CommonMethodHandles.getLootTableGSON().newJsonWriter((Writer)writer);
                dumper.setIndent("  ");
                CommonMethodHandles.getLootTableGSON().toJson((Object)table, table.getClass(), dumper);
            }
            catch (Throwable t) {
                LootTweakerMain.logger.warn("Failed to dump loot table {}", (Object)tableLoc);
                t.printStackTrace();
            }
            writer.close();
            LootTweakerMain.logger.info(String.format("Loot table %s saved to %s", tableLoc, dumpTarget.getCanonicalPath()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static LootPool createTemporaryPool(String name) {
        return LootUtils.createPool(name, 0, 0, 0, 0);
    }

    public static LootPool createPool(String name, int minRolls, int maxRolls, int minBonusRolls, int maxBonusRolls) {
        return new LootPool(NO_ENTRIES, NO_CONDITIONS, new RandomValueRange((float)minRolls, (float)maxRolls), new RandomValueRange((float)minBonusRolls, (float)maxBonusRolls), name);
    }

    public static LootCondition[] parseConditions(Object[] conditions) {
        if (conditions == null) {
            return NO_CONDITIONS;
        }
        LootCondition[] parsedConditions = new LootCondition[conditions.length];
        for (int c = 0; c < conditions.length; ++c) {
            if (conditions[c] instanceof JsonElement) {
                parsedConditions[c] = LootUtils.parseJSONCondition((JsonElement)conditions[c]);
                continue;
            }
            if (conditions[c] instanceof ZenLootConditionWrapper) {
                parsedConditions[c] = ((ZenLootConditionWrapper)conditions[c]).condition;
                continue;
            }
            CraftTweakerAPI.logError((String)I18n.func_135052_a((String)"loottweaker.messages.error.unparseableType", (Object[])new Object[]{conditions[c]}));
        }
        return parsedConditions;
    }

    public static LootCondition parseJSONCondition(JsonElement conditionJSON) {
        return (LootCondition)CommonMethodHandles.getLootTableGSON().fromJson(conditionJSON, LootCondition.class);
    }

    public static LootFunction[] addStackFunctions(IItemStack iStack, LootFunction[] existingFunctions) {
        IData stackData;
        ItemStack stack = CraftTweakerMC.getItemStack((IItemStack)iStack);
        boolean sizeFuncExists = false;
        boolean damageFuncExists = false;
        boolean nbtFuncExists = false;
        for (LootFunction lootFunction : existingFunctions) {
            if (lootFunction instanceof SetCount) {
                sizeFuncExists = true;
            }
            if (lootFunction instanceof SetDamage || lootFunction instanceof SetMetadata) {
                damageFuncExists = true;
            }
            if (!(lootFunction instanceof SetNBT)) continue;
            nbtFuncExists = true;
        }
        int capacityRequired = existingFunctions.length + (sizeFuncExists ? 0 : 1) + (damageFuncExists ? 0 : 1) + (nbtFuncExists ? 0 : 1);
        ArrayList retList = Lists.newArrayListWithCapacity((int)capacityRequired);
        Collections.addAll(retList, existingFunctions);
        if (iStack.getAmount() > 1 && !sizeFuncExists) {
            retList.add(new SetCount(NO_CONDITIONS, new RandomValueRange((float)iStack.getAmount())));
        }
        if (iStack.getDamage() > 0 && !damageFuncExists) {
            if (stack.func_77984_f()) {
                retList.add(new SetDamage(NO_CONDITIONS, new RandomValueRange((float)stack.func_77952_i() / (float)stack.func_77958_k())));
            } else {
                retList.add(new SetMetadata(NO_CONDITIONS, new RandomValueRange((float)iStack.getDamage())));
            }
        }
        if ((stackData = iStack.getTag()) != DataMap.EMPTY && !nbtFuncExists) {
            retList.add(new SetNBT(NO_CONDITIONS, CraftTweakerMC.getNBTCompound((IData)stackData)));
        }
        return retList.toArray(NO_FUNCTIONS);
    }

    public static LootFunction[] parseFunctions(Object[] functions) {
        if (functions == null) {
            return NO_FUNCTIONS;
        }
        LootFunction[] parsedFunctions = new LootFunction[functions.length];
        for (int f = 0; f < functions.length; ++f) {
            if (functions[f] instanceof JsonElement) {
                parsedFunctions[f] = LootUtils.parseJSONFunction((JsonElement)functions[f]);
                continue;
            }
            if (functions[f] instanceof ZenLootFunctionWrapper) {
                parsedFunctions[f] = ((ZenLootFunctionWrapper)functions[f]).function;
                continue;
            }
            CraftTweakerAPI.logError((String)I18n.func_135052_a((String)"loottweaker.messages.error.unparseableType", (Object[])new Object[]{functions[f]}));
        }
        return parsedFunctions;
    }

    public static LootFunction parseJSONFunction(JsonElement functionJson) {
        return (LootFunction)CommonMethodHandles.getLootTableGSON().fromJson(functionJson, LootFunction.class);
    }
}

