/*
 * Decompiled with CFR 0.152.
 */
package thaumicperiphery;

import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Loader;
import thaumicperiphery.proxy.CommonProxy;

public class Config {
    public static final String CATEGORY_TWEAKS = "tweaks";
    public static final String CATEGORY_COMPAT = "compat";
    private static final List<String> PROPERTY_ORDER_TWEAKS = new ArrayList<String>();
    private static final List<String> PROPERTY_ORDER_COMPAT = new ArrayList<String>();
    public static boolean tcBaubleRenderer;
    public static boolean copperBrassRecipe;
    public static boolean emberCaster;
    public static boolean manaCaster;

    public static void readConfig() {
        Configuration cfg = CommonProxy.config;
        try {
            cfg.load();
            Config.initGeneralConfig(cfg);
        }
        catch (Exception exception) {
        }
        finally {
            if (cfg.hasChanged()) {
                cfg.save();
            }
        }
    }

    private static void initGeneralConfig(Configuration cfg) {
        cfg.addCustomCategoryComment(CATEGORY_TWEAKS, "Tweaks to existing Thaumcraft features");
        cfg.addCustomCategoryComment(CATEGORY_COMPAT, "Mod compatability options");
        tcBaubleRenderer = cfg.getBoolean("Thaumcraft Bauble Renderer", CATEGORY_TWEAKS, true, "Adds renderers to Thaumcraft's belts and amulets");
        copperBrassRecipe = cfg.getBoolean("Copper Brass Recipe", CATEGORY_TWEAKS, true, "Replaces iron with copper in the crucible recipe for alchemical brass");
        emberCaster = cfg.getBoolean("Ember Caster", CATEGORY_COMPAT, true, "Enables the caster's gauntlet that uses ember instead of vis") && Loader.isModLoaded((String)"embers");
        manaCaster = cfg.getBoolean("Mana Caster", CATEGORY_COMPAT, true, "Enables the caster's gauntlet that uses mana (from Botania) instead of vis") && Loader.isModLoaded((String)"botania");
        PROPERTY_ORDER_TWEAKS.add("Thaumcraft Bauble Renderer");
        PROPERTY_ORDER_TWEAKS.add("Copper Brass Recipe");
        PROPERTY_ORDER_COMPAT.add("Ember Caster");
        PROPERTY_ORDER_COMPAT.add("Mana Caster");
        cfg.setCategoryPropertyOrder(CATEGORY_TWEAKS, PROPERTY_ORDER_TWEAKS);
        cfg.setCategoryPropertyOrder(CATEGORY_COMPAT, PROPERTY_ORDER_COMPAT);
    }
}

