/*
 * Decompiled with CFR 0.152.
 */
package com.tictim.ceu.mte.trait.infinite;

import com.tictim.ceu.gui.InfiniteEnergyData;
import com.tictim.ceu.mte.MTEInfiniteEnergy;
import com.tictim.ceu.mte.trait.infinite.TraitInfiniteEnergy;
import com.tictim.ceu.util.Numbers;
import gregtech.api.GTValues;
import gregtech.api.capability.GregtechCapabilities;
import gregtech.api.capability.IEnergyContainer;
import gregtech.api.gui.IUIHolder;
import gregtech.api.gui.ModularUI;
import java.math.BigInteger;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;

public class TraitInfiniteGteuEmitter
extends TraitInfiniteEnergy.Emitter
implements IEnergyContainer {
    private int tier = 9;
    private long voltage = GTValues.V[9];

    public TraitInfiniteGteuEmitter(MTEInfiniteEnergy mte) {
        super(mte);
    }

    public int getTier() {
        return this.tier;
    }

    @Override
    public void setTier(int tier) {
        this.tier = tier;
        this.voltage = GTValues.V[this.tier];
    }

    public String getName() {
        return "infinite_gteu_emitter";
    }

    public int getNetworkID() {
        return 1;
    }

    public <T> T getCapability(Capability<T> capability) {
        return (T)((Object)(capability == GregtechCapabilities.CAPABILITY_ENERGY_CONTAINER ? this : null));
    }

    @Override
    public ModularUI createUI(IUIHolder holder, EntityPlayer player) {
        return new InfiniteEnergyData(this).guiBuilder().buttonInfinite().energyInput("EU").buttonVoltage().buttonAcceptDecline().createUI(holder, player);
    }

    @Override
    protected boolean send(EnumFacing facing) {
        long accepted;
        long voltage;
        long stored;
        IEnergyContainer s;
        TileEntity te = this.metaTileEntity.getWorld().func_175625_s(this.metaTileEntity.getPos().func_177972_a(facing));
        if (te != null && (s = (IEnergyContainer)te.getCapability(GregtechCapabilities.CAPABILITY_ENERGY_CONTAINER, facing.func_176734_d())) != null && s.inputsEnergy(facing.func_176734_d()) && (stored = this.getEnergyStored()) / (voltage = Math.min(this.voltage, s.getInputVoltage())) > 0L && (accepted = s.acceptEnergyFromNetwork(facing.func_176734_d(), voltage, Math.min(s.getInputAmperage(), stored / voltage)) * voltage) > 0L) {
            if (!this.isInfinite()) {
                this.subtract(BigInteger.valueOf(accepted));
            }
            return true;
        }
        return false;
    }

    public long acceptEnergyFromNetwork(EnumFacing side, long voltage, long amperage) {
        return 0L;
    }

    public boolean inputsEnergy(EnumFacing side) {
        return false;
    }

    public boolean outputsEnergy(EnumFacing side) {
        return !this.mte.isDisabled();
    }

    public long changeEnergy(long differenceAmount) {
        this.add(BigInteger.valueOf(differenceAmount));
        return differenceAmount;
    }

    public long getInputAmperage() {
        return 64L;
    }

    public long getInputVoltage() {
        return this.voltage;
    }

    public long getEnergyStored() {
        return this.isInfinite() ? Long.MAX_VALUE : Numbers.toLong(this.energy);
    }

    public long getEnergyCapacity() {
        return this.getEnergyStored();
    }

    @Override
    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = super.serializeNBT();
        nbt.func_74774_a("tier", (byte)this.tier);
        return nbt;
    }

    @Override
    public void deserializeNBT(NBTTagCompound nbt) {
        super.deserializeNBT(nbt);
        this.setTier(nbt.func_74771_c("tier"));
    }
}

