/*
 * Decompiled with CFR 0.152.
 */
package com.tictim.ceu.mte.trait.infinite;

import com.tictim.ceu.gui.InfiniteEnergyData;
import com.tictim.ceu.mte.MTEInfiniteEnergy;
import com.tictim.ceu.mte.trait.infinite.TraitInfiniteEnergy;
import com.tictim.ceu.util.Numbers;
import gregtech.api.gui.IUIHolder;
import gregtech.api.gui.ModularUI;
import java.math.BigInteger;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class TraitInfiniteFeReceiver
extends TraitInfiniteEnergy
implements IEnergyStorage {
    public TraitInfiniteFeReceiver(MTEInfiniteEnergy mte) {
        super(mte);
    }

    public String getName() {
        return "infinite_fe_receiver";
    }

    public int getNetworkID() {
        return 0;
    }

    public <T> T getCapability(Capability<T> capability) {
        return (T)((Object)(capability == CapabilityEnergy.ENERGY ? this : null));
    }

    @Override
    public ModularUI createUI(IUIHolder holder, EntityPlayer player) {
        return new InfiniteEnergyData(this).guiBuilder().energyInput("FE").buttonAcceptDecline().createUI(holder, player);
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        if (maxReceive <= 0 || this.mte.isDisabled()) {
            return 0;
        }
        if (!simulate) {
            this.add(BigInteger.valueOf(maxReceive));
        }
        return maxReceive;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return 0;
    }

    public int getEnergyStored() {
        return Numbers.toInt(this.energy);
    }

    public int getMaxEnergyStored() {
        return this.getEnergyStored();
    }

    public boolean canExtract() {
        return false;
    }

    public boolean canReceive() {
        return !this.mte.isDisabled();
    }
}

