/*
 * Decompiled with CFR 0.152.
 */
package com.tictim.ceu.gui;

import com.google.common.collect.ImmutableList;
import com.tictim.ceu.gui.EmptyTextureArea;
import com.tictim.ceu.gui.TextFieldWidgetInfiniteEnergy;
import com.tictim.ceu.mte.trait.infinite.TraitInfiniteEnergy;
import com.tictim.ceu.mte.trait.infinite.TraitInfiniteGteuEmitter;
import gregtech.api.GTValues;
import gregtech.api.gui.IUIHolder;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.Widget;
import gregtech.api.gui.resources.TextureArea;
import gregtech.api.gui.widgets.ClickButtonWidget;
import gregtech.api.gui.widgets.CycleButtonWidget;
import gregtech.api.gui.widgets.LabelWidget;
import gregtech.api.util.function.BooleanConsumer;
import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.client.config.GuiUtils;

public class InfiniteEnergyData
implements Supplier<String>,
Consumer<String>,
BooleanSupplier,
BooleanConsumer,
IntSupplier,
IntConsumer {
    private static final String[] INFINITE_OFF_ON = new String[]{"info.infinite_energy.finite", "info.infinite_energy.infinite"};
    private static final Pattern NUMBER_PATTERN = Pattern.compile("[0-9]*");
    private static final Predicate<String> NUMBER_PATTERN_VALIDATOR = s -> NUMBER_PATTERN.matcher((CharSequence)s).matches();
    private static final String[] TRANSLATABLE_VOLTAGE_NAMES;
    private final TraitInfiniteEnergy trait;
    private boolean isDirty;
    private String text;
    private int tier;
    private boolean isInfinite;

    public InfiniteEnergyData(TraitInfiniteEnergy trait) {
        this.trait = trait;
        this.text = trait.getEnergy().toString();
    }

    public InfiniteEnergyData(TraitInfiniteEnergy.Emitter trait) {
        this((TraitInfiniteEnergy)trait);
        this.isInfinite = trait.isInfinite();
    }

    public InfiniteEnergyData(TraitInfiniteGteuEmitter trait) {
        this((TraitInfiniteEnergy.Emitter)trait);
        this.tier = trait.getTier();
    }

    public InfiniteEnergyGuiBuilder guiBuilder() {
        return new InfiniteEnergyGuiBuilder();
    }

    public void markDirty(boolean isDirty) {
        this.isDirty = isDirty;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    @Override
    public String get() {
        return this.text;
    }

    @Override
    public void accept(String s) {
        this.markDirty(true);
        this.text = s;
    }

    @Override
    public boolean getAsBoolean() {
        return this.isInfinite;
    }

    public void apply(boolean value) {
        this.markDirty(true);
        this.isInfinite = value;
    }

    @Override
    public int getAsInt() {
        return this.tier;
    }

    @Override
    public void accept(int value) {
        this.markDirty(true);
        this.tier = value;
    }

    public static ModularUI createWIPScreen(IUIHolder holder, EntityPlayer player) {
        return new ModularUI.Builder((TextureArea)new EmptyTextureArea(300.0, 9.0), 300, 9).widget((Widget)new LabelWidget(150, 0, "This feature is still work in progress.", 0xFFFFFF).setXCentered(true)).build(holder, player);
    }

    static {
        ImmutableList.Builder b = new ImmutableList.Builder();
        for (int i = 0; i < GTValues.V.length; ++i) {
            b.add((Object)("info.infinite_energy." + GTValues.VN[i].toLowerCase()));
        }
        TRANSLATABLE_VOLTAGE_NAMES = (String[])b.build().toArray((Object[])new String[0]);
    }

    public class InfiniteEnergyGuiBuilder {
        private final ArrayDeque<Widget> widgets = new ArrayDeque();
        private int y;
        private boolean infinite;
        private boolean energy;
        private boolean tier;

        public InfiniteEnergyGuiBuilder buttonInfinite() {
            if (!this.widgets.isEmpty()) {
                this.y += 4;
            }
            this.widgets.add((Widget)new CycleButtonWidget(0, this.y, 200, 20, INFINITE_OFF_ON, () -> InfiniteEnergyData.this.getAsBoolean() ? 1 : 0, i -> InfiniteEnergyData.this.apply(i != 0)));
            this.y += 20;
            this.infinite = true;
            return this;
        }

        public InfiniteEnergyGuiBuilder energyInput(String labelText) {
            if (!this.widgets.isEmpty()) {
                this.y += 4;
            }
            this.widgets.add((Widget)new TextFieldWidgetInfiniteEnergy(2, this.y, 180, 12, true, InfiniteEnergyData.this).setValidator(NUMBER_PATTERN_VALIDATOR));
            this.widgets.add((Widget)new LabelWidget(188, this.y + 2, labelText, -1));
            this.y += 12;
            this.energy = true;
            return this;
        }

        public InfiniteEnergyGuiBuilder buttonVoltage() {
            if (!this.widgets.isEmpty()) {
                this.y += 4;
            }
            this.widgets.add((Widget)new CycleButtonWidget(0, this.y, 200, 20, TRANSLATABLE_VOLTAGE_NAMES, (IntSupplier)InfiniteEnergyData.this, (IntConsumer)InfiniteEnergyData.this));
            this.y += 20;
            this.tier = true;
            return this;
        }

        public InfiniteEnergyGuiBuilder buttonAcceptDecline() {
            if (!this.widgets.isEmpty()) {
                this.y += 16;
            }
            this.buttonClose(true);
            this.buttonClose(false);
            this.y += 20;
            return this;
        }

        private void buttonClose(final boolean setDirty) {
            this.widgets.add((Widget)new ClickButtonWidget(setDirty ? 0 : 102, this.y, 98, 20, setDirty ? "info.infinite_energy.accept" : "info.infinite_energy.decline", c -> InfiniteEnergyData.this.markDirty(setDirty)){

                public void handleClientAction(int id, PacketBuffer buffer) {
                    super.handleClientAction(id, buffer);
                    this.gui.entityPlayer.func_71053_j();
                }

                public void drawInForeground(int mouseX, int mouseY) {
                    if (1.isMouseOver((int)this.xPosition, (int)this.yPosition, (int)this.width, (int)this.height, (int)mouseX, (int)mouseY)) {
                        GuiUtils.drawHoveringText((List)new ImmutableList.Builder().add((Object)I18n.func_135052_a((String)(setDirty ? "info.button.accept" : "info.button.decline"), (Object[])new Object[0])).build(), (int)mouseX, (int)mouseY, (int)this.gui.getScreenWidth(), (int)this.gui.getScreenHeight(), (int)-1, (FontRenderer)Minecraft.func_71410_x().field_71466_p);
                    }
                }
            });
        }

        public ModularUI createUI(IUIHolder holder, EntityPlayer player) {
            ModularUI.Builder b = new ModularUI.Builder((TextureArea)new EmptyTextureArea(200.0, this.y), 200, this.y);
            for (Widget w : this.widgets) {
                b.widget(w);
            }
            return b.bindCloseListener(() -> {
                if (!player.field_70170_p.field_72995_K && InfiniteEnergyData.this.isDirty()) {
                    if (this.infinite) {
                        InfiniteEnergyData.this.trait.setInfinite(InfiniteEnergyData.this.getAsBoolean());
                    }
                    if (this.energy) {
                        InfiniteEnergyData.this.trait.setEnergy(InfiniteEnergyData.this.get().isEmpty() ? BigInteger.ZERO : new BigInteger(InfiniteEnergyData.this.get()));
                    }
                    if (this.tier) {
                        InfiniteEnergyData.this.trait.setTier(InfiniteEnergyData.this.getAsInt());
                    }
                }
            }).build(holder, player);
        }
    }
}

