/*
 * Decompiled with CFR 0.152.
 */
package com.tictim.ceu.enums;

import com.tictim.ceu.enums.NumberType;
import com.tictim.ceu.mte.MTECeu;
import com.tictim.ceu.mte.MTEInfiniteEnergy;
import com.tictim.ceu.mte.trait.TraitFeIn;
import com.tictim.ceu.mte.trait.TraitFeOut;
import com.tictim.ceu.mte.trait.TraitGteuIn;
import com.tictim.ceu.mte.trait.TraitGteuOut;
import com.tictim.ceu.mte.trait.TraitIc2EuIn;
import com.tictim.ceu.mte.trait.TraitIc2EuOut;
import com.tictim.ceu.mte.trait.charger.ChargeHandler;
import com.tictim.ceu.mte.trait.charger.ChargeHandlerFE;
import com.tictim.ceu.mte.trait.charger.ChargeHandlerIC2EU;
import com.tictim.ceu.mte.trait.infinite.TraitInfiniteEnergy;
import com.tictim.ceu.mte.trait.infinite.TraitInfiniteFeEmitter;
import com.tictim.ceu.mte.trait.infinite.TraitInfiniteFeReceiver;
import com.tictim.ceu.mte.trait.infinite.TraitInfiniteGteuEmitter;
import com.tictim.ceu.mte.trait.infinite.TraitInfiniteGteuReceiver;
import com.tictim.ceu.mte.trait.infinite.TraitInfiniteIc2euEmitter;
import com.tictim.ceu.mte.trait.infinite.TraitInfiniteIc2euReceiver;
import gregtech.api.capability.GregtechCapabilities;
import javax.annotation.Nullable;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;

public enum Energy {
    FE("fe", 4, NumberType.INTEGER){

        @Override
        public TraitInfiniteEnergy createInfiniteEnergyEmitterTrait(MTEInfiniteEnergy mte) {
            return new TraitInfiniteFeEmitter(mte);
        }

        @Override
        public TraitInfiniteEnergy createInfiniteEnergyReceiverTrait(MTEInfiniteEnergy mte) {
            return new TraitInfiniteFeReceiver(mte);
        }

        @Override
        public void createEnergyEmitterTrait(MTECeu ceu) {
            new TraitFeOut(ceu);
        }

        @Override
        public void createEnergyReceiverTrait(MTECeu ceu) {
            new TraitFeIn(ceu);
        }

        @Override
        public ChargeHandler createChargeHandler(MTECeu ceu) {
            return new ChargeHandlerFE(ceu);
        }
    }
    ,
    GTEU("gteu", 1, NumberType.LONG){

        @Override
        public TraitInfiniteEnergy createInfiniteEnergyEmitterTrait(MTEInfiniteEnergy mte) {
            return new TraitInfiniteGteuEmitter(mte);
        }

        @Override
        public TraitInfiniteEnergy createInfiniteEnergyReceiverTrait(MTEInfiniteEnergy mte) {
            return new TraitInfiniteGteuReceiver(mte);
        }

        @Override
        public void createEnergyEmitterTrait(MTECeu ceu) {
            new TraitGteuOut(ceu);
        }

        @Override
        public void createEnergyReceiverTrait(MTECeu ceu) {
            new TraitGteuIn(ceu);
        }

        @Override
        public ChargeHandler createChargeHandler(MTECeu ceu) {
            throw new UnsupportedOperationException("No ChargeHandler for GTEU!");
        }
    }
    ,
    IC2EU("ic2eu", 1, NumberType.DOUBLE){

        @Override
        public TraitInfiniteEnergy createInfiniteEnergyEmitterTrait(MTEInfiniteEnergy mte) {
            return new TraitInfiniteIc2euEmitter(mte);
        }

        @Override
        public TraitInfiniteEnergy createInfiniteEnergyReceiverTrait(MTEInfiniteEnergy mte) {
            return new TraitInfiniteIc2euReceiver(mte);
        }

        @Override
        public void createEnergyEmitterTrait(MTECeu ceu) {
            new TraitIc2EuOut(ceu);
        }

        @Override
        public void createEnergyReceiverTrait(MTECeu ceu) {
            new TraitIc2EuIn(ceu);
        }

        @Override
        public ChargeHandler createChargeHandler(MTECeu ceu) {
            return new ChargeHandlerIC2EU(ceu);
        }
    };

    private final String name;
    private final int defaultConversionRate;
    private final NumberType numberType;

    private Energy(String name, int defaultConversionRate, NumberType numberType) {
        this.name = name;
        this.defaultConversionRate = defaultConversionRate;
        this.numberType = numberType;
    }

    public String getName() {
        return I18n.func_74838_a((String)("ceu.energy." + this.name));
    }

    public String getSimpleName() {
        return I18n.func_74838_a((String)("ceu.energy.simple." + this.name));
    }

    public String getRawName() {
        return this.name;
    }

    public int getDefaultConversionRate() {
        return this.defaultConversionRate;
    }

    public NumberType getNumberType() {
        return this.numberType;
    }

    @Nullable
    public Capability<?> getCapability() {
        switch (this) {
            case FE: {
                return CapabilityEnergy.ENERGY;
            }
            case GTEU: {
                return GregtechCapabilities.CAPABILITY_ENERGY_CONTAINER;
            }
            case IC2EU: {
                return null;
            }
        }
        throw new IllegalArgumentException();
    }

    public abstract TraitInfiniteEnergy createInfiniteEnergyEmitterTrait(MTEInfiniteEnergy var1);

    public abstract TraitInfiniteEnergy createInfiniteEnergyReceiverTrait(MTEInfiniteEnergy var1);

    public abstract void createEnergyEmitterTrait(MTECeu var1);

    public abstract void createEnergyReceiverTrait(MTECeu var1);

    public abstract ChargeHandler createChargeHandler(MTECeu var1);

    public boolean isEmitterDisabledByDefault() {
        return this == IC2EU;
    }

    public boolean isReceiverDisabledByDefault() {
        return this == IC2EU;
    }

    public String toString() {
        return this.getName();
    }
}

