/*
 * Decompiled with CFR 0.152.
 */
package com.tictim.ceu.enums;

import com.tictim.ceu.config.CeuConfig;
import com.tictim.ceu.enums.ConverterType;
import com.tictim.ceu.enums.Energy;
import com.tictim.ceu.util.CeuCraftingHelper;
import com.tictim.ceu.util.Ratio;
import gregtech.api.items.OreDictNames;
import javax.annotation.Nullable;

public enum CeuType implements CeuCraftingHelper.RecipeFunction
{
    CEU(ConverterType.CEU_CEF, true){

        @Override
        public Object[] createRecipe(int tier, int slots) {
            return new Object[]{"WTW", "RMR", "WSW", Character.valueOf('M'), CeuCraftingHelper.HELPER.hull(tier), Character.valueOf('W'), CeuCraftingHelper.HELPER.cable(tier, slots), Character.valueOf('T'), OreDictNames.chestWood, Character.valueOf('R'), CeuCraftingHelper.HELPER.redCable(slots), Character.valueOf('S'), CeuCraftingHelper.HELPER.circuit(tier)};
        }
    }
    ,
    CEF(ConverterType.CEU_CEF, false){

        @Override
        public Object[] createRecipe(int tier, int slots) {
            return new Object[]{"WSW", "RMR", "WTW", Character.valueOf('M'), CeuCraftingHelper.HELPER.hull(tier), Character.valueOf('W'), CeuCraftingHelper.HELPER.cable(tier, slots), Character.valueOf('T'), OreDictNames.chestWood, Character.valueOf('R'), CeuCraftingHelper.HELPER.redCable(slots), Character.valueOf('S'), CeuCraftingHelper.HELPER.circuit(tier)};
        }
    }
    ,
    ICEU(ConverterType.ICEU_ICEF, true){

        @Override
        @Nullable
        public Object[] createRecipe(int tier, int slots) {
            return null;
        }
    }
    ,
    ICEF(ConverterType.ICEU_ICEF, false){

        @Override
        @Nullable
        public Object[] createRecipe(int tier, int slots) {
            return null;
        }
    };

    private final ConverterType type;
    private final boolean isCeu;

    private CeuType(ConverterType type, boolean isCeu) {
        this.type = type;
        this.isCeu = isCeu;
    }

    public ConverterType getConverterType() {
        return this.type;
    }

    public boolean isCeu() {
        return this.isCeu;
    }

    public Energy getInput() {
        return this.type.getInput(this.isCeu);
    }

    public Energy getOutput() {
        return this.type.getOutput(this.isCeu);
    }

    public Ratio getDefaultConversionRate() {
        return Ratio.ratioOf(this.getInput().getDefaultConversionRate(), this.getOutput().getDefaultConversionRate());
    }

    public CeuType getCounterpart() {
        switch (this) {
            case CEU: {
                return CEF;
            }
            case CEF: {
                return CEU;
            }
            case ICEU: {
                return ICEF;
            }
            case ICEF: {
                return ICEU;
            }
        }
        throw new IllegalArgumentException("il");
    }

    public Ratio ratio(int tier) {
        return CeuConfig.instance().getRatio(this, tier);
    }

    public boolean isDisabled(int tier) {
        return CeuConfig.instance().isDisabled(this, tier);
    }

    public Ratio ceuRatio(int tier) {
        return this.isCeu() ? this.ratio(tier) : this.getCounterpart().ratio(tier);
    }

    public Ratio cefRatio(int tier) {
        return this.isCeu() ? this.getCounterpart().ratio(tier) : this.ratio(tier);
    }

    public String toString() {
        return this.name().toLowerCase();
    }
}

