/*
 * Decompiled with CFR 0.152.
 */
package com.tictim.ceu.energy;

import com.tictim.ceu.enums.Energy;
import com.tictim.ceu.mte.MTECeu;
import com.tictim.ceu.util.Ratio;
import gregtech.api.capability.GregtechCapabilities;
import gregtech.api.capability.IElectricItem;
import ic2.api.item.IBackupElectricItemManager;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.Optional;

@Optional.InterfaceList(value={@Optional.Interface(modid="ic2", iface="ic2.api.item.IBackupElectricItemManager"), @Optional.Interface(modid="ic2", iface="ic2.api.item.IElectricItemManager")})
public class ElectricItemManagerGTEU
implements IBackupElectricItemManager {
    private final Ratio ratio;

    public ElectricItemManagerGTEU(MTECeu ceu) {
        this.ratio = ceu.getType().getInput() == Energy.GTEU ? ceu.ratio() : ceu.ratio().reverse();
    }

    @Optional.Method(modid="ic2")
    public boolean handles(ItemStack stack) {
        return stack.hasCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null);
    }

    @Optional.Method(modid="ic2")
    public double charge(ItemStack stack, double amount, int tier, boolean ignoreTransferLimit, boolean simulate) {
        IElectricItem e = (IElectricItem)stack.getCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null);
        return e == null ? 0.0 : this.ratio.convertToDouble(e.charge(this.ratio.reverse().convertToLong(amount), tier, ignoreTransferLimit, simulate));
    }

    @Optional.Method(modid="ic2")
    public double discharge(ItemStack stack, double amount, int tier, boolean ignoreTransferLimit, boolean externally, boolean simulate) {
        IElectricItem e = (IElectricItem)stack.getCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null);
        return e == null ? 0.0 : this.ratio.convertToDouble(e.discharge(this.ratio.reverse().convertToLong(amount), tier, ignoreTransferLimit, externally, simulate));
    }

    @Optional.Method(modid="ic2")
    public double getCharge(ItemStack stack) {
        IElectricItem e = (IElectricItem)stack.getCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null);
        return e == null ? 0.0 : this.ratio.convertToDouble(e.getCharge());
    }

    @Optional.Method(modid="ic2")
    public double getMaxCharge(ItemStack stack) {
        IElectricItem e = (IElectricItem)stack.getCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null);
        return e == null ? 0.0 : this.ratio.convertToDouble(e.getMaxCharge());
    }

    @Optional.Method(modid="ic2")
    public boolean canUse(ItemStack stack, double amount) {
        IElectricItem e = (IElectricItem)stack.getCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null);
        return e != null && e.canUse(this.ratio.reverse().convertToLong(amount));
    }

    @Optional.Method(modid="ic2")
    public boolean use(ItemStack stack, double amount, @Nullable EntityLivingBase entity) {
        long amountGteu;
        IElectricItem e = (IElectricItem)stack.getCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null);
        if (e != null && e.discharge(amountGteu = this.ratio.reverse().convertToLong(amount), e.getTier(), true, true, true) >= amountGteu) {
            e.discharge(amountGteu, e.getTier(), true, true, false);
            return true;
        }
        return false;
    }

    @Optional.Method(modid="ic2")
    public void chargeFromArmor(ItemStack stack, EntityLivingBase entity) {
    }

    @Optional.Method(modid="ic2")
    public String getToolTip(ItemStack stack) {
        return "";
    }

    @Optional.Method(modid="ic2")
    public int getTier(ItemStack stack) {
        IElectricItem e = (IElectricItem)stack.getCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null);
        return e == null ? 0 : e.getTier();
    }
}

