/*
 * Decompiled with CFR 0.152.
 */
package com.tictim.ceu.config;

import com.tictim.ceu.config.CeuSetting;
import com.tictim.ceu.enums.CeuType;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.config.Configuration;

public class CeuVoltageCategory {
    private final CeuType type;
    private final CeuSetting[] settings;

    public CeuVoltageCategory(@Nullable Configuration retro, CeuType type) {
        this.type = type;
        this.settings = new CeuSetting[type.getConverterType().getMaxTier() - type.getConverterType().getMinTier()];
        for (int i = 0; i < this.settings.length; ++i) {
            this.settings[i] = new CeuSetting(retro, type, i + type.getConverterType().getMinTier());
        }
    }

    public CeuVoltageCategory(NBTTagCompound nbt, CeuType type) {
        this.type = type;
        NBTTagCompound subnbt = nbt.func_74775_l(type.name().toLowerCase());
        this.settings = new CeuSetting[type.getConverterType().getMaxTier() - type.getConverterType().getMinTier()];
        for (int i = 0; i < this.settings.length; ++i) {
            this.settings[i] = new CeuSetting(subnbt, type, i + type.getConverterType().getMinTier());
        }
    }

    public CeuSetting getSetting(int tier) {
        return this.settings[MathHelper.func_76125_a((int)tier, (int)this.type.getConverterType().getMinTier(), (int)this.type.getConverterType().getMaxTier()) - this.type.getConverterType().getMinTier()];
    }

    public void serialize(NBTTagCompound nbt) {
        NBTTagCompound subnbt = new NBTTagCompound();
        for (CeuSetting setting : this.settings) {
            setting.serialize(subnbt);
        }
        if (!subnbt.func_82582_d()) {
            nbt.func_74782_a(this.type.name().toLowerCase(), (NBTBase)subnbt);
        }
    }
}

