/*
 * Decompiled with CFR 0.152.
 */
package com.tictim.ceu.config;

import com.tictim.ceu.config.CeuConfig;
import com.tictim.ceu.config.PropertyHandler;
import com.tictim.ceu.enums.CeuType;
import com.tictim.ceu.enums.ConverterType;
import com.tictim.ceu.util.Ratio;
import gregtech.api.GTValues;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.config.Configuration;

public class CeuSetting {
    private final CeuType type;
    private final int tier;
    private final String category;
    public final Ratio conversionRatio;
    public final boolean disable;

    public CeuSetting(@Nullable Configuration retro, CeuType type, int tier) {
        this.type = type;
        this.tier = tier;
        this.category = "general." + type.toString().toLowerCase() + "." + GTValues.VN[tier];
        if (type.getConverterType() == ConverterType.CEU_CEF) {
            this.conversionRatio = Ratio.ratioOf(new PropertyHandler(CeuConfig.cfg, this.category, "conversionRatio", type.getDefaultConversionRate().toString(), "Conversion ratio between two energy units (INPUT:OUTPUT)").replace(new PropertyHandler(retro, GTValues.VN[tier], type == CeuType.CEU ? "CEURatio" : "CEFRatio", "4:1", ""), (p, pRetro) -> {
                if (type == CeuType.CEU) {
                    p.set(Ratio.PATTERN.matcher(pRetro.getString()).replaceAll("$2:$1"));
                } else {
                    p.set(pRetro.getString());
                }
            }), type.getDefaultConversionRate());
            this.disable = new PropertyHandler(CeuConfig.cfg, this.category, "disable", type.getConverterType().isDisabledByDefault(), "").replace(new PropertyHandler(retro, GTValues.VN[tier], type == CeuType.CEU ? "CEUDisabled" : "CEFDisabled", false, "")).getBoolean();
        } else {
            this.conversionRatio = Ratio.ratioOf(CeuConfig.cfg.get(this.category, "conversionRatio", type.getDefaultConversionRate().toString(), "Conversion ratio between two energy units (INPUT:OUTPUT)"), type.getDefaultConversionRate());
            this.disable = CeuConfig.cfg.get(this.category, "disable", type.getConverterType().isDisabledByDefault(), "").getBoolean();
        }
    }

    public CeuSetting(NBTTagCompound nbt, CeuType type, int tier) {
        this.type = type;
        this.tier = tier;
        this.category = "general." + type.toString().toLowerCase() + "." + GTValues.VN[tier];
        NBTTagCompound subnbt = nbt.func_74775_l(GTValues.VN[tier]);
        this.conversionRatio = Ratio.ratioOf(subnbt);
        this.disable = subnbt.func_74767_n("disable");
    }

    public void serialize(NBTTagCompound nbt) {
        NBTTagCompound subnbt = new NBTTagCompound();
        subnbt.func_74757_a("disable", this.disable);
        this.conversionRatio.serialize(subnbt);
        nbt.func_74782_a(GTValues.VN[this.tier], (NBTBase)subnbt);
    }
}

