/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import de.ellpeck.actuallyadditions.mod.tile.CustomEnergyStorage;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityInventoryBase;
import de.ellpeck.actuallyadditions.mod.util.ItemStackHandlerAA;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import de.ellpeck.actuallyadditions.mod.util.WorldUtil;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.energy.IEnergyStorage;

public class TileEntityDirectionalBreaker
extends TileEntityInventoryBase {
    public static final int RANGE = 8;
    public static final int ENERGY_USE = 5;
    public final CustomEnergyStorage storage = new CustomEnergyStorage(10000, 20, 0);
    private int lastEnergy;
    private int currentTime;

    public TileEntityDirectionalBreaker() {
        super(9, "directionalBreaker");
    }

    @Override
    public void writeSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        super.writeSyncableNBT(compound, type);
        this.storage.writeToNBT(compound);
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            compound.func_74768_a("CurrentTime", this.currentTime);
        }
    }

    @Override
    public void readSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        super.readSyncableNBT(compound, type);
        this.storage.readFromNBT(compound);
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            this.currentTime = compound.func_74762_e("CurrentTime");
        }
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (!this.field_145850_b.field_72995_K) {
            if (!this.isRedstonePowered && !this.isPulseMode) {
                if (this.currentTime > 0) {
                    --this.currentTime;
                    if (this.currentTime <= 0) {
                        this.doWork();
                    }
                } else {
                    this.currentTime = 15;
                }
            }
            if (this.storage.getEnergyStored() != this.lastEnergy && this.sendUpdateWithInterval()) {
                this.lastEnergy = this.storage.getEnergyStored();
            }
        }
    }

    private void doWork() {
        if (this.storage.getEnergyStored() >= 40) {
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            EnumFacing sideToManipulate = WorldUtil.getDirectionByPistonRotation(state);
            for (int i = 0; i < 8; ++i) {
                BlockPos coordsBlock = this.field_174879_c.func_177967_a(sideToManipulate, i + 1);
                IBlockState breakState = this.field_145850_b.func_180495_p(coordsBlock);
                Block blockToBreak = breakState.func_177230_c();
                if (blockToBreak == null || this.field_145850_b.func_175623_d(coordsBlock) || !(this.field_145850_b.func_180495_p(coordsBlock).func_185887_b(this.field_145850_b, coordsBlock) > -1.0f)) continue;
                NonNullList drops = NonNullList.func_191196_a();
                blockToBreak.getDrops(drops, (IBlockAccess)this.field_145850_b, coordsBlock, breakState, 0);
                float chance = WorldUtil.fireFakeHarvestEventsForDropChance(this, (NonNullList<ItemStack>)drops, this.field_145850_b, coordsBlock);
                if (!(chance > 0.0f) || !(this.field_145850_b.field_73012_v.nextFloat() <= chance) || !StackUtil.canAddAll(this.inv, (List<ItemStack>)drops, false)) continue;
                this.field_145850_b.func_175718_b(2001, coordsBlock, Block.func_176210_f((IBlockState)this.field_145850_b.func_180495_p(coordsBlock)));
                this.field_145850_b.func_175698_g(coordsBlock);
                StackUtil.addAll(this.inv, (List<ItemStack>)drops, false);
                this.storage.extractEnergyInternal(5, false);
                this.func_70296_d();
            }
        }
    }

    @Override
    public ItemStackHandlerAA.IAcceptor getAcceptor() {
        return (slot, stack, automation) -> !automation;
    }

    public int getEnergyScaled(int i) {
        return this.storage.getEnergyStored() * i / this.storage.getMaxEnergyStored();
    }

    @Override
    public boolean isRedstoneToggle() {
        return true;
    }

    @Override
    public void activateOnPulse() {
        this.doWork();
    }

    @Override
    public IEnergyStorage getEnergyStorage(EnumFacing facing) {
        return this.storage;
    }
}

