/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.blocks;

import de.ellpeck.actuallyadditions.mod.blocks.base.BlockBase;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Triple;

public class BlockGreenhouseGlass
extends BlockBase {
    public BlockGreenhouseGlass(String name) {
        super(Material.field_151592_s, name);
        this.setHarvestLevel("pickaxe", 0);
        this.func_149711_c(0.5f);
        this.func_149752_b(10.0f);
        this.func_149672_a(SoundType.field_185853_f);
        this.func_149675_a(true);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public int func_149717_k(IBlockState state) {
        return 0;
    }

    @Deprecated
    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        IBlockState otherState = world.func_180495_p(pos.func_177972_a(side));
        Block block = otherState.func_177230_c();
        return state != otherState || block != this && super.func_176225_a(state, world, pos, side);
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public EnumRarity getRarity(ItemStack stack) {
        return EnumRarity.EPIC;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (world.field_72995_K) {
            return;
        }
        if (world.func_175710_j(pos) && world.func_72935_r()) {
            Triple<BlockPos, IBlockState, IGrowable> trip = BlockGreenhouseGlass.firstBlock(world, pos);
            boolean once = false;
            if (trip != null) {
                for (int i = 0; i < 3; ++i) {
                    IBlockState growState;
                    IBlockState iBlockState = growState = i == 0 ? (IBlockState)trip.getMiddle() : world.func_180495_p((BlockPos)trip.getLeft());
                    if (growState.func_177230_c() != trip.getRight() || !((IGrowable)trip.getRight()).func_176473_a(world, (BlockPos)trip.getLeft(), growState, false)) continue;
                    ((IGrowable)trip.getRight()).func_176474_b(world, rand, (BlockPos)trip.getLeft(), growState);
                    once = true;
                }
            }
            if (once) {
                world.func_175718_b(2005, ((IBlockState)trip.getMiddle()).func_185914_p() ? ((BlockPos)trip.getLeft()).func_177984_a() : (BlockPos)trip.getLeft(), 0);
            }
        }
    }

    public static Triple<BlockPos, IBlockState, IGrowable> firstBlock(World world, BlockPos glassPos) {
        IBlockState state;
        BlockPos.MutableBlockPos mut = new BlockPos.MutableBlockPos(glassPos);
        do {
            mut.func_181079_c(mut.func_177958_n(), mut.func_177956_o() - 1, mut.func_177952_p());
            if (mut.func_177956_o() >= 0) continue;
            return null;
        } while (!(state = world.func_180495_p((BlockPos)mut)).func_185914_p() && !(state.func_177230_c() instanceof IGrowable));
        if (state.func_177230_c() instanceof IGrowable) {
            return Triple.of((Object)mut.func_185334_h(), (Object)state, (Object)((IGrowable)state.func_177230_c()));
        }
        return null;
    }
}

