/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.inventory;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import org.cyclops.commoncapabilities.api.capability.itemhandler.ItemMatch;
import org.cyclops.commoncapabilities.api.capability.itemhandler.SlotlessItemHandlerWrapper;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;

public class IndexedSlotlessItemHandlerWrapper
extends SlotlessItemHandlerWrapper {
    private final IInventoryIndexReference inventory;
    private MovementStrategy inputStrategy;
    private MovementStrategy outputStrategy;

    public IndexedSlotlessItemHandlerWrapper(IItemHandler itemHandler, IInventoryIndexReference inventory, MovementStrategy inputStrategy, MovementStrategy outputStrategy) {
        super(itemHandler);
        this.inventory = inventory;
        this.inputStrategy = inputStrategy;
        this.outputStrategy = outputStrategy;
    }

    public IndexedSlotlessItemHandlerWrapper(IItemHandler itemHandler, IInventoryIndexReference inventory) {
        this(itemHandler, inventory, MovementStrategy.FIRST, MovementStrategy.FIRST);
    }

    protected int getNonFullSlotWithItemStack(@Nonnull ItemStack itemStack, int matchFlags) {
        if (!IngredientComponent.ITEMSTACK.getMatcher().hasCondition((Object)matchFlags, (Object)1)) {
            for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
                ItemStack slotStack = this.itemHandler.getStackInSlot(i);
                if (!ItemMatch.areItemStacksEqual((ItemStack)slotStack, (ItemStack)itemStack, (int)matchFlags) || slotStack.func_190916_E() >= this.itemHandler.getSlotLimit(i) || slotStack.func_190916_E() >= slotStack.func_77976_d()) continue;
                return i;
            }
            return -1;
        }
        Map<Item, Int2ObjectMap<ItemStack>> items = this.inventory.getIndex();
        Int2ObjectMap<ItemStack> stacks = items.get(itemStack.func_77973_b());
        if (stacks != null) {
            for (Int2ObjectMap.Entry entry : stacks.int2ObjectEntrySet()) {
                ItemStack value = (ItemStack)entry.getValue();
                if (value.func_190916_E() >= Math.min(this.inventory.getInventoryStackLimit(), value.func_77976_d()) || !ItemMatch.areItemStacksEqual((ItemStack)value, (ItemStack)itemStack, (int)matchFlags)) continue;
                return entry.getIntKey();
            }
        }
        return -1;
    }

    protected int getNonEmptySlotWithItemStack(@Nonnull ItemStack itemStack, int matchFlags) {
        if (!IngredientComponent.ITEMSTACK.getMatcher().hasCondition((Object)matchFlags, (Object)1)) {
            for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
                ItemStack slotStack = this.itemHandler.getStackInSlot(i);
                if (slotStack.func_190926_b() || !ItemMatch.areItemStacksEqual((ItemStack)slotStack, (ItemStack)itemStack, (int)matchFlags)) continue;
                return i;
            }
            return -1;
        }
        Map<Item, Int2ObjectMap<ItemStack>> items = this.inventory.getIndex();
        Int2ObjectMap<ItemStack> stacks = items.get(itemStack.func_77973_b());
        if (stacks != null) {
            for (Int2ObjectMap.Entry entry : stacks.int2ObjectEntrySet()) {
                ItemStack value = (ItemStack)entry.getValue();
                if (!ItemMatch.areItemStacksEqual((ItemStack)value, (ItemStack)itemStack, (int)matchFlags)) continue;
                return entry.getIntKey();
            }
        }
        return -1;
    }

    protected Iterator<Integer> getSlotsWithItemStack(@Nonnull ItemStack itemStack, int matchFlags) {
        if (!IngredientComponent.ITEMSTACK.getMatcher().hasCondition((Object)matchFlags, (Object)1)) {
            return IntStream.range(0, this.itemHandler.getSlots()).filter(slot -> ItemMatch.areItemStacksEqual((ItemStack)this.itemHandler.getStackInSlot(slot), (ItemStack)itemStack, (int)matchFlags)).iterator();
        }
        Map<Item, Int2ObjectMap<ItemStack>> items = this.inventory.getIndex();
        Int2ObjectMap<ItemStack> stacks = items.get(itemStack.func_77973_b());
        if (stacks == null) {
            return Collections.emptyIterator();
        }
        return new IndexIterator((Iterator<Int2ObjectMap.Entry<ItemStack>>)stacks.int2ObjectEntrySet().iterator(), itemStack, matchFlags);
    }

    protected int getEmptySlot() {
        return this.inputStrategy == MovementStrategy.FIRST ? this.inventory.getFirstEmptySlot() : this.inventory.getLastEmptySlot();
    }

    protected int getNonEmptySlot() {
        return this.outputStrategy == MovementStrategy.FIRST ? this.inventory.getFirstNonEmptySlot() : this.inventory.getLastNonEmptySlot();
    }

    public MovementStrategy getInputStrategy() {
        return this.inputStrategy;
    }

    public void setInputStrategy(MovementStrategy inputStrategy) {
        this.inputStrategy = inputStrategy;
    }

    public MovementStrategy getOutputStrategy() {
        return this.outputStrategy;
    }

    public void setOutputStrategy(MovementStrategy outputStrategy) {
        this.outputStrategy = outputStrategy;
    }

    public static class IndexIterator
    implements Iterator<Integer> {
        private final Iterator<Int2ObjectMap.Entry<ItemStack>> slotIterator;
        private final ItemStack prototype;
        private final int matchFlags;
        private Integer next;

        public IndexIterator(Iterator<Int2ObjectMap.Entry<ItemStack>> slotIterator, ItemStack prototype, int matchFlags) {
            this.slotIterator = slotIterator;
            this.prototype = prototype;
            this.matchFlags = matchFlags;
            this.next = this.findNext();
        }

        protected Integer findNext() {
            while (this.slotIterator.hasNext()) {
                Int2ObjectMap.Entry<ItemStack> entry = this.slotIterator.next();
                int slot = entry.getIntKey();
                ItemStack itemStack = (ItemStack)entry.getValue();
                if (!ItemMatch.areItemStacksEqual((ItemStack)itemStack, (ItemStack)this.prototype, (int)this.matchFlags)) continue;
                return slot;
            }
            return null;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public Integer next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("Slot out of bounds");
            }
            Integer next = this.next;
            this.next = this.findNext();
            return next;
        }
    }

    public static interface IInventoryIndexReference {
        public int getInventoryStackLimit();

        public Map<Item, Int2ObjectMap<ItemStack>> getIndex();

        public int getFirstEmptySlot();

        public int getLastEmptySlot();

        public int getFirstNonEmptySlot();

        public int getLastNonEmptySlot();
    }

    public static enum MovementStrategy {
        FIRST,
        LAST;

    }
}

