/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.config.extendedconfig;

import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.cyclops.cyclopscore.config.ConfigurableType;
import org.cyclops.cyclopscore.config.configurable.ConfigurableBiome;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.cyclopscore.init.ModBase;

public abstract class BiomeConfig
extends ExtendedConfig<BiomeConfig> {
    public BiomeConfig(ModBase mod, int defaultId, String namedId, String comment, Class<? extends Biome> element) {
        super(mod, defaultId > 0, namedId, comment, element);
    }

    @Override
    public String getTranslationKey() {
        return "biomes." + this.getMod().getModId() + "." + this.getNamedId();
    }

    @Override
    public ConfigurableType getHolderType() {
        return ConfigurableType.BIOME;
    }

    public ConfigurableBiome getBiome() {
        return (ConfigurableBiome)this.getSubInstance();
    }

    public void registerBiomeDictionary() {
        BiomeDictionary.makeBestGuess((Biome)this.getBiome());
    }

    @Override
    public IForgeRegistry<?> getRegistry() {
        return ForgeRegistries.BIOMES;
    }

    @Override
    public void onForgeRegistered() {
        super.onForgeRegistered();
        this.registerBiomeDictionary();
    }
}

