/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.config.configurable;

import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.potion.Potion;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.cyclops.cyclopscore.config.configurable.IConfigurable;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.cyclopscore.config.extendedconfig.PotionConfig;
import org.cyclops.cyclopscore.init.ModBase;

public abstract class ConfigurablePotion
extends Potion
implements IConfigurable<PotionConfig> {
    private final ResourceLocation resource;
    protected PotionConfig eConfig = null;

    protected ConfigurablePotion(ExtendedConfig<PotionConfig> eConfig, boolean badEffect, int color, int iconIndex) {
        super(badEffect, color);
        this.setConfig((PotionConfig)eConfig);
        this.func_76390_b(eConfig.getTranslationKey());
        this.func_76399_b(iconIndex % 8, iconIndex / 8);
        this.resource = new ResourceLocation(eConfig.getMod().getModId(), eConfig.getMod().getReferenceValue(ModBase.REFKEY_TEXTURE_PATH_GUI) + "potions.png");
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_76392_e() {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(this.resource);
        return super.func_76392_e();
    }

    private void setConfig(PotionConfig eConfig) {
        this.eConfig = eConfig;
    }

    @Override
    public PotionConfig getConfig() {
        return this.eConfig;
    }

    public boolean isActiveOn(EntityLivingBase entity) {
        return this.isActiveOn(entity, this);
    }

    public boolean isActiveOn(EntityLivingBase entity, Potion potion) {
        return entity.func_70660_b(potion) != null;
    }

    public int getAmplifier(EntityLivingBase entity, Potion potion) {
        return entity != null ? entity.func_70660_b(potion).func_76458_c() : 0;
    }

    public int getAmplifier(EntityLivingBase entity) {
        return this.getAmplifier(entity, this);
    }

    protected abstract void onUpdate(EntityLivingBase var1);

    @SubscribeEvent
    public void onEntityUpdate(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        if (this.isActiveOn(entity)) {
            this.onUpdate(entity);
        }
    }
}

